/* picXt.c
 * 14nov90
 */

#include "picX.h"

/* Prototypes */
static pico p_XtInstallAccelerators(pico);
static pico p_XtRemoveAllCallbacks(pico);
static void handleEvent(Widget, pico, XEvent*);
static pico p_XtAddEventHandler(pico);
static pico p_XtRemoveEventHandler(pico);
static pico p_setMotionHint(pico);
static pico p_XSetWMHints(pico);
static pico setPSHint(pico);
static pico setPHint(pico);
static pico p_XtInitialize(pico);
static pico p_XtToolkitInitialize(void);
static pico p_XtCreateApplicationContext(void);
static pico p_XtCreatePopupShell(pico);
static pico p_XtAppCreateShell(pico);
static pico p_XtOpenDisplay(pico);
static pico p_XtSetValues(pico);
static pico p_XtGetValues(pico);
static pico p_XtUnmanageChild(pico);
static pico p_XtDestroyWidget(pico);
static pico p_XtManageChild(pico);
static pico p_XtRealizeWidget(pico);
static pico p_XtAppMainLoop();
static pico p_XtAppPending();
static pico p_XtAppNextEvent();
static pico p_XtDispatchEvent();
static pico p_XtDisplay(pico);
static pico p_XtWindow(pico);
static pico p_XtWindowToWidget(pico);
static pico p_XtAppPeekEvent(pico);
static pico p_XtParent(pico);
static pico p_XtFree(pico);
static pico p_XtPopup(pico);
static pico p_XtPopdown(pico);
static pico p_XtMoveWidget(pico);

symInit XtSyms[] = {
   {"XTINSTALLACCELERATORS",       p_XtInstallAccelerators},
   {"XTREMOVEALLCALLBACKS",        p_XtRemoveAllCallbacks},
   {"XTADDEVENTHANDLER",           p_XtAddEventHandler},
   {"XTREMOVEEVENTHANDLER",        p_XtRemoveEventHandler},
   {"SETMOTIONHINT",               p_setMotionHint},
   {"XSETWMHINTS",                 p_XSetWMHints},
   {"SETPSHINT",                   setPSHint},
   {"SETPHINT",                    setPHint},
   {"XTINITIALIZE",                p_XtInitialize},
   {"XTTOOLKITINITIALIZE",         p_XtToolkitInitialize},
   {"XTCREATEAPPLICATIONCONTEXT",  p_XtCreateApplicationContext},
   {"XTCREATEPOPUPSHELL",          p_XtCreatePopupShell},
   {"XTAPPCREATESHELL",            p_XtAppCreateShell},
   {"XTOPENDISPLAY",               p_XtOpenDisplay},
   {"XTSETVALUES",                 p_XtSetValues},
   {"XTGETVALUES",                 p_XtGetValues},
   {"XTUNMANAGECHILD",             p_XtUnmanageChild},
   {"XTDESTROYWIDGET",             p_XtDestroyWidget},
   {"XTMANAGECHILD",               p_XtManageChild},
   {"XTREALIZEWIDGET",             p_XtRealizeWidget},
   {"XTAPPMAINLOOP",               p_XtAppMainLoop},
   {"XTAPPPENDING",                p_XtAppPending},
   {"XTAPPNEXTEVENT",              p_XtAppNextEvent},
   {"XTDISPATCHEVENT",             p_XtDispatchEvent},
   {"XTDISPLAY",                   p_XtDisplay},
   {"XTWINDOW",                    p_XtWindow},
   {"XTWINDOWTOWIDGET",            p_XtWindowToWidget},
   {"XTAPPPEEKEVENT",              p_XtAppPeekEvent},
   {"XTPARENT",                    p_XtParent},
   {"XTFREE",                      p_XtFree},
   {"XTPOPUP",                     p_XtPopup},
   {"XTPOPDOWN",                   p_XtPopdown},
   {"XTMOVEWIDGET",                p_XtMoveWidget},
   NULL
};


static char *argvi1[] = {"Cosy"};


pico p_XtInstallAccelerators(x)
pico x;
{
   Widget dest;

   dest = (Widget)nextNum(&x);
   XtInstallAccelerators(dest, (Widget)nextNum(&x));
   return tSym;
}

pico p_XtRemoveAllCallbacks(x)
pico x;
{
   Widget w;
   char name[64];

   w = (Widget)nextNum(&x);
   nextString(&x,name,64);
   XtRemoveAllCallbacks(w, name);
   return tSym;
}

static void handleEvent(w,foo,ev)
Widget w;
pico foo;
XEvent *ev;
{
   apply2(foo,boxNum(w),boxNum(ev));
}

pico p_XtAddEventHandler(x)
pico x;
{
   Widget w;
   EventMask mask;
   Boolean noMask;

   w = (Widget)nextNum(&x);
   mask = (EventMask)nextNum(&x);
   noMask = nextBool(&x);
   XtAddEventHandler(w,mask,noMask,(XtEventHandler)handleEvent,nextFun(&x));
   return tSym;
}

pico p_XtRemoveEventHandler(x)
pico x;
{
   Widget w;
   EventMask mask;
   Boolean noMask;

   w = (Widget)nextNum(&x);
   mask = (EventMask)nextNum(&x);
   noMask = nextBool(&x);
   XtRemoveEventHandler(w,mask,noMask,(XtEventHandler)handleEvent,nextFun(&x));
   return tSym;
}

pico p_setMotionHint(x)
pico x;
{
Display *display;
Window  window;
XSetWindowAttributes   abuti;

   display = (Display *)nextNum(&x);
   window = (Window )nextNum(&x);
   abuti.event_mask = PointerMotionHintMask;
   XChangeWindowAttributes (display,window,CWEventMask,&abuti);
   return tSym;
}

pico p_XSetWMHints(x)
pico x;
{
   Display *display;
   Window   parent;
   XWMHints   *wmhints;

   display = (Display *)nextNum(&x);
   parent = (Window)nextNum(&x);
   wmhints = (XWMHints *)nextNum(&x);
   XSetWMHints (display,parent,&wmhints);
   return tSym;

}

pico setPSHint(x)         /* in R4 XSetWMNormalHints */
pico x;
{
   Display *display;
   Window   parent;
   XSizeHints theSizeHints;

   display = (Display *)nextNum(&x);
   parent = (Window)nextNum(&x);
   theSizeHints.flags = USPosition | USSize;
   theSizeHints.x = nextNum(&x);
   theSizeHints.y = nextNum(&x);
   theSizeHints.width =  nextNum(&x);
   theSizeHints.height =  nextNum(&x);
   XSetNormalHints (display,parent,&theSizeHints);
   return tSym;
}

pico setPHint(x)
pico x;
{
   Display *display;
   Window   parent;
   XSizeHints theSizeHints;

   display = (Display *)nextNum(&x);
   parent = (Window)nextNum(&x);
   theSizeHints.flags = USPosition;
   theSizeHints.x = nextNum(&x);
   theSizeHints.y = nextNum(&x);
   XSetNormalHints(display,parent,&theSizeHints);
   return tSym;
}

pico p_XtInitialize(x)
pico x;
{
   char buf1[64];
   char buf2[64];
   int argc = 1;
   Widget toplevel;

   nextString(&x,buf1,64);
   nextString(&x,buf2,64);
   if((toplevel = XtInitialize(buf1,buf2, NULL, 0, &argc, argvi1)) == 0)
      return nilSym;
   return boxNum(toplevel);
}

pico p_XtToolkitInitialize()
{
   XtToolkitInitialize();
   return tSym;
}

pico p_XtCreateApplicationContext()
{
   return boxNum((XtAppContext)XtCreateApplicationContext());
}

pico p_XtCreatePopupShell(x)
pico x;
{
   char buf1[64];
   int app_w_class;
   WidgetClass wc;

   nextString(&x,buf1,64);
   app_w_class = nextNum(&x);

if(app_w_class)
   wc = transientShellWidgetClass;
else
   wc = applicationShellWidgetClass;

   return boxNum((Widget)XtCreatePopupShell(buf1,wc,(Widget)nextNum(&x),
                   NULL, 0));
}

pico p_XtAppCreateShell(x)
pico x;
{
char name[64];
char class[64];
int app_w_class;
Display *disp;
WidgetClass wc;

   nextString(&x,name,64);
   nextString(&x,class,64);
   app_w_class = nextNum(&x);
   disp = (Display *)nextNum(&x);
   wc = app_w_class? transientShellWidgetClass : applicationShellWidgetClass;
   initArgs(x);
   return boxNum((Widget)XtAppCreateShell(name,class,wc,disp,args,argCnt));
}

pico p_XtOpenDisplay(x)
pico x;
{
XtAppContext   app_context;
char app_name[64];
char app_class[64];
Cardinal   argc = 0;

   app_context = (XtAppContext)nextNum(&x);
   nextString(&x,app_name,64);
   (String)nextString(&x,app_class,64);
   return boxNum((Display *)XtOpenDisplay(app_context,"",
                  app_name, app_class, NULL, 0,
                  &argc, ""));
}

pico p_XtSetValues(x)
pico x;
{
Widget w;
char buff[20][64];
Arg args[20];
register int n=0;

   w = (Widget)nextNum(&x);
   while (isCell(x)) {
      args[n].name = nextString(&x,buff[n],64);
      args[n].value = nextNum(&x);
      ++n;
   }
   XtSetValues(w, args, n);
   return tSym;
}

pico p_XtGetValues(x)
pico x;
{
Widget w;
char buff[100][64];
XtArgVal val[100];
Arg args[100];
number mask[100];
register int n=0;

   w = (Widget)nextNum(&x);
   while (isCell(x)) {
      args[n].name = nextString(&x,buff[n],64);
      args[n].value = (XtArgVal)&val[n];
      mask[n] = nextNum(&x);
      ++n;
   }
   XtGetValues(w, args, n);
   push(nilSym);
   while (--n >= 0)
      tos = newCell(boxNum(val[n] & mask[n]),tos);
   return pop();
}

pico p_XtUnmanageChild(x)
pico x;
{

XtUnmanageChild((Widget)nextNum(&x) );
return tSym;

}

pico p_XtDestroyWidget(x)
pico x;
{
   XtDestroyWidget((Widget)nextNum(&x) );
   return tSym;
}

pico p_XtManageChild(x)
pico x;
{
   XtManageChild(nextNum(&x));
   return tSym;
}

pico p_XtRealizeWidget(x)
pico x;
{
Widget toplevel;

   toplevel = (Widget)nextNum(&x);
   XtRealizeWidget(toplevel);
   return tSym;

}

pico p_XtAppMainLoop(x)
pico   x;
{
   XtAppMainLoop((XtAppContext)nextNum(&x));
   return tSym;
}

pico p_XtAppPending(x)
pico x;
{
return boxBool((XtInputMask) XtAppPending((XtAppContext)nextNum(&x)));
}

pico p_XtAppNextEvent(x)
pico x;
{
XtAppContext app_c;

   app_c = (XtAppContext)nextNum(&x);
   XtAppNextEvent(app_c,(XEvent*)nextNum(&x));
   return tSym;
}

pico p_XtDispatchEvent(x)
pico x;
{
   XtDispatchEvent((XEvent*)nextNum(&x));
   return tSym;
 }

pico p_XtDisplay(x)
pico x;
{
Widget w;

  w = (Widget) nextNum(&x);
return boxNum((Display*) XtDisplay(w));
}

pico p_XtWindow(x)
pico x;
{
Widget w;

  w = (Widget) nextNum(&x);
  return boxNum((Window ) XtWindow(w));
}

pico p_XtWindowToWidget(x)
pico x;
{
Display   *dsply;

  dsply = (Display *) nextNum(&x);
  return boxNum((Widget ) XtWindowToWidget(dsply, nextNum(&x)));
}

pico p_XtAppPeekEvent(x)
pico x;
{
XtAppContext app_c;

   app_c = (XtAppContext)nextNum(&x);
   return boxBool((Boolean)XtAppPeekEvent(app_c,(XEvent*)nextNum(&x)));
}

pico p_XtParent(x)
pico x;
{
Widget w;

  w = (Widget) nextNum(&x);
return boxNum((Widget) XtParent(w));
}

pico p_XtFree(x)
pico x;
{

  XtFree((char*)nextNum(&x));
  return tSym;
}

pico p_XtPopup(x)
pico x;
{

  /*XtPopup((Widget)nextNum(&x),(XtGrabKind)XtGrabNonexclusive);*/
  XtPopup((Widget)nextNum(&x),(XtGrabKind)XtGrabNone);
  return tSym;
}

pico p_XtPopdown(x)
pico x;
{

  XtPopdown((Widget)nextNum(&x));
  return tSym;
}

pico p_XtMoveWidget(x)
pico x;
{
Widget w;
Position xos;

  w = (Widget) nextNum(&x);
  xos = (Position) nextNum(&x);
  XtMoveWidget(w,xos,nextNum(&x));
  return tSym;
}

