[compile.l 17apr91abu]

<de compile1 ()
   (local (*pos1 *pos2 p x y)
      (setq
         p (pop *parse)
         *pos1 (pop p)
         *pos2 (pop p) )
      (cond
         ((stringp (car p))
            (new 'statement *pos1 *pos2 [p]
               (cons 'norm$ (cons (car p) (evArgs (cdr p)))) ) )
         ((and (match '(*X "=" *A) p) (isSymbol *X))
            (new 'statement *pos1 *pos2 [p]
               (if (isString *A)
                  (list 'puts$ (car *A) (car *X))
                  (list 'put$ (evExpr *A) (car *X)) ) ) )
         ((and (match '(DEFAULT *X "=" *A) p) (isSymbol *X))
            (new 'statement *pos1 *pos2 [p]
               (list 'default$ (evExpr *A) (car *X)) ) )
         ((and (match '(SELECT *X "=" *A ":" *Y ":" *Z) p) (isSymbol *X))
            (local (y z)
               (setq
                  y (evList *Y)
                  z (evList *Z) )
               (unless (eq (length y) (sub1 (length z)))
                  (cosyError #(str "SELECT: Falsche Argumentanzahl")) )
               (new 'statement *pos1 *pos2 [p]
                  (list 'sel$ (evExpr *A) (car *X) y z) ) ) )
         ((and
               (or
                  (match '(GET *X "," *W "," *S "," *V) p)
                  (prog1
                     (match '(GET *X "," *W "," *S) p)
                     (setq *V (0)) ) )
               (isSymbol *X)
               (isString *S) )
            (new 'get-stmt *pos1 *pos2 [p] (evExpr *W)
               (car *X) (car *S) (evExpr *V) ) )
         ((and
               (match '(GETS *X "," *W "," *S "," *V) p)
               (isSymbol *X)
               (isString *S) )
            (new 'gets-stmt *pos1 *pos2 [p] (evStr *W)
               (car *X) (car *S) (evStr *V) ) )
         ((match '(IF *A) p)
            (new 'if-stmt *pos1 *pos2 [p] *A) )
         ((match '(WHILE *A) p)
            (new 'while-stmt *pos1 *pos2 [p] *A) )
         ((match '(FOR *A "=" *B TO *C STEP *D) p)
            (new 'for-stmt *pos1 *pos2 [p] *A *B *C *D) )
         ((match '(FOR *A "=" *B TO *C) p)
            (new 'for-stmt *pos1 *pos2 [p] *A *B *C (10000)) )
         ((match '(GRBEG *X) p)
            (new 'grb-stmt *pos1 *pos2 [p] (eval (evExpr *X))) )
         (t
            (unless
               (setq x
                  (find *c-tab
                     (lambda (x) (match (car x) p)) ) )
               (compError  #(str "Falscher Befehl")) )
            (new 'statement *pos1 *pos2 [p] (eval (cadr x))) >

<de compile ()
   (local (d st n p *p x)
      (with *job
         (when (setq d (slot dirty))
            (memory 12000)
            (watch *display)
            (dotPos)
            (slot laststroke (last (slot strokes)))
            (slot lastabs (slot abszisse))
            (slot lastord (slot ordinate))
            (setq st (slot code))
            (setq *code [Init result-count]
               (list (or (pop st) 0)) )
            (zero n)
            (while (and st (leq (get (car st) 'text2) d))
               (setq n (get (car st) 'text2))
               (nconc1 *code (pop st)) )
            (setq
               *p (add n (txtPtr (slot listener)))
               *parse )
            (until (zerop (byte *p))
               (setq p *p)
               (if (setq x (parse))
                  (setq *parse
                     (nconc1 *parse
                        (cons
                           n
                           (cons
                              (inc n (sub *p p))
                              (preProcess x) ) ) ) )
                  (inc n (sub *p p)) ) )
            (setq n (length *code))
            (while *parse
               (nconc1 *code (compile1)) )
            (if (or st (null (slot code)))
               (progn
                  (initExec *job)
                  (all exec (cdr (slot code *code))) )
               (progn
                  (initExec1 *job)
                  (all exec (nthcdr n (slot code *code))) ) )
            (do setStat 'statWin (slot pos) (slot status1))
            (slot dirty nil)
            >

<de program (s)
   (catch 'error
      (unMark *job)
      (appStmt s)
      (compile)
      (reDraw) >

<de code (s a b c d e f)
   (append s " "
      (usForm a)
      (when b
         (append ","
            (usForm b)
            (when c
               (append ","
                  (usForm c)
                  (when d
                     (append ","
                        (usForm d)
                        (when e
                           (append ","
                              (usForm e)
                              (when f
                                 (append "," (usForm f)) >

<de evStrList (l)
   (list
      (cons
         'list
         (mapcar
            (delimComma l)
            evStr >

<de evList (l)
   (mapcar
      (delimComma l)
      evExpr >

<de evArgs (l)
   (mapcar
      (delimComma l)
      (lambda ($x)
         (unless (eq (car $x) '#(symbol "-" t))
            (if (isString $x)
               (car $x)
               (evExpr $x) >

<de evExpr ($l)
   (unless $l
      (syntax) )
   (prog1
      (expr-z)
      (when $l (syntax)) >

<de evStr (x)
   (cond
      ((isString x) (car x))
      ((isSymbol x) (list 'gets$ (car x)))
      (t (compError #(str "String erwartet"))) >

<de need (n)
   (or n (compError #(str "Zahlenwert erwartet "))) >

<de needSym (x)
   (unless (isSymbol x)
      (compError #(str "Variable erwartet")) )
   (car x) >

[++ EXPR-Z:  EXPR-E {"|" EXPR-E} ++]
<de expr-z ()
   (local (x)
      (when (setq x (expr-e))
         (when (equal "|" (car $l))
            (pop $l)
            (setq x (list 'bitor x (need (expr-e))))
            (while (equal "|" (car $l))
               (pop $l)
               (nconc1 x (need (expr-e))) ) )
         x >

[++ EXPR-E:  EXPR-D {"&" EXPR-D} ++]
<de expr-e ()
   (local (x)
      (when (setq x (expr-d))
         (when (equal "&" (car $l))
            (pop $l)
            (setq x (list 'bitand x (need (expr-d))))
            (while (equal "&" (car $l))
               (pop $l)
               (nconc1 x (need (expr-d))) ) )
         x >

[++ EXPR-D:  EXPR-C [("="|"<>"|"<"|"<="|">"|">=") EXPR-C] ++]
<de expr-d ()
   (local (x y i)
      (when (setq x (expr-c))
         (when
            (setq i
               (index
                  (car $l)
                  '("=" "<>" "<" "<=" ">" ">=") ) )
            (pop $l)
            (setq y (need (expr-c)))
            (setq x
               (case i
                  (0 (list 'eq$ x y))
                  (1 (list 'ne$ x y))
                  (2 (list 'lt$ x y))
                  (3 (list 'le$ x y))
                  (4 (list 'lt$ y x))
                  (5 (list 'le$ y x)) ) ) )
         x >

[++ EXPR-C:  EXPR-B {("+"|"-") EXPR-B} ++]
<de expr-c ()
   (local (x [s] op)
      (when (setq x (expr-b))
         (when (or (equal "+" (car $l)) (equal "-" (car $l)))
            (setq x
               (list
                  (if (equal "+" (pop $l)) 'add 'sub)
                  x
                  (need (expr-b)) ) )
            (while (or (equal "+" (car $l)) (equal "-" (car $l)))
               (if
                  (eq
                     (car x)
                     (setq op (if (equal "+" (pop $l)) 'add 'sub)) )
                  (nconc1 x (need (expr-b)))
                  (setq x (list op x (need (expr-b)))) ) ) )
         x >

[++ EXPR-B:  EXPR-A {("*"|"/") EXPR-A} ++]
<de expr-b ()
   (local (x op)
      (when (setq x (expr-a))
         (when (or (equal "*" (car $l)) (equal "/" (car $l)))
            (setq x
               (list
                  (if (equal "*" (pop $l)) 'mul$ 'div$)
                  x
                  (need (expr-a)) ) )
            (while (or (equal "*" (car $l)) (equal "/" (car $l)))
               (if
                  (eq
                     (car x)
                     (setq op (if (equal "*" (pop $l)) 'mul$ 'div$)) )
                  (nconc1 x (need (expr-a)))
                  (setq x (list op x (need (expr-a)))) ) ) )
         x >

[++ EXPR-A:  NUMBER["."[NUMBER]] | NAME | ("("EXPR")") ++]
<de expr-a ()
   (cond
      ((equal "+" (car $l))
         (pop $l)
         (expr-z) )
      ((equal "-" (car $l))
         (pop $l)
         (if (numberp (car $l))
            (minus (pop $l))
            (list 'minus (expr-z)) ) )
      ((numberp (car $l))
         (pop $l) )
      ((memq (car $l) '(xa ya la wa mx$ my$))
         (case (car $l)
            (xa (pop $l) (lambda xa$))
            (ya (pop $l) (lambda ya$))
            (la (pop $l) (lambda la$))
            (wa (pop $l) (lambda wa$))
            ((mx$ my$) (chop 2 $l)) ) )
      ((and (car $l) (symbolp (car $l)))
         (if (equal "(" (cadr $l))
            (local ($s x)
               (setq $s (pop $l))
               (unless (setq x (assoc $s *f-tab))
                  (compError (nameString $s) #(str "Ist keine Funktion")) )
               (pop $l)
               (prog1
                  (list (cdr x) (expr-z))
                  (unless (equal ")" (pop $l))
                     (syntax) ) ) )
            (list 'get$ (pop $l)) ) )
      ((equal "(" (car $l))
         (prog2
            (pop $l)
            (expr-z)
            (unless (equal ")" (pop $l))
               (compError #(str "Fehlende rechte Klammer")) ) ) )
      (t (syntax)) >

t
