[mousin.l 03jan91]

[++ Mouse input commands ++]
<de fix-set (w)
   (catch 'error
      (local (pt)
         (when (setq pt (click hvSpot))
            (program
               (code "s" (car pt) (cdr pt)) >

<de mkLine (pt)
   (cond
      ((eq (car pt) (car (get *job 'pos)))
         (code "y" (cdr pt)) )
      ((eq (cdr pt) (cdr (get *job 'pos)))
         (code "x" (car pt)) )
      (t
         (code "xy" (car pt) (cdr pt)) >

<de fix-line (w)
   (catch 'error
      (local (pt)
         (with *job
            (when (setq pt (click hvSpot stiff (slot pos) line2))
               (program (mkLine pt)) >

<de hybArc (pt1 pt pt2)
   (local (c r arc)
      (when (setq c (center pt1 pt pt2))
         (setq
            r (distPt c pt)
            pt (ptToAngle c pt)
            pt1 (ptToAngle c pt1)
            pt2 (ptToAngle c pt2)
            arc (mod (sub pt2 pt1 #(mul 64 -360)) #(mul 64 360)) )
         (drawArc *display (get *job 'draw) (get *job 'gc)
            (cons2
               (sub (car c) r)
               (sub (cdr c) r)
               (add (car c) r 1)
               (add (cdr c) r 1) )
            pt1
            (if
               (lessp
                  (mod (sub pt pt1 #(mul 64 -360)) #(mul 64 360))
                  arc )
               arc
               (sub arc #(mul 64 360)) >

<de fix-circle (w)
   (catch 'error
      (local ($pt pt1 pt2)
         (with *job
            (setq $pt (slot pos))
            (and
               (setq pt1 (click hvSpot stiff $pt line2))
               (setq pt2
                  (click hvSpot nil pt1
                     (lambda (oldPt newPt)
                        (hybArc
                           (unScale $pt)
                           newPt
                           oldPt ) ) ) )
               (program
                  (code "kxyxy"
                     (car pt2)
                     (cdr pt2)
                     (car pt1)
                     (cdr pt1) >

<de drawBack ()
   (when (lessp 1 (length *poly))
      (if (listp (caadr *poly))
         (hybArc
            (unScale (pop *poly))
            (unScale (car (pop *poly)))
            (unScale (car *poly)) )
         (line2 (unScale (pop *poly)) (unScale (car *poly))) >

<de fix-poly (w)
   (catch 'error
      (local (pt $okey lst)
         (setq *poly (list (get *job 'pos)))
         (while
            (or
               (setq pt
                  (click hvSpot stiff (car *poly)
                     (lambda (oldPt newPt weg)
                        (if (if weg $okey (setq $okey *a-key))
                           (if (listp (caadr *poly))
                              (line2 oldPt newPt)
                              (hybArc
                                 (unScale (cadr *poly))
                                 newPt
                                 oldPt ) )
                           (line2 oldPt newPt) ) ) ) )
               *c-key )
            (if *c-key
               (drawBack)
               (progn
                  (if (and (not (listp (caadr *poly))) *a-key)
                     (progn
                        (line2
                           (unScale (car *poly))
                           (unScale (cadr *poly)) )
                        (hybArc
                           (unScale (cadr *poly))
                           (unScale pt)
                           (unScale (car *poly)) )
                        (rplacd *poly
                           (cons (list pt) (cdr *poly)) ) )
                     (progn
                        (line2 (unScale (car *poly)) (unScale pt))
                        (push pt *poly) ) ) ) ) )
         (setq
            *poly (cdr (reverse *poly))
            lst )
         (while *poly
            (setq lst
               (nconc lst
                  (if (pointp (car *poly))
                     (code "xy" (caar *poly) (cdr (pop *poly)))
                     (code "kxyxy"
                        (caaar *poly)
                        (cdar (pop *poly))
                        (caar *poly)
                        (cdr (pop *poly)) ) ) ) )
            (when *poly
               (setq lst (nconc1 lst ^J)) ) )
         (appStmt lst)
         (compile)
         (redraw) >

[++++++
<de poly1 ()
   (if (pointp (car *poly))
      (mkLine (pop *poly))
      (code "kxyxy"
         (caaar *poly)
         (cdar (pop *poly))
         (caar *poly)
         (cdr (pop *poly)) >
++++++]

<de fix-bez (w)
   (catch 'error
      (local ($q r p2)
         (with *job
            (and
               (setq $q (click hvSpot stiff (slot pos) line2))
               (line2 (unScale (slot pos)) (unScale $q))
               (prog1
                  (and
                     (setq p2 (click hvSpot stiff (slot pos) line2))
                     (setq r
                        (click hvSpot stiff p2
                           (lambda (oldPt newPt weg)
                              (line2 oldPt newPt)
                              (with *job
                                 (draw
                                    (div 40000 (slot scale))
                                    (list
                                       (list
                                          (slot pos)
                                          (cons $q (scale newPt))
                                          (scale oldPt) ) )
                                    scLine ) ) ) ) ) )
                  (line2 (unScale (slot pos)) (unScale $q)) )
               (program
                  (code "bezier"
                     (car $q)
                     (cdr $q)
                     (car r)
                     (cdr r)
                     (car p2)
                     (cdr p2) >

<de fix-spline (w)
   (catch 'error
      (local (a b s)
         (with *job
            (and
               (setq a (click hvSpot))
               (setq b (click hvSpot))
               (setq s (click hvSpot))
               (setq b
                  (bezier
                     (car (slot pos)) (cdr (slot pos))
                     (car a) (cdr a)
                     (car b) (cdr b)
                     (car s) (cdr s) ) )
               (program
                  (code "bezier"
                     (caar b)
                     (cdar b)
                     (cadr b)
                     (cddr b)
                     (car s)
                     (cdr s) >
               >

<de fix-rect (w)
   (catch 'error
      (local (pt1 pt2)
         (when
            (and
               (setq pt1 (click hvSpot))
               (setq pt2
                  (click hvSpot stiff pt1
                     (lambda (oldPt newPt)
                        (with *job
                           (drawRect
                              *display
                              (slot draw)
                              (slot gc)
                              (bounds oldPt newPt)) ) ) ) ) )
            (program
               (append
                  (code "s" (car pt1) (cdr pt1)) "^J"
                  (code "x" (car pt2)) "^J"
                  (code "y" (cdr pt2)) "^J"
                  (code "x" (car pt1)) "^J"
                  (code "y" (cdr pt1)) >

<de fix-ellipse (w)
   (catch 'error
      (local (pt1 pt2 h v)
         (with *job
            (when
               (and
                  (setq pt1 (click hvSpot))
                  (setq pt2
                     (click hvSpot stiff pt1
                        (lambda (oldPt newPt)
                           (drawArc *display (slot draw) (slot gc)
                              (bounds oldPt newPt)
                              0
                              #(mul 64 360) ) ) ) ) )
               (setq
                  h (div2 (sub (car pt2) (car pt1)))
                  v (div2 (sub (cdr pt2) (cdr pt1))) )
               (program
                  (if (eq (abs h) (abs v))
                     (code
                        "circle"
                        (add h (car pt1))
                        (add v (cdr pt1))
                        (abs h) )
                     (code
                        "ellipse"
                        (add h (car pt1))
                        (add v (cdr pt1))
                        (abs h)
                        (abs v) >

t
