[prim.l 01aug91abu]

<de doOut (df)
   (dosys (read1 df)) >
[++++++
   (local (s1 nm s2)
      (setq
         s2 (readlist df)
         s1 (pop s2)
         nm (pop s2) )
      (unless
         (zerop
            (system
               (append s1 (append *home nm) s2) ) )
         (warn #(str "Fehler bei Ausgabe") df) >
++++++++]

<de doPrint (nm df)
   (unless
      (zerop (system (append "cat " nm " | " (read1 df))))
      (warn #(str "Kann nicht drucken") nm) >

<de grpStrokes (n)
   (or
      (if (zerop n)
         (get *job 'strokes)
         (cdr (assoc n *grps)) )
      (elemErr) >

<de wDiff (a e)
   (when (leq e a)
      (inc e 3600000) )
   (sub e a) >

<de linkser (b c pt a)
   (lessp
      (wdiff
         (setq a (winkl pt a))
         (winkl pt b) )
      (wdiff
         a
         (winkl pt c) >

<de closed (z)
   (equal (car z) (last z)) >

<de findStroke (s lst)
   (local (n l)
      (zero n)
      (loop
         (t (eq s (car lst)) (list n))
         (t
            (and
               (get (car lst) 'strokes)
               (setq l (findStroke s (get (car lst) 'strokes))) )
            (cons n l) )
         (t (null (setq lst (cdr lst))))
         (inc n #(eye 10000)) >

<de indStroke (l lst)
   (local (x s)
      (unless (setq x (nth (div (pop l) #(eye 10000)) lst))
         (elemErr) )
      (if l
         (if (setq s (get x 'strokes))
            (indStroke l s)
            (elemErr) )
         x >

<de cutStroke (l lst)
   (local (s)
      (setq s (nth (div (pop l) #(eye 10000)) lst))
      (if l
         (with s
            (slot strokes (cutStroke l (slot strokes))) )
         (cut s lst) )
      lst >

<de hiPict (obj)
   (local (x)
      (with *job
         (setq x (get obj 'status))
         (unless (assoc x (slot hiPict))
            (slot hiPict
               (nconc1
                  (slot hiPict)
                  (cons x (dynamo zapPict (newPict))) ) ) )
         (ref (cdr (assoc x (slot hiPict)))) >

<de stPict (obj)
   (local (x)
      (with *job
         (setq x (get obj 'status))
         (unless (assoc x (slot stPict))
            (slot stPict
               (nconc1
                  (slot stPict)
                  (cons x (dynamo zapPict (newPict))) ) ) )
         (ref (cdr (assoc x (slot stPict)))) >

<de matmul (a1 b1 c1 d1 e1 f1 a2 b2 c2 d2 e2 f2)
   (setq
      a (add (muldiv a1 a2 10000) (muldiv d1 b2 10000))
      b (add (muldiv b1 a2 10000) (muldiv e1 b2 10000))
      c (add (muldiv c1 a2 10000) (muldiv f1 b2 10000) c2)
      d (add (muldiv a1 d2 10000) (muldiv d1 e2 10000))
      e (add (muldiv b1 d2 10000) (muldiv e1 e2 10000))
      f (add (muldiv c1 d2 10000) (muldiv f1 e2 10000) f2) >

<de dflt-h ()
   (muldiv
      58
      (sub (right *screen) (left *screen))
      100 >

<de dflt-v ()
   (sub (bottom *screen) (top *screen) 150) >

(zero $find)

<de doFind (s)
   (and s (setq *find s))
   (local (n)
      (with *job
         (and
            *find
            (setq n
               (txFind
                  (txtPtr (slot listener))
                  (txtLen (slot listener))
                  $find
                  *find ) )
            (hiText *job (setq $find n) (add n (strlen *find))) >

<de setJob (obj)
   (when (neq obj *job)
      (off *undo *redo)
      (when *job
         (with *job
            (slot *vars *vars)
            (slot *strs *strs)
            (slot *grps *grps)
            (slot *merk *merk) ) )
      (if (setq *job obj)
         (with obj
            (do show 'statWin)
            (do setStat 'statWin (slot pos) (slot status1))
            (setq
               *vars (slot *vars)
               *strs (slot *strs)
               *grps (slot *grps)
               *merk (slot *merk) )
            [(do reset obj)] )
         (progn
            (off *vars *strs *grps *merk)
            (do hide 'statWin)
            (XSetInputFocus *display
               (XtWindow (car *menu))
               #None #CurrentTime ) ) ) )
   obj >

<de dirty (n)
   (flag *job 'dirty)
   (with *job
      (slot dirty
         (if (slot dirty)
            (min n (slot dirty))
            n >

<de txPaste (s)
   (with *job
   (XmTextReplace
      (slot listener)
      (selStart (slot listener))
      (selEnd (slot listener))
      s >

<de insLine (s n1 n2)
   (default n2 n1)
   (with *job
      (XmTextReplace (slot listener) n1 n2 (^J))
      (XmTextReplace (slot listener) n1 n1 s) >

<de hiText (job n1 n2)
   (with *job
      (XtSetValues (slot listener) "cursorPosition" n1)
      (XmTextSetSelection (slot listener)
         n1
         (default n2 n1)
         #CurrentTime >

<de install (wg lst1 lst2)
   (mapc lst1
      (lambda (x)
         (callback wg (car x) (cdr x)) ) )
   (mapc lst2
      (lambda (x)
         (call2back wg (car x) (value (cadr x)) (cddr x)) >

<de normCode (s)
   (or
      (get
         (find *jobs
            (lambda (x) (equal s (get x 'name))) )
         'code )
      (cdr (assoc s *norm))
      (local (p txt *p)
         (watch *display)
         (or
            (exists s (setq p))
            (exists s (setq p (get *job 'path)))
            (setq p (find *path (lambda (p) (exists s p))))
            (cosyError s #(str "Norm nicht gefunden")) )
         (setq *p
            (ref
               (setq txt
                  (readFile (append p s)
                     #(str "Oeffnen Datei Fehler") ) ) ) )
         (setq
            *code (list 0)
            *parse )
         (until (zerop (byte *p))
            (when (setq x (parse))
               (setq *parse
                  (nconc1 *parse
                     (cons nil (cons nil (preprocess x))) ) ) ) )
         (while *parse
            (nconc1 *code (compile1)) )
         (push (cons s *code) *norm)
         *code >

<de delimComma (s)
   (when s
      (delim s (lambda (x) (equal x ","))) >

<de allStrokes (lst n1 n2)
   (mapcan lst
      (lambda (s)
         (with s
            (when (get (slot statement) 'text1)
               (if (leq n1 (get (slot statement) 'text1) n2)
                  (list s)
                  (if (slot strokes)
                     (allStrokes (slot strokes) n1 n2) >

<de markSelection ()
   (with *job
      (mark *job
         (allStrokes
            (slot strokes)
            (selStart (slot listener))
            (selEnd (slot listener)) >

<de superStroke (obj lst)
   (local (n x)
      (with *job
         (setq n (length (slot strokes)))
         (all exec lst)
         (setq x
            (new obj (nthcdr n (slot strokes))) )
         (if (zerop n)
            (slot strokes (list x))
            (rplacd
               (nthcdr (sub1 n) (slot strokes))
               (list x) ) )
         x >

(setq $grp 0)

<de mkGrp ()
   (while (assoc (mul #(eye 10000) (inc $grp)) *grps))
   (format $grp) >

(setq $scale (mul 10 10000))

<de setPos (pt)
   (with *job
      (slot pos (slot pos1 pt)) >

<de isSymbol (x)
   (and
      (eq 1 (length x))
      (car x)
      (symbolp (car x)) >

<de isString (x)
   (and
      (eq 1 (length x))
      (stringp (car x)) >

<de usForm (n f)
   (setq n
      (if f
         (format (div (add n 50) #(eye 100)) 2)
         (format n #(eye 4)) ) )
   (while (eq \0 (last n))
      (shift n) )
   (when (eq \. (last n))
      (shift n) )
   n >

<de line2 (pt1 pt2)
   (with *job
      (XDrawLine *display (slot draw) (slot gc)
         (car pt1) (cdr pt1)
         (car pt2) (cdr pt2) >

<de scale-h (d)
   (with *job
      (add
         (slot org-h)
         (muldiv #$scale d (slot scale)) >

<de scale-v (d)
   (with *job
      (sub
         (slot org-v)
         (muldiv #$scale d (slot scale)) >

<de scale (pt)
   (cons
      (scale-h (car pt))
      (scale-v (cdr pt)) >

<de scale1 (n)
   (muldiv #$scale n (get *job 'scale)) >

<de dots (n s)
   (muldiv s n #$scale) >

<de dots-h (n)
   (with *job
      (muldiv
         (slot scale)
         (sub n (slot org-h))
         #$scale >

<de dots-v (n)
   (with *job
      (muldiv
         (slot scale)
         (sub (slot org-v) n)
         #$scale >

<de unScale (pt)
   (cons
      (limit (dots-h (car pt)) -32000 +32000)
      (limit (dots-v (cdr pt)) -32000 +32000) >

<de scLine (h1 v1 h2 v2)
   (with *job
      (XDrawLine *display (slot draw) (slot gc)
         (muldiv (slot scale) (sub h1 (slot org-h)) #$scale)
         (muldiv (slot scale) (sub (slot org-v) v1) #$scale)
         (muldiv (slot scale) (sub h2 (slot org-h)) #$scale)
         (muldiv (slot scale) (sub (slot org-v) v2) #$scale) >

[+++ Graphics +++]
<de gcNormal ()
   (with *job
      (XSetForeground *display (slot gc) 0)
      (penSize *display (slot gc) 0)
      (solid *display (slot gc))
      (XSetFunction *display (slot gc) GXcopy) >

<de patXor ()
   (with *job
      (XSetFunction *display (slot gc) GXinvert) >
[++++++
      (XSetForeground *display (slot gc) #(pack 1023 1023 1023)) [!???!]
      (XSetFunction *display (slot gc) GXxor) >
++++++]

<de foreColor (c)
   (XSetForeground *display (get *job 'gc) c) >

<de backColor (c)
   (XSetBackground *display (get *job 'gc) c) >

<de putDot (pt)
   (with *job
      (XDrawLine *display (slot draw) (slot gc)
         (car pt) (sub2 (cdr pt)) (car pt) (add2 (cdr pt)) )
      (XDrawLine *display (slot draw) (slot gc)
         (sub2 (car pt)) (cdr pt) (add2 (car pt)) (cdr pt) >
[++++
   (with *job
      (fillRect *display (slot draw) (slot gc)
         (cons
            pt
            (cons
               (add dotSiz (car pt))
               (add dotSiz (cdr pt)) >
++++]

[++++++
<de nconc2 (l1 l2)
   (local (x)
      (if (setq x (shift l1))
         (nconc l1 (list (nconc x (pop l2))) l2)
         (nconc l1 l2) >
++++++]

t
