[ps.l 30jul91]

(off $fd $aufl $pass)
(on $first)
(setq $aufl 250)

[+++++
<de lyCmd (w)
   (catch 'error
      [(fileDialog "POSTSCRIPT" mkPs) ]
      (mkLy) >
+++++++]

<de psCmd (w)
   (catch 'error
      [(fileDialog "POSTSCRIPT" mkPs) ]
      (mkPs) >

<de psLy (lst)
   (local (r)
      (dupInit)
      (zero $pen $pos-h $pos-v)
      (setq
         $pass 50000
         r (bounds (mapcar lst (lambda (ly) (bounds (cadr ly)))))
         $fd (doCreate (append *home "tmp/ps")) )
      (psHeader 500000 500000 r)
      (mapc lst ps1ly)
      (psTrailer r) >

<de mkPs ([nm x y])
   (local (r)
      (dupInit)
      (zero $pen $pos-h $pos-v)
      (setq $pass 50000)
      (setq
         r (total (get *job 'strokes))
         $fd (doCreate (append *home "tmp/ps")) )
      (psHeader 500000 500000 r)
      (all ps (get *job 'strokes))
      (psTrailer r) >

<de psHeader (x y r)
   (local (h v)
      (setq
         $aufl 500
         h (abs (sub (bottom r) (top r)))
         v (abs (sub (right r) (left r))) )
      (prline "initgraphics" $fd)
      (prline "0 0 moveto" $fd)
      (when (lessp h v)
         (setq $aufl 700)
         (prline "90.0 rotate" $fd)
         (prline "0 -600 translate" $fd)
         (prline "0 0 moveto" $fd) )
      (setq $aufl (div (max $aufl h v) $aufl))
      (if (lessp h v)
         (setq h (left r) v (top r))
         (setq h (top r) v (left r)) )
      (prline
         (append
            (format (muldiv (sub x h) 1000 $aufl) 3)
            " "
            (format (muldiv (sub y v) 1000 $aufl) 3)
            " translate" )
         $fd )
      (prline "0 0 moveto" $fd)
      (PsPassKreuz) >

<de psTrailer (r1)
   (prline "stroke" $fd)
   [++++++
   (when (lessp (bottom r1) (right r1))
      (prline "400 0 translate" $fd)
      (prline "-90.0 rotate" $fd) )
   ++++++]
   (prline "showpage" $fd)
   (close $fd)
   (doOut "ps.dat") >

<de PsPassKreuz ()
   (when $pass
      (local (n)
         (setq n (div2 $pass))
         (PsLine n 0 (minus n) 0)
         (PsLine 0 (minus n) 0 n >

[+ 1000  wg. inch +]
<de PsLine (x1 y1 x2 y2)
   (unless
      (and
         (eq $pos-h x1)
         (eq $pos-v y1) )
      (if $first
         (off $first)
         (prline "stroke" $fd) )
      (prline "newpath" $fd)
      (prline
         (append
            (format (muldiv x1 1000 $aufl) 3) (list -1)
            (format (muldiv y1 1000 $aufl) 3)
            " moveto" )
         $fd ) )
   (prline
      (append
         (format (muldiv x2 1000 $aufl) 3) (list -1)
         (format (muldiv y2 1000 $aufl) 3)
         " lineto" )
      $fd )
   (off $first)
   (setq $pos-h x2)
   (setq $pos-v y2) >

[+ 1000  wg. inch +]
<de PsCurveto (p q r s)
   (unless
      (and
         (eq $pos-h (car p))
         (eq $pos-v (cdr p)) )
      (if $first
         (off $first)
         (prline "stroke" $fd) )
      (prline "newpath" $fd)
      (prline
         (append
            (format (muldiv (car p) 1000 $aufl) 3) (list -1)
            (format (muldiv (cdr p) 1000 $aufl) 3)
            " moveto" )
         $fd ) )
   (prline
      (append
         (format (muldiv (car q) 1000 $aufl) 3) (list -1)
         (format (muldiv (cdr q) 1000 $aufl)  3) (list -1)
         (format (muldiv (car r) 1000 $aufl) 3) (list -1)
         (format (muldiv (cdr r) 1000 $aufl)  3) (list -1)
         (format (muldiv (car s) 1000 $aufl) 3) (list -1)
         (format (muldiv (cdr s) 1000 $aufl)  3)
         " curveto" )
      $fd )
   (off $first)
   (setq $pos-h (car s))
   (setq $pos-v (cdr s)) >

<de PsStChk (obj)
   (local (a n)
      (with obj
         (setq n (cdr (assoc 'pen (slot status))))
         (unless (eq n $pen)
            (setq $pen n)
            (prline "stroke" $fd)
            (prline "newpath" $fd)
            (when (setq a (cdr (assoc 'COLOR (slot status))))
               (psColor a) )
            (psDash (cdr (assoc 'TYPE (slot status))))
            (prline
               (append
                  (format (muldiv $pos-h 1000 $aufl) 3) (list -1)
                  (format (muldiv $pos-v 1000 $aufl) 3)
                  " moveto" )
               $fd  >

<de lyChk (ty)
   (unless (eq ty $type)
      (setq $type ty)
      (prline "stroke" $fd)
      (prline "newpath" $fd)
      (psDash
         (nth
            ty
            '(NIL SINGLE DOUBLE TRIPLE QUAD) ) )
      (prline
         (append
            (format (muldiv $pos-h 1000 $aufl) 3) (list -1)
            (format (muldiv $pos-v 1000 $aufl) 3)
            " moveto" )
         $fd  >

<de psDash (s)
   (case s
      (SINGLE
         (prline "[] 0 setdash" $fd)
         (prline "0.5 setlinewidth" $fd) )
      (DOUBLE
         (prline "[6 3] 0 setdash" $fd)
         (prline "0.5 setlinewidth" $fd) )
      (TRIPLE
         (prline "[2 2] 0 setdash" $fd)
         (prline "0.5 setlinewidth" $fd) )
      (QUAD
         (prline "[8 2 2 2] 0 setdash" $fd)
         (prline "0.5 setlinewidth" $fd) )
      (t [ nil = bemassung ]
         (prline "0.1 setlinewidth" $fd)
         (prline "[] 0 setdash" $fd) >

<de psColor (s)
   [++++++++
   (prline
      (append
         (format (przt (nth 0 s)) 2)
         (32)
         (format (przt (nth 1 s)) 2)
         (32)
         (format (przt (nth 2 s)) 2)
         " setrgbcolor" )
      $fd
      ++++++++++]
      >

<de PsBrChk (obj)
   [+++++++
   (local (n)
      (with obj
         (setq n (cdr (assoc 'count (slot status))))
         (unless (eq n $cnt)
            (prline
               (case (setq $cnt n)
                  (0 "BR1;")
                  (1 "BR9;")
                  (t (append "BR" (format n) ";")) )
               $fd
               ++++++]
               >

<de ps1ly (ly)
   (lyChk (caar ly))
   (draw 1000 (knips (cadr ly) (cddr ly))
      (lambda (h1 v1 h2 v2)
         (PsLine h1 v1 h2 v2) )
      (lambda (p q r s)
         (PsCurveto p q r s)
         t >

<to ps stroke (obj)
   (local (g)
      (when (setq g (dupChk (get obj 'graf)))
         (PsstChk obj)
         (draw 1000 g
            (lambda (h1 v1 h2 v2)
               (PsLine h1 v1 h2 v2) )
            (lambda (p q r s)
               (PsCurveto p q r s)
               t >

(to ps s-set (obj))

<to ps s-grp (obj)
   (all ps (get obj 'strokes)) >

[ rotate counterclockwise coord-system]
t
