[stroke.l 09aug91abu]

(setq *graf)

[+++ Stroke objects +++]
<de total (lst)
   (when lst
      (local ($x1 $y1 $x2 $y2)
         (setq
            $x1 *max
            $y1 *max
            $x2 *min
            $y2 *min )
         (all total lst)
         (cons2 $x1 $y1 $x2 $y2) >

<de tot-x (x)
   (setq
      $x1 (min $x1 x)
      $x2 (max $x2 x) >

<de tot-y (y)
   (setq
      $y1 (min $y1 y)
      $y2 (max $y2 y) >

<de doSnap (pt $pt)
   (local (x)
      (with *job
         (setq
            $snap (0.0)
            $dist (dist $pt (0.0)) )
         (all snap (slot strokes))
         (mapc (slot abszisse)
            (lambda (h)
               (and
                  pt
                  (setq x
                     (intsec
                        (cons h -100000000)
                        (cons h 100000000)
                        pt
                        $pt ) )
                  (snapPt x) )
               (mapc (slot ordinate)
                  (lambda (v) (snapPt (cons h v))) ) ) )
         (mapc (slot ordinate)
            (lambda (v)
               (and
                  pt
                  (setq x
                     (intsec
                        (cons -100000000 v)
                        (cons 100000000 v)
                        pt
                        $pt ) )
                  (snapPt x) )
               (mapc (slot abszisse)
                  (lambda (h) (snapPt (cons h v))) ) ) )
         $snap >

<de snapPt (pt)
   (when (lessp (dist pt $pt) $dist)
      (setq
         $dist (dist pt $pt)
         $snap pt >

<de setStat (obj)
   (put obj 'status (get *job 'status1)) >


(object stroke)

<to t (obj $foo)
   (put obj 'statement *stmt)
   (with *job
      (slot strokes
         (append (slot strokes) (list obj)) )
      ($foo)
      (slot status1 (slot status)) >

<to del (obj pt1 pt2) >  [+ network detail !!  +]

<to cut (obj) >  [+ network detail !!  +]

<to graf (obj s)
   (local (x)
      (with obj
         (and
            (slot status)
            (or (null s) (member (car (slot status)) s))
            (if (setq x (assoc (slot status) *graf))
               (nconc (cdr x) (copy (slot graf)))
                  [+ (graf (slot graf)
                     (lambda (pt)
                        (if
                           (find *graf
                              (lambda (l)
                                 (find (cdr l)
                                    (lambda (z)
                                       (find z
                                          (lambda (p)
                                             (and
                                                (pointp p)
                                                (nearPt p pt)
                                                (setq x p) ) ) ) ) ) ) )
                           x pt ) ) ) ) +]
               (push
                  (cons
                     (slot status)
                     (copy (slot graf)) )
                  *graf >

<to ww1 (obj l pt1 pt2)
   (local (a b g)
      (setq
         g (get obj 'graf)
         a (last (last g))
         b (caar g) )
      (when
         (and
            (member (car (get obj 'status)) l)
            (or
               (equal a pt1)
               (equal a pt2)
               (equal b pt1)
               (equal b pt2) ) )
         (push obj *statlist) >

<to ww (obj l)
   (when (member (car (get obj 'status)) l)
      (push obj *statlist) >

<to size (obj)
   (add 4 [?]
      (size (value obj))
      (size (plist obj)) >

<to intersec (obj pt1 pt2)
   (with obj
      (when (cdr (assoc 'type (slot status)))
         (unless
            (beyond
               (or
                  (slot bounds)
                  (slot bounds (bounds (slot graf))) )
               pt1 pt2 )
            (secGraf (slot graf) pt1 pt2) >

<to gib-la (obj)
   (route
      (get obj 'graf) >

<to gib-wa (obj)
   (with obj
      (winkl (slot pt) (last (last (slot graf)))) >

<to total (obj)
   (local (r)
      (with obj
         (setq r (or (slot bounds) (slot bounds (bounds (slot graf)))))
         (tot-x (left r))
         (tot-x (right r))
         (tot-y (top r))
         (tot-y (bottom r)) >

<to dup (obj)
   (local (x)
      (set
         (setq x (gensym))
         (value obj) )
      (setplist x (plist obj))
      x >

<to hilite (obj)
   (draw (div 20000 (get *job 'scale)) (get obj 'graf)
      (lambda (h1 v1 h2 v2)
         (drawLine h1 v1 h2 v2 (hiPict obj)) >

<to draw (obj)
   (draw (div 20000 (get *job 'scale)) (get obj 'graf)
      (lambda (h1 v1 h2 v2)
         (drawLine h1 v1 h2 v2 (stPict obj)) >

<to getUr (obj)
   (caar (get obj 'graf)) >

<to setPos (obj)
   (setPos (last (last (get obj 'graf)))) >

<to pumk (obj)
   (with obj
      (slot graf
         (reverse (mapcar (slot graf) anti)) ) )
   obj >

<to spiegel-x (obj)
   (with obj
      (and (slot bounds) (slot bounds nil))
      (slot pt (mPtX (slot pt)))
      (slot graf
         (graf (slot graf) mPtX) )
      (setPos (last (last (slot graf)))) >

<to spiegel-y (obj)
   (with obj
      (and (slot bounds) (slot bounds nil))
      (slot pt (mPtY (slot pt)))
      (slot graf
         (graf (slot graf) mPtY) )
      (setPos (last (last (slot graf)))) >

<to dreh (obj w)
   (local (h v cw sw)
      (with *job
         (setq
            h (slot ur-x)
            v (slot ur-y)
            cw (cos w 10000)
            sw (sin w 10000) )
         (with obj
            (and (slot bounds) (slot bounds nil))
            (slot pt (rotz (slot pt) h v cw sw))
            (slot graf
               (graf (slot graf)
                  (lambda (pt)
                     (rotz pt h v cw sw) ) ) )
            (setPos (last (last (slot graf)))) >

<to trans (obj a b c d e f)
   (with obj
      (and (slot bounds) (slot bounds nil))
      (slot pt (transPt (slot pt) a b c d e f))
      (slot graf
         (graf (slot graf)
            (lambda (pt) (transPt pt a b c d e f)) ) )
      (setPos (last (last (slot graf)))) >

<to move (obj x y)
   (with obj
      (and (slot bounds) (slot bounds nil))
      (slot pt (movePt (slot pt) x y))
      (slot graf
         (graf (slot graf)
            (lambda (pt) (movePt pt x y)) ) )
      (setPos (last (last (slot graf)))) >

<to atari (obj pt)
   (local (n)
      (with obj
         (setq n (div 200000 (get *job 'scale)))
         (and
            (ptInRect pt
               (insetRect
                  (or (slot bounds) (slot bounds (bounds (slot graf))))
                  (minus n)
                  (minus n) ) )
            (onside pt (slot graf) n)
            (list obj) >

<to snap (obj)
   (with obj
      (mapc (slot graf)
         (lambda (lst)
            (mapc lst
               (lambda (x)
                  (when (pointp x) (snapPt x)) >
[++++++
      (snapPt (caar (slot graf)))
      (snapPt (last (last (slot graf)))) >
++++++]


[--------------  SET - STROKES ----------------------------]
(object s-set stroke)

<to t (obj pt)
   (local (s)
      (with *job
         (setq s (slot status1))
         (from stroke t obj
            (lambda ()
               (with obj
                  (slot pt (get *job 'pos))
                  (slot graf (list (list pt)))
                  (setPos (caar (slot graf))) ) )
            (slot status1 s) >

<to show (obj)
   (local (b)
      (with obj
         (setq b (caar (slot graf)))
         (new 'showWin #(str "Set")
            (list
               (append #(str "X: ") (usForm (car b)))
               (append #(str "Y: ") (usForm (cdr b))) >

<to hilite (obj)
   (drawDot (caar (get obj 'graf)) (hiPict obj)) >

<to gib-la (obj)
   (with obj
      (distpt (slot pt) (last (last (slot graf)))) >

(to intersec (obj pt1 pt2))
(to total (obj))
(to pumk (obj) obj)
(to draw (obj))
<to getur (obj) (get obj 'pt)>


[--------------  LINE - STROKES ----------------------------]
(object s-line stroke)

<to t (obj a b)
   (from stroke t obj
      (lambda ()
         (setStat obj)
         (with obj
            (slot pt a)
            (slot graf (list (list a b))) )
         (setpos b) >

<to del (obj pt1 pt2)   [+ network +]
   (unless *del-stroke
      (with obj
         (when
            (and
               (or
                  (nearpt (caar (slot graf)) pt2)
                  (nearpt (caar (slot graf)) pt1) )
               (or
                  (nearpt (last (last (slot graf))) pt2)
                  (nearpt (last (last (slot graf))) pt1) ) )
            (setq *del-stroke obj) >

<to show (obj)
   (showLine obj (car (get obj 'status))) >



[-------------- ARC - STROKES ----------------------------]
(object s-arc stroke)

[anfangspunkt bogen , mittelpunkt, endpunkt, rechtslaufend]
<to t (obj pa m pe f)
   (from stroke t obj
      (lambda ()
         (setStat obj)
         (with obj
            (slot pt m)
            (slot graf (list (arcBez pa m pe f))) )
         (setpos pe) >

<to show (obj)
   (showArc obj (car (get obj 'status)) #(str "Arc")) >


(object s-circle s-arc)
<to show (obj)
   (showArc obj (car (get obj 'status)) #(str "Kreis")) >

[anfangspunkt bogen , mittelpunkt, endpunkt,rechtslaufend]
<to trans (obj a b c d e f)
   (unless (and (eq (abs a) (abs e)) (eq (abs b) (abs d)))
      (rplaca (class obj) 's-arc) )
   (from s-arc trans obj a b c d e f) >

(off *circles)

<to hilite (obj)
   (if *circles
      (drawCircle obj (hiPict obj))
      (from stroke hilite obj) >

<to draw (obj)
   (if *circles
      (drawCircle obj (stPict obj))
      (from stroke draw obj) >


[--------------  ELLIPSE - STROKES ----------------------------]
(object s-ellipse s-arc)

[anfangspunkt bogen , mittelpunkt, endpunkt,rechtslaufend]
<to t (obj m h v)
   (from stroke t obj
      (lambda ()
         (local (pt a b c d e f)
            (setStat obj)
            (zero b d)
            (if (lessp v h)
               (setq
                  pt (cons (sub (car m) h) (cdr m))
                  a 10000
                  c 0
                  e (muldiv v 10000 h)
                  f (muldiv (cdr m) (sub 10000 e) 10000) )
               (setq
                  pt (cons (car m) (add (cdr m) v))
                  a (muldiv h 10000 v)
                  c (muldiv (car m) (sub 10000 a) 10000)
                  e 10000
                  f 0 ) )
            (with obj
               (slot pt m)
               (slot graf (list (arcBez pt m pt t))) )
            (do trans obj a b c d e f) >

<to show (obj)
   (showArc obj (car (get obj 'status)) #(str "Ellipse")) >

[--------------  BEZIER - STROKES ----------------------------]
(object s-bez stroke)

<to t (obj p1 q r p2)
   (from stroke t obj
      (lambda ()
         (setStat obj)
         (with obj
            (slot pt p1)
            (slot graf (list (list p1 (cons q r) p2))) )
         (setpos p2) >

<to show (obj)
   (local (g p q r np)
      (with obj
         (setq
            g (slot graf)
            p (slot pt)
            q (car (cadar g))
            r (cdr (cadar g))
            np (last (last g)) )
         (new 'showWin #(str "Bezier")
            (list
               (append #(str "PX: ") (usForm (car p)))
               (append #(str "PY: ") (usForm (cdr p)))
               (append #(str "QX: ") (usForm (car q)))
               (append #(str "QY: ") (usForm (cdr q)))
               (append #(str "RX: ") (usForm (car r)))
               (append #(str "RY: ") (usForm (cdr r)))
               (append #(str "SX: ") (usForm (car np)))
               (append #(str "SY: ") (usForm (cdr np)))
               (append #(str "LA: ") (usForm (do gib-la obj)))
               (append #(str "Status: ") (car (get obj 'status)) >


[--------------  GRUPPEN  - STROKES ----------------------------]

(object s-grp stroke)

<to t (obj lst)
   (memory 6000)
   (from stroke t obj
      (lambda ()
         (with obj
            (slot strokes lst)
            (slot pos
               (or
                  (may getUr (car lst))
                  (0 . 0) >

<to del (obj pt1 pt2)   [+ network +]
   (all del (get obj 'strokes) pt1 pt2) >

<to cut (obj)   [+ network +]
   (when *del-stroke
      (if (cut *del-stroke (get obj 'strokes))
         (setq *del-stroke)
         (all del (get obj 'strokes)) >

<to graf (obj s)
   (all graf (get obj 'strokes) s) >

<to ww1 (obj l)
   (mapc (get obj 'strokes)
      (lambda (x)
         (do ww1 x l) >

<to ww (obj l)
   (mapc (get obj 'strokes)
      (lambda (x)
         (do ww x l) >

<to size (obj)
   (local (n)
      (setq n (from stroke size obj))
      (mapc (get obj 'strokes)
         (lambda (x)
            (inc n (do size x)) ) )
      n >

<to show (obj)
   (local (s a b c)
      (when
         (and
            (setq s (get obj 'strokes))
            (setq a (total s))
            (setq b (get obj 'statement)) )
         (cond
            ((setq c (get b 'name))
               (new 'showWin #(str "gruppe")
                  (nconc
                     (list
                        (append
                           #(str "Gruppendefinition")
                           #(str "  Gruppe ")
                           (align (format (div c 10000)) 3) ) )
                     (strrec a) ) ) )
            ((eq (car (get b 'code)) 'norm$)
               (new 'showWin #(str "Norm")
                  (nconc
                     (list
                        (append
                           #(str "Norm ")
                           (cadr (get b 'code)) ) )
                     (strrec a) ) ) )
            ((eq (car (get b 'code)) 'c-grp)
               (new 'showWin #(str "gruppe")
                  (nconc
                     (list
                        (append
                           #(str "Gruppenaufruf")
                           #(str "  Gruppe ")
                           (align
                              (format (div (cadr (get b 'code)) 10000))
                              3 ) ) )
                     (strrec a)  >

<de strrec (a)
   (list
      (append
         #(str "oben    ")
         (align (format  (div (bottom a) 1000) 1) 7) )
      (append
         #(str "links   ")
         (align (format  (div (left a) 1000) 1) 7) )
      (append
         #(str "unten   ")
         (align (format  (div (top a) 1000) 1) 7) )
      (append
         #(str "rechts  ")
         (align (format  (div (right a) 1000) 1) 7) >

<to gib-la (obj)
   (local (s l n)
      (when (setq s (get obj 'strokes))
         (off l)
         (setq n (length s))
         (until
            (or
               (zerop n)
               (setq l (do gib-la (nth (dec n) s))) ) )
         l >

<to gib-wa (obj)
   (local (s w n)
      (when (setq s (get obj 'strokes))
         (off w)
         (setq n (length s))
         (until
            (or
               (zerop n)
               (setq w (do gib-wa (nth (dec n) s))) ) )
         w >

<to dup (obj)
   (local (x)
      (setq x (from stroke dup obj))
      (put x 'strokes
         (mapcar (get x 'strokes)
            (lambda (y) (do dup y)) ) )
      x >

<to total (obj)
   (local (s r)
      (with obj
         (when (setq s (slot strokes))
            (setq r
               (or
                  (slot bounds)
                  (slot bounds (total s)) ) )
            (tot-x (left r))
            (tot-x (right r))
            (tot-y (top r))
            (tot-y (bottom r)) >

<to getUr (obj)
   (get obj 'pos) >

<to setPos (obj)
   (with obj
      (when (slot strokes)
         (do setPos (last (slot strokes))) >

<to pumk (obj)
   (local (l)
      (setq l)
      (mapc (get obj 'strokes)
         (lambda (e) (push (do pumk e) l)) )
      (put obj 'strokes l)
      obj >

<to intersec (obj pt1 pt2)
   (with obj
      (when (slot strokes)
         (unless
            (beyond
               (or
                  (slot bounds)
                  (slot bounds (total (slot strokes))) )
               pt1 pt2 )
            (mapcan (slot strokes)
               (lambda (x)
                  (do intersec x pt1 pt2) >

<to spiegel-x (obj)
   (with obj
      (and (slot bounds) (slot bounds nil))
      (slot pos (mPtX (slot pos)))
      (all spiegel-x (slot strokes)) >

<to spiegel-y (obj)
   (with obj
      (and (slot bounds) (slot bounds nil))
      (slot pos (mPtY (slot pos)))
      (all spiegel-y (slot strokes)) >

<to dreh (obj w)
   (with obj
      (and (slot bounds) (slot bounds nil))
      (slot pos
         (rotz
            (slot pos)
            (get *job 'ur-x)
            (get *job 'ur-y)
            (cos w 10000) (sin w 10000) ) )
      (all dreh (slot strokes) w) >

<to trans (obj a b c d e f)
   (with obj
      (and (slot bounds) (slot bounds nil))
      (slot pos
         (transPt (slot pos) a b c d e f) )
      (all trans (slot strokes) a b c d e f) >

<to move (obj x y)
   (with obj
      (and (slot bounds) (slot bounds nil))
      (slot pos (movePt (slot pos) x y))
      (all move (slot strokes) x y) >

<to atari (obj pt)
   (local (s n a)
      (with obj
         (and
            (setq s (slot strokes))
            (setq n (div 200000 (get *job 'scale)))
            (ptInRect pt
               (insetRect
                  (or (slot bounds) (slot bounds (total s)))
                  (minus n)
                  (minus n) ) )
            (loop
               (t (null s))
               (t (setq a (do atari (pop s) pt))
                  (cons obj a) >

<to snap (obj)
   (with obj
      (snapPt (slot pos))
      (all snap (slot strokes)) >

<to hilite (obj)
   (local (s r)
      (with obj
         (when (setq s (slot strokes))
            (setq r
               (or
                  (slot bounds)
                  (slot bounds (total s)) ) )
            (unless
               (beyond
                  (portRect *display (get *job 'draw))
                  (unScale (car r))
                  (unScale (cdr r)) )
               (all hilite (get obj 'strokes)) >

<to draw (obj)
   (local (s r)
      (with obj
         (when (setq s (slot strokes))
            (setq r
               (or
                  (slot bounds)
                  (slot bounds (total s)) ) )
            (unless
               (beyond
                  (portRect *display (get *job 'draw))
                  (unScale (car r))
                  (unScale (cdr r)) )
               (all draw s) >


[----------------  NORM  - STROKES ----------------------------]

(object s-norm s-grp)

<to t (obj lst)
   (from stroke t obj
      (lambda ()
         (local (s)
            [(setq *graf)]
            (memory (div2 (amount lst (lambda (x) (do size x)))))
            (all graf lst)
            (with obj
               (slot pos (0 . 0))
               (mapc *graf
                  (lambda (x)
                     (with (setq s (gensym))
                        (set s '(stroke . object))
                        (slot statement *stmt)
                        (slot status (car x))
                        (slot graf (cdr x))
                        (slot pt (0.0)) )
                     (slot strokes (nconc1 (slot strokes) s)) ) ) )
            (setq *graf) >

<to atari (obj pt)
   (local (l)
      (when (setq l (from s-grp atari obj pt))
         (chop 1 l) >

t
