[viewer.l 31jan91]

<de hilite (job)
   (with *job
      [(penSize *display (slot gc) 0)]
      (solid *display (slot gc))
      (patXor)
      (mapc (slot hiPict)
         (lambda (x)
            (drawPict *display (slot draw) (slot gc) (ref (cdr x))) >

<de drawGrid (dh dv col)
   (foreColor col)
   (local (r)
      (setq r (portRect *display (slot draw)))
      (rplaca (car r) (dots-h (grid (scale-h 0) dh)))
      (rplacd (car r) (dots-v (grid (scale-v 0) dv)))
      (pustel *display (slot draw) (slot gc) r dh dv (slot scale)) >

<de dotPos ()
   (foreColor #(pack 0 0 0))
   (patXor)
   (putDot (unscale (get *job 'pos))) >

[(setq  $grid1 50000  $grid2 100000)]

<de redraw (f)
   (watch *display)
   (local (a)
      (with *job
         (if
            (or
               f
               (not (equal (slot lastabs) (slot abszisse)))
               (not (equal (slot lastord) (slot ordinate)))
               (not (setq a (memq (slot laststroke) (slot strokes)))) )
            (genPict)
            (all draw (cdr a)) )
         (refresh) >

<de genPict ()
   (with *job
      (mapc (slot stPict)
         (lambda (x)
            (clrPict (ref (cdr x))) ) )
      (mapc (slot hiPict)
         (lambda (x)
            (clrPict (ref (cdr x))) ) )
      (all draw (slot strokes))
      (all hilite (slot mark)) >


<de refresh ()
   (with *job
      (gcNormal)
      (XClearWindow *display (slot draw))
      (when (flagp *job 'grid)
         (drawGrid (slot grid-h) (slot grid-v) #(pack 0 400 0)) )
      (foreColor #(pack 800 800 0))
      (mapc (slot abszisse)
         '((h)
            (setq h (dots-h h))
            (XDrawLine *display (slot draw) (slot gc)
               h -9999 h +9999 ) ) )
      (mapc (slot ordinate)
         '((v)
            (setq v (dots-v v))
            (XDrawLine *display (slot draw) (slot gc)
               -9999 v +9999 v ) ) )
      (when (flagp *job 'hilite)
         (hilite *job) )
      (mapc (slot stPict)
         (lambda (x)
            (gcNormal)
            (foreColor (apply pack (cdr (assoc 'color (car x)))))
            (when (eq 'DOTTED (cdr (assoc 'style (car x))))
               (dotted *display (slot gc)) )
            (drawPict
               *display
               (slot draw)
               (slot gc)
               (ref (cdr x)) ) ) )
      (dotPos) >

<de findViewer (wg)
   (or
      (find *jobs
         (lambda (x)
            (eq wg (get x 'viewer)) ) )
      (error "Viewer not found") >

[+++ VIEWER event functions +++]
<de v-key (*job ev)
   (case (XKey ev)
      (#XK-Left (warp-h *display -1))
      (#XK-Up (warp-v *display -1))
      (#XK-Right (warp-h *display +1))
      (#XK-Down (warp-v *display +1))
      (#XK-Return (print [doAtari] (ev-pos ev)))
      (t (do reset *job)) >

<de v-button (*job ev)
   (do button 'statWin)
   (case (ev-button ev)
      (1 (doAtari (ev-pos ev)))
      (2 (schieb (ev-pos ev)))
      (3) >

<de v-release (*job ev)>

<de v-motion (*job ev)>

<de v-expose (*job ev)
   (if (zerop (ev-count ev))
      (refresh) >

<de v-out (*job ev)>

(off $top)

<de viewer (wg ev)
   (local (job)
      (setq job (findViewer wg))
      (case (ev-type ev)
         (#KeyPress (v-key job ev))
         (#ButtonPress (v-button job ev))
         (#ButtonRelease (v-release job ev))
         (#MotionNotify (v-motion job ev))
         (#Expose (v-expose job ev))
         (#VisibilityNotify
            (when
               (and
                  (zerop (ev-vistate ev))
                  (neq $top (get job 'viewer)) )
               (setq $top (get job 'viewer))
               (setJob job) ) )
         (#FocusIn (setJob job))
         (#FocusOut (v-out job ev)) >

t
