/* keye.c
 * 05mar91abu
 */

#include "../src/pico.h"
#include "cosy.h"

#define HLON 1
#define HLOFF 2
#define HLRD 3
#define HLWR 4
#define HLKEYE 5

#define DEV "/dev/keye"

typedef unsigned char byte;
typedef unsigned short word;

/* Prototypes */
static bool port(int);
static void hlOn(void);
static void hlOff(void);
static int keye(byte*);
static void hlRead(word);
static void hlWrite(word,word);

/* Globals */
static int k_fd;
static int thePort,modAd;
static char initStr[] = "PicoLisp";


pico KEye(x)
pico x;
{
   number a,c;
   char buf[5+8];

   if (isCell(cdr(x))) {
      a = unBox(car(x));
      x = cdr(x);
      *(byte*)(buf+5) = a >> 16;
      *(word*)(buf+6) = a;
      *(word*)(buf+8) = unBox(car(x));
      *(word*)(buf+10) = (c = unBox(cdr(x))) >> 8;
      *(byte*)(buf+12) = c;
      hlOn(), keye(buf), hlOff();
      return boxNum(*(number*)(buf+6));
   }
   /* strcpy(buf+5, initStr); */
   x = EVAL1(x);
   NEEDNUM(x);
   *(number*)(buf+6) = unBox(x);
   hlOn(), keye(buf), hlOff();
   return newCell(
      boxNum(*(byte*)(buf+5) << 16  |  *(word*)(buf+6)),
      newCell(
         boxNum(*(word*)(buf+8)),
         boxNum(*(word*)(buf+10) << 8  |  *(byte*)(buf+12)) ) );
}

pico HlInit(x)
pico x;
{
   modAd = nextNum(&x);
   return boxBool(port(0) || port(1) || port(2));
}

/* 0: 0x3BC   1: 0x378   2: 0x278 */
bool port(n)
int n;
{
   char buf[5+9];

   thePort = n;
   strcpy(buf+5, initStr);
   hlOn();
   if (keye(buf) && keye(buf) && !strncmp(initStr,buf+5,8)) {
      hlOff();
      return YES;
   }
   hlOff();
   return NO;
}

void hlOn()
{
   char buf[10];

   k_fd = open(DEV,2);
   buf[0] = HLON;
   *(word*)(buf + 1) = thePort;
   *(word*)(buf + 3) = modAd;
   write(k_fd,buf,7);
}
  
void hlOff()
{
   char buf[10];

   buf[0] = HLOFF;
   *(word*)(buf + 1) = thePort;
   write(k_fd,buf,7);
   close(k_fd);
}

keye(p)
byte *p;
{
   int m;

   *p = HLKEYE;
   *(word*)(p+1) = thePort;
   *(word*)(p+3) = 2;
   m = write(k_fd,p,13);
   read(k_fd,p+5,13);
   return m;
}

void hlRead(adr)
word adr;
{
   char buf[10];

   buf[0] = HLRD;
   *(word*)(buf + 1) = thePort;
   *(word*)(buf + 3) = adr;
   write(k_fd,buf,7);
}

void hlWrite(adr,val)
word adr,val;
{
   char buf[10];

   buf[0] = HLWR;
   *(word*)(buf + 1) = thePort;
   *(word*)(buf + 3) = adr;
   *(word*)(buf + 5) = val;
   write(k_fd,buf,7);
}
