/* kreis.c
 * 14jan91gr
 */

#include "../src/pico.h"
#include "bez.h"
#include "cosy.h"


/* Prototypes */
static bool pcentre(Dxy,Dxy,Dxy,Dxy*);
static void rrr(Dxy,Dxy,Dxy,Dxy*,Dxy*,double);
static double winkel(Dxy, Dxy, Dxy, Dxy);

pico ArcLen(x)
pico x;
{
   Dxy pa,m,pe;
   bool f;
   double w;

   nextCosyPoint(&x,&pa);
   nextCosyPoint(&x,&m);
   nextCosyPoint(&x,&pe);
   f = nextBool(&x);
   w = winkl(m,pe) + 360.0 - winkl(m,pa);
   if (w > 360.0)
      w -= 360.0;
   if (f)
      w = 360.0 - w;
   return boxCosyDouble(2*PI * DIS(m,pe) * w/360.0);
}

pico boxCosyDouble(n)
register double n;
{
   return boxDouble(n * SCAL);
}

pico boxCosyPoint(p)
register Dxy *p;
{
   return newCell(boxDouble(p->dx * SCAL), boxDouble(p->dy * SCAL));
}

pico Cosyacos(z)
pico z;
{
   double x;

   x = nextCosyDouble(&z);
   return boxCosyDouble(acos(x)*180.0/PI);
}

pico Cosyasin(z)
pico z;
{
    double x;

    x = nextCosyDouble(&z);

   return boxCosyDouble(asin(x)*180.0/PI);
}

pico Cosyatan(z)
pico z;
{
    double x;

    x = nextCosyDouble(&z);

   return boxCosyDouble(atan(x)*180.0/PI);
}

pico CosyLw(x)
pico x;
{
    Dxy p;
    double w,l;

    nextCosyPoint(&x,&p);
    l = nextCosyDouble(&x);
    w = nextCosyDouble(&x)*PI/180;
    p.dx += cos(PI2-w)*l;
    p.dy += sin(PI2-w)*l;

    return boxCosyPoint(&p);
}

pico CosyCos(z)
pico z;
{
    double y,w,l;

    y = nextCosyDouble(&z);         /*  y-wert startpunkt  */
    l = nextCosyDouble(&z);         /*  laenge  */
    w = nextCosyDouble(&z)*PI/180;

   return boxCosyDouble(y + sin(PI2-w)*l);
}

pico CosySin(z)
pico z;
{
    double x,w,l;

    x = nextCosyDouble(&z);         /*  x-wert startpunkt  */
    l = nextCosyDouble(&z);         /*  laenge  */
    w = nextCosyDouble(&z)*PI/180;

   return boxCosyDouble(x + cos(PI2-w)*l);
}

pico CosyTan(z)
pico z;
{
    Dxy p;
    double y,w,l;

    nextCosyPoint(&z,&p);         /* startpoint   */
    y = nextCosyDouble(&z);         /*  y-wert  */
    w = nextCosyDouble(&z)*PI/180;

      l = y - p.dy;

    if (l == 0.0) return boxCosyPoint(&p);

      if (w==PI2 || w==3*PI2) return nilSym;

   return newCell(boxDouble((p.dx + tan(w) * l) * SCAL), boxDouble(y * SCAL));
}

pico CosyCoTan(z)
pico z;
{
    Dxy p;
    double x,w,l;

    nextCosyPoint(&z,&p);         /* startpoint   */
    x = nextCosyDouble(&z);         /*  x-wert  */
    w = nextCosyDouble(&z)*PI/180;

      l = x - p.dx;

    if (l == 0.0) return boxCosyPoint(&p);

      if (w==0.0 || w==PI || w == 2*PI) return nilSym;

   w = PI2 - w;            /* versezzt um 90 grad */

   return newCell(boxDouble(x * SCAL), boxDouble((p.dy + tan(w) * l) * SCAL));
}

pico Cosygxy(x)
pico x;
{
    Dxy p0,p1,p2,p3,ps,erg;
    double r,h,l,scale;

    nextCosyPoint(&x,&p0);         /* startpoint   */
    nextCosyPoint(&x,&p1);         /* startpoint   */
    nextCosyPoint(&x,&p2);         /*  endpoint  */
    r = nextCosyDouble(&x);         /*  radius  */

    h = DIS(p1,p2);
    l = r-h;
    p3.dx = p2.dx + (p2.dx - p1.dx)*l/h;
    p3.dy = p2.dy + (p2.dy - p1.dy)*l/h;

   if (fabs(r) < h || r==0 || h==0) return nilSym;

    h = cos(asin(l/r)) * r;      /* laenge p3-mittelpunkt */


    ps.dx = (p0.dx - p1.dx) / DIS(p0,p1);    /***senkrechter einheitsvectorvector */
    ps.dy = (p0.dy - p1.dy) / DIS(p0,p1);

    erg.dx = p3.dx + ps.dx*h;
    erg.dy = p3.dy + ps.dy*h;

   if ((p1.dy - p0.dy) == 0.0) {
      p3.dx = (p2.dy - p1.dy) / (p0.dx - p1.dx);
   }
   else {
      p3.dx = (p2.dx - p1.dx) / (p1.dy - p0.dy);   /* ob endpunkt links oder rechts von gerade*/
   }
    p3.dy = 0;

    push(nilSym);
    tos = newCell(boxCosyPoint(&p3), tos);
    tos = newCell(boxCosyPoint(&erg), tos);
   return pop();
}

pico Cosykxy(x)
pico x;
{

    Dxy pm,p1,p2,ps,erg1,erg2;
    double r,h;

    nextCosyPoint(&x,&p1);         /* startpoint   */
    nextCosyPoint(&x,&p2);         /*  endpoint  */
    r = nextCosyDouble(&x);         /*  radius  */

    h = DIS(p1,p2);
    if (fabs(r) < h/2 || r==0 || h==0) return nilSym;

    pm.dx = (p1.dx + p2.dx) / 2;   /* set middle point */
    pm.dy = (p1.dy + p2.dy) / 2;

    ps.dx = (p1.dy - p2.dy) / h;    /***senkrechter einheitsvector */
    ps.dy = (p2.dx - p1.dx) / h;

    h = sin(acos(DIS(p2,pm)/r)) *r;   /* laenge pm-schnittpunkt */

    erg1.dx = pm.dx + ps.dx*h;
    erg1.dy = pm.dy + ps.dy*h;

    erg2.dx = pm.dx - ps.dx*h;
    erg2.dy = pm.dy - ps.dy*h;

    push(nilSym);
    tos = newCell(boxCosyPoint(&erg1), tos);
    tos = newCell(boxCosyPoint(&erg2), tos);
   return pop();
#if 0
    push(boxCosyPoint(&erg1));
    x = newCell(tos,boxCosyPoint(&erg2));
    drop();
    return x;

    return newCell(boxDouble(erg.dx * 10000), boxDouble(erg.dy * 10000));
#endif
}

/*schnittpunkt gerade kreis  */
pico Cosyspgk(x)
pico x;
{
    Dxy p1,p2,pc,erg,o,u;
    double a,b,c,b1, k,r,z;

    nextCosyPoint(&x,&u);         /* startpoint   */
    nextCosyPoint(&x,&o);         /* endpoint   */
    nextCosyPoint(&x,&pc);        /* centrepoint   */
    r = nextCosyDouble(&x);

#if 0
   if (p1.dx > p2.dx) {
      o = p1;
      u = p2;
   }
   else {
      o = p2;
      u = p1;
   }
   if (o.dy < u.dy) {
      a = o.dy;
      o.dy = u.dy;
      u.dy = a;
   }
#endif
                /* achsenabschnitt der gerade y-achse */
    b1 = (-u.dx * (o.dy - u.dy) / (o.dx - u.dx)) + u.dy;
    k = (o.dy - u.dy) / (o.dx - u.dx);   /*tangens*/
                /* y=k*x +b */
    z = b1 - pc.dy;

    a = 1 + k*k;                  /* quad. gleichung */
    b = 2*(k*z - pc.dx) / a;         /* p */
    c = (z*z + pc.dx*pc.dx - r*r) / a;   /* q */

    r = b*b/4 - c;

    if ( r < 0.0 ) return nilSym;
    r = sqrt(r);

    p1.dx = -b/2 - r;
      p1.dy = k*p1.dx + b1;

    p2.dx = -b/2 + r;
      p2.dy = k*p2.dx + b1;

    push(nilSym);
    tos = newCell(boxCosyPoint(&p1), tos);
    tos = newCell(boxCosyPoint(&p2), tos);
   return pop();
}

/*schnittpunkt kreis kreis  */
pico Cosyspkk(x)
pico x;
{
    Dxy m1,m2,p1,p2;
    double a,b,c,a1,c1,b1,z,r1,r2,r, d;

    nextCosyPoint(&x,&m1);         /* erster mittelpunkt   */
    nextCosyPoint(&x,&m2);         /* 2. mittelpunkt   */
    r1 = fabs(nextCosyDouble(&x));
    r2 = fabs(nextCosyDouble(&x));

    d = DIS(m1,m2);                  /* check ob schnittpunkte moeglich */

   if ( (r1+r2) < d || (d + r1) < r2 || (d + r2) < r1 )
       return nilSym;
    if   (m2.dy == m1.dy) {
       p1.dx = p2.dx =  -(m1.dx*m1.dx - m2.dx*m2.dx -r1*r1 + r2*r2) / (2*(m2.dx - m1.dx));

          b = -2*m1.dy;
      c = (p1.dx - m1.dx)*(p1.dx - m1.dx) + m1.dy*m1.dy - r1*r1;

      r = sqrt(b*b/4 - c);
       if (r<0.0) return nilSym;

        p1.dy = m1.dy + r;
         p2.dy = m1.dy - r;
    }
    else {
                         /* gleichnug der gerade a1*y + b1*x + c1  = 0 */
          a1 = 2 * (m2.dy - m1.dy);      /*  , y-koeffizient */
       b1 = -(2 * (m2.dx - m1.dx)) / a1;      /* , x-koeffizient */
                           /* ,restglied */
       c1 = -(m1.dy*m1.dy - m2.dy*m2.dy + m1.dx*m1.dx - m2.dx*m2.dx - r1*r1 + r2*r2) / a1;
                              /* y = b1*x + c1 */

      z = c1 - m1.dy;
          a = 1 + b1*b1;                  /* quad. gleichung */
       b = 2*(b1*z - m1.dx) / a;            /* p */
          c = (z*z + m1.dx*m1.dx - r1*r1) / a;   /* q */

          r = sqrt(b*b/4 - c);

          if (r<0.0) return nilSym;

          p1.dx = -b/2 - r;
         p1.dy = b1*p1.dx + c1;

       p2.dx = -b/2 + r;
         p2.dy = b1*p2.dx + c1;
   }

    push(nilSym);
    tos = newCell(boxCosyPoint(&p1), tos);
    tos = newCell(boxCosyPoint(&p2), tos);
   return pop();
}

pico Cosysqrt(x)
pico x;
{
   double a;

    a = nextCosyDouble(&x);

   return boxCosyDouble(sqrt(a));
}

/*return winkel der linie po,p1 in cosywinkel */
pico Winkl(x)
pico x;
{
   Dxy p1,p2;

   nextCosyPoint(&x,&p1);
   nextCosyPoint(&x,&p2);
   return boxNum((4500000 - (long)(winkl(p1,p2) * SCAL)) % 3600000);
}

pico LotPoint(x)
register pico x;
{
   register pico y,z;
   double a,b,c,d,n;
   double fx,fy,gx,gy,px,py;

   push(EVAL1(x)); /* First arg: bLine's start point */
   x = cdr(x);
   push(EVAL1(x)); /* Second arg: bLine's end point */
   x = cdr(x);
   x = EVAL1(x); /* Third arg: point */
   y = pop();
   z = pop();
   fx = (double)(unBox(car(z)));
   fy = (double)(unBox(cdr(z)));
   gx = (double)(unBox(car(y)));
   gy = (double)(unBox(cdr(y)));
   px = (double)(unBox(car(x)));
   py = (double)(unBox(cdr(x)));
   a = distPt(px,py,fx,fy);
   b = distPt(px,py,gx,gy);
   if ((c = distPt(fx,fy,gx,gy)) == 0.0)
      return nilSym;
   a *= a;
   b *= b;
   c *= c;
   n = (a - b + c) / (2*c);
   if (n < 0.0  ||  n > 1.0)
      return nilSym;
   return newCell(boxDouble(fx + n*(gx-fx)), boxDouble(fy + n*(gy - fy)));
}

/* mittelpunkt aus punkt und winkel und radius */
pico mpt(x)
pico x;
{
    Dxy pt;
    double r,w;

    nextCosyPoint(&x,&pt);
    w = nextCosyDouble(&x)*PI/180.0;
    r = nextCosyDouble(&x);

    return newCell(
       boxDouble((pt.dx - sin(w)*r) * SCAL),
       boxDouble((pt.dy - cos(w)*r) * SCAL) );
}

double nextCosyDouble(p)
register pico *p;
{
   register pico x;

   x = EVAL1(*p);
   *p = cdr(*p);
   NEEDNUM(x);
   return (double)unBox(x) / SCAL;
}


void nextCosyPoint(p,wfp)
register pico *p;
Dxy *wfp;
{
   register pico x;

   x = EVAL1(*p);
   *p = cdr(*p);
   needPoint(x);
   wfp->dx = (double)unBox(car(x)) / SCAL;
   wfp->dy = (double)unBox(cdr(x)) / SCAL;
}

/* input three points: point point point(= 2 lines), search centre  */
bool pcentre(p0,p1,p2,cntr)
Dxy p0,p1,p2,*cntr;
{
   Dxy p3, p4;
   double a1, a2, nenner, z1x, z1y, z2x, z2y;

   z1x = p1.dy - p0.dy;
   z1y = p0.dx - p1.dx;
   z2x = p2.dy - p1.dy;
   z2y = p1.dx - p2.dx;
   if ((nenner = z1y * z2x - z1x * z2y) == 0.0)
      return NO;
   p3.dx = (p0.dx + p1.dx)/2;
   p3.dy = (p0.dy + p1.dy)/2;
   p4.dx = (p2.dx + p1.dx)/2;
   p4.dy = (p2.dy + p1.dy)/2;

   if (z1x == 0) {
      a1 = (p4.dy - p3.dy + z2y/z2x * (p3.dx-p4.dx)) * z2x / nenner;
      cntr->dx = p3.dx + a1 * z1x;
      cntr->dy = p3.dy + a1 * z1y;
   }
   else {
     a2 = (p4.dy - p3.dy - z1y/z1x * (p4.dx-p3.dx)) * z1x / nenner;
     cntr->dx = p4.dx + a2 * z2x;
     cntr->dy = p4.dy + a2 * z2y;
   }
   return YES;
}


#if 0
pico ptangle(x)
pico x;
{
    Dxy pt;
    double r,w;

    nextCosyPoint(&x,&pc);
    w = (nextCosyDouble(&x) - 90.0)*PI/180;   /*versezzt um 90 grad */
    r = nextCosyDouble(&x);

    return newCell(
       boxDouble((pt.dx + cos(w)*r) * SCAL),
       boxDouble((pt.dy + sin(w)*r) * SCAL) );
}
#endif

/* aus mittelpunkt und winkel und radius ->endpunkt */
pico ptangle(x)
pico x;
{
    Dxy pc;
    double r,w;

    nextCosyPoint(&x,&pc);
    w = (90.0 - nextCosyDouble(&x))*PI/180;   /*versezzt um 90 grad */
    r = nextCosyDouble(&x);

    return newCell(
       boxDouble((pc.dx + cos(w)*r) * SCAL),
       boxDouble((pc.dy + sin(w)*r) * SCAL) );
}

pico quadgl(z)
pico z;
{
    Dxy pt;
    double x, y, r, e;
    register double c,d;

    x = nextCosyDouble(&z);
    y = nextCosyDouble(&z);
    r = nextCosyDouble(&z);
    e = nextCosyDouble(&z);

    c = x*x + (e-y) *(e-y) - r*r;
    if (x*x < c) return nilSym;

    d = sqrt(x*x - c);

    return newCell(boxDouble((x-d) * SCAL),boxDouble((x+d) * SCAL));
}

/* from points p0, p1, p2 of polygon and radius r (rounded corner)
   determines center pc and starting points of curve-segment
   at p3 laying on line p0,p1 and endpoint p4 laying on p1,p2   */
void rrr(p0,p1,p2,p3,p4,r)
Dxy p1, p2, p0, *p3, *p4;
double r;
{
   Dxy p[6];
   double a1,a2, z1x, z1y, z2x, z2y;
   Dxy v1,v2;

   p[0]=p0;
   p[1]=p1;
   p[2]=p2;
/******** 
   if (DIS(p0,p1)-2.0  <  r)
      r = DIS(p0,p1)-2.0;
   if (DIS(p1,p2)-2.0  <  r)
      r = DIS(p1,p2)-2.0;
***********/
   z1x = p[0].dx - p[1].dx;
   z1y = p[0].dy - p[1].dy;
   z2x = p[2].dx - p[1].dx;
   z2y = p[2].dy - p[1].dy;
   a1 = 1.0 / sqrt(z1x*z1x + z1y*z1y);
   a2 = 1.0 / sqrt(z2x*z2x + z2y*z2y);
   v1.dx = r * a1 * z1x;
   v1.dy = r * a1 * z1y;
   v2.dx = r * a2 * z2x;
   v2.dy = r * a2 * z2y;
   p[3].dx = p[1].dx + 2*v1.dx;
   p[3].dy = p[1].dy + 2*v1.dy;
   p[4].dx = p[1].dx + 2*v2.dx;
   p[4].dy = p[1].dy + 2*v2.dy;
   p3->dx = p[1].dx + v1.dx;
   p3->dy = p[1].dy + v1.dy;
   p4->dx = p[1].dx + v2.dx;
   p4->dy = p[1].dy + v2.dy;
}

#if 0
pico RndPt(x)
pico x;
{
   Dxy p0,p1,p2;
   double r;
   Dxy pc,p3,p4,temp,a,b;

   nextCosyPoint(&x,&p0);
   a = p0;
   nextCosyPoint(&x,&p1);
   nextCosyPoint(&x,&p2);
   b = p2;
   r = nextCosyDouble(&x);
   if ( r == 0.0 ||
      (p0.dx == p1.dx && p0.dy == p1.dy) ||
      (p0.dx == p2.dx && p0.dy == p2.dy) ||
      (p1.dx == p2.dx && p1.dy == p2.dy) )
      return nilSym;
   rrr(p0,p1,p2,&p3,&p4,fabs(r));
   p0.dx = p1.dx + 2*(p3.dx-p1.dx);
   p0.dy = p1.dy + 2*(p3.dy-p1.dy);
   p2.dx = p1.dx + 2*(p4.dx-p1.dx);
   p2.dy = p1.dy + 2*(p4.dy-p1.dy);
   if (!pcentre(p0,p1,p2,&pc))
      return nilSym;
/*
   if (r < 0.0)
      temp = pc,  pc = p1,  p1 = temp;
*/
    push(nilSym);
    tos = newCell(boxCosyPoint(&b), tos);
    tos = newCell(boxCosyPoint(&p4), tos);
    tos = newCell(boxCosyPoint(&pc), tos);
    tos = newCell(boxCosyPoint(&p3), tos);
    tos = newCell(boxCosyPoint(&a), tos);
   return pop();
}
#endif

pico Rotz(p)
pico p;
{
   register number pch,pcv,a11,a12;
   point p1;

   nextPoint(&p,&p1);            /* Point to rotate */
   pch = num(EVAL1(p));
   NEEDNUM(pch);                /*center of rotation */
   pch = unBox(pch);
   p = cdr(p);
   pcv = num(EVAL1(p));
   NEEDNUM(pcv);
   pcv = unBox(pcv);
   p = cdr(p);
   a11 = num(EVAL1(p));
   NEEDNUM(a11);
   a11 = unBox(a11);
   p = cdr(p);
   a12 = num(EVAL1(p));
   NEEDNUM(a12);
   a12 = unBox(a12);

   if (pch==p1.h && pcv==p1.v)
      return newCell(boxNum(p1.h),boxNum(p1.v));

   p1.h =p1.h - pch;
   p1.v = p1.v - pcv;
   return newCell(
           boxNum(muldiv(a11 , p1.h ,10000)+
                  muldiv(a12 , p1.v, 10000) +
                  + pch) ,
           boxNum  (muldiv(-a12 , p1.h ,10000)+
                   muldiv(a11 ,p1.v, 10000) +
                   + pcv) );
}

#if 0
pico Rotz(p)
pico p;
{
   point p1,x,w;
   double pch,pcv,wh;
   register double i;
   register double r;
   double a11,a12,a21,a22;

   nextPoint(&p,&p1);            /* Point to rotate */
   pch = nextCosyDouble(&p);         /* Center of rotation */
   pcv = nextCosyDouble(&p);
   wh = nextCosyDouble(&p) * PI /180.0;   /* Angle */

   if (pch==p1.dx && pcv==p1.dy)
      return boxCosyPoint(&p1);

   a11 =  cos(wh);                  /* set rotation matrix */
   a12 =  sin(wh);
   a21 = -sin(wh);
   a22 =  cos(wh);

   w.dx = p1.dx - pch;
   w.dy = p1.dy - pcv;
   x.dx = a11 * w.dx + a12 * w.dy + pch;
   x.dy = a21 * w.dx + a22 * w.dy + pcv;

   return boxCosyPoint(&x);
}
#endif

/* winkel zwischen drei punkten p0, p1, p2 kleiner 180 grad-rechtssystem? */
#define RSN 100000000

pico rSyst(x)
pico x;
{
   register number n;
   point a,b,c;

   nextPoint(&x,&a);
   nextPoint(&x,&b);
   nextPoint(&x,&c);
   n = maxNumber(
         abs(muldiv(a.h,b.v,RSN)),
         maxNumber(
            abs(muldiv(a.v,b.h,RSN)),
            maxNumber(
               abs(muldiv(c.h,a.v,RSN)),
               maxNumber(
                  abs(muldiv(c.v,a.h,RSN)),
                  maxNumber(abs(muldiv(b.h,c.v,RSN)),
                      abs(muldiv(b.v,c.h,RSN))) ) ) ) );
   if (!n)
      n = 1;
   return boxBool(
         ((muldiv(a.h,b.v,n) - muldiv(a.v,b.h,n)) +
            (muldiv(c.h,a.v,n) - muldiv(c.v,a.h,n)) +
            (muldiv(b.h,c.v,n) - muldiv(b.v,c.h,n))) < 0 );
}

/* return punkt1 fuer erste gerade, punkt zweifuer zweite gerade */
pico tm(x)
pico x;
{
   double mx,my, ex,ey,cx,cy,r,a,b ;
   Dxy p1,p2;

    r = nextCosyDouble(&x);      /* radius */
    nextCosyPoint(&x,&p1);
    cx = nextCosyDouble(&x);   /* mittelpunkt */
    cy = nextCosyDouble(&x);
    ex = nextCosyDouble(&x);   /* punkt */
    ey = nextCosyDouble(&x);

    a = r/distPt(p1.dx,p1.dy,cx,cy);   /* sin */
    b = cos(asin(a));

    mx = cx - p1.dx;
    my = cy - p1.dy;

    p1.dx = mx*b - my*a;
    p1.dy = mx*a + my*b;

    a = -r/distPt(ex,ey,cx,cy);   /* sin */
    b = cos(asin(a));

    mx = cx - ex;
    my = cy - ey;

    p2.dx = mx*b - my*a;
    p2.dy = mx*a + my*b;

    push(nilSym);
    tos = newCell(boxCosyPoint(&p2), tos);
    tos = newCell(boxCosyPoint(&p1), tos);
   return pop();
}
/* extract angle from centrepoint c and two circle points p0 and p1 */
double winkel(pc,p0,p1,p2)
Dxy pc, p0, p2, p1;
{
   double w1, w2, w0, arc;

    w0 = arcTan(p0.dx-pc.dx, pc.dy-p0.dy);
    w2 = arcTan(p2.dx-pc.dx, pc.dy-p2.dy);
    w1 = arcTan(p1.dx-pc.dx, pc.dy-p1.dy);
    w1 = w1 >= 0.0? w1 : (2*PI) + w1;
    w2 = w2 >= 0.0? w2 : (2*PI) + w2;
    w0 = w0 >= 0.0? w0 : (2*PI) + w0;
    if (w2 > w0) {
       if ( (w1>w2 && w1<=(2*PI)) || (w1<w0 && w1>=0.0) )
          return -(2*PI) + w2 - w0;
   }
   else if ( (w1>w0 && w1<=(2*PI)) || (w1<w2 && w1>=0.0) )
       return (2*PI) - w0 + w2;
    return w2 - w0;
}

/*return wether point lies in sector */
pico wis(z)
pico z;
{
    double mx,my,px,py,s,w;

    mx = nextCosyDouble(&z);   /* mittelpunkt */
    my = nextCosyDouble(&z);
    px = nextCosyDouble(&z);   /* punkt */
    py = nextCosyDouble(&z);
    s = nextCosyDouble(&z);      /* startsector */

   if ((s==1.0) && px>=mx && py>=my) return tSym;
   if ((s==2.0) && px>=mx && py<=my) return tSym;
   if ((s==3.0) && px<=mx && py<=my) return tSym;
   if ((s==4.0) && px<=mx && py>=my) return tSym;
   return nilSym;
}

