/* kreis1.c
 * 11jan91gr
 */

#include "../src/pico.h"
#include "bez.h"
#include "cosy.h"

static bool schnittpt(Dxy,Dxy,Dxy,Dxy,Dxy*);

double arcTan(y,x)
register double x;  /* X-coordinate */
register double y;  /* Y-coordinate */
{
   double dval;

   if   (fabs(x) < EPS)
      return  y > 0.0 ?  PI2 : -PI2;
   dval = atan(y / x);
   if   (x > 0.0)
      return (dval);
   return y > 0.0 ?  dval+PI : dval-PI;
}

pico Cosykrinbo(x)
pico x;
{
   Dxy m,pe,e,pc,s;
   double l,r,a;

   nextCosyPoint(&x,&m);
   nextCosyPoint(&x,&pe);
   r = nextCosyDouble(&x);

   l = DIS(m,pe);
   a = (l*l - r*r) / (2*fabs(r));

   if (r < 0.0) {            /*linksdrehend */
      e.dx = (pe.dy - m.dy) / l;
      e.dy = -(pe.dx - m.dx) / l;

   }
   else {            /*rechtssdrehend */
      e.dx = -(pe.dy - m.dy) / l;
      e.dy = (pe.dx - m.dx) / l;
   }
   r = fabs(r);
   pc.dx = pe.dx + a*e.dx;
   pc.dy = pe.dy + a*e.dy;

   l = DIS(m,pc);
   s.dx = m.dx + r*(pc.dx - m.dx)/l;   /*schnitt kreis gerade */
   s.dy = m.dy + r*(pc.dy - m.dy)/l;

   return newCell(boxCosyPoint(&pc),boxCosyPoint(&s));
}

double winkl(p1,p2)
Dxy p1,p2;
{
   double a;

   if (DIS(p1,p2) == 0.0)
      return 0.0;
   a = arcTan(p2.dy - p1.dy,p2.dx - p1.dx) * 180.0 / PI;
   if (0.0 <= a && a <= 180.0)
      return a;
   return 360.0 + a;
}

pico tangente(x)
pico x;
{
   Dxy p0,p1,p2,p3;
   double l1,l2;
   Dxy pc,w1,w2,temp,e1,e2;

   nextCosyPoint(&x,&p0);
   nextCosyPoint(&x,&p1);
   nextCosyPoint(&x,&p2);
   nextCosyPoint(&x,&p3);

   if ((l1 = DIS(p0,p1)) == 0.0) return nilSym;
   if ((l2 = DIS(p1,p2)) == 0.0) return nilSym;
   e1.dx = (p0.dx - p1.dx) / l1;      /*einheitsvectoren */
   e1.dy = (p0.dy - p1.dy) / l1;
    e2.dx = (p2.dx - p1.dx) / l2;
   e2.dy = (p2.dy - p1.dy) / l2;

   w1.dx = (p1.dx + e1.dx + p1.dx +e2.dx) / 2;      /* new punkt on winkelhalbierender */
   w1.dy = (p1.dy + e1.dy + p1.dy +e2.dy) / 2;

   if ((l1 = DIS(p2,p3)) == 0.0) return nilSym;
   e1.dx = (p3.dx - p2.dx) / l1;      /*einheitsvectoren */
   e1.dy = (p3.dy - p2.dy) / l1;
   e2.dx = (p1.dx - p2.dx) / l2;
   e2.dy = (p1.dy - p2.dy) / l2;

   w2.dx = (p2.dx + e1.dx + p2.dx +e2.dx) / 2;      /* new punkt on winkelhalbierender */
   w2.dy = (p2.dy + e1.dy + p2.dy +e2.dy) / 2;

   if (!schnittpt(p1,w1,p2,w2,&pc)) return nilSym;

   return boxCosyPoint(&pc);
}

/* Intersection of two lines */
bool schnittpt(p0,p1,p2,p3,erg)
Dxy p0,p1,p2,p3;
Dxy* erg;
{
   double ax,ay,bx,by,cx,cy,dx,dy,ex,ey;
   double a1,a2,b1,b2;

   ax = p0.dx;
   ay = p0.dy;
   bx = p1.dx;
   by = p1.dy;
   dx = p2.dx;
   dy = p2.dy;
   ex = p3.dx;
   ey = p3.dy;


   if (ax==bx && dx==ex || ay==by && dy==ey) { /* Trivially parallel */
parallel:
      if (ax==dx && ay==dy || ax==ex && ay==ey) {
         erg->dx = ax;
         erg->dy = ay;
         return YES;
      }
      if (bx==dx && by==dy || bx==ex && by==ey) {
         erg->dx = bx;
         erg->dy = by;
         return YES;
      }
         return NO;
   }
   if (ax == bx) {
      a2 = (ey - dy) / (ex - dx);
      b2 = dy - a2 * dx;
      cx = ax;
      cy = a2 * cx + b2;
   }
   else if (dx == ex) {
      a1 = (by - ay) / (bx - ax);
      b1 = ay - a1 * ax;
      cx = dx;
      cy = a1 * cx + b1;
   }
   else if (dy == ey) {
      a1 = (by - ay) / (bx - ax);
      b1 = ay - a1 * ax;
      cy = dy;
      cx = (cy - b1) / a1;
   }
   else {
      a1 = (by - ay) / (bx - ax);
      a2 = (ey - dy) / (ex - dx);
      b1 = ay - a1 * ax;
      b2 = dy - a2 * dx;
      if (a1 == a2)
         goto parallel; /* Parallel */
      cy = (b1 - a1*b2/a2) / (1 - a1/a2);
      cx = (cy - b2) / a2;
   }

   erg->dx = cx;
   erg->dy = cy;
   return YES;
}

