/*******************************************************************/
/*                                                                 */
/*                       HARDLOCK E-Y-E                            */
/*                      C Implementation                           */
/*                                                                 */
/*                (c) 1989 by ///FAST Electronic                   */
/*                                                                 */
/*                                                                 */
/*       Computer: IBM PC or compatible                            */
/*       OS      : MS-PC/DOS 2.0 - 4.0                             */
/*       Language: TURBO C 2.0                                     */
/*       Author  : Thomas Schroeter                                */
/*       Version : 1.0                                             */
/*       Date    : September 7, 1989                               */
/*                                                                 */
/*       modified: Thomas Christinck (for XENIX)                   */
/*       Date mod: November 22 1989                                */
/*                 remove include                                  */
/*                 modify function-headers                         */
/*	 							   */
/*	 modified: Marcus M|uller (for 386/ix)			   */
/*	 Date mod: Januar 08 1990				   */
/*								   */
/*                                                                 */
/*******************************************************************/


#include "keye.h"

#define inportb(p)    inb(p)
#define outportb(p,w) outb(p,w)

#define AND    &
#define OR     |
#define XOR    ^

#define FALSE 0
#define TRUE  1
#define Boolean Word

Word    k_eye ();

void    Feal  ();
Byte    SBox  ();
Byte    RotLeft1();
Byte    RotLeft2();

void    EEco    ();

void    EEno    ();
void    EEout1  ();
void    EEout0  ();
void    ShiftOut();
void    WaitBusy();
Byte    EEInBit ();

void HL_ON (Port, ModAd)
Word Port;
Word ModAd;
{
     Word  n;
     Byte M0, M1, M2;

     M0 =  ModAd        AND 0x1F;           /*  make M0..M2 */
     M1 = (ModAd >>  5) AND 0x1F;
     M2 = (ModAd >> 10) AND 0x1F;

     outportb(Port, 0x7E);                  /* HL on  */

     for(n = 0; n < 16; n++){               /* sync HL */
        outportb(Port, 0x7F);
        outportb(Port, 0xFF);
        }

     outportb(Port, (M0 << 1) OR 0x41);     /*  output M0 */
     outportb(Port, (M0 << 1) OR 0xC1);

     outportb(Port, (M1 << 1) OR 0x01);     /*  output M1  */

     outportb(Port, (M2 << 1) OR 0x01);     /*  output M2  */
     outportb(Port, (M2 << 1) OR 0x81);

     outportb(Port, 0xC1);                  /*  one more sync */
     outportb(Port, 0x41);
}

void HL_OFF(Port)
Word Port;
{
     outportb(Port, 0xFE);
     outportb(Port, 0x7E);
}

Boolean K_EYE(Port, Inp, BlkCnt)
Word Port;
Byte * Inp;
Word BlkCnt;
{
     Word  m, n = 5,
          BitSum = 0;
     Long Left, Right,
          Mem, Key[6];

     Left  = *(Long *) &Inp[0];             /* get left 32 bit */
     Right = *(Long *) &Inp[4];             /* get right 32 bit */

     do{                                    /* encryption loop */
       Mem = Key[n] = Right;                /* store right 32 bit */
       BitSum += k_eye(Port, (char *) &Key[n]);   /* returns bits from HL */
       Right = Right XOR Key[n] XOR Left;         /* FEISTEL Chiffre */
       Left = Mem;                                /* restore left side */
   }while (n--);                                  /* 6 times */

     *(Long *) &Inp[0] = Right;                   /* write result back */
     *(Long *) &Inp[4] = Left;
     --BlkCnt;                                    /* already 1 block */
     if(BlkCnt)                                   /* more than one */
       if(BlkCnt <= 0x1FFF)                       /* <= 8192 blocs (64kb) */
         for(m = 0; m < BlkCnt; m++){             /* do number of blocks */
            Inp += 8;                             /* next data block */
            n = 5;                                /* 6 times chiffre */

            Left  = *(Long *) &Inp[0];
            Right = *(Long *) &Inp[4];

            do{
              Mem = Right;
              Feal((char *)&Right, Key[n]);
              Right ^= Left;
              Left = Mem;
            }while(n--);

            *(Long *) &Inp[0] = Right;
            *(Long *) &Inp[4] = Left;
            }

     if(BitSum > 3 && BitSum < 45) return TRUE;   /* HL is connected */

     return FALSE;                                /* HL not connected */
}

Word k_eye(Port, Right)
Word Port;
Byte Right[];
{
     Byte j, Accu, HlBit;
     Word  i, k,
          Bits = 0;

     outportb(Port, 0x81);                        /*  reset HL register */

     HlBit = 1;                                   /*  first bit always 1 */
     for(i = 0; i < 9; i++){                      /*  9 times argument  */
        for(k = 0; k < 4; k++){                   /* 4 * 4 bit = 16 bit */

           outportb(Port, ((Right[k] << 2) AND 0x3C) OR 0x41);   /*  set arg */
           j = (k + 1 + HlBit) AND 3;
           Accu = RotLeft1(Right[k]);
           Accu = (Accu + j + Right[j]) AND 0xFF;

           outportb(Port, ((Right[k] << 2) AND 0x3C) OR 0xC1);   /* Clock-Arg */
           Right[k] = RotLeft1(Accu);
           }

        HlBit = (((inportb(Port + 1) AND 0x80) >> 7) XOR 1);  /* read result */
        Bits += HlBit;
        }

     return Bits;
}

void Feal(Arg, Key)
Byte Arg[];
Long Key;
{
     Arg[1] ^= Arg[0];
     Arg[2] ^= Arg[3];

     *(Long *) &Arg[0] ^= Key;

     Arg[1] = SBox(Arg[1], Arg[2], 1);
     Arg[0] = SBox(Arg[0], Arg[1], 0);
     Arg[2] = SBox(Arg[2], Arg[1], 0);
     Arg[3] = SBox(Arg[3], Arg[2], 1);
}

Byte SBox(a, b, d)
Byte a,b,d;
{
     Byte acc;

     acc = (a + b + d) AND 0xFF;
     acc = RotLeft2(acc);

     return acc;
}

Byte RotLeft1(a)
Byte a;
{
     if(a >= 0x80)
       return((a << 1) OR 1);

     return(a << 1);
}

Byte RotLeft2(a)
Byte a;
{
     Byte h;

     h = a >> 6;
     a <<= 2;

     return(a OR h);
}

Word HL_RD(Port, Register)
Word Port, Register;
{
     Word  n;
     Word Val = 0;

     EEco(Port);                                  /* Chip Select  */
     EEout1(Port);                                /*  output 1  */
     ShiftOut(Port, Register OR 0x80);            /* Opcode READ */
     for(n = 0; n < 16; n++){                     /* read 16 Bits  */
        Val <<= 1;                                /* next position */
        Val |= EEInBit(Port);                     /* add Bit read from EEP */
        }
     return Val;
}

void HL_WR(Port, Register, Val)
Word Port, Register;
Word Val;
{
     EEco(Port);                                  /* Activer EEP */
     EEout1(Port);                                /* 1 */
     ShiftOut(Port, 0x30);                      
     EEno(Port);                                  /* CS off  */

     EEco(Port);
     EEout1(Port);
     ShiftOut(Port, Register | 0xC0);             /*  ERASE REGISTER */
     EEno(Port);
     WaitBusy(Port);                              /* wait till erased  */

     EEco(Port);
     EEout1(Port);
     ShiftOut(Port, Register | 0x40);             /* WRITE REGISTER */

     ShiftOut(Port, (Byte) (Val >> 8));           /*  write value Hi 8 Bit  */
     ShiftOut(Port, (Byte) (Val AND 0xFF));       /*  write value Lo 8 Bit  */

     EEno(Port);
     WaitBusy(Port);                              /* wait till done  */
}

void EEco(Port)                                   /* EEP Chip Select */
Word Port;
{
     outportb(Port, 0xC1);
     outportb(Port, 0x81);
     outportb(Port, 0x41);
     outportb(Port, 0x43);
     outportb(Port, 0xC3);
}

void EEno(Port)                             /* EEP Chip Select off  */
Word Port;
{
     outportb(Port, 0x41);
     outportb(Port, 0x01);
     outportb(Port, 0x41);
}

void EEout1(Port)                           /* EEP output 1  */
Word Port;
{
     outportb(Port, 0xD1);
     outportb(Port, 0x51);
     outportb(Port, 0xD1);
}

void EEout0(Port)                           /* EEP output 0  */
Word Port;
{
     outportb(Port, 0xC1);
     outportb(Port, 0x41);
     outportb(Port, 0xC1);
}

void ShiftOut(Port, Val)                    /*  EEP output 8 Bit value */
Word Port;                                  
Byte Val;
{
     Word  n;


     for(n = 0; n < 8; n++){
        if(Val AND 0x80) EEout1(Port);
        else EEout0(Port);
        Val <<= 1;
        }
}

void WaitBusy(Port)                         /*  EEP wait till idle */
                                            /* attendre jusqu' ce que EEP soit termin */
Word Port;
{
     Byte a;
     Word  n = 10000;

     EEco(Port);
     EEout1(Port);

     do{
       EEout0(Port);
       if(!(inportb(Port + 1) AND 0x80))
         break;
     }while(n--);

     EEno(Port);
}

Byte EEInBit(Port)                          /* EEP read 1 Bit  */
Word Port;
{
     Byte Bit;

     outportb(Port, 0x41);
     outportb(Port, 0xC1);

     Bit = inportb(Port + 1) AND 0x80;

     outportb(Port, 0x41);

     return((Bit >> 7) XOR 1);
}

