/****************************************************************/
/*             Hardlock implementation 386/ix                   */
/****************************************************************/

#include <sys/types.h>
#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/signal.h>
#include <sys/errno.h>
#include <sys/dir.h>
#include <sys/seg.h>
#include <sys/page.h>
#include <sys/user.h>
 
extern int max_copyrights;
extern char *oem_copyrights[];


/************************************************************************/
/*                      DEFINITIONS                                     */
/************************************************************************/

#define VERSION "KEYE Version 1.0 386/ix (c) 1990 Fast electronic & CAB GmbH." 

#define BUFFERSIZE      1100

#define TRUE            1
#define FALSE           0

#define SEM_FREE        0           /* Semaphore free */
#define SEM_BUSY        1           /* Semaphore busy */
#define SEM_WANTED      2           /* Semaphore busy and requested */

#define HLON   1
#define HLOFF  2
#define HLRD   3
#define HLWR   4
#define HLKEYE 5


/************************************************************************/
/*									*/
/*              DRIVER GLOBAL VARIABLES                                 */
/*                                                                      */
/************************************************************************/

static short hl_sem;   /* Hardlock semaphore */
static unsigned char buf[BUFFERSIZE]; /* Buffer for KEYE */
static short BlockCount; /* BlockCount for KEYE */
static short par_port[3];

/************************************************************************/
/*                                                                      */
/*       Functions and types: Byte, Word, Long       			*/
/*									*/
/************************************************************************/

#include "keye.h"


hlinit()
{
  int i;
  hl_sem = SEM_FREE;
  for (i=0; i < max_copyrights; i++) {
    if (!oem_copyrights[i]) {
      oem_copyrights[i] = VERSION;
      break;
    }
  }
  par_port[0] = 0x3bc;
  par_port[1] = 0x378;
  par_port[2] = 0x278;
}

hlopen(dev,flag)
{
}

hlclose(dev,flag)
{
}

hlread(dev)
{
  int i;
  for (i=0; i< BlockCount*4; i++)
    passc(buf[i+5]);
}

hlwrite(dev)
{
  int i;
  int sp;
  int ret;
  int prt;
  struct parms {
    int      fdesc;
    faddr_t  pbuf;
    unsigned count;
  } *uap;

  for (i=0; i < 7; i++)
    buf[i] = cpass();
    sp = spl0();

    if (hl_sem & SEM_BUSY) {
      hl_sem |= SEM_WANTED;
      sleep((caddr_t)hl_sem,PRIBIO);
    }
  splx(sp);
  sp = spl5(); 
  hl_sem = SEM_BUSY;

  ret = 0;
  prt = *(short *)(buf + 1);
  if (prt >= 0 && prt <= 2)
    *(short *)(buf + 1) = par_port[prt];
  else
    *(short *)(buf + 1) = par_port[0];
  switch (*buf) {
    case HLON:
      HL_ON(*((short *)(buf+1)), *((short *)(buf+3)));
      break;
    case HLOFF:
      HL_OFF(*((short *)(buf+1)));
      break;
    case HLRD:
      ret = HL_RD(*((short *)(buf+1)), *((short *)(buf+3)));
      break;
    case HLWR:
      HL_WR(*((short *)(buf+1)), *((short *)(buf+3)), *((short *)(buf+5)));
      break;
    case HLKEYE:
      BlockCount = *((short *)(buf+3));
      for (i=2; i < BlockCount*4; i++)
        buf[5+i] = cpass();
      ret = K_EYE(*((short *)(buf+1)), buf+5, *((short *)(buf+3))); 
      break;
    default:
      printf("!!!! KEYE-Error !!!! illegal case in hardlock-module");
  }
  splx(sp);
  hl_sem &= ~SEM_BUSY;
  if (hl_sem & SEM_WANTED) {
    hl_sem &= ~SEM_WANTED;
    wakeup((caddr_t)hl_sem);
  }
  uap = (struct parms *) u.u_ap;
  uap->count = ret;
  u.u_count = 0;
}
