/* picoBig.c
 * 16feb91abu
 */

#include "pico.h"

#define setCarry(n) (carry = ((long)(n) << 1) < 0)
#define unBig(n)    ((bigDig)(n) >> 2)

typedef unsigned long bigDig;

static bigDig carry;

static void bigUnder(void);
static void bigAdd(pico,pico);
static void bigSub(pico,pico);
static void bigInc(pico,bigDig);
static void bigDec(pico,bigDig);
static void bigMul2(pico);
static void bigMul5(pico);
static void bigDiv2(pico);
static bool bigLeq(pico,pico);

void bigUnder()
{
   err("BigNum underflow");
}

pico Big(x)
register pico x;
{
   x = EVAL1(x);
   NEEDSTRING(x);
   push(newCell(boxNum(unBox(car(x)) - '0'),nilSym));
   if (car(x) == boxNum('0'))
      while (isCell(x = cdr(x))) {
         bigMul2(tos); /* Times 16 */
         bigMul2(tos);
         bigMul2(tos);
         bigMul2(tos);
         bigInc(tos, unBox(car(x)) - '0');
      }
   else
      while (isCell(x = cdr(x))) {
         bigMul5(tos); /* Times 10 */
         bigMul2(tos);
         bigInc(tos, unBox(car(x)) - '0');
      }
   return pop();
}

void bigAdd(src,dst)
register pico src,dst;
{
   register pico x;
   register bigDig n;

   setCarry(n = unBig(car(src)) + unBig(car(dst)));
   car(dst) = boxNum(n);
   src = cdr(src);
   dst = cdr(x = dst);
   loop {
      if (!isCell(src)) {
         while (isCell(dst)) {
            if (!carry)
               return;
            setCarry(n = unBig(car(dst)) + carry);
            car(dst) = boxNum(n);
            dst = cdr(x = dst);
         }
         break;
      }
      if (!isCell(dst)) {
         do {
            setCarry(n = unBig(car(src)) + carry);
            cdr(x) = newCell(boxNum(n),nilSym);
            x = cdr(x);
         } while (isCell(src = cdr(src)));
         break;
      }
      setCarry(n = unBig(car(src)) + unBig(car(dst)) + carry);
      car(dst) = boxNum(n);
      src = cdr(src);
      dst = cdr(x = dst);
   }
   if (carry)
      cdr(x) = newCell(ONE,nilSym);
}

void bigSub(src,dst)
register pico src,dst;
{
   register pico x,y;
   register bigDig n;

   setCarry(n = unBig(car(dst)) - unBig(car(src)));
   car(dst) = boxNum(n);
   src = cdr(src);
   dst = cdr(x = y = dst);
   loop {
      if (!isCell(src)) {
         while (isCell(dst)) {
            if (!carry)
               return;
            setCarry(n = unBig(car(dst)) - carry);
            car(dst) = boxNum(n);
            dst = cdr(x = dst);
         }
         break;
      }
      if (!isCell(dst))
         bigUnder();
      setCarry(n = unBig(car(dst)) - unBig(car(src)) - carry);
      car(dst) = boxNum(n);
      src = cdr(src);
      dst = cdr(x = dst);
   }
   if (carry)
      bigUnder();
   while (car(x) == ZERO &&  x != y) {
      src = y;
      while (cdr(src) != x)
         src = cdr(src);
      cdr(x = src) = nilSym;
   }
}

void bigInc(x,n)
register pico x;
bigDig n;
{
   register pico y;

   setCarry(n = unBig(car(x)) + n);
   car(x) = boxNum(n);
   while (carry) {
      if (isCell(x = cdr(y = x))) {
         setCarry(n = unBig(car(x)) + 1);
         car(x) = boxNum(n);
      }
      else {
         cdr(y) = newCell(ONE,nilSym);
         break;
      }
   }
}

void bigDec(x,n)
register pico x;
bigDig n;
{
   register pico y,z;

   setCarry(n = unBig(car(z = x)) - n);
   car(x) = boxNum(n);
   while (isCell(x = cdr(y = x))) {
      if (!carry)
         return;
      setCarry(n = unBig(car(x)) - carry);
      car(x) = boxNum(n);
   }
   if (carry)
      bigUnder();
   while (car(y) == ZERO &&  y != z) {
      x = z;
      while (cdr(x) != y)
         x = cdr(x);
      cdr(y = x) = nilSym;
   }
}

void bigMul2(x)
register pico x;
{
   register pico y;
   bigDig n;

   setCarry(n = 2*unBig(car(x)));
   car(x) = boxNum(n);
   while (isCell(x = cdr(y = x))) {
      setCarry(n = 2*unBig(car(x)) + carry);
      car(x) = boxNum(n);
   }
   if (carry)
      cdr(y) = newCell(ONE,nilSym);
}

void bigMul5(x)
register pico x;
{
   register bigDig n,m,ov1,ov2;
   register pico y;

   n = unBig(car(x));
   ov1 = ((long)(m = 4 * n) << 1) < 0;
   if ((long)m < 0)
      ov1 += 2;
   if ((m ^ m+n) & 0xC0000000)
      ++ov1;
   car(x) = boxNum(m+n);
   while (isCell(x = cdr(y = x))) {
      n = unBig(car(x));
      ov2 = ((long)(m = 4 * n) << 1) < 0;
      if ((long)m < 0)
         ov2 += 2;
      if ((m ^ m+n+ov1) & 0xC0000000)
         ++ov2;
      car(x) = boxNum(m+n+ov1);
      ov1 = ov2;
   }
   if (ov1)
      cdr(y) = newCell(boxNum(ov1),nilSym);
}

void bigDiv2(x)
register pico x;
{
   register pico y,z;
   bigDig n;

   car(x) = boxNum(unBig(car(z = x)) / 2);
   while (isCell(x = cdr(y = x))) {
      if ((bigDig)car(x) & 4)
         car(y) = (pico)((bigDig)car(y) | 0x80000000);
      car(x) = boxNum(unBig(car(x)) / 2);
   }
   if (car(y) == ZERO &&  y != z) {
      while (cdr(z) != y)
         z = cdr(z);
      cdr(z) = nilSym;
   }
}

bool bigLeq(x,y)
register pico x,y;
{
   register bool res;
   register pico x1,y1,x2,y2;

   x1 = y1 = nilSym;
   while (isCell(x2 = cdr(x)) && isCell(y2 = cdr(y))) {
      cdr(x) = x1;
      x1 = x;
      x = x2;
      cdr(y) = y1;
      y1 = y;
      y = y2;
   }
   if (isCell(cdr(x)))
      res = NO;
   else if (isCell(cdr(y)))
      res = YES;
   else loop {
      if ((bigDig)car(x) < (bigDig)car(y)) {
         res = YES;
         break;
      }
      if ((bigDig)car(x) > (bigDig)car(y)) {
         res = NO;
         break;
      }
      if (!isCell(x1))
         return YES;
      x2 = cdr(x1);
      cdr(x1) = x;
      x = x1;
      x1 = x2;
      y2 = cdr(y1);
      cdr(y1) = y;
      y = y1;
      y1 = y2;
   }
   while (isCell(x1)) {
      x2 = cdr(x1);
      cdr(x1) = x;
      x = x1;
      x1 = x2;
      y2 = cdr(y1);
      cdr(y1) = y;
      y = y1;
      y1 = y2;
   }
   return res;
}

pico BigAdd(x)
register pico x;
{
   push(copy1(EVAL1(x)));
   NEEDCELL(tos);
   NEEDNUM(car(tos));
   while (isCell(x = cdr(x))) {
      push(EVAL1(x));
      if (isNum(tos))
         bigInc(nos,unBox(tos));
      else {
         NEEDCELL(tos);
         NEEDNUM(car(tos));
         bigAdd(tos,nos);
      }
      drop();
   }
   return pop();
}

pico BigSub(x)
register pico x;
{
   push(copy1(EVAL1(x)));
   NEEDCELL(tos);
   NEEDNUM(car(tos));
   while (isCell(x = cdr(x))) {
      push(EVAL1(x));
      if (isNum(tos))
         bigDec(nos,unBox(tos));
      else {
         NEEDCELL(tos);
         NEEDNUM(car(tos));
         bigSub(tos,nos);
      }
      drop();
   }
   return pop();
}

pico BigMul(x)
register pico x;
{
   register bigDig n;

   push(copy1(EVAL1(x)));
   NEEDCELL(tos);
   NEEDNUM(car(tos));
   while (isCell(x = cdr(x))) {
      push(copy1(EVAL1(x)));
      push(newCell(ZERO,nilSym));
      if (isNum(nos)) {
         n = unBox(nos);
         while (n) {
            if (n & 1)
               bigAdd(tros,tos);
            bigMul2(tros);
            n /= 2;
         }
      }
      else {
         NEEDCELL(nos);
         NEEDNUM(car(nos));
         while (car(nos) != ZERO || isCell(cdr(nos))) {
            if ((bigDig)car(nos) & 4)
               bigAdd(tros,tos);
            bigMul2(tros);
            bigDiv2(nos);
         }
      }
      tros = tos;
      drop2();
   }
   return pop();
}

pico BigDiv(x)
register pico x;
{
   register long i;

   push(copy1(EVAL1(x)));
   NEEDCELL(tos);
   NEEDNUM(car(tos));
   x = cdr(x);
   push(copy1(EVAL1(x)));
   NEEDCELL(tos);
   NEEDNUM(car(tos));
   x = cdr(x);
   x = EVAL1(x); /* Mod-Flag */
   push(newCell(ZERO,nilSym));
   i = 0;
   while (bigLeq(nos,tros)) {
      bigMul2(nos);
      ++i;
   }
   while (--i >= 0) {
      bigMul2(tos);
      bigDiv2(nos);
      if (bigLeq(nos,tros)) {
         bigSub(nos,tros);
         bigInc(tos,1);
      }
   }
   x = isNil(x)? tos : newCell(tos,tros);
   drop3();
   return x;
}

pico BigSqrt(x)
register pico x;
{
   push(copy1(EVAL1(x)));
   NEEDCELL(tos);
   NEEDNUM(car(tos));
   x = cdr(x);
   x = EVAL1(x); /* Round-Flag */
   push(newCell(ONE,nilSym));
   while (bigLeq(tos,nos)) {
      bigMul2(tos);
      bigMul2(tos);
   }
   push(newCell(ZERO,nilSym));
   do {
      bigAdd(nos,tos);
      if (bigLeq(tos,tros)) {
         bigSub(tos,tros);
         bigAdd(nos,tos);
      }
      else
         bigSub(nos,tos);
      bigDiv2(tos);
      bigDiv2(nos);
      bigDiv2(nos);
   } while (car(nos) != ZERO || isCell(cdr(nos)));
   if (!isNil(x) && !bigLeq(tros,tos))
      bigInc(tos,1);
   x = pop();
   drop2();
   return x;
}

pico BigLeq(x)
register pico x;
{
   register pico y,z;

   y = EVAL1(x);
   NEEDCELL(y);
   NEEDNUM(car(y));
   while (isCell(x = cdr(x))) {
      z = EVAL1(x);
      NEEDCELL(z);
      NEEDNUM(car(z));
      if (!bigLeq(y,z))
         return nilSym;
      y = z;
   }
   return tSym;
}
