/* picoDebug.c
 * 10feb91abu
 */

#include "pico.h"
#include <time.h>
#include <sys/times.h>

/* Prototypes */
static void dots(long);
static void how(pico,pico);
static bool nestp(pico,pico);


pico Loc(x)
register pico x;
{
   x = EVAL1(x);
   return isNum(x)? nilSym:boxNum(x);
}

pico Has(x)
register pico x;
{
   register pico y;
   register int i;

   push(nilSym);
   push(y = EVAL1(x));
   for (i=0; i<=THREADS; ++i) {
      x = env.threads[i];
      while (isCell(x)) {
         if (equal(y, val(car(x))))
            nos = newCell(car(x),nos);
         x = cdr(x);
      }
   }
   drop();
   return pop();
}

static bool nestp(x,y)
register pico x,y;
{
   while (isCell(y)) {
      if (match(x,car(y)) || isCell(car(y)) && nestp(x,car(y)))
         return YES;
      y = cdr(y);
   }
   return x == y;
}

pico Who(x)
register pico x;
{
   register int i;
   register pico y, z;

   push(nilSym);
   push(z = EVAL1(x));
   for (i=0; i<=THREADS; ++i) {
      x = env.threads[i];
      while (isCell(x)) {
         if (isCell(y = val(car(x))) && nestp(z,y))
            nos = newCell(car(x),nos);
         x = cdr(x);
      }
   }
   drop();
   return pop();
}

static void how(x,y)
register pico x,y;
{
   register pico z,expr;

   expr = y;
   while (isCell(y)) {
      z = car(y);
      if (match(x,z) || isCell(z) && car(z)==quoteSym && car(cdr(z))==x) {
         tab();
         prin0((!isCell(z) || (car(z)==quoteSym))? expr:z);
         crlf();
         break;
      }
      if (isCell(z))
         how(x,z);
      y = cdr(y);
   }
}

pico How(x)
register pico x;
{
   register int i;
   register pico y, z, t;
   Afile *sSave;

   sSave = stream;
   setStream(NULL);
   y = EVAL1(x);
   if (isCell(x = cdr(x))) {
      NEEDSYM(y);
      how(EVAL1(x),val(y));
   }
   else
      for (i=0; i<=THREADS; ++i) {
         t = env.threads[i];
         while (isCell(t)) {
            if (isCell(x = val(car(t)))) {
               z = x;
               do
                  z = cdr(z);
               while (isCell(z));
               if (z == objectSym) {
                  while (isCell(z = car(x))) {
                     if (nestp(y,cdr(z))) {
                        prin0(car(z));
                        space();
                        prin0(car(t));
                        crlf();
                        how(y,cdr(z));
                     }
                     x = cdr(x);
                  }
               }
               else if (nestp(y,x)) {
                  prin0(car(t));
                  crlf();
                  how(y,x);
               }
            }
            t = cdr(t);
         }
      }
   stream = sSave;
   return y;
}

pico BreakFun(x)
register pico x;
{
   Afile *sSave;

   push(val(logFlg));
   val(logFlg) = nilSym;
   push(val(macFlg));
   val(macFlg) = nilSym;
   sSave = stream;
   setStream(NULL);
   prString("$ ");
   prin0(x);
   crlf();
   revalo(x);
   stream = sSave;
   val(macFlg) = pop();
   val(logFlg) = pop();
   return EVAL(x);
}

static void dots(i)
register long i;
{
   i  =  i < 64 ?  i:64;
   while (--i >= 0)
      chrOut('.');
}

pico TraceFun(x)
register pico x;
{
   pico foo, body;
   Afile *sSave;

   sSave = stream;
   setStream(NULL);
   dots(++traceLevel);
   prin0(foo = car(x));
   x = cdr(x);
   body = cdr(x);
   chrOut('[');
   if (isCell(x = car(x)))
      loop {
         cutPr(val(car(x)));
         if (!isCell(x = cdr(x)))
            break;
         space();
      }
   chrOut(']');
   crlf();
   x = evalBody(body);
   dots(traceLevel--);
   prin0(foo);
   chrOut('=');
   cutPr(x);
   crlf();
   stream = sSave;
   return x;
}

pico ProfFun(x)
register pico x;
{
   pico y;
   struct tms tim1,tim2;
   long n, saveTime;
   static long profTime;

   saveTime = profTime;
   times(&tim1);
   y = evalBody(cdr(x));
   times(&tim2);
   n = (tim2.tms_utime - tim1.tms_utime) - (profTime - saveTime);
   car(x) = boxNum(unBox(car(x)) + n);
   profTime += n;
   return y;
}

pico Dump(x)
register pico x;
{
   register char c, *adr;
   register int i, j, len;
   Afile *sSave;

   adr = (char*)EVAL1(x);
   NEEDNUM(adr);
   adr = (char*)(unBox(adr) & 0x3FFFFFFF);
   if (isNil(x = EVAL1(cdr(x))))
      len = 1;
   else
      len = unBox(x);
   sSave = stream;
   setStream(NULL);
   for (i=0; i<len; ++i) {
      keyBreak();
      prHexNum((unsigned long)adr + i*16);
      prString("   ");
      j = 0;
      do {
         c = adr[i*16+j];
         hexChar(c >> 4 & 0xF);
         hexChar(c & 0xF);
         space();
      } while (++j < 16);
      prString("  ");
      j = 0;
      do {
         chrOut(((c = adr[i*16+j] & 0x7F) >= ' '  &&  c <= '~') ?  c : '.');
      } while (++j < 16);
      crlf();
   }
   stream = sSave;
   return boxNum(adr+len*16);
}

pico Trail()
{
   register pico x;
   register stkFrame *s;

   if ((s = stkBase) == &topFrame)
      return nilSym;
   while (!s->self)
      if ((s = s->link) == &topFrame)
         return nilSym;
   push(x = newCell(s->self, nilSym));
   while ((s = s->link) != &topFrame)
      if (s->self) {
         cdr(x) = newCell(s->self, nilSym);
         x = cdr(x);
      }
   return pop();
}

pico Track(x)
pico x;
{
   register int dspCnt, fCnt;
   register pico *p;
   register stkFrame *s, *last;

   if (!isCell(x))
      dspCnt = MAXNUM;
   else {
      x = EVAL1(x);
      NEEDNUM(x);
      dspCnt = unBox(x);
   }
   s = stkBase;
   last = NULL;
   while (s != &topFrame  &&  dspCnt > 0) {
      if (s->self) {
         cutPr(s->self);
         space();
         --dspCnt;
      }
      fCnt = s->cnt;
      p = s->sp + 4*fCnt - 3;
      while (--fCnt >= 0) {
         if (s->self)
            space(), prin0(*p), prString(":"), cutPr(val(*p));
         x = val(*p);
         val(*p) = *(p+2);
         *(p+2) = x;
         p -= 4;
      }
      if (s->self)
         crlf();
      p = (pico*)s;
      s = s->link;
      ((stkFrame*)p)->link = last;
      last = (stkFrame*)p;
   }
   while (last) {
      fCnt = last->cnt;
      p = last->sp + 4*fCnt - 3;
      while (--fCnt >= 0) {
         x = val(*p);
         val(*p) = *(p+2);
         *(p+2) = x;
         p -= 4;
      }
      p = (pico*)last;
      last = last->link;
      ((stkFrame*)p)->link = s;
      s = (stkFrame*)p;
   }
   return tSym;
}

pico Revalo(x)
register pico x;
{
   revalo(EVAL1(x));
   return tSym;
}
