/* picoFlow.c
 * 17dec90abu
 */

#include "pico.h"

pico retVal;

pico Quit(x)
pico x;
{
   applyProc(val(quitSym), EVAL1(x));
   closeAll();
   exitPico(SUCCESS);
}

pico Eval(x)
register pico x;
{
   push(x = EVAL1(x));
   x = EVAL(x);
   drop();
   return x;
}

pico Slot(x)
register pico x;
{
   if (isCell(cdr(x))) {
      push(*withPtr);
      push(car(x));
      x = put(EVAL1(cdr(x)));
      drop2();
      return x;
   }
   return get(*withPtr, car(x));
}

pico SlotStar(x)
register pico x;
{
   register pico y;

   y = tail(*withPtr);
   if (isNum(y) || !isCell(y = car(y)))
      errObj(*withPtr,"No Properties");
   if (isCell(cdr(x))) {
      push(cdr(y));
      push(car(x));
      x = put(EVAL1(cdr(x)));
      drop2();
      return x;
   }
   return get(cdr(y), car(x));
}

pico With(x)
register pico x;
{
   register pico sym;
   pico *withSave;

   sym = EVAL1(x);
   NEEDSYM(sym);
   push(sym);
   withSave = withPtr;
   withPtr = stkPtr+1;
   x = evalBody(cdr(x));
   drop();
   withPtr = withSave;
   return x;
}

pico Catch(x)
register pico x;
{
   catchFrame f;

   f.tag = EVAL1(x);
   f.link = catchBase;
   catchBase = &f;
   f.sp = stkPtr;
   f.with = withPtr;
   f.stkBase = stkBase;
   x  =  (setjmp(f.env)) ?  retVal : evalBody(cdr(x));
   stkPtr = f.sp;
   withPtr = f.with;
   catchBase = f.link;
   return x;
}

pico Throw(x)
register pico x;
{
   register long cnt;

   x = EVAL2(x,retVal);
   while (catchBase) {
      if (x == catchBase->tag) {
         while (stkBase != catchBase->stkBase) {
            stkPtr = stkBase->sp;
            cnt = stkBase->cnt;
            while (--cnt >= 0) {
               val(*(stkPtr+1)) = *(stkPtr+3);
               stkPtr += 4;
            }
            stkBase = stkBase->link;
         }
         longjmp(catchBase->env,-1);
      }
      catchBase = catchBase->link;
   }
   errObj(x, "Unmatched tag");
}

pico Error(x)
register pico x;
{
   char buf[256];

   reset();
   prString("Error: ");
   while (isCell(x)) {
      prString(bufString(EVAL1(x), buf, 256));
      x = cdr(x);
   }
   doError();
}

pico Getd(x)
register pico x;
{
   x = EVAL1(x);
   NEEDSYM(x);
   x = val(x);
   return funp(x)? x:nilSym;
}

pico Putd(x)
register pico x;
{
   register pico sym;

   sym = EVAL2(x,x);
   NEEDSYM(sym);
   CHECKSYM(sym);
   val(sym) = isNum(x)? (pico)(num(x) | 1) : x;
   return sym;
}

pico De(x)
register pico x;
{
   redefine(car(x),cdr(x));
   return car(x);
}

pico Define(x)
register pico x;
{
   register pico sym1, sym2;

   while (isCell(x)) {
      sym1 = car(x);
      x = cdr(x);
      sym2 = car(x);
      x = cdr(x);
      NEEDSYM(sym2);
      redefine(sym1,val(sym2));
   }
   return tSym;
}

pico If(x)
register pico x;
{
   if (isNil(EVAL1(x))) {
      x = cdr(cdr(x));
      return EVAL1(x);
   }
   return EVAL1(cdr(x));
}

pico When(x)
register pico x;
{
   register pico y;

   if (isNil(EVAL1(x)))
      return nilSym;
   x = cdr(x);
   do
      y = EVAL(car(x));
   while (isCell(x = cdr(x)));
   return y;
}

pico Unless(x)
register pico x;
{
   register pico y;

   if (!isNil(EVAL1(x)))
      return nilSym;
   x = cdr(x);
   do
      y = EVAL(car(x));
   while (isCell(x = cdr(x)));
   return y;
}

pico And(x)
register pico x;
{
   register pico y;

   do {
      if (isNil(y = EVAL1(x)))
         break;
   } while (isCell(x = cdr(x)));
   return y;
}

pico Or(x)
register pico x;
{
   register pico y;

   do {
      if (!isNil(y = EVAL1(x)))
         break;
   } while (isCell(x = cdr(x)));
   return y;
}

pico Nand(x)
register pico x;
{
   register pico y;

   do {
      if (isNil(y = EVAL1(x)))
         return tSym;
   } while (isCell(x = cdr(x)));
   return nilSym;
}

pico Nor(x)
register pico x;
{
   register pico y;

   do {
      if (!isNil(y = EVAL1(x)))
         return nilSym;
   } while (isCell(x = cdr(x)));
   return tSym;
}

pico Xor(x)
register pico x;
{
   register bool f;

   f = NO;
   while (isCell(x)) {
      if (!isNil(EVAL1(x))) {
         if (f)
            return nilSym;
         f = YES;
      }
      x = cdr(x);
   }
   return f? tSym : nilSym;
}

pico Not(x)
pico x;
{
   return isNil(EVAL1(x)) ?  tSym : nilSym;
}

pico Cond(x)
register pico x;
{
   do {
      if (!isNil(EVAL1(car(x))))
         return evalBody(cdr(car(x)));
   } while (isCell(x = cdr(x)));
   return nilSym;
}

pico Case(x)
register pico x;
{
   register pico y, z, key;

   key = EVAL1(x);
   x = cdr(x);
   do {
      y = car(x);
      if (isCell(z = car(y))) {
         do {
            if (car(z) == key)
               return evalBody(cdr(y));
         } while (isCell(z = cdr(z)));
      }
      else if (z == tSym  ||  z == key)
         return evalBody(cdr(y));
   } while (isCell(x = cdr(x)));
   return nilSym;
}

pico Loop(x)
pico x;
{
   register pico body, clause;

   loop {
      body = x;
      do {
         clause = car(body);
         if (car(clause) != tSym)
            EVAL(clause);
         else {
            clause = cdr(clause);
            if (!isNil(EVAL1(clause)))
               return evalBody(cdr(clause));
         }
      } while (isCell(body = cdr(body)));
   }
}

pico For(x)
register pico x;
{
   register pico sym, cond, body;
   stkFrame f;

   f.self = NULL;
   body = cdr(x);
   x = car(x);
   NEEDCELL(x);
   sym = car(x);
   NEEDSYM(sym);
   CHECKSYM(sym);
   push(val(sym));
   push(sym);
   x = cdr(x);
   val(sym) = EVAL1(x);
   f.link = stkBase;
   stkBase = &f;
   f.sp = stkPtr;
   f.cnt = 1;
   x = cdr(x);
   push(cond = EVAL1(x));
   x = car(cdr(x));
   push(nilSym);
   while (!equal(val(sym),EVAL(cond))) {
      tos = evalBody(body);
      val(sym) = isNil(x)? (pico)(num(val(sym))+4) : EVAL(x);
   }
   x = pop();
   drop2();
   val(sym) = pop();
   stkBase = f.link;
   return x;
}

pico While(x)
register pico x;
{
   register pico cond;

   cond = car(x);
   x = cdr(x);
   push(nilSym);
   while (!isNil(EVAL(cond)))
      tos = evalBody(x);
   return pop();
}

pico Until(x)
register pico x;
{
   register pico cond;

   cond = car(x);
   x = cdr(x);
   push(nilSym);
   while (isNil(EVAL(cond)))
      tos = evalBody(x);
   return pop();
}

pico Repeat(x)
register pico x;
{
   register pico y;

   do
      y = evalBody(x);
   while (isNil(y));
   return y;
}

pico Reptn(x)
register pico x;
{
   register number count;
   register pico y;

   count = num(EVAL1(x));
   NEEDNUM(count);
   count = unBox(count);
   x = cdr(x);
   while (count > 0) {
      y = evalBody(x);
      --count;
   }
   return y;
}

pico Local(x)
register pico x;
{
   register pico y, sym;
   register long cnt;
   stkFrame f;

   f.self = NULL;
   y = car(x);
   cnt = 0;
   while (isCell(y)) {
      sym = car(y);
      NEEDSYM(sym);
      CHECKSYM(sym);
      push(val(sym));
      push(sym);
      y = cdr(y);
      ++cnt;
   }
   f.link = stkBase;
   stkBase = &f;
   f.sp = stkPtr;
   f.cnt = cnt;
   x = evalBody(cdr(x));
   while (--cnt >= 0) {
      sym = pop();
      val(sym) = pop();
   }
   stkBase = f.link;
   return x;
}

pico Prog1(x)
register pico x;
{
   push(EVAL1(x));
   evalBody(cdr(x));
   return pop();
}

pico Prog2(x)
register pico x;
{
   EVAL1(x);
   x = cdr(x);
   push(EVAL1(x));
   evalBody(cdr(x));
   return pop();
}
