/* picoGC.c
 * 12feb91abu
 */

#include "pico.h"
#include <fcntl.h>
#include <malloc.h>

static pico adjLimit;

/* Prototypes */
static void adjust(pico*);
static void allFree(void);
static void compact(void);
static void deLocate(pico*,pico*);
static pico doShare(pico,pico);
static void doZap(pico);
static void freezErr(void);
static void gc(void);
static void mark(pico);
static void reLocate(pico*,pico*);
static pico share1(pico);
static pico share1List(pico);

static pico shareX,shareY;
static pico noZap;
static number zaps;

void dynFree(x)
register pico x;
{
   free((void*)unBox(x));
}

pico dynamo(foo,x)
register pico foo,x;
{
   NEEDFUN(foo);
   push(newSym(DYNAMO, newCell(foo,x)));
   if (!avail)
      gc();
   x = avail;
   avail = x->link;
   x->data = tos;
   x->link = dynamos;
   dynamos = x;
   return pop();
}

pico Dynamo(x)
register pico x;
{
   push(EVAL1(x));      /* DisposeFun */
   x = EVAL1(cdr(x));   /* Object */
   return dynamo(xpop(),x);
}

pico newCell(x,y)
register pico x,y;
{
   register pico p;

   if (!avail) {
      push(x), push(y);
      gc();
      y = pop(), x = pop();
   }
   p = avail;
   avail = p->link;
   car(p) = x;
   cdr(p) = y;
   return p;
}

pico newCell2(a,b,c,d)
pico a,b,c,d;
{
   push(newCell(a,b));
   a = newCell(c,d);
   return newCell(xpop(), a);
}

/* Share common subexpressions */
pico share1(x)
register pico x;
{
   pico p;

   while (isCell(x)) {
      if (cdr(x)==shareY && car(x)==shareX)
         return x;
      if (p = share1(car(x)))
         return p;
      x = cdr(x);
   }
   return NULL;
}

pico doShare(x,y)
pico x,y;
{
   register pico z,p,*ptr;
   register int i;

   shareX = x;
   shareY = y;
   ptr = stkPtr;               /* Search stack */
   while (ptr) {
      if (p = share1(*(ptr+1)))
         return p;
      ptr = (pico*)*ptr;
   }
   for (i=0; i<=THREADS; ++i) {   /* Search oblist */
      z = env.threads[i];
      while (isCell(z)) {
         if (p = share1(mkCell(car(z))))
            return p;
         z = cdr(z);
      }
   }
   return newCell(x,y);
}

pico share(x,y)
pico x,y;
{
   if (!isNil(val(shareFlg)))
      return doShare(x,y);
   return newCell(x,y);
}

pico share1List(x)
register pico x;
{
   if (!isCell(x))
      return x;
   return doShare(share1List(car(x)),share1List(cdr(x)));
}

pico shareList(x)
register pico x;
{
   if (!isNil(val(shareFlg)))
      return share1List(x);
   return x;
}

void mark(x)
register pico x;
{
   while (!isNum(x) && isFree(x = cellPtr(x))) {
      *markPtr(x) &= ~1;
      mark(x->data);
      x = x->link;
   }
}

void allFree()
{
   register char *p;
   register long n;

   p = markPtr(heap);
   n = heapEnd - heap;
   do {
      *p |= 1;
      p += 8;
   } while (--n);
}

void gc()
{
   register pico *ptr,p,q;
   register number i;

   ttyOut('{');
   allFree();
   i = THREADS;                 /* Mark oblist */
   do
      mark(env.threads[i]);
   while (--i >= 0);
   mark(env.run);               /* Mark initial runtime expression */
   mark(applyList);             /* Mark apply list */
   ptr = stkPtr;                /* Mark stack */
   while (ptr) {
      mark(*(ptr+1));
      ptr = (pico*)*ptr;
   }
   ptr = &dynamos;              /* Dispose of dynamic memory objects */
   while (p = *ptr) {
      if (isFree(cellPtr(q = clr(car(p))))) {
         q = val(q);
         apply1(car(q),cdr(q));
         *ptr = p->link;
      }
      else {
         *markPtr(p) &= ~1;
         ptr = &p->link;
      }
   }
   ptr = NULL;                  /* Collect free cells */
   p = heapEnd - 1;
   do {
      if (isFree(p)) {
         p->link = (pico)ptr;
         ptr = (pico*)p;
      }
   } while (--p > dolSym);
   *markPtr(mkCell(nilSym)+1) &= ~1;
   if (!(avail = (pico)ptr))
      err("Out of cell space");
   keyBreak();
   ttyOut('}');
}

pico Gc(x)
register pico x;
{
   register number n;

   if (isCell(x)) {
      x = EVAL1(x);
      NEEDNUM(x);
      n = unBox(x);
      x = avail;
      while (x) {
         if (--n == 0)
            return nilSym;
         x = x->link;
      }
   }
   gc();
   return tSym;
}

/* Collect and compact cell Space */
void adjust(p)
register pico *p;
{
   register pico x = *p;

   if (!isNum(x)  &&  x >= adjLimit)
      *p = isSym(x)? mkSym(tail(x)) : car(x);
}

void compact()
{
   register pico p, q;
   register long n;

   allFree();
   n = THREADS;
   do
      mark(env.threads[n]);
   while (--n >= 0);
   mark(env.run);
   p = mkCell(dolSym+1);
   q = heapEnd;
   do {
      while (!isFree(p))
         if (++p == q)
            goto adjPtr;
      do {
         if (--q == p)
            goto adjPtr;
      } while (isFree(q));
      *p = *q;
      q->data = p;
   } while (++p != q);
adjPtr:                        /* Adjust pointers */
   adjLimit = p;
   n = THREADS;               /* Adjust threads and heap */
   do
      adjust(env.threads+n);
   while (--n >= 0);
   adjust(&env.run);
   do {
      --q;
      adjust(&q->link);
      adjust(&q->data);
   } while (q > heap);
   *markPtr(mkCell(nilSym)+1) &= ~1;
   avail = NULL;               /* Build new avail list */
   q = heapEnd;
   while (--q >= p) {
      q->link = avail;
      avail = q;
   }
}

void deLocate(adr1,adr2)
register pico *adr1, *adr2;
{
   do {
      if (isNum(*adr1)) {
         if (num(*adr1) & 1)
            *adr1 = boxFun(unBox(*adr1) /* - num(CurrentA5)*/);
      }
      else
         *adr1 = (pico)((num(*adr1) & ~1L) - num(heap));
   } while (++adr1 < adr2);
}

void reLocate(adr1,adr2)
register pico *adr1, *adr2;
{
   do {
      if (isNum(*adr1)) {
         if (num(*adr1) & 1)
            *adr1 = boxFun(unBox(*adr1) /* + num(CurrentA5)*/);
      }
      else
         *adr1 = (pico)((num(*adr1) & ~1L) + num(heap));
   } while (++adr1 < adr2);
}

void freezErr()
{
   err("FREEZE error");
}

/* Generate freeze file */
pico Freeze(x)
register pico x;
{
   char fName[FILENAME];
   int fd;
   long buffer[2];
   int e;

   bufString(EVAL1(x), fName, FILENAME);
   closeAll();
   val(loadSym) = nilSym;
   if ((fd = open(fName, O_CREAT|O_TRUNC|O_WRONLY, 0666)) < 0)
      err("Can't create FREEZE");
   env.run = cdr(x);
   reset();
   unwind();
   compact();
   /* Write header */
   buffer[0] = VERSION;
   buffer[1] = (char*)adjLimit - (char*)heap;
   if (write(fd, (char*)buffer, 8) < 0)
      freezErr();
   /* Write environment */
   deLocate(env.threads, &env.run+1);
   e = write(fd, (char*)&env, sizeof(env));
   reLocate(env.threads, &env.run+1);
   if (e < 0)
      freezErr();
   /* Write heap */
   deLocate((pico*)heap, (pico*)adjLimit);
   e = write(fd, (char*)heap, buffer[1]);
   reLocate((pico*)heap, (pico*)adjLimit);
   if (e < 0)
      freezErr();
   close(fd);
   longjmp(errRst,-1);
}

bool unFreeze(fName)
char *fName;
{
   register pico p,q;
   long buffer[2];
   int fd;

   if ((fd = open(fName, O_RDONLY)) < 0)
      return NO;
   /* Read header */
   if (read(fd, (char*)buffer, 8) < 0  ||  buffer[0] != VERSION) {
      close(fd);
      return NO;
   }
   p = heap + buffer[1]/sizeof(cell);
   /* Read environment */
   if (read(fd, (char*)&env, sizeof(env)) < 0) {
      close(fd);
      return NO;
   }
   reLocate(env.threads, &env.run+1);
   /* Read heap */
   if (read(fd, (char*)heap, buffer[1]) < 0) {
      close(fd);
      return NO;
   }
   reLocate((pico*)heap, (pico*)p);
   close(fd);
   avail = NULL;               /* Build avail list */
   q = heapEnd;
   while (--q >= p) {
      q->link = avail;
      avail = q;
   }
   return YES;
}

/* Cut long symbol names to 6 chars */
void doZap(x)
register pico x;
{
   register pico y,z;

   if (!isNum(x)) {
      if (isCell(x)) {
         if (isFree(x)) {
            *markPtr(x) &= ~1;
            doZap(car(x));
            doZap(cdr(x));
         }
      }
      else if (isFree(z = mkCell(x))) {
         *markPtr(z) &= ~1;
         y = noZap;
         while (isCell(y)) {
            if (x == clr(car(y)))
               goto skip;
            y = cdr(y);
         }
         if (!isNum(y = car(z))) {
            if (isNum(car(y))) {
               ++zaps;
               car(z) = (pico)(num(car(y)) | 0x7C);
            }
            else {
               while (!isNum(cdr(y)) && !isNum(car(cdr(y))))
                  y = cdr(y);
               if (!isNum(cdr(y))) {
                  ++zaps;
                  cdr(y) = (pico)(num(car(cdr(y))) | 0x7C);
               }
            }
         }
      skip:
         doZap(car(z));
         doZap(cdr(z));
      }
   }
}

pico Zap(x)
register pico x;
{
   register long n;

   noZap = EVAL1(x);
   allFree();
   zaps = 0;
   n = THREADS;               /* Mark oblist */
   do
      doZap(env.threads[n]);
   while (--n >= 0);
   gc();
   return boxNum(zaps);
}

pico Avail(x)
register pico x;
{
   register number n;

   if (isNil(x = EVAL1(x))) {
      x = avail;
      n = 0;
      while (x) {
         ++n;
         x = x->link;
      }
      return boxNum(n);
   }
   NEEDNUM(x);
   n = unBox(x);
   x = avail;
   while (x) {
      if (--n == 0)
         return tSym;
      x = x->link;
   }
   return nilSym;
}
