/* picoGeo.c
 * 16feb91abu
 */

#include "pico.h"


pico pNormal(x)
register pico x;
{
   point p1,p2;

   unBoxPoint(EVAL1(x),&p1);
   if (isCell(x = cdr(x)))
      unBoxPoint(EVAL1(x),&p2);
   else
      p2.h = p2.v = 0;
   return newCell(boxNum(p2.h + p2.v-p1.v), boxNum(p2.v + p1.h-p2.h));
}

pico PtInRect(x)
pico x;
{
   point pt;
   rect r;

   nextPoint(&x,&pt);
   nextRect(&x,&r);
   return boxBool(
      pt.h >= r.left &&
      pt.h < r.right &&
      pt.v >= r.top &&
      pt.v < r.bottom );
}

pico Beyond(x)
pico x;
{
   rect r;
   point pt1,pt2,pt;

   nextRect(&x,&r);
   nextPoint(&x,&pt1);
   pt2 = pt1;
   while (isCell(x)) {
      nextPoint(&x,&pt);
      BOUNDS(pt,pt1,pt2);
   }
   return boxBool(
      pt1.h < r.left  &&  pt2.h < r.left  ||
      pt1.h > r.right  &&  pt2.h > r.right  ||
      pt1.v < r.top  &&  pt2.v < r.top  ||
      pt1.v > r.bottom  &&  pt2.v > r.bottom );
}

pico InsetRect(x)
pico x;
{
   rect r;
   number h,v;

   nextRect(&x,&r);
   h = nextNum(&x);
   v = nextNum(&x);
   r.left += h;
   r.right -= h;
   r.top += v;
   r.bottom -= v;
   return boxRect(&r);
}

pico OffsetRect(x)
pico x;
{
   rect r;
   number h,v;

   nextRect(&x,&r);
   h = nextNum(&x);
   v = nextNum(&x);
   r.left += h;
   r.right += h;
   r.top += v;
   r.bottom += v;
   return boxRect(&r);
}

long dist(h1,v1,h2,v2)
long h1,v1,h2,v2;
{
   register long dh,dv;

   if ((dh = h2 - h1) < 0)
      dh = -dh;
   if ((dv = v2 - v1) < 0)
      dv = -dv;
   return  dh>dv?  dh + dv*41/100 - dh/24  :  dv + dh*41/100 - dv/24;
}

double distPt(h1,v1,h2,v2)
double h1,v1,h2,v2;
{
   register double h,v;

   h = h2 - h1;
   v = v2 - v1;
   return sqrt(h*h + v*v);
}

pico Dist(x)
register pico x;
{
   register long dh,dv;
   register pico y;

   push(y = EVAL1(x));
   needPoint(y);
   x = cdr(x);
   needPoint(x = EVAL1(x));
   drop();
   dh = unBox(car(y)) - unBox(car(x));
   dv = unBox(cdr(y)) - unBox(cdr(x));

   if (dh < 0)
      dh = -dh;
   if (dv < 0)
      dv = -dv;
   return
      boxNum(dh>dv?  dh + dv*41/100 - dh/24  :  dv + dh*41/100 - dv/24);
}

pico DistPt(x)
register pico x;
{
   register pico y;

   push(y = EVAL1(x));
   needPoint(y);
   x = cdr(x);
   needPoint(x = EVAL1(x));
   drop();
   return boxNum(
      pythag(unBox(car(y)) - unBox(car(x)),
      unBox(cdr(y)) - unBox(cdr(x)) ) );
}

pico MidPt(x)
register pico x;
{
   register pico y;

   push(y = EVAL1(x));
   needPoint(y);
   x = cdr(x);
   needPoint(x = EVAL1(x));
   drop();
   return newCell(
      boxNum((unBox(car(y)) + unBox(car(x))) / 2),
      boxNum((unBox(cdr(y)) + unBox(cdr(x))) / 2) );
}

bool intsec(a,b,d,e,f,p)
point *a,*b,*d,*e;
bool f;
point *p;
{
   register number dh,dv,n,h,v,k,w;

   if (a->h==e->h && a->v==e->v  ||  a->h==d->h && a->v==d->v) {
      p->h = a->h;
      p->v = a->v;
      return YES;
   }
   if (b->h==e->h && b->v==e->v  ||  b->h==d->h && b->v==d->v) {
      p->h = b->h;
      p->v = b->v;
      return YES;
   }
   h = b->h - a->h;
   v = b->v - a->v;
   k = e->h - d->h;
   w = e->v - d->v;
   if (h == 0) {
      if (k == 0)
         return NO;
      p->h = a->h;
   }
   else if (k == 0)
      p->h = d->h;
   else {
      if (abs(h) >= abs(k)) {
         if (!(n = w - muldiv(k,v,h)))
            return NO;
         p->h = a->h;
         dh = a->h - d->h;
         dv = a->v - d->v;
         if (abs(dh)+abs(dv) > abs(b->h - d->h) + abs(b->v - d->v)) {
            p->h = b->h;
            dh = b->h - d->h;
            dv = b->v - d->v;
         }
         if (mulchk(dh,w,n) || mulchk(dv,k,n))
            return NO;
         p->h += - muldiv(dh,w,n) + muldiv(dv,k,n);
      }
      else {
         if (!(n = muldiv(h,w,k) - v))
            return NO;
         p->h = d->h;
         dh = a->h - d->h;
         dv = a->v - d->v;
         if (abs(dh)+abs(dv) > abs(a->h - e->h) + abs(a->v - e->v)) {
            p->h = e->h;
            dh = a->h - e->h;
            dv = a->v - e->v;
         }
         if (mulchk(dh,v,n) || mulchk(dv,h,n))
            return NO;
         p->h += - muldiv(dh,v,n) + muldiv(dv,h,n);
      }
   }
   if (v == 0) {
      if (w == 0)
         return NO;
      p->v = a->v;
   }
   else if (w == 0) {
      n = -k;
      p->v = d->v;
   }
   else {
      if (abs(v) >= abs(w)) {
         if (!(n = muldiv(h,w,v) - k))
            return NO;
         p->v = a->v;
         dh = a->h - d->h;
         dv = a->v - d->v;
         if (abs(dh)+abs(dv) > abs(b->h - d->h) + abs(b->v - d->v)) {
            p->v = b->v;
            dh = b->h - d->h;
            dv = b->v - d->v;
         }
         if (mulchk(dh,w,n) || mulchk(dv,k,n))
            return NO;
         p->v += - muldiv(dh,w,n) + muldiv(dv,k,n);
      }
      else {
         if (!(n = h - muldiv(k,v,w)))
            return NO;
         p->v = d->v;
         dh = a->h - d->h;
         dv = a->v - d->v;
         if (abs(dh)+abs(dv) > abs(a->h - e->h) + abs(a->v - e->v)) {
            p->v = e->v;
            dh = a->h - e->h;
            dv = a->v - e->v;
         }
         if (mulchk(dh,v,n) || mulchk(dv,h,n))
            return NO;
         p->v += - muldiv(dh,v,n) + muldiv(dv,h,n);
      }
   }
   if (!f) {
      n = p->h;
      if (n < a->h  &&  n < b->h  ||  n < d->h  &&  n < e->h ||
               n > a->h  &&  n > b->h  ||  n > d->h  &&  n > e->h )
         return NO;
      n = p->v;
      if (n < a->v  &&  n < b->v  ||  n < d->v  &&  n < e->v ||
               n > a->v  &&  n > b->v  ||  n > d->v  &&  n > e->v )
         return NO;
   }
   return YES;
}

pico Intsec(x)
pico x;
{
   point a,b,d,e,p;

   nextPoint(&x,&a);
   nextPoint(&x,&b);
   nextPoint(&x,&d);
   nextPoint(&x,&e);
   return
      intsec(&a, &b, &d, &e, !isNil(EVAL1(x)), &p)?
         newCell(boxNum(p.h),boxNum(p.v)) :
         nilSym;
}

pico Center(x)
pico x;
{
   point a,b,c,ab,bc,d,e,m;

   nextPoint(&x,&a);
   nextPoint(&x,&b);
   nextPoint(&x,&c);
   if (a.h==b.h && a.v==b.v || b.h==c.h && b.v==c.v ||
                                          a.h==c.h && a.v==c.v )
      return nilSym;
   ab.h = (a.h + b.h) / 2;
   ab.v = (a.v + b.v) / 2;
   bc.h = (b.h + c.h) / 2;
   bc.v = (b.v + c.v) / 2;
   d.h = ab.h + b.v - a.v;
   d.v = ab.v - b.h + a.h;
   e.h = bc.h + c.v - b.v;
   e.v = bc.v - c.h + b.h;
   return
      intsec(&ab, &d, &bc, &e, YES, &m)?
         newCell(boxNum(m.h),boxNum(m.v)) :
         nilSym;
}

/* Displacement for parallel lines */
pico Parall(x)
register pico x;
{
   double d,h,v,dh,dv,a;

   push(EVAL1(x)); /* Line */
   needPoint(tos);
   x = cdr(x);
   push(EVAL1(x));
   needPoint(tos);
   x = cdr(x);
   x = EVAL1(x); /* Displacement */
   NEEDNUM(x);
   d = (double)unBox(x);
   x = pop();
   dh = (double)unBox(car(x));
   dv = (double)unBox(cdr(x));
   x = pop();
   dh -= (double)unBox(car(x));
   dv -= (double)unBox(cdr(x));
   if (dh == 0.0)
      return newCell(boxDouble(dv<0.0? d : -d), ZERO);
   if (d < 0.0) {
      dh = -dh;
      dv = -dv;
   }
   a = dv / dh;
   v = sqrt(d*d / (1 + a*a));
   h = -a * v;
   return newCell(boxDouble(dh<0.0? -h : h), boxDouble(dh<0.0? -v : v));
}
