/* picoMain.c
 * 14feb91abu
 */

#include "pico.h"
#include "malloc.h"

/* Global objects */
pico applyList, mapCell, mapSym;
pico mapCell2, mapSym2, mapCell3, mapSym3, mapCell4, mapSym4;
pico nilSym, voidSym, tSym, quoteSym, lambdaSym, shareFlg;
pico objectSym, classSym;
pico star1Sym, star2Sym, star3Sym, star4Sym, star5Sym, star6Sym;
pico dolSym, fkeySym, againSym, quitSym;
pico fileSym, loadSym, editSym;
pico echoFlg, srcFlg, logFlg, macFlg, printFlg;

picoEnv env;

/* Globals */
char *heapMem;
pico heap, heapEnd;
pico avail;
pico dynamos;              /* Dynamic memory objects */
jmp_buf errRst;            /* Error restart longjump */
pico *stkPtr;              /* Stack pointer */
stkFrame *stkBase;         /* Stack frame base */
stkFrame topFrame;
catchFrame *catchBase;     /* Catch frame base */
pico *withPtr;             /* Current WITH-pointer */
pico loadPos;              /* Start of definition in source file */
pico loadName;
pico theMessage;           /* Current message */

char *lName;               /* Line I/O device name */
char *lbp;
Afile *stream;             /* The current input stream */
int nextChar;              /* Char look ahead on input */
int nextSave;
int ttyDev;                /* Serial channels */
int auxDev = 0;
int traceLevel;            /* Trace recursion level */
int revaLevel;             /* Nesting level of read-eval-loops */
bool fresh;                /* Fresh start or loading freeze file */
char signOnMsg[] = "PICO Lisp  10jul91\n";
char lBuff[LBSIZE] = "[(c) Alexander Burger 1987 .. 1991]";

/* Prototypes */
static void applyErr(pico);
static void init(bool);
void usage(void);
void main(int,char*[]);

/* Initialization */
void reset()
{
   lbp = lBuff;
   while (*lbp)
      ++lbp;
   traceLevel = 0;
   stream = NULL;
   nextChar = nextSave = 0;
}

void closeAll()
{
   while (isCell(val(fileSym)))
      closeFile((Afile*)unBox(car(car(val(fileSym)))));
}

void unwind()
{
   register pico *p;
   register long cnt;

   while (stkBase != &topFrame) {
      p = stkBase->sp;
      cnt = stkBase->cnt;
      while (--cnt >= 0) {
         val(*(p+1)) = *(p+3);
         p += 4;
      }
      stkBase = stkBase->link;
   }
   stkPtr = NULL;
   catchBase = NULL;
   withPtr = &nilSym;
}

/* Error processing */
void doError()
{
   char buf[FILENAME];

   if (isNum(loadPos)) {
      prString("\n[Line ");
      prNumber(unBox(loadPos));
      prString(" in ");
      prString(bufString(loadName, buf, FILENAME));
      chrOut(']');
   }
   crlf();
   revalo(nilSym);
   unwind();
   closeAll();
   longjmp(errRst,-1);
}

void error(s,t)
char *s,*t;
{
   reset();
   prString(s);
   if (t)
      prString(t);
   doError();
}

void err(s)
char *s;
{
   error(s,NULL);
}

void cBreak()
{
   Afile *sSave;

   push(val(logFlg));
   val(logFlg) = nilSym;
   push(val(macFlg));
   val(macFlg) = nilSym;
   sSave = stream;
   setStream(NULL);
   prString("\nCONSOLE BREAK\n");
   revalo(nilSym);
   stream = sSave;
   val(macFlg) = pop();
   val(logFlg) = pop();
}

/* Print the error object */
void errObj(x,s)
pico x;
char *s;
{
   reset();
   prin0(x);
   error(": ",s);
}

void errStrObj(x,s)
pico x;
char *s;
{
   char msg[1024];

   reset();
   if (strLength(x) >= 1024)
      err(s);
   prString(bufString(x,msg,1024));
   error(": ",s);
}

void numberError(x)
pico x;
{
   errObj(x, "Number expected");
}

void cellError(x)
pico x;
{
   errObj(x, "Cell expected");
}

void symbolError(x)
pico x;
{
   errObj(x, "Symbol expected");
}

void objError(x)
pico x;
{
   errObj(x, "Cell or Symbol expected");
}

void listError(x)
pico x;
{
   errObj(x, "List expected");
}

void strError(x)
pico x;
{
   errObj(x, "String expected");
}

void funError(x)
pico x;
{
   errObj(x, "Function expected");
}

void dynamoError(x)
pico x;
{
   errObj(x, "Dynamo expected");
}

void protected(x)
pico x;
{
   errObj(x, "Protected symbol");
}

void circError()
{
   err("Circular list");
}

void divError()
{
   err("Division by Zero");
}

void ovflError()
{
   err("Arithmetic Overflow");
}

void internErr(s)
char *s;
{
   error("Internal error: ",s);
}

/* Evaluate a list */
pico eval0(x)
register pico x;
{
   register pico y,z;
   register pico *p;
   register long cnt;
   stkFrame f;

   if (isNum(y = car(x)))
      return x;
   if (!isSym(y)) {
      if (isNum(y = eval0(y)))
         return (*(fun)(unBox(y)))(cdr(x));
      if (!isSym(y))
         return applySexpr(y, cdr(x));
   }
   if (isNum(z = val(y))) {
#if 0
      if (!(num(z) & 1))
         errObj(y,"Bad function");
#endif
      return (*(fun)(unBox(z)))(cdr(x));
   }
   if (isSym(z))
      errObj(y, "Undefined");
   f.self = y;
   x = cdr(x);
   y = car(z);
   cnt = 0;
   while (isCell(y)) {
      ++cnt;
      push(EVAL(car(x)));
      push(car(y));
      x = cdr(x);
      y = cdr(y);
   }
   if (!isNil(y)) {
      ++cnt;
      push(x);
      push(y);
   }
   f.link = stkBase;
   stkBase = &f;
   p = f.sp = stkPtr;
   f.cnt = cnt;
   while (--cnt >= 0) {
      x = *++p;
      y = val(x);
      p += 2;
      val(x) = *p;
      *p++ = y;
   }
   x = cdr(z);
   do
      y = EVAL(car(x));
   while (isCell(x = cdr(x)));
   while (--f.cnt >= 0) {
      x = pop();
      val(x) = pop();
   }
   stkBase = f.link;
   return y;
}

pico applySexpr(sexpr,x)
pico sexpr;
register pico x;
{
   register pico y;
   register pico *p;
   register long cnt;
   stkFrame f;

   f.self = sexpr;
   y = car(sexpr);
   cnt = 0;
   while (isCell(y)) {
      ++cnt;
      push(EVAL(car(x)));
      push(car(y));
      x = cdr(x);
      y = cdr(y);
   }
   if (!isNil(y)) {
      ++cnt;
      push(x);
      push(y);
   }
   f.link = stkBase;
   stkBase = &f;
   p = f.sp = stkPtr;
   f.cnt = cnt;
   while (--cnt >= 0) {
      x = *++p;
      y = val(x);
      p += 2;
      val(x) = *p;
      *p++ = y;
   }
   x = cdr(sexpr);
   do
      y = EVAL(car(x));
   while (isCell(x = cdr(x)));
   while (--f.cnt >= 0) {
      x = pop();
      val(x) = pop();
   }
   stkBase = f.link;
   return y;
}

pico applyMethod(sexpr,arg,x)
pico sexpr;
register pico arg,x;
{
   register pico y;
   register pico *p;
   register long cnt;
   stkFrame f;

   f.self = theMessage;
   cnt = 0;
   if (isCell(y = car(sexpr))) {
      cnt = 1;
      push(arg);
      push(car(y));
      y = cdr(y);
      while (isCell(y)) {
         ++cnt;
         push(EVAL(car(x)));
         push(car(y));
         x = cdr(x);
         y = cdr(y);
      }
      if (!isNil(y)) {
         ++cnt;
         push(x);
         push(y);
      }
   }
   f.link = stkBase;
   stkBase = &f;
   p = f.sp = stkPtr;
   f.cnt = cnt;
   while (--cnt >= 0) {
      x = *++p;
      y = val(x);
      p += 2;
      val(x) = *p;
      *p++ = y;
   }
   x = cdr(sexpr);
   do
      y = EVAL(car(x));
   while (isCell(x = cdr(x)));
   while (--f.cnt >= 0) {
      x = pop();
      val(x) = pop();
   }
   stkBase = f.link;
   return y;
}

pico applyProc(procDef,arg)
pico procDef;
pico arg;
{
   register pico x, y;
   register pico *p;
   stkFrame f;

   f.self = procDef;
   if (!isCell(procDef))
      return nilSym;
   x = car(procDef);
   p = &arg;
   f.cnt = 0;
   while (isCell(x)) {
      ++f.cnt;
      y = car(x);
      x = cdr(x);
      push(val(y));
      push(y);
      val(y) = *p++;
   }
   f.link = stkBase;
   stkBase = &f;
   f.sp = stkPtr;
   x = evalBody(cdr(procDef));
   while (--f.cnt >= 0) {
      y = pop();
      val(y) = pop();
   }
   stkBase = f.link;
   return x;
}

static void applyErr(x)
pico x;
{
   errObj(x,"Can't apply");
}

pico apply1(x,arg)
register pico x,arg;
{
   register pico y,sym;
   stkFrame f;

   if (isNum(x)) {
      val(mapSym) = arg;
      x = (*(fun)(unBox(x)))(mapCell);
      val(mapSym) = nilSym;
      return x;
   }
   if (isSym(x))
      applyErr(x);
   f.self = x;
   y = car(x);
   f.cnt = 1;
   if (!isCell(y) || !isSym(sym = car(y)))
      applyErr(x);
   push(val(sym));
   push(sym);
   val(sym) = arg;
   while (isCell(y = cdr(y))) {
      ++f.cnt;
      sym = car(y);
      push(val(sym));
      push(sym);
      val(sym) = nilSym;
   }
   f.link = stkBase;
   stkBase = &f;
   f.sp = stkPtr;
   x = evalBody(cdr(x));
   while (--f.cnt >= 0) {
      sym = pop();
      val(sym) = pop();
   }
   stkBase = f.link;
   return x;
}

pico apply2(x,arg1,arg2)
register pico x,arg1,arg2;
{
   register pico y,sym;
   stkFrame f;

   if (isNum(x)) {
      val(mapSym2) = arg1;
      val(mapSym) = arg2;
      x = (*(fun)(unBox(x)))(mapCell2);
      val(mapSym2) = nilSym;
      val(mapSym) = nilSym;
      return x;
   }
   if (isSym(x))
      applyErr(x);
   f.self = x;
   y = car(x);
   f.cnt = 2;
   if (!isCell(y) || !isSym(sym = car(y)))
      applyErr(x);
   push(val(sym));
   push(sym);
   val(sym) = arg1;
   y = cdr(y);
   if (!isCell(y) || !isSym(sym = car(y)))
      applyErr(x);
   push(val(sym));
   push(sym);
   val(sym) = arg2;
   while (isCell(y = cdr(y))) {
      ++f.cnt;
      sym = car(y);
      push(val(sym));
      push(sym);
      val(sym) = nilSym;
   }
   f.link = stkBase;
   stkBase = &f;
   f.sp = stkPtr;
   x = evalBody(cdr(x));
   while (--f.cnt >= 0) {
      sym = pop();
      val(sym) = pop();
   }
   stkBase = f.link;
   return x;
}

pico apply3(x,arg1,arg2,arg3)
register pico x,arg1,arg2,arg3;
{
   register pico y,sym;
   stkFrame f;

   if (isNum(x)) {
      val(mapSym3) = arg1;
      val(mapSym2) = arg2;
      val(mapSym) = arg3;
      x = (*(fun)(unBox(x)))(mapCell3);
      val(mapSym3) = nilSym;
      val(mapSym2) = nilSym;
      val(mapSym) = nilSym;
      return x;
   }
   if (isSym(x))
      applyErr(x);
   f.self = x;
   y = car(x);
   f.cnt = 3;
   if (!isCell(y) || !isSym(sym = car(y)))
      applyErr(x);
   push(val(sym));
   push(sym);
   val(sym) = arg1;
   y = cdr(y);
   if (!isCell(y) || !isSym(sym = car(y)))
      applyErr(x);
   push(val(sym));
   push(sym);
   val(sym) = arg2;
   y = cdr(y);
   if (!isCell(y) || !isSym(sym = car(y)))
      applyErr(x);
   push(val(sym));
   push(sym);
   val(sym) = arg3;
   while (isCell(y = cdr(y))) {
      ++f.cnt;
      sym = car(y);
      push(val(sym));
      push(sym);
      val(sym) = nilSym;
   }
   f.link = stkBase;
   stkBase = &f;
   f.sp = stkPtr;
   x = evalBody(cdr(x));
   while (--f.cnt >= 0) {
      sym = pop();
      val(sym) = pop();
   }
   stkBase = f.link;
   return x;
}

pico apply4(x,arg1,arg2,arg3,arg4)
register pico x,arg1,arg2,arg3,arg4;
{
   register pico y,sym;
   stkFrame f;

   if (isNum(x)) {
      val(mapSym4) = arg1;
      val(mapSym3) = arg2;
      val(mapSym2) = arg3;
      val(mapSym) = arg4;
      x = (*(fun)(unBox(x)))(mapCell4);
      val(mapSym4) = nilSym;
      val(mapSym3) = nilSym;
      val(mapSym2) = nilSym;
      val(mapSym) = nilSym;
      return x;
   }
   if (isSym(x))
      applyErr(x);
   f.self = x;
   y = car(x);
   f.cnt = 4;
   if (!isCell(y) || !isSym(sym = car(y)))
      applyErr(x);
   push(val(sym));
   push(sym);
   val(sym) = arg1;
   y = cdr(y);
   if (!isCell(y) || !isSym(sym = car(y)))
      applyErr(x);
   push(val(sym));
   push(sym);
   val(sym) = arg2;
   y = cdr(y);
   if (!isCell(y) || !isSym(sym = car(y)))
      applyErr(x);
   push(val(sym));
   push(sym);
   val(sym) = arg3;
   y = cdr(y);
   if (!isCell(y) || !isSym(sym = car(y)))
      applyErr(x);
   push(val(sym));
   push(sym);
   val(sym) = arg4;
   while (isCell(y = cdr(y))) {
      ++f.cnt;
      sym = car(y);
      push(val(sym));
      push(sym);
      val(sym) = nilSym;
   }
   f.link = stkBase;
   stkBase = &f;
   f.sp = stkPtr;
   x = evalBody(cdr(x));
   while (--f.cnt >= 0) {
      sym = pop();
      val(sym) = pop();
   }
   stkBase = f.link;
   return x;
}

pico Apply(x)
register pico x;
{
   register pico y, sexpr,sym;
   stkFrame f;

   push(EVAL1(x));
   x = cdr(x);
   x = EVAL1(x);
   sexpr = pop();
   if (isNum(sexpr)) {
      register pico p;

      if (!isCell(y = x))
         return (*(fun)(unBox(sexpr)))(nilSym);
      p = mapCell;
      while (isCell(y = cdr(y)))
         if ((p += 2) > applyList)
            errObj(x, "Too long list for APPLY");
      y = p;
      p = car(y);
      do {
         val(p) = car(x);
         p -= 2;
      } while (isCell(x = cdr(x)));
      x = (*(fun)(unBox(sexpr)))(y);
      p = car(y);
      do {
         val(p) = nilSym;
         p -= 2;
      } while (p >= mapSym);
      return x;
   }
   if (isSym(sexpr))
      applyErr(sexpr);
   f.self = sexpr;
   y = car(sexpr);
   f.cnt = 0;
   while (isCell(y)) {
      ++f.cnt;
      sym = car(y);
      push(val(sym));
      push(sym);
      val(sym) = car(x);
      x = cdr(x);
      y = cdr(y);
   }
   f.link = stkBase;
   stkBase = &f;
   f.sp = stkPtr;
   x = evalBody(cdr(sexpr));
   while (--f.cnt >= 0) {
      sym = pop();
      val(sym) = pop();
   }
   stkBase = f.link;
   return x;
}

pico evalBody(x)
register pico x;
{
   register pico y;

   do
      y = EVAL(car(x));
   while (isCell(x = cdr(x)));
   return y;
}

/* Program termination */
void usage()
{
   giveup("Usage: pico [-m<size>] [-l<ttyDev>] [-f<file>] [+any <any>] [<files>]");
}

void giveup(s)
char *s;
{
   fprintf(stderr,"%s\n",s);
   exitPico(FAIL);
}

void revalo(expr)
pico expr;
{
   register pico x;
   pico hidden,str;
   stkFrame *frameSave;
   catchFrame *catchSave;

   ++revaLevel;
   hidden = env.threads[THREADS];
   push(val(classSym));
   push(val(dolSym));
   val(dolSym) = expr;
   frameSave = stkBase;
   catchSave = catchBase;
   while ((x = read0(YES)) != tSym) {
      push(x);
      if (!stream  &&  lBuff[0]  &&  val(againSym) != nilSym  &&
               !equal(str = unBufCString(lBuff), car(val(againSym))) )
         val(againSym) = newCell(str, val(againSym));
      tos = EVAL(x);
      if (!stream) {
         val(star6Sym) = val(star5Sym);
         val(star5Sym) = val(star4Sym);
         val(star4Sym) = val(star3Sym);
         val(star3Sym) = val(star2Sym);
         val(star2Sym) = val(star1Sym);
         val(star1Sym) = tos;
         prString("-> ");
         prin0(tos);
         crlf();
      }
      drop();
      if (stkBase != frameSave)
         internErr("Frame");
      if (catchBase != catchSave)
         internErr("CatchFrame");
   }
   val(dolSym) = pop();
   val(classSym) = pop();
   env.threads[THREADS] = hidden;
   --revaLevel;
}

static void init(flg)
bool flg;
{
   fresh = flg;
   initSymbols();
   reset();
}

#define ARGMAX      8
#define MINCELLS   2000
#define DFLTCELLS   200000

void main(argc,argv)
int argc;
char *argv[];
{
   register pico p;
   register long n;
   char *frzName;
   int fCnt;
   char *fileNames[ARGMAX];
   long nCells;

   nCells = DFLTCELLS;
   frzName = NULL;
   lName = TTY1;
   fCnt = 0;
   while ( --argc > 0 ) {
      if ( **++argv == '-') {
         switch(argv[0][1]) {
         case 'm':
            if (argv[0][2] == '\0') {
               --argc, ++argv;
               nCells = atol( &argv[0][0] );
            }
            else
               nCells = atol( &argv[0][2] );
            if (nCells < MINCELLS)
               giveup("Too small memory size");
            break;
         case 'f':
            if (argv[0][2] == '\0') {
               --argc, ++argv;
               frzName = argv[0];
            }
            else
               frzName = argv[0] + 2;
            break;
         case 'l':
            if (argv[0][2] == '\0') {
               --argc, ++argv;
               lName = argv[0];
            }
            else
               lName = argv[0] + 2;
            break;
         default:
            usage();
            break;
         }
      }
      else {
         if (fCnt >= ARGMAX-1)
            giveup("Too many source files");
         else
            fileNames[fCnt++] = argv[0];
      }
   }

   if (!(heapMem = malloc((nCells+1) * sizeof(cell))))
      giveup("Can't allocate memory");
   initSerial();
   prString(signOnMsg);
   heap = (pico)((long)heapMem  + (CELLSIZE-1) & ~(CELLSIZE-1));
   heapEnd = heap + nCells;

   /* Init PICO environment */
   stkPtr = NULL;
   catchBase = NULL;
   withPtr = &nilSym;
   loadPos = NULL;
   dynamos = NULL;

   stkBase = &topFrame;
   topFrame.link = NULL;
   topFrame.sp = NULL;
   topFrame.cnt = 0;

   /* Error Entry */
   if (setjmp(errRst)) {
      val(dolSym) = nilSym;
      val(loadSym) = nilSym;
   }
   else {
      if (frzName) {
         if (!unFreeze(frzName))
            giveup("Can't UNFREEZE\r");
         init(NO);
         topFrame.self = tSym;
         evalBody(env.run);
      }
      else {
         /* Init empty heap */
         avail = NULL;
         p = heapEnd;
         n = nCells;
         do {
            --p;
            p->link = avail;
            avail = p;
         } while (--n);
         init(YES);
         topFrame.self = tSym;
         env.genSeed[0] = env.genSeed[1] = '$';
         env.genSeed[2] = env.genSeed[3] = env.genSeed[4] = 'A';
         env.genSeed[5] = '@';
         env.genSeed[6] = '\0';
         env.run = nilSym;
         revaLevel = 0;
      }
      for (n = 0; n < fCnt; ++n)
         Load(newCell(unBufCString(fileNames[n]),nilSym));
   }
   do {
      revaLevel = -1;
      revalo(nilSym);
      prString("Exit Pico?");
      revaLevel = 0;
   } while (read0(YES) != tSym);
   exitPico(SUCCESS);
}
