/* picoObj.c
 * 17dec90abu
 */

#include "pico.h"

/* Prototypes */
static void badMessage(pico);
static pico getClass(void);
static pico method(pico);

static pico getClass()
{
   register pico cl;

   cl = val(classSym);
   if (isNum(cl) || !isSym(cl) || cl<=tSym)
      errObj(cl,"Bad *CLASS");
   return cl;
}

/* Define object */
pico OBject(x)
register pico x;
{
   register pico y,sym;

   sym = car(x);
   NEEDSYM(sym);
   CHECKSYM(sym);
   if (!isCell(x = cdr(x)))
      x = objectSym;
   else {
      push(y = newCell(car(x),objectSym));
      while (isCell(x = cdr(x))) {
         cdr(y) = newCell(car(x),objectSym);
         y = cdr(y);
      }
      x = pop();
   }
   if ((y = val(sym)) == voidSym)
      val(sym) = x;
   else {
      while (isCell(y) && isCell(car(y)))
         y = cdr(y);
      if (!sameDef(x,y)) {
         redefMsg(sym,NULL);
         val(sym) = x;
      }
   }
   record(sym,srcFlg);
   return val(classSym) = sym;
}

/* Define method for current class */
pico To(x)
register pico x;
{
   register pico y,mth,cl;

   mth = car(x);
   x = cdr(x);
   cl = car(x);
   if (isNil(cl) || isCell(cl))
      cl = getClass();
   else
      x = cdr(x);
   y = val(cl);
   while (isCell(y)) {
      if (car(car(y)) == mth) {
         y = car(y);
         if (!sameDef(cdr(y),x))
            redefMsg(mth,cl);
         cdr(y) = x;
         goto done;
      }
      y = cdr(y);
   }
   val(cl) = newCell(newCell(mth,x), val(cl));
done:
   record(cl,mth);
   return mth;
}

/* Find method in object or its classes */
static pico method(x)
register pico x;
{
   register pico y;

   x = val(x);
   while (isCell(y = car(x))) {
      if (car(y) == theMessage)
         return cdr(y);
      x = cdr(x);
   }
   while (isCell(x)) {
      if (y = method(car(x)))
         return y;
      x = cdr(x);
   }
   return NULL;
}

pico Method(x)
register pico x;
{
   push(EVAL1(x));      /* Message */
   x = cdr(x);
   x = EVAL1(x);       /* Object */
   theMessage = pop();
   return (x = method(x))? x : nilSym;
}

static
void badMessage(obj)
pico obj;
{
   reset();
   prin0(theMessage);
   prString(": Bad message to ");
   prin0(obj);
   doError();
}

/* Find and execute method in object or its classes */
pico Do(x)
register pico x;
{
   register pico y,obj;

   push(car(x));      /* Message */
   x = cdr(x);
   obj = EVAL1(x);    /* Object */
   theMessage = pop();
   if (y = method(obj))
      return applyMethod(y, obj, cdr(x));
   badMessage(obj);
}

pico All(x)
register pico x;
{
   register pico y,obj,msg;

   msg = car(x);  /* Message */
   x = cdr(x);
   push(EVAL1(x));  /* Object list */
   x = cdr(x);
   y = nilSym;
   while (isCell(tos)) {
      theMessage = msg;
      if (!(y = method(obj = car(tos))))
         badMessage(obj);
      y = applyMethod(y, obj, x);
      tos = cdr(tos);
   }
   drop();
   return y;
}

pico May(x)
register pico x;
{
   register pico y,obj,msg;

   msg = car(x);      /* Message */
   x = cdr(x);
   obj = EVAL1(x);    /* Object */
   theMessage = msg;
   if (y = method(obj))
      return applyMethod(y, obj, cdr(x));
   return nilSym;
}

/* Inherit method from another class */
pico From(x)
register pico x;
{
   register pico y,obj;

   obj = car(x);         /* Class */
   x = cdr(x);
   theMessage = car(x);   /* Message */
   if (y = method(obj))
      return applySexpr(y,cdr(x));
   errObj(theMessage,"Can't inherit");
}

pico Super(x)
register pico x;
{
   register pico y,z,obj,msg;

   msg = car(x);      /* Message */
   x = cdr(x);
   obj = EVAL1(x);    /* Object */
   theMessage = msg;
   z = val(obj);
   while (isCell(car(z)))
      z = cdr(z);
   while (isCell(z)) {
      if (y = method(car(z)))
         return applyMethod(y, obj, cdr(x));
      z = cdr(z);
   }
   return nilSym;
}

/* Create object */
pico New(x)
register pico x;
{
   register pico y,z;

   push(y = EVAL1(x));    /* Class */
   if (!isCell(y))
      y = newCell(y,objectSym);
   else {
      push(z = newCell(car(y),objectSym));
      while (isCell(y = cdr(y))) {
         cdr(z) = newCell(car(y),objectSym);
         z = cdr(z);
      }
      y = pop();
   }
   push(z = gensym(y));
   theMessage = tSym;
   if (y = method(z))
      applyMethod(y,z,cdr(x));
   drop2();
   return z;
}

/* Return object's classes */
pico Class(x)
register pico x;
{
   register pico y;

   x = EVAL1(x);
   NEEDSYM(x);
   x = val(x);
   while (isCell(x) && isCell(car(x)))
      x = cdr(x);
   y = x;
   while (isCell(y))
      y = cdr(y);
   return (y == objectSym)? x : nilSym;
}

/* Define a Daemon */
pico Daemon(x)
register pico x;
{
   register pico msg,obj;

   msg = car(x); /* Message */
   x = cdr(x);
   push(obj = EVAL1(x)); /* Object */
   NEEDSYM(obj);
   x = cdr(x);
   x = EVAL1(x); /* Daemon code */
   x = newCell(msg,x);
   val(obj) = newCell(x,val(obj));
   drop();
   return msg;
}
