/* test.c 27aug90abu */

#include <stdio.h>
#include <math.h>

#define DIST(dh,dv,h1,v1,h2,v2) (\
   dh  =  h2>h1?  h2-h1 : h1-h2, \
   dv  =  v2>v1?  v2-v1 : v1-v2, \
   dh>dv?  dh + dv*41/100 - dh/24  :  dv + dh*41/100 - dv/24 )


long dist(h1,v1,h2,v2)
long h1,v1,h2,v2;
{
   register long dh,dv;

   if ((dh = h2 - h1) < 0)
      dh = -dh;
   if ((dv = v2 - v1) < 0)
      dv = -dv;
   return  dh>dv?  dh + dv*41/100 - dh/24  :  dv + dh*41/100 - dv/24;
}

#define MAXMUL 46340 /* sqrt(2**31-1) */

long pyth(a,b)
register long a,b;
{
   register long n;

   if (a < 0)
      a = -a;
   if (b < 0)
      b = -b;
   n = 1;
   while (a > MAXMUL  ||  b > MAXMUL) {
      a /= 2;
      b /= 2;
      n *= 2;
   }
   return n * isqrt(a*a + b*b);
}

void giveup(s)
char *s;
{
   fprintf(stderr,"%s\n",s);
   exit();
}

main(ac,av)
int ac;
char *av[];
{
   long h1,v1,h2,v2;

   if (ac <= 4)
      giveup("Not enaff args");
   h1 = atol(av[1]);
   v1 = atol(av[2]);
   h2 = atol(av[3]);
   v2 = atol(av[4]);
   printf("Distance: %d\n",dist(h1,v1,h2,v2));
}
