/* intsec.c
 * 28nov90
 */

#include <stdio.h>

#define NO 0
#define YES 1

typedef int integer;
typedef long number;
typedef int bool;

typedef struct {
   long h,v;
} point;

long *stkPtr;              /* Dummy Stack pointer (for picopp.o) */

bool intsec(a,b,d,e,f,p)
point *a,*b,*d,*e;
bool f;
point *p;
{
   register number dh,dv,n,h,v,k,w;

   if (a->h==e->h && a->v==e->v  ||  a->h==d->h && a->v==d->v) {
      p->h = a->h;
      p->v = a->v;
      return YES;
   }
   if (b->h==e->h && b->v==e->v  ||  b->h==d->h && b->v==d->v) {
      p->h = b->h;
      p->v = b->v;
      return YES;
   }
   h = b->h - a->h;
   v = b->v - a->v;
   k = e->h - d->h;
   w = e->v - d->v;
   if (h == 0) {
      if (k == 0)
         return NO;
      p->h = a->h;
   }
   else if (k == 0)
      p->h = d->h;
   else {
      if (abs(h) >= abs(k)) {
         if (!(n = w - muldiv(k,v,h)))
            return NO;
         p->h = a->h;
         dh = a->h - d->h;
         dv = a->v - d->v;
         if (abs(dh)+abs(dv) > abs(b->h - d->h) + abs(b->v - d->v)) {
            p->h = b->h;
            dh = b->h - d->h;
            dv = b->v - d->v;
         }
         if (mulchk(dh,w,n) || mulchk(dv,k,n))
            return NO;
         p->h += - muldiv(dh,w,n) + muldiv(dv,k,n);
      }
      else {
         if (!(n = muldiv(h,w,k) - v))
            return NO;
         p->h = d->h;
         dh = a->h - d->h;
         dv = a->v - d->v;
         if (abs(dh)+abs(dv) > abs(a->h - e->h) + abs(a->v - e->v)) {
            p->h = e->h;
            dh = a->h - e->h;
            dv = a->v - e->v;
         }
         if (mulchk(dh,v,n) || mulchk(dv,h,n))
            return NO;
         p->h += - muldiv(dh,v,n) + muldiv(dv,h,n);
      }
   }
   if (v == 0) {
      if (w == 0)
         return NO;
      p->v = a->v;
   }
   else if (w == 0) {
      n = -k;
      p->v = d->v;
   }
   else {
      if (abs(v) >= abs(w)) {
         if (!(n = muldiv(h,w,v) - k))
            return NO;
         p->v = a->v;
         dh = a->h - d->h;
         dv = a->v - d->v;
         if (abs(dh)+abs(dv) > abs(b->h - d->h) + abs(b->v - d->v)) {
            p->v = b->v;
            dh = b->h - d->h;
            dv = b->v - d->v;
         }
         if (mulchk(dh,w,n) || mulchk(dv,k,n))
            return NO;
         p->v += - muldiv(dh,w,n) + muldiv(dv,k,n);
      }
      else {
         if (!(n = h - muldiv(k,v,w)))
            return NO;
         p->v = d->v;
         dh = a->h - d->h;
         dv = a->v - d->v;
         if (abs(dh)+abs(dv) > abs(a->h - e->h) + abs(a->v - e->v)) {
            p->v = e->v;
            dh = a->h - e->h;
            dv = a->v - e->v;
         }
         if (mulchk(dh,v,n) || mulchk(dv,h,n))
            return NO;
         p->v += - muldiv(dh,v,n) + muldiv(dv,h,n);
      }
   }
   if (!f) {
      n = p->h;
      if (n < a->h  &&  n < b->h  ||  n < d->h  &&  n < e->h ||
               n > a->h  &&  n > b->h  ||  n > d->h  &&  n > e->h )
         return NO;
      n = p->v;
      if (n < a->v  &&  n < b->v  ||  n < d->v  &&  n < e->v ||
               n > a->v  &&  n > b->v  ||  n > d->v  &&  n > e->v )
         return NO;
   }
   return YES;
}

main(ac,av)
int ac;
char *av[];
{
   point a,b,d,e,pt;

   a.h = 1859906;
   a.v = 1364798;
   b.h = 1859163;
   b.v = 1365449;
   if (ac == 1) {
      d.h = 2610234;
      d.v = 2266005;
      e.h = 1853907;
      e.v = 1358411;
   }
   else {
      d.h = 1853907;
      d.v = 1358411;
      e.h = 2610234;
      e.v = 2266005;
   }
   if (intsec(&a,&b,&d,&e,NO,&pt))
      printf("Ok: (%d . %d)\n",pt.h,pt.v);
   else
      printf("No\n");
}
