[dasm.l 16jul90abu]

[Disassemble <n> lines starting at <adr>]
<de dasm (adr n)
   (reptn (default n 1)
      (setq adr (dasm1 adr)) >

[Find address of SUBR]
<de findSubr ($n)
   (best (oblist)
      (lambda ($x)
         (and
            (numberp (getd $x))
            (leq (ptr (add2 (getd $x))) $n)
            (ptr (add2 (getd $x))) >

[++++++
   Free Variables:
      OP   Oplist entry
      OPC  Opcode
      ADR  Operand address
      DST  Destination address
++++++]

(de $regs
   "d0" "d1" "d2" "d3" "d4" "d5" "d6" "d7"
   "a0" "a1" "a2" "a3" "a4" "a5" "a6" "a7" )

[+ Display Primitives +]
<de d-reg1 ()
   (putc \d)
   (prin1 (bitand 7 opc)) >

<de a-reg1 ()
   (putc \a)
   (prin1 (bitand 7 opc)) >

<de d-reg2 ()
   (putc \d)
   (prin1 (div (bitand 0E00 opc) 512)) >

<de a-reg2 ()
   (putc \a)
   (prin1 (div (bitand 0E00 opc) 512)) >

<de pc-reg () (prin2 "PC")>
<de sr-reg () (prin2 "SR")>
<de cc-reg () (prin2 "CCR")>
<de us-reg () (prin2 "USP")>
<de a-mem () (putc \() (a-reg1) (putc \))>
<de dMem () (w-mem) (a-mem)>
<de miMem1 () (putc \-) (a-mem)>
<de miMem2 () (putc \-) (putc \() (a-reg2) (putc \))>
<de memPl1 () (a-mem) (putc \+)>
<de memPl2 () (putc \() (a-reg2) (putc \)) (putc \+)>

<de pr1h (n)
   (prin1 n)
   (when (lessp 9 (abs n))
      (putc \[)
      (prHex n)
      (putc \]) >

<de b-mem ()
   (pr1h (byte (add1 adr))) >

<de w-mem ()
   (pr1h (word adr))
   (inc adr 2) >

<de l-mem ()
   (pr1h (ptr adr))
   (setq adr (add 4 adr)) >

<de x-reg ()
   (putc \,)
   (putc (if (minusp (byte adr)) \a \d))
   (prin1 (div (bitand 070 (byte adr)) 16))
   (putc \.)
   (putc (if (zerop (bitand 8 (byte adr))) \w \l))
   (putc \))
   (inc adr 2) >

<de immed ()
   (putc \#)
   (case (last (car op))
      (\b (b-mem) (inc adr 2))
      (\w (w-mem))
      (\l (l-mem)) >

<de immq ()
   (local (n)
      (putc \#)
      (setq n (div (bitand 0E00 opc) 512))
      (prin1 (if (zerop n) 8 n)) >

<de immW () (putc \#) (w-mem)>

[Effective address]
<de effAd1 ()
   (case (bitand 038 opc)
      (000 [Dn] (d-reg1))
      (008 [An] (a-reg1))
      (010 [(An)] (a-mem))
      (018 [(An)+] (memPl1))
      (020 [-(An)] (miMem1))
      (028 [d(An)] (dMem))
      (030 [d(An,Xi)]
         (b-mem)
         (putc \()
         (a-reg1)
         (x-reg) )
      (038
         (case (bitand 7 opc)
            (0 [Abs.w]
               (w-mem)
               (prin2 ".s") )
            (1 [Abs.l]
               (l-mem) )
            (2 [d(PC)]
               (setq dst (add adr (word adr)))
               (w-mem)
               (putc \()
               (pc-reg)
               (putc \)) )
            (3 [d(PC,Xi)]
               (b-mem)
               (putc \()
               (pc-reg)
               (x-reg) )
            (4 [Imm] (immed) >

<de effAd2 ()
   (local (opc)
      (setq opc
         (bitor
            (div (bitand 0E00 opc) 512)
            (div (bitand 01C0 opc) 8) ) )
      (effAd1) >

<de disp (n)
   (prin1 n)
   (setq dst (add n adr)) >

<de lbra ()
   (disp (word adr))
   (inc adr 2) >

<de branch ()
   (if (zerop (bitand 0FF opc))
      (lbra)
      (disp (byte (sub1 adr))) >

<de moveq ()
   (putc \#)
   (pr1h (byte (sub1 adr))) >

<de trapq ()
   (putc \#)
   (prin1 (bitand 15 (byte (sub1 adr)))) >

<de movem ()
   (local ($regs mask)
      (if (eq 020 (bitand 038 opc))
         (setq $regs (reverse $regs)) )
      (setq mask (word adr))
      (inc adr 2)
      (unless (zerop mask)
         (while (zerop (bitand 1 mask))
            (setq mask (div2 mask))
            (pop $regs) )
         (prin2 (pop $regs))
         (while $regs
            (setq mask (div2 mask))
            (if (zerop (bitand 1 mask))
               (pop $regs)
               (progn
                  (putc \/)
                  (prin2 (pop $regs)) >

<de dcw ()
   (pr1h (word (sub2 adr))) >

[+ Disassembler Opcode Table +]
(de *ops
   [ name     mask   (data foo) ]
   ("andi.b"  0FFFF (0023C immed cc-reg))
   ("andi.w"  0FFFF (0027C immed sr-reg))
   ("bra"     0FFFF (06000 branch))
   ("bsr"     0FFFF (06100 branch))
   ("bhi"     0FFFF (06200 branch))
   ("bls"     0FFFF (06300 branch))
   ("bcc"     0FFFF (06400 branch))
   ("bcs"     0FFFF (06500 branch))
   ("bne"     0FFFF (06600 branch))
   ("beq"     0FFFF (06700 branch))
   ("bvc"     0FFFF (06800 branch))
   ("bvs"     0FFFF (06900 branch))
   ("bpl"     0FFFF (06A00 branch))
   ("bmi"     0FFFF (06B00 branch))
   ("bge"     0FFFF (06C00 branch))
   ("blt"     0FFFF (06D00 branch))
   ("bgt"     0FFFF (06E00 branch))
   ("ble"     0FFFF (06F00 branch))
   ("eori.b"  0FFFF (00A3C immed cc-reg))
   ("eori.w"  0FFFF (00A7C immed sr-reg))
   ("illegal" 0FFFF (04AFC))
   ("nop"     0FFFF (04E71))
   ("ori.b"   0FFFF (0003C immed cc-reg))
   ("ori.w"   0FFFF (0007C immed sr-reg))
   ("reset"   0FFFF (04E70))
   ("rte"     0FFFF (04E73))
   ("rtr"     0FFFF (04E77))
   ("rts"     0FFFF (04E75))
   ("stop"    0FFFF (04E72 immW))
   ("trapv"   0FFFF (04E76))
   ("dbra"    0FFF8 (050C8 d-reg1 lbra))
   ("dbf"     0FFF8 (051C8 d-reg1 lbra))
   ("dbhi"    0FFF8 (052C8 d-reg1 lbra))
   ("dbls"    0FFF8 (053C8 d-reg1 lbra))
   ("dbcc"    0FFF8 (054C8 d-reg1 lbra))
   ("dbcs"    0FFF8 (055C8 d-reg1 lbra))
   ("dbne"    0FFF8 (056C8 d-reg1 lbra))
   ("dbeq"    0FFF8 (057C8 d-reg1 lbra))
   ("dbvc"    0FFF8 (058C8 d-reg1 lbra))
   ("dbvs"    0FFF8 (059C8 d-reg1 lbra))
   ("dbpl"    0FFF8 (05AC8 d-reg1 lbra))
   ("dbmi"    0FFF8 (05BC8 d-reg1 lbra))
   ("dbge"    0FFF8 (05CC8 d-reg1 lbra))
   ("dblt"    0FFF8 (05DC8 d-reg1 lbra))
   ("dbgt"    0FFF8 (05EC8 d-reg1 lbra))
   ("dble"    0FFF8 (05FC8 d-reg1 lbra))
   ("ext.w"   0FFF8 (04880 d-reg1))
   ("ext.l"   0FFF8 (048C0 d-reg1))
   ("link"    0FFF8 (04E50 a-reg1 immW))
   ("move"    0FFF8 (04E60 a-reg1 us-reg))
   ("move"    0FFF8 (04E68 us-reg a-reg1))
   ("swap"    0FFF8 (04840 d-reg1))
   ("unlk"    0FFF8 (04E58 a-reg1))
   ("trap"    0FFF0 (04E40 trapq))
   ("addi.b"  0FFC0 (00600 immed effAd1))
   ("addi.w"  0FFC0 (00640 immed effAd1))
   ("addi.l"  0FFC0 (00680 immed effAd1))
   ("andi.b"  0FFC0 (00200 immed effAd1))
   ("andi.w"  0FFC0 (00240 immed effAd1))
   ("andi.l"  0FFC0 (00280 immed effAd1))
   ("asl.b"   0FFC0 (0E1C0 effAd1))
   ("asr.b"   0FFC0 (0E0C0 effAd1))
   ("bchg"    0FFC0 (00840 immW effAd1))
   ("bclr"    0FFC0 (00880 immW effAd1))
   ("bset"    0FFC0 (008C0 immW effAd1))
   ("btst"    0FFC0 (00800 immW effAd1))
   ("clr.b"   0FFC0 (04200 effAd1))
   ("clr.w"   0FFC0 (04240 effAd1))
   ("clr.l"   0FFC0 (04280 effAd1))
   ("cmpi.b"  0FFC0 (00C00 immed effAd1))
   ("cmpi.w"  0FFC0 (00C40 immed effAd1))
   ("cmpi.l"  0FFC0 (00C80 immed effAd1))
   ("eori.b"  0FFC0 (00A00 immed effAd1))
   ("eori.w"  0FFC0 (00A40 immed effAd1))
   ("eori.l"  0FFC0 (00A80 immed effAd1))
   ("jmp"     0FFC0 (04EC0 effAd1))
   ("jsr"     0FFC0 (04E80 effAd1))
   ("lsl.b"   0FFC0 (0E3C0 effAd1))
   ("lsr.b"   0FFC0 (0E2C0 effAd1))
   ("move.w"  0FFC0 (044C0 effAd1 cc-reg))
   ("move.w"  0FFC0 (046C0 effAd1 sr-reg))
   ("move.w"  0FFC0 (040C0 sr-reg effAd1))
   ("movem.w" 0FFC0 (04880 movem effAd1) (04C80 effAd1 movem))
   ("movem.l" 0FFC0 (048C0 movem effAd1) (04CC0 effAd1 movem))
   ("nbcd"    0FFC0 (04800 effAd1))
   ("neg.b"   0FFC0 (04400 effAd1))
   ("neg.w"   0FFC0 (04440 effAd1))
   ("neg.l"   0FFC0 (04480 effAd1))
   ("negx.b"  0FFC0 (04000 effAd1))
   ("negx.w"  0FFC0 (04040 effAd1))
   ("negx.l"  0FFC0 (04080 effAd1))
   ("not.b"   0FFC0 (04600 effAd1))
   ("not.w"   0FFC0 (04640 effAd1))
   ("not.l"   0FFC0 (04680 effAd1))
   ("ori.b"   0FFC0 (00000 immed effAd1))
   ("ori.w"   0FFC0 (00040 immed effAd1))
   ("ori.l"   0FFC0 (00080 immed effAd1))
   ("pea"     0FFC0 (04840 effAd1))
   ("rol.b"   0FFC0 (0E7C0 effAd1))
   ("ror.b"   0FFC0 (0E6C0 effAd1))
   ("roxl.b"  0FFC0 (0E5C0 effAd1))
   ("roxr.b"  0FFC0 (0E4C0 effAd1))
   ("st"      0FFC0 (050C0 effAd1))
   ("sf"      0FFC0 (051C0 effAd1))
   ("shi"     0FFC0 (052C0 effAd1))
   ("sls"     0FFC0 (053C0 effAd1))
   ("scc"     0FFC0 (054C0 effAd1))
   ("scs"     0FFC0 (055C0 effAd1))
   ("sne"     0FFC0 (056C0 effAd1))
   ("seq"     0FFC0 (057C0 effAd1))
   ("svc"     0FFC0 (058C0 effAd1))
   ("svs"     0FFC0 (059C0 effAd1))
   ("spl"     0FFC0 (05AC0 effAd1))
   ("smi"     0FFC0 (05BC0 effAd1))
   ("sge"     0FFC0 (05CC0 effAd1))
   ("slt"     0FFC0 (05DC0 effAd1))
   ("sgt"     0FFC0 (05EC0 effAd1))
   ("sle"     0FFC0 (05FC0 effAd1))
   ("subi.b"  0FFC0 (00400 immed effAd1))
   ("subi.w"  0FFC0 (00440 immed effAd1))
   ("subi.l"  0FFC0 (00480 immed effAd1))
   ("tas"     0FFC0 (04AC0 effAd1))
   ("tst.b"   0FFC0 (04A00 effAd1))
   ("tst.w"   0FFC0 (04A40 effAd1))
   ("tst.l"   0FFC0 (04A80 effAd1))
   ("bra.s"   0FF00 (06000 branch))
   ("bsr.s"   0FF00 (06100 branch))
   ("bhi.s"   0FF00 (06200 branch))
   ("bls.s"   0FF00 (06300 branch))
   ("bcc.s"   0FF00 (06400 branch))
   ("bcs.s"   0FF00 (06500 branch))
   ("bne.s"   0FF00 (06600 branch))
   ("beq.s"   0FF00 (06700 branch))
   ("bvc.s"   0FF00 (06800 branch))
   ("bvs.s"   0FF00 (06900 branch))
   ("bpl.s"   0FF00 (06A00 branch))
   ("bmi.s"   0FF00 (06B00 branch))
   ("bge.s"   0FF00 (06C00 branch))
   ("blt.s"   0FF00 (06D00 branch))
   ("bgt.s"   0FF00 (06E00 branch))
   ("ble.s"   0FF00 (06F00 branch))
   ("abcd"    0F1F8 (0C100 d-reg1 d-reg2) (0C108 miMem1 miMem2))
   ("exg"     0F1F8 (0C140 d-reg1 d-reg2))
   ("exg"     0F1F8 (0C148 a-reg1 a-reg2))
   ("exg"     0F1F8 (0C188 a-reg1 d-reg2))
   ("asl.b"   0F1F8 (0E100 immq d-reg1) (0E120 d-reg2 d-reg1))
   ("asl.w"   0F1F8 (0E140 immq d-reg1) (0E160 d-reg2 d-reg1))
   ("asl.l"   0F1F8 (0E180 immq d-reg1) (0E1A0 d-reg2 d-reg1))
   ("asr.b"   0F1F8 (0E000 immq d-reg1) (0E020 d-reg2 d-reg1))
   ("asr.w"   0F1F8 (0E040 immq d-reg1) (0E060 d-reg2 d-reg1))
   ("asr.l"   0F1F8 (0E080 immq d-reg1) (0E0A0 d-reg2 d-reg1))
   ("cmpm.b"  0F1F8 (0B108 memPl1 memPl2))
   ("cmpm.w"  0F1F8 (0B148 memPl1 memPl2))
   ("cmpm.l"  0F1F8 (0B188 memPl1 memPl2))
   ("lsl.b"   0F1F8 (0E108 immq d-reg1) (0E128 d-reg2 d-reg1))
   ("lsl.w"   0F1F8 (0E148 immq d-reg1) (0E168 d-reg2 d-reg1))
   ("lsl.l"   0F1F8 (0E188 immq d-reg1) (0E1A8 d-reg2 d-reg1))
   ("lsr.b"   0F1F8 (0E008 immq d-reg1) (0E028 d-reg2 d-reg1))
   ("lsr.w"   0F1F8 (0E048 immq d-reg1) (0E068 d-reg2 d-reg1))
   ("lsr.l"   0F1F8 (0E088 immq d-reg1) (0E0A8 d-reg2 d-reg1))
   ("movep.w" 0F1F8 (00108 dMem d-reg2) (00188 d-reg2 dMem))
   ("movep.l" 0F1F8 (00148 dMem d-reg2) (001C8 d-reg2 dMem))
   ("rol.b"   0F1F8 (0E118 immq d-reg1) (0E138 d-reg2 d-reg1))
   ("rol.w"   0F1F8 (0E158 immq d-reg1) (0E178 d-reg2 d-reg1))
   ("rol.l"   0F1F8 (0E198 immq d-reg1) (0E1B8 d-reg2 d-reg1))
   ("ror.b"   0F1F8 (0E018 immq d-reg1) (0E038 d-reg2 d-reg1))
   ("ror.w"   0F1F8 (0E058 immq d-reg1) (0E078 d-reg2 d-reg1))
   ("ror.l"   0F1F8 (0E098 immq d-reg1) (0E0B8 d-reg2 d-reg1))
   ("roxl.b"  0F1F8 (0E110 immq d-reg1) (0E130 d-reg2 d-reg1))
   ("roxl.w"  0F1F8 (0E150 immq d-reg1) (0E170 d-reg2 d-reg1))
   ("roxl.l"  0F1F8 (0E190 immq d-reg1) (0E1B0 d-reg2 d-reg1))
   ("roxr.b"  0F1F8 (0E010 immq d-reg1) (0E030 d-reg2 d-reg1))
   ("roxr.w"  0F1F8 (0E050 immq d-reg1) (0E070 d-reg2 d-reg1))
   ("roxr.l"  0F1F8 (0E090 immq d-reg1) (0E0B0 d-reg2 d-reg1))
   ("sbcd"    0F1F8 (08100 d-reg1 d-reg2) (08108 miMem1 miMem2))
   ("addx.b"  0F1C8 (0D100 d-reg1 d-reg2) (0D108 miMem1 miMem2))
   ("addx.w"  0F1C8 (0D140 d-reg1 d-reg2) (0D148 miMem1 miMem2))
   ("addx.l"  0F1C8 (0D180 d-reg1 d-reg2) (0D188 miMem1 miMem2))
   ("subx.b"  0F1C8 (09100 d-reg1 d-reg2) (09108 miMem1 miMem2))
   ("subx.w"  0F1C8 (09140 d-reg1 d-reg2) (09148 miMem1 miMem2))
   ("subx.l"  0F1C8 (09180 d-reg1 d-reg2) (09188 miMem1 miMem2))
   ("add.b"   0F1C0 (0D000 effAd1 d-reg2) (0D100 d-reg2 effAd1))
   ("add.w"   0F1C0 (0D040 effAd1 d-reg2) (0D140 d-reg2 effAd1))
   ("add.l"   0F1C0 (0D080 effAd1 d-reg2) (0D180 d-reg2 effAd1))
   ("adda.w"  0F1C0 (0D0C0 effAd1 a-reg2))
   ("adda.l"  0F1C0 (0D1C0 effAd1 a-reg2))
   ("addq.b"  0F1C0 (05000 immq effAd1))
   ("addq.w"  0F1C0 (05040 immq effAd1))
   ("addq.l"  0F1C0 (05080 immq effAd1))
   ("and.b"   0F1C0 (0C000 effAd1 d-reg2) (0C100 d-reg2 effAd1))
   ("and.w"   0F1C0 (0C040 effAd1 d-reg2) (0C140 d-reg2 effAd1))
   ("and.l"   0F1C0 (0C080 effAd1 d-reg2) (0C180 d-reg2 effAd1))
   ("bchg"    0F1C0 (00140 d-reg2 effAd1))
   ("bclr"    0F1C0 (00180 d-reg2 effAd1))
   ("bset"    0F1C0 (001C0 d-reg2 effAd1))
   ("btst"    0F1C0 (00100 d-reg2 effAd1))
   ("chk"     0F1C0 (04180 effAd1 d-reg2))
   ("cmp.b"   0F1C0 (0B000 effAd1 d-reg2))
   ("cmp.w"   0F1C0 (0B040 effAd1 d-reg2))
   ("cmp.l"   0F1C0 (0B080 effAd1 d-reg2))
   ("cmpa.w"  0F1C0 (0B0C0 effAd1 a-reg2))
   ("cmpa.l"  0F1C0 (0B1C0 effAd1 a-reg2))
   ("divs.w"  0F1C0 (081C0 effAd1 d-reg2))
   ("divu.w"  0F1C0 (080C0 effAd1 d-reg2))
   ("eor.b"   0F1C0 (0B100 d-reg2 effAd1))
   ("eor.w"   0F1C0 (0B140 d-reg2 effAd1))
   ("eor.l"   0F1C0 (0B180 d-reg2 effAd1))
   ("lea"     0F1C0 (041C0 effAd1 a-reg2))
   ("movea.w" 0F1C0 (03040 effAd1 a-reg2))
   ("movea.l" 0F1C0 (02040 effAd1 a-reg2))
   ("muls.w"  0F1C0 (0C1C0 effAd1 d-reg2))
   ("mulu.w"  0F1C0 (0C0C0 effAd1 d-reg2))
   ("or.b"    0F1C0 (08000 effAd1 d-reg2) (08100 d-reg2 effAd1))
   ("or.w"    0F1C0 (08040 effAd1 d-reg2) (08140 d-reg2 effAd1))
   ("or.l"    0F1C0 (08080 effAd1 d-reg2) (08180 d-reg2 effAd1))
   ("sub.b"   0F1C0 (09000 effAd1 d-reg2) (09100 d-reg2 effAd1))
   ("sub.w"   0F1C0 (09040 effAd1 d-reg2) (09140 d-reg2 effAd1))
   ("sub.l"   0F1C0 (09080 effAd1 d-reg2) (09180 d-reg2 effAd1))
   ("suba.w"  0F1C0 (090C0 effAd1 a-reg2))
   ("suba.l"  0F1C0 (091C0 effAd1 a-reg2))
   ("subq.b"  0F1C0 (05100 immq effAd1))
   ("subq.w"  0F1C0 (05140 immq effAd1))
   ("subq.l"  0F1C0 (05180 immq effAd1))
   ("moveq"   0F100 (07000 moveq d-reg2))
   ("move.b"  0F000 (01000 effAd1 effAd2))
   ("move.w"  0F000 (03000 effAd1 effAd2))
   ("move.l"  0F000 (02000 effAd1 effAd2))
   ("dc.w" 0 (0 dcw)) )

[Disassemble one instruction]
<de dasm1 (adr)
   (prHex adr)
   (tab)
   <local (opc dst)
      (setq opc (word adr))
      (inc adr 2)
      (setq dst)
      (find *ops
         (lambda (op)
            (find (cddr op)
               (lambda (x)
                  (when
                     (eq
                        (car x)
                        (bitand opc (cadr op)) )
                     (prin2 (car op))
                     (when (setq x (cdr x))
                        (space)
                        ((getd (car x)))
                        (when (cadr x)
                           (putc \,)
                           ((getd (cadr x))) ) )
                     (when dst
                        (tab)
                        (putc \[)
                        (prHex dst)
                        (putc \]) )
                     t >
   (terpri)
   adr >

t [dasm.l]
