[too.l 12feb91abu]

[Define a function key]
<de defKey (c . $x)
   (if (assoc c *fKey)
      (rplacd (assoc c *fKey) $x)
      (push (cons c $x) *fKey) >

[Find matching symbols]
<de what (s)
   (filter (oblist)
      (lambda (x)
         (wild s (pname x)) >

[++++++
<de has ($x)
   (filter (oblist)
      (lambda ($y)
         (equal $x (value $y)) >
++++++]

<de can ($x)
   (filter (oblist)
      (lambda ($y)
         (and
            (class $y)
            (assoc $x (value $y)) >

[Read one expression]
[Find function in file]
<de ff ($f $c)
   (local (x)
      (when (setq x (if $c (get $c $f) (get $f '*src)))
         (prin2 "Line ")
         (prin1 (car x))
         (prin2 " in ")
         (prLine (cdr x))
         t >

[Data inspection]
<de more (l $foo)
   (default $foo print)
   (local (n)
      (prin1 (zero n))
      (putc \#)
      ($foo (pop l))
      (while (and (pairp l) (neq 27 (hitkey)))
         (prin1 (inc n))
         (putc \#)
         ($foo (pop l)) )
      t >

[Pretty Printing]
<de *pp
   t if when unless while until reptn case for local with catch
   lambda do from may >

<de pretty ($x $l $f)
   (reptn (default $l 0) (tab $f))
   (if (lessp (depth $x) 3)
      (prin1 $x $f)
      (progn
         (putc \( $f)
         (while
            (and
               (member (prin1 (pop $x) $f) *pp)
               (lessp (depth (car $x)) 3) )
            (space $f) )
         (while $x
            (terpri $f)
            (pretty (pop $x) (add1 $l) $f) )
         (space $f)
         (putc \) $f) >

<de pp ($x $c $f)
   (putc \( $f)
   (prin1
      (if $c
         'to
         (if (atom (value $x)) 'setq 'de) )
      $f )
   (space $f)
   (prog1
      (prin1 $x $f)
      (space $f)
      (setq $x
         (if $c
            (cdr (assoc $x (value $c)))
            (value $x) ) )
      (if (atom $x)
         (prin1
            (if (or (null $x) (numberp $x))
               $x
               (list 'quote $x))
            $f )
         (progn
            (prin1 (pop $x) $f)
            (while (pairp $x)
               (terpri $f)
               (pretty (pop $x) 1 $f) )
            (when $x
               (prin2 " . " $f)
               (prin1 $x) )
            (space $f) ) )
      (putc \) $f)
      (terpri $f) >

<de fold ($x $l2 $l1)
   (reptn (default $l1 0) (tab))
   (if (lessp (depth $x) 3)
      (prin1 $x)
      (progn
         (or (zerop $l1) (putc \())
         (while
            (and
               (member (prin1 (pop $x)) *pp)
               (lessp (depth (car $x)) 3) )
            (space) )
         (if (lessp $l1 $l2)
            (while $x
               (terpri)
               (fold (pop $x) $l2 (add1 $l1)) )
            (prin2 " ..") )
         (space)
         (putc \)) >

<de fp ($x $l)
   (default $l 3)
   (putc \()
   (prin1 'de) (space)
   (prog1
      (prin1 $x)
      (space)
      (fold (value $x) $l)
      (terpri) >

<de show ($x $f)
   (prLine "Value:" $f)
   (tab $f) (print (value $x) $f)
   (prLine "Properties:" $f)
   (mapc (plist $x)
      (lambda ($y) (tab $f) (print $y $f)) )
   (prLine "Flags:" $f)
   (tab $f) (print (flags $x) $f)
   $x >

<de tData ($o $x)
   (when (pairp $x)
      (cond
         ((eq 'with (car $x))
            (local ($w)
               (setq $w (cadr $x))
               (tData $o (caddr $x))
               (tData $o (cdddr $x)) ) )
         ((and (eq 'slot (car $x)) (eq $o $w))
            (push1 (cadr $x) $l) )
         ((and
               (memq (car $x) '(put get))
               (eq $o (cadr $x))
               (pairp (caddr $x))
               (eq 'quote (car (caddr $x))) )
            (push1 (cadr (caddr $x)) $l) )
         (t
            (tData $o (car $x))
            (tData $o (cdr $x)) >

<de $type ($x)
   (when $x
      (check)
      (mapc (value $x)
         '(($y)
            (when (pairp $y)
               (tData (caadr $y) (cddr $y)) ) ) )
      (mapc (class $x) $type) >

<de type ($x $d $f)
   (prLine "Class:" $f)
   (tab $f) (print (class $x) $f)
   (when $d
      (prLine "Data:" $f)
      (local ($l)
         (setq $l)
         ($type $x)
         (tab $f) (print $l $f) ) )
   (prLine "Methods:" $f)
   (mapc (value $x)
      (lambda ($y)
         (when (pairp $y)
            (tab $f) (prin1 (car $y) $f)
            (space $f) (print (cadr $y) $f) ) ) )
   $x >

[Structure Editor]
<setq *scrap>

<de ptch ($x $n)
   (local ($c)
      (loop
         (t $done $x)
         (if $p
            (pretty (car $x) $n)
            (prin1 (car $x)) )
         (terpri)
         (setq $c (upc (hitKey)))
         (t (eq $c ^H) $x)
         (t (eq $c \E) (on $done) $x)
         <setq $x
            (if (leq \1 $c \9)
               (cons (chop (sub $c \0) $x) $x)
               (case $c
                  ((^M ^J) (cons (ptch (car $x) (add1 $n)) (cdr $x)))
                  (\  (cons (car $x) (ptch (cdr $x) $n)))
                  (\Q (throw t 'quit))
                  (\P (toggle $p) $x)
                  (\D (cdr $x))
                  (\I (prin2 "Insert") (cons (read) $x))
                  (\R (prin2 "Replace") (cons (read) (cdr $x)))
                  (\X (setq *scrap (car $x)) (cdr $x))
                  (\C (setq *scrap (car $x)) $x)
                  (\V (cons *scrap $x))
                  (\@ (append (car $x) (cdr $x)))
                  (\B
                     (if (eq 'BREAK$ (caar $x))
                        (cons (cdar $x) (cdr $x))
                        (cons (cons 'BREAK$ (car $x)) (cdr $x)) ) )
                  (t $x) > >

<de ed ($x $c)
   (catch t
      (local ($done $p)
         (off $done $p)
         (if $c
            (progn
               (setq $x (assoc $x (value $c)))
               (rplacd $x (ptch (cdr $x) 0))
               (car $x) )
            (putd $x (ptch (value $x) 0)) >

[Debugging]
<de dbug (l)
   (or
      (atom (car l))
      (numberp (caar l))
      (eq 'BREAK$ (caar l))
      (rplaca l (cons 'BREAK$ (car l))) >

<de debug (lst)
   (when (pairp lst)
      (case (pop lst)
         (case
            (dbug lst)
            (mapc (cdr lst)
               (lambda (l) (map (cdr l) dbug)) ) )
         (cond
            (mapc lst
               (lambda (l) (map l dbug)) ) )
         ((lambda for local)
            (map (cdr lst) dbug) )
         (loop
            (map lst
               (lambda (l)
                  (if (eq t (caar l))
                     (map (cdar l) dbug)
                     (dbug l) ) ) ) )
         (t (map lst dbug)) )
      t >

<de unbug (lst)
   (when (pairp lst)
      (map lst
         (lambda (l)
            (when (pairp (car l))
               (when (eq 'BREAK$ (caar l))
                  (rplaca l (cdar l)) )
               (unbug (car l)) ) ) )
      t >

<de expr (nargs $f)
   (local (newfun arglst)
      (putd
         (setq newfun (gensym))
         (getd $f) )
      (setq arglst)
      (reptn nargs
         (push (gensym) arglst) )
      (putd $f
         (list arglst (cons newfun arglst) >

<de subr ($x)
   (putd $x
      (getd (caadr (getd $x) >

<de traced ($x $c)
   (setq $x
      (if $c
         (method $x $c)
         (getd $x) ) )
   (and
      (pairp $x)
      (eq 'TRACE$ (caadr $x)) >

[Convert ((X Y) A B) --> ((X Y) (TRACE$ FOO (X Y) A B))]
<de trace ($x $n)
   (if (and $n (symbolp $n))
      (unless (or (traced $x $n) (not (method $x $n)))
         (rplacd
            (method $x $n)
            (list
               (nconc
                  (list 'TRACE$ (cons $x $n))
                  (cons
                     (car (method $x $n))
                     (cdr (method $x $n)) ) ) ) )
         $x )
      (unless (or (traced $x) (symbolp (getd $x)))
         (if (numberp (getd $x))
            (expr $n $x) )
         (putd $x
            (list
               (car (getd $x))
               (nconc (list 'TRACE$ $x) (getd $x) >

[Convert ((X Y) (TRACE$ FOO (X Y) A B)) --> ((X Y) A B)]
<de untrace ($x $n)
   (if (and $n (symbolp $n))
      (when (traced $x $n)
         (rplacd
            (method $x $n)
            (cdddr (cadr (method $x $n))) )
         $x )
      (when (traced $x)
         (putd $x (cddr (cadr (getd $x))))
         (if $n (subr $x))
         $x >

[Profiler]
<de profed (lst)
   (and (pairp lst) (eq 'prof$ (caadr lst))) >

<de prof (lst)
   (when (pairp lst)
      (if (profed lst)
         (prog1 (cadr (cadr lst))
            (rplaca (cdadr lst) 0) )
         (prog1 t
            (rplacd lst
               (list (cons 'prof$ (cons 0 (cdr lst)))) >

<de unprof (lst)
   (when (profed lst)
      (rplacd lst
         (cddr (cadr lst)) )
      t >

<de profile ()
   (more
      (sort
         (mapcan (oblist)
            (lambda ($x)
               (and
                  (profed (getd $x))
                  (not (zerop (cadr (cadr (getd $x)))))
                  (list (cons $x (prof (getd $x)))) ) ) )
         cdr )
      (lambda (x)
         (prin1 (car x))
         (prin2 ": ")
         (prin1 (cdr x))
         (prin2 " ticks [")
         (prin2 (format (div (cdr x) 6) 1))
         (prline " sec]") >

[Print call-tree]
<de $tree ($x)
   (cond
      ((symbolp $x)
         (when
            (and
               (pairp (getd $x))
               (not (memq $x $lst)) )
            (reptn $n (tab))
            (print $x)
            (push $x $lst)
            (push1 $x *tree)
            (unless (memq $x $l)
               (tree
                  (getd $x)
                  $lim
                  (add1 $n)
                  (append $lst $l) ) ) ) )
      ((and (pairp $x) (neq 'quote (car $x)))
         (mapc $x $tree) >

<de tree ($x $lim $n $l)
   (default $lim *max)
   (unless $n
      (zero $n)
      (setq *tree) )
   (when (leq $n $lim)
      (local ($lst)
         (setq $lst)
         ($tree $x) >

<de roots ($x $lim $n $l)
   (default  $lim *max  $n 0)
   (when (leq $n $lim)
      (reptn $n (tab))
      (print $x)
      (unless (memq $x $l)
         (mapc (who $x)
            (lambda ($y)
               (roots $y $lim (add1 $n) (cons $x $l)) >

<de family ($x $f)
   (local ($l)
      (setq $l (filter (oblist) class))
      ($fam1 0 $x $f)
      ($fam2 1 $x $f)
      $x >

<de $fam1 ($n $x $f)
   (mapc (class $x)
      '(($y) ($fam1 (add1 $n) $y $f)) )
   (reptn $n (tab $f))
   (print $x $f) >

<de $fam2 ($n $x $f)
   (mapc $l
      '(($y)
         (when (memq $x (class $y))
            (reptn $n (tab $f))
            (print $y $f)
            ($fam2 (add1 $n) $y $f) >

t [too.l]
