/* pico.h
 * 09apr93abu
 */

#if UNIX
#include <setjmp.h>
#include <math.h>
#define REVBYTE         YES

#elif MPW
#include <SetJmp.h>
#include <Math.h>
pascal void brk(void) = 0xA9FF; /* Debugger() */
#define NULL            0L
#define REVBYTE         NO

#elif MSC
#include <setjmp.h>
#include <math.h>
#define NULL            0L
#define REVBYTE         YES

#endif

#define VERSION         0x213
#define FAIL            0                 /* Termination results */
#define SUCCESS         1
#define YES             -1                /* Boolean values */
#define NO              0

#define ctrl(c)         (c - '@')          /* Control key */
#define ARGMAX          8
#define CELLS           4000
#define BUFSIZE         4096
#define LBSIZE          256                /* Line buffer size */
#define BS              8                  /* Backspace */
#define CR              13                 /* Carriage Return */
#define NL              10                 /* NewLine */
/* #define BREAK           0x7F               /* Break with DEL key */
#define ESCAPE          27                 /* Escape key */
#define EOL             '\n'               /* End of line character */
#define APPLYMAX        32                 /* Max args for SUBR-APPPLY */
#define FILENAME        256                /* Max file name length */
#define MAXNUM          0x1FFFFFFF         /* Max pos. number */
#define MAXNEG          -0x20000000        /* Max neg. number */
#define MAXLIST         1000000            /* Maximum list length */
#define THREADS         256                /* Hash table size */
#define TABLEN          3                  /* Tab char expansion */
#define DYNAMO          ((pico)0x6C464E6E) /* 0x6C464E6E = '-DYN-' */
#define ROUND           0.5
#define ZERO            boxNum(0)
#define ONE             boxNum(1)
#define DASH            27                 /* '-' CharTable index */

typedef short integer;
typedef long number;
typedef int bool;
typedef unsigned char uchar;
typedef unsigned short word;
typedef unsigned short bits16;
typedef unsigned long bits32;
#if UNIX
#define real double
#elif MPW
#define real extended
#elif MSC
#define real double
#endif

typedef struct cell {            /* Pico primary data type */
   struct cell *data;
   struct cell *link;
} cell;

typedef cell *pico;
typedef pico (*fun)();
typedef void *(*fooPtr)();

typedef struct heap {
   struct heap *next;
   struct heap *prev;
   cell cells[CELLS];
} heap;

typedef struct {
   pico threads[THREADS+1];   /* First to relocate */
   pico run;                  /* Last to relocate */
   uchar genSeed[8];
} picoEnv;

typedef struct bindFrame {
	struct bindFrame *link;
	pico self;
	int cnt;
	struct {
		pico sym;
		pico val;
	} bnd[1];
} bindFrame;

typedef struct catchFrame {
   struct catchFrame *link;
   pico tag;
	pico stkPtr;
	bindFrame *bindPtr;
   pico *withPtr;
   jmp_buf env;
} catchFrame;

typedef struct symInit {         /* Symbol initialization */
   uchar *nameInit;
   fooPtr funInit;
} symInit;

typedef struct {
   int fd;
   long pos;
   bool dirty;
   int cnt,max;
   uchar buf[BUFSIZE];
} picoFile;

/* Macros */
#define loop            for (;;)
#define num(x)          ((number)(x))
#define push(x,c)       ((c).data=(x), (c).link=stkPtr, stkPtr=&(c))
#define tos(c)          ((c).data)
#define pop(c)          (stkPtr=(c).link, (c).data)
#define drop(c)         (stkPtr=(c).link)

#define clr(x)          ((pico)(num(x) & ~1L))
#define cellPtr(x)      ((pico)(num(x) & ~7))

#define car(x)          ((x)->data)
#define cdr(x)          ((x)->link)
#define caar(x)         (car(car(x)))
#define cadr(x)         (car(cdr(x)))
#define cdar(x)         (cdr(car(x)))
#define cddr(x)         (cdr(cdr(x)))
#define caaar(x)        (car(car(car(x))))
#define caadr(x)        (car(car(cdr(x))))
#define cadar(x)        (car(cdr(car(x))))
#define caddr(x)        (car(cdr(cdr(x))))
#define cdaar(x)        (cdr(car(car(x))))
#define cdadr(x)        (cdr(car(cdr(x))))
#define cddar(x)        (cdr(cdr(car(x))))
#define cdddr(x)        (cdr(cdr(cdr(x))))
#define tail(x)         (((x)-1)->link)
#define val(x)          ((x)->data)
#define ref(x)          (cdr(val(x)))

#define isNil(x)        ((x) == nilSym)
#define isNum(x)        (num(x)&2)
#define isZero(x)       (num(x)==2)
#define isSym(x)        (num(x)&4)
#define isCell(x)       (!(num(x)&6))

#define EQCELL(x,y)     (car(x)==car(y) && cdr(x)==cdr(y))

#define NEEDNUM(x)      if (!isNum(x)) numberError((pico)x)
#define NEEDSYM(x)      if (isNum(x) || !isSym(x)) symbolError(x)
#define NEEDCELL(x)     if (!isCell(x)) cellError(x)
#define NEEDLIST(x)     if (!isNil(x) && !isCell(x)) listError(x)
#define NEEDSTRING(x)   if (!isNil(x) && !isCell(x)) strError(x)
#define NEEDFUN(x)      if (!funp(x)) funError(x)
#define NEEDDYNAMO(x)   if (!isSym(x) || getPname(x)!=DYNAMO) dynamoError(x)
#define CHECKSYM(x)     if (x>=heaps->cells && x<=tSym) protErr(x)

#define boxNum(n)       ((pico)((num(n) << 2) + 2))
#define unBox(n)        (num(n) >> 2)
#define mkSym(x)        ((pico)(num(x) + 4))
#define mkCell(sym)     ((pico)(num(sym) - 4))
#define newSym(nam,val) (mkSym(newCell(nam,val)))
#define packNum(h,m,l)  (boxNum((num(h) & 1023L)<<20 | (num(m) & 1023L)<<10 | num(l)&1023L))

#if UNIX
#define boxPtr(n)       ((pico)(((n) << 2) + 2))
#define unBoxPtr(n)     ((number)((unsigned long)(n) >> 2))
#define boxSubr(n)      ((pico)(((n) << 2) + 3))
#define unBoxSubr(n)    (num(n) >> 2)
#define evSubr(x,y)     ((*(fun)(unBox(x)))(y))

#elif MPW
#define boxPtr(n)       ((pico)(((n) << 2) + 2))
#define unBoxPtr(n)     ((number)((unsigned long)(n) >> 2))
#define boxSubr(n)      ((pico)(((n) << 2) + 3))
#define unBoxSubr(n)    (num(n) >> 2)
#define evSubr(x,y)     ((*(fun)(unBox(x)))(y))

#elif MSC
pico boxPtr(number);
number unBoxPtr(pico);
pico boxSubr(number);
number unBoxSubr(pico);
pico evSubrX(pico,pico);
#define evSubr(x,y)     (evSubrX(y,x))

#endif

#if REVBYTE
#define markPtr(x)      ((char*)(x))
#else
#define markPtr(x)      ((char*)(x) + 3)
#endif

#define isFree(x)       (*markPtr(x) & 1)

/* Evaluation */
#define EVAL(x)         (isNum(x)? x : (isSym(x)? val(x) : evList(x)))
#define EVAL1(x)        (EVAL(car(x)))

/* Globals */
extern pico applyList, mapCell, mapSym;
extern pico mapCell2, mapSym2, mapCell3, mapSym3, mapCell4, mapSym4;
extern pico nilSym, voidSym, tSym, itSym, quoteSym, shareFlg;
extern pico objectSym, classSym, metaSym;
extern pico dashSym, dash2Sym, dash3Sym, dash4Sym, dash5Sym;
extern pico topSym, fkeySym, againSym, quitSym;
extern pico fileSym, argvSym, loadSym, editSym;
extern pico queueSym, srcFlg, logFlg, printFlg;

extern picoEnv env;

extern heap *heaps;
extern pico avail;
extern pico stkPtr;					/* Stack pointer */
extern bindFrame *bindPtr;			/* Bindings pointer */
extern catchFrame *catchPtr;		/* Catch frame pointer */
extern pico *withPtr;				/* Current with-frame pointer */

extern pico dynamos;					/* Dynamic memory objects */
extern jmp_buf errRst;				/* Error restart longjump */
extern pico loadPos;					/* Start of definition in source file */
extern pico loadName;
extern pico theMessage;				/* Current message */

extern int frzFd;					   /* libStartUp return values */
extern int loadCnt;
extern uchar *fileNames[ARGMAX];

extern uchar lBuff[LBSIZE];		/* Line buffer */
extern uchar *lbp;
extern picoFile *stream;         /* The current input stream */
extern int traceLevel;           /* Trace recursion level */
extern int revaLevel;            /* Nesting level of read-eval-loops */
extern bool fresh;               /* Fresh start or loading freeze file */

extern int MathSP;               /* Math processor stack pointer */

/* Prototypes */
#ifdef __cplusplus
extern "C" {
#endif
number absNumber(number);
void accumulate(int,number*);
pico append(pico,pico);
pico apExpr(pico,int,pico*,pico,pico);
pico apply1(pico,pico);
pico apply2(pico,pico,pico);
pico apply3(pico,pico,pico,pico);
pico apply4(pico,pico,pico,pico,pico);
int ascii(pico);
pico boxBool(bool);
pico boxHiLo(long);
pico boxLong(long);
pico boxReal(real);
pico chkPtr(void*);
int chrIn(void);
uchar *bufString(pico,uchar*,long);
void cBreak(void);
void cellError(pico);
void chrOut(int);
void circError(void);
void closeAll(void);
void closeFile(picoFile*);
number compare(pico,pico);
pico compressName(uchar*);
pico compressString(pico);
pico copy(pico);
pico copy1(pico);
void crlf(void);
void cutPr(pico);
pico doDelete(pico,pico);
void divError(void);
void doError(void);
void doZap(pico);
pico dynamo(pico,pico);
void dynFree(pico);
void dynamoError(pico);
bool equal(pico,pico);
void err(uchar*);
void error(uchar*,uchar*);
void errObj(pico,uchar*);
void errStrObj(pico,uchar*);
pico evalBody(pico);
pico evExpr(pico,pico,pico);
pico evList(pico);
pico evMethod(pico,pico,pico,pico);
void exitPico(bool);
uchar *expShort(number,uchar*);
pico find(pico,bool);
int firstChar(pico);
number fixmul(number,number);
void funError(pico);
bool funp(pico);
pico gensym(pico);
pico get(pico,pico);
void getLine(uchar*, uchar*);
pico getPname(pico);
void giveup(uchar*);
heap *heapAlloc(heap*);
void hexChar(int);
bool hidden(pico);
pico init1Sym(uchar*,bool,pico);
void initApplication(void);
void initAppVars(void);
void initSymbols(void);
void initSymTab(symInit*);
pico intern(pico,bool);
void internErr(uchar*);
bool keyBreak(void);
number length(pico);
void listError(pico);
pico local(pico,pico);
bool match(pico,pico);
number maxNumber(number,number);
bool member(pico,pico);
number minNumber(number,number);
number muldiv(number,number,number);
pico nconc(pico,pico);
pico newCell(pico,pico);
pico newCell2(pico,pico,pico,pico);
bool nextBool(pico*);
void *nextDynamo(pico*);
number nextNum(pico*);
void *nextPtr(pico*);
uchar *nextString(pico*,uchar*,int);
pico nextVar(pico*);
void numberError(pico);
void objError(pico);
pico plist(pico);
void prin0(pico);
void prName(pico);
void prNumber(number);
void prHexNum(unsigned long);
void prompt(int);
void protErr(pico);
void prString(uchar*);
pico put(pico,pico,pico);
pico read0(bool);
void record(pico,pico);
void redefine(pico,pico);
void redefMsg(pico,pico);
void reset(void);
void revalo(pico);
bool sameDef(pico,pico);
void setPlist(pico,pico);
void setStream(picoFile*);
void setFlags(pico,pico);
pico share(pico,pico);
pico shareList(pico);
void space(void);
void stackError(void);
void stopApplication(void);
void strError(pico);
int strLength(pico);
void symbolError(pico);
void tab(void);
pico unBufString(uchar*);
pico unBufCntString(int,uchar*);
bool unFreeze(int);
void unwind(void);
int upc(int);

/* LIB prototypes */
void libStartUp(int,char*[]);
void libError(uchar*);
char *libAlloc(unsigned long);
void libFree(char*);
char *libRealloc(char*,unsigned long);
void libBlock(char*,char*,unsigned long);
long libTick(void);
void libDate(number*,number*,number*);
void libTime(number*,number*,number*);
int libRdOpen(uchar*);
int libWrOpen(uchar*,long);
int libRdWrOpen(uchar*);
int libRead(int,char*,long);
int libWrite(int,char*,long);
bool libSeek(int,long);
long libFPos(int);
long libFSize(int);
bool libClose(int);
pico libDir(uchar*);
void libExit(bool);
bool libLink(uchar*,uchar*);
bool libUnlink(uchar*);
void initConsole(void);
bool initSerial(uchar*);
void initSysSyms(void);
number libSystem(uchar*);
void initSysVars(void);
number rnd32(void);
int serialIn(void);
void serialOut(int);
int serialReady(void);
void ttyOut(int);
bool ttyAvail(void);
int waitTTY(void);
void deLocate(pico*,pico*);
void reLocate(pico*,pico*);

/* SUBR prototypes */
pico Abs(pico);
pico AccByte(pico);
pico AccChar(pico);
pico Access(pico);
pico AccPtr(pico);
pico AccString(pico);
pico AccWord(pico);
pico Add(pico);
pico Add1(pico);
pico Add2(pico);
pico Align(pico);
pico All(pico);
pico Alloc(pico);
pico Amount(pico);
pico And(pico);
pico Append(pico);
pico Apply(pico);
pico Array(pico);
pico Assoc(pico);
pico Ascii(pico);
pico ATom(pico);
pico Backsp(pico);
pico Bell(pico);
pico pBench(pico);
pico Best(pico);
pico Big(pico);
pico BigAdd(pico);
pico BigDiv(pico);
pico BigLeq(pico);
pico BigMul(pico);
pico BigSub(pico);
pico BigSqrt(pico);
pico Bind(pico);
pico pBit(pico);
pico Bitl(pico);
pico Bitr(pico);
pico pBitAnd(pico);
pico pBitNot(pico);
pico pBitOff(pico);
pico pBitOn(pico);
pico pBitOr(pico);
pico pBitXor(pico);
pico Block(pico);
pico Boundp(pico);
pico BreakFun(pico);
pico Car(pico);
pico Cdr(pico);
pico Caar(pico);
pico Cadr(pico);
pico Cdar(pico);
pico Cddr(pico);
pico Caaar(pico);
pico Caadr(pico);
pico Cadar(pico);
pico Caddr(pico);
pico Cdaar(pico);
pico Cdadr(pico);
pico Cddar(pico);
pico Cdddr(pico);
pico Cadddr(pico);
pico Cddddr(pico);
pico Case(pico);
pico Catch(pico);
pico Check(void);
pico Chop(pico);
pico Class(pico);
pico Close(pico);
pico Comment(pico);
pico Cond(pico);
pico Cons(pico);
pico Cons2(pico);
pico Copy(pico);
pico Cos(pico);
pico Creat(pico);
pico Cut(pico);
pico CutPr(pico);
pico Dashp(pico);
pico pDate(void);
pico De(pico);
pico Dec(pico);
pico Default(pico);
pico Define(pico);
pico Delete(pico);
pico Demon(pico);
pico DEpth(pico);
pico Diff(pico);
pico Digit(pico);
pico Dir(pico);
pico Div(pico);
pico Div2(pico);
pico Do(pico);
pico Dump(pico);
pico Dynamo(pico);
pico Enum(pico);
pico Eq(pico);
pico Equal(pico);
pico Erase(pico);
void Error(pico);
pico Eval(pico);
pico Evenp(pico);
pico Filter(pico);
pico Find(pico);
pico Flag(pico);
pico Flagp(pico);
pico Flags(pico);
pico For(pico);
pico Format(pico);
pico Free(pico);
void Freeze(pico);
pico From(pico);
pico FSize(pico);
pico Funp(pico);
pico Gc(pico);
pico Gensym(void);
pico Get(pico);
pico Getc(pico);
pico Getd(pico);
pico GetLine(pico);
pico Has(pico);
pico Hidden(pico);
pico High(pico);
pico HitKey(void);
pico How(pico);
pico If(pico);
pico Inc(pico);
pico Index(pico);
pico Insert(pico);
pico Is(pico);
pico Key(void);
pico Last(pico);
pico Last2(pico);
pico Length(pico);
pico Leq(pico);
pico Lessp(pico);
pico Letter(pico);
pico Limit(pico);
pico Link(pico);
pico List(pico);
pico Listp(pico);
pico Load(pico);
pico Loc(pico);
pico Local(pico);
pico Look(pico);
pico Loop(pico);
pico Low(pico);
pico Lowc(pico);
pico Map(pico);
pico Map2(pico);
pico Mapc(pico);
pico Mapc2(pico);
pico Mapcan(pico);
pico Mapcan2(pico);
pico Mapcar(pico);
pico Mapcar2(pico);
pico Mapcon(pico);
pico Mapcon2(pico);
pico Maplist(pico);
pico Maplist2(pico);
pico Match(pico);
pico Math(pico);
pico Max(pico);
pico May(pico);
pico Member(pico);
pico Memq(pico);
pico Method(pico);
pico Middle(pico);
pico Min(pico);
pico Minus(pico);
pico Minusp(pico);
pico Mod(pico);
pico Mul(pico);
pico Mul2(pico);
pico Muldiv(pico);
pico Nand(pico);
pico Nconc(pico);
pico Nconc1(pico);
pico Neq(pico);
pico Neuro(pico);
pico New(pico);
pico Nextc(pico);
pico Nor(pico);
pico Not(pico);
pico Nth(pico);
pico Nthcdr(pico);
pico Number(pico);
pico Numberp(pico);
pico OBject(pico);
pico Oblist(pico);
pico Oddp(pico);
pico Off(pico);
pico On(pico);
pico One(pico);
pico Onep(pico);
pico Open(pico);
pico Or(pico);
pico Order(pico);
pico Pack(pico);
pico Pairp(pico);
pico Pipe(pico);
pico Plist(pico);
pico Plusp(pico);
pico Pname(pico);
pico Pop(pico);
pico PrHex(pico);
pico Prin1(pico);
pico Prin2(pico);
pico Print(pico);
pico PrLine(pico);
pico ProfFun(pico);
pico Prog1(pico);
pico Prog2(pico);
pico Push(pico);
pico Push1(pico);
pico Put(pico);
pico Putc(pico);
pico Putd(pico);
pico Quit(pico);
pico Quote(pico);
pico pRandom(pico);
pico Raw(pico);
pico Read(pico);
pico Record(pico);
pico Ref(pico);
pico Ref2(pico);
pico Rem(pico);
pico Remob(pico);
pico Remove(pico);
pico fRename(pico);
pico Repeat(pico);
pico Reptn(pico);
pico Revalo(pico);
pico Reverse(pico);
pico Ring(pico);
pico Round(pico);
pico Rplaca(pico);
pico Rplacd(pico);
pico Sect(pico);
pico Seek(pico);
pico Serial(pico);
pico Set(pico);
pico SetFlags(pico);
pico SetPlist(pico);
pico Setq(pico);
pico Shift(pico);
pico Sift(pico);
pico Sign(pico);
pico Sin(pico);
pico pSize(pico);
pico Slot(pico);
pico SlotDash(pico);
pico Solve(pico);
pico Sort(pico);
pico Space(pico);
pico Splay(pico);
pico Split(pico);
pico Square(pico);
pico Sqrt(pico);
pico Store(pico);
pico Stringp(pico);
pico StrLen(pico);
pico Stuff(pico);
pico Sub(pico);
pico Sub1(pico);
pico Sub2(pico);
pico Subst(pico);
pico Super(pico);
pico Swap(pico);
pico Symbol(pico);
pico Symbolp(pico);
pico System(pico);
pico Tab(pico);
pico Tail(pico);
pico Tan(pico);
pico Terpri(pico);
void Throw(pico);
pico pTime(void);
pico To(pico);
pico Toggle(pico);
pico TraceFun(pico);
pico Track(pico);
pico Trail(void);
pico Train(pico);
pico Unify(pico);
pico Unique(pico);
pico Unless(pico);
pico UnPack(pico);
pico Until(pico);
pico Upc(pico);
pico Value(pico);
pico Varp(pico);
pico When(pico);
pico Where(pico);
pico While(pico);
pico Who(pico);
pico Wild(pico);
pico With(pico);
pico Worst(pico);
pico Xchg(pico);
pico Xor(pico);
pico Zero(pico);
pico Zerop(pico);
#ifdef __cplusplus
}
#endif
