/* picoFlow.c
 * 27jan92abu
 */

#pragma segment picoFlow

#include "pico.h"

pico retVal;

pico Quit(x)
pico x;
{
   if (isNil(val(quitSym)) || !isNil(apply1(val(quitSym), EVAL1(x)))) {
   	closeAll();
   	exitPico(SUCCESS);
	}
	return nilSym;
}

pico Eval(x)
register pico x;
{
	cell c1;

   push(x = EVAL1(x), c1);
   x = EVAL(x);
   drop(c1);
   return x;
}

pico Slot(x)
register pico x;
{
	cell c1;

   if (isCell(cdr(x))) {
      push(*withPtr,c1);
      x = put(tos(c1), car(x), EVAL1(cdr(x)));
      drop(c1);
      return x;
   }
   return get(*withPtr, car(x));
}

pico SlotDash(x)
register pico x;
{
   register pico y;
	cell c1;

   y = tail(*withPtr);
   if (isNum(y) || !isCell(y = car(y)))
      errObj(*withPtr,"No Properties");
   if (isCell(cdr(x))) {
      push(cdr(y),c1);
      x = put(tos(c1), car(x), EVAL1(cdr(x)));
      drop(c1);
      return x;
   }
   return get(cdr(y), car(x));
}

pico With(x)
register pico x;
{
   pico *withSave;
	cell c1;

   push(EVAL1(x),c1);
   NEEDSYM(tos(c1));
   withSave = withPtr;
   withPtr = &tos(c1);
   x = evalBody(cdr(x));
   drop(c1);
   withPtr = withSave;
   return x;
}

pico Catch(x)
register pico x;
{
   catchFrame f;

   f.tag = EVAL1(x);
   f.link = catchPtr;
   catchPtr = &f;
   f.stkPtr = stkPtr;
   f.bindPtr = bindPtr;
   f.withPtr = withPtr;
   x  =  (setjmp(f.env)) ?  retVal : evalBody(cdr(x));
   stkPtr = f.stkPtr;
   catchPtr = f.link;
   withPtr = f.withPtr;
   return x;
}

void Throw(x)
register pico x;
{
   register long i;
	cell c1;

	push(EVAL1(x),c1);
	x = cdr(x);
	retVal = EVAL1(x);
	x = pop(c1);
   while (catchPtr) {
      if (x == catchPtr->tag) {
         while (bindPtr != catchPtr->bindPtr) {
            i = bindPtr->cnt;
            while (--i >= 0)
					val(bindPtr->bnd[i].sym) = bindPtr->bnd[i].val;
            bindPtr = bindPtr->link;
         }
         longjmp(catchPtr->env,-1);
      }
      catchPtr = catchPtr->link;
   }
   errObj(x, "Unmatched tag");
}

void Error(x)
register pico x;
{
   uchar buf[256];

   reset();
   prString("Error: ");
   while (isCell(x)) {
      prString(bufString(EVAL1(x), buf, 256L));
      x = cdr(x);
   }
   doError();
}

pico Getd(x)
register pico x;
{
   x = EVAL1(x);
   NEEDSYM(x);
   x = val(x);
   return funp(x)? x:nilSym;
}

pico Putd(x)
register pico x;
{
   register pico sym;
	cell c1;

	push(sym = EVAL1(x), c1);
	x = cdr(x);
	x = EVAL1(x);
	drop(c1);
   NEEDSYM(sym);
   CHECKSYM(sym);
   val(sym) = isNum(x)? (pico)(num(x) | 1) : x;
   return sym;
}

pico De(x)
register pico x;
{
   redefine(car(x),cdr(x));
   return car(x);
}

pico Define(x)
register pico x;
{
   register pico sym1, sym2;

   while (isCell(x)) {
      sym1 = car(x);
      x = cdr(x);
      sym2 = car(x);
      x = cdr(x);
      NEEDSYM(sym2);
      redefine(sym1,val(sym2));
   }
   return tSym;
}

pico If(x)
register pico x;
{
   if (isNil(val(itSym) = EVAL1(x))) {
      x = cdr(cdr(x));
      return EVAL1(x);
   }
   return EVAL1(cdr(x));
}

pico When(x)
register pico x;
{
   register pico y;

   if (isNil(val(itSym) = EVAL1(x)))
      return nilSym;
   x = cdr(x);
   do
      y = EVAL(car(x));
   while (isCell(x = cdr(x)));
   return y;
}

pico Unless(x)
register pico x;
{
   register pico y;

   if (!isNil(EVAL1(x)))
      return nilSym;
   x = cdr(x);
   do
      y = EVAL(car(x));
   while (isCell(x = cdr(x)));
   return y;
}

pico And(x)
register pico x;
{
   register pico y;

   do {
      if (isNil(y = EVAL1(x)))
         break;
   } while (isCell(x = cdr(x)));
   return y;
}

pico Or(x)
register pico x;
{
   register pico y;

   do {
      if (!isNil(y = EVAL1(x)))
         break;
   } while (isCell(x = cdr(x)));
   return y;
}

pico Nand(x)
register pico x;
{
   register pico y;

   do {
      if (isNil(y = EVAL1(x)))
         return tSym;
   } while (isCell(x = cdr(x)));
   return nilSym;
}

pico Nor(x)
register pico x;
{
   register pico y;

   do {
      if (!isNil(y = EVAL1(x)))
         return nilSym;
   } while (isCell(x = cdr(x)));
   return tSym;
}

pico Xor(x)
register pico x;
{
   register bool f;

   f = NO;
   while (isCell(x)) {
      if (!isNil(EVAL1(x))) {
         if (f)
            return nilSym;
         f = YES;
      }
      x = cdr(x);
   }
   return f? tSym : nilSym;
}

pico Not(x)
pico x;
{
   return isNil(EVAL1(x)) ?  tSym : nilSym;
}

pico Cond(x)
register pico x;
{
   do {
      if (!isNil(EVAL1(car(x))))
         return evalBody(cdr(car(x)));
   } while (isCell(x = cdr(x)));
   return nilSym;
}

pico Case(x)
register pico x;
{
   register pico y, z, key;

   key = EVAL1(x);
   x = cdr(x);
   do {
      y = car(x);
      if (isCell(z = car(y))) {
         do {
            if (car(z) == key)
               return evalBody(cdr(y));
         } while (isCell(z = cdr(z)));
      }
      else if (z == tSym  ||  z == key)
         return evalBody(cdr(y));
   } while (isCell(x = cdr(x)));
   return nilSym;
}

pico Loop(x)
pico x;
{
   register pico body, clause;

   loop {
      body = x;
      do {
         clause = car(body);
         if (car(clause) == tSym) {
            clause = cdr(clause);
            if (!isNil(EVAL1(clause)))
               return evalBody(cdr(clause));
         }
         else if (car(clause) == nilSym) {
            clause = cdr(clause);
            if (isNil(EVAL1(clause)))
               return evalBody(cdr(clause));
         }
         else
            EVAL(clause);
      } while (isCell(body = cdr(body)));
   }
}

pico For(x)
register pico x;
{
   register pico sym, cond, body;
   bindFrame f;
	cell c1,c2;

   body = cdr(x);
   x = car(x);
   NEEDCELL(x);
   sym = car(x);
   x = cdr(x);
   NEEDSYM(sym);
   CHECKSYM(sym);
   f.bnd[0].sym = sym;
   f.bnd[0].val = val(sym);
   val(sym) = EVAL1(x);
   x = cdr(x);
   f.link = bindPtr;
   bindPtr = &f;
   f.self = NULL;
   f.cnt = 1;
   push(nilSym,c1);
   push(cond = EVAL1(x),c2);
   x = car(cdr(x));
   while (!equal(val(sym),EVAL(cond))) {
      tos(c1) = evalBody(body);
      val(sym) = isNil(x)? (pico)(num(val(sym))+4) : EVAL(x);
   }
   val(sym) = f.bnd[0].val;
   bindPtr = f.link;
   return pop(c1);
}

pico While(x)
register pico x;
{
   register pico cond;
	cell c1;

   cond = car(x);
   x = cdr(x);
	push(nilSym,c1);
   while (!isNil(val(itSym) = EVAL(cond)))
      tos(c1) = evalBody(x);
   return pop(c1);
}

pico Until(x)
register pico x;
{
   register pico cond;
	cell c1;

   cond = car(x);
   x = cdr(x);
   push(nilSym,c1);
   while (isNil(val(itSym) = EVAL(cond)))
      tos(c1) = evalBody(x);
   return pop(c1);
}

pico Repeat(x)
register pico x;
{
   register pico y;

   do
      y = evalBody(x);
   while (isNil(y));
   return y;
}

pico Reptn(x)
register pico x;
{
   register number count;
   register pico y;

   count = num(EVAL1(x));
   NEEDNUM(count);
   count = unBox(count);
   x = cdr(x);
   while (count > 0) {
      y = evalBody(x);
      --count;
   }
   return y;
}

pico Bind(x)
register pico x;
{
	return local(EVAL1(x), cdr(x));
}

pico Local(x)
pico x;
{
	return local(car(x), cdr(x));
}

pico Prog1(x)
register pico x;
{
	cell c1;

   push(EVAL1(x),c1);
   evalBody(cdr(x));
   return pop(c1);
}

pico Prog2(x)
register pico x;
{
	cell c1;

   EVAL1(x);
   x = cdr(x);
   push(EVAL1(x),c1);
   evalBody(cdr(x));
   return pop(c1);
}
