/* picoObj.c
 * 06nov92abu
 */

#pragma segment picoObj

#include "pico.h"

/* Prototypes */
static void badMessage(pico);
static pico getClass(void);
static pico method(pico);

static pico getClass()
{
   register pico cl;

   cl = val(classSym);
   if (isNum(cl) || !isSym(cl) || cl<=tSym)
      errObj(cl,"Bad *CLASS");
   return cl;
}

/* Define object */
pico OBject(x)
register pico x;
{
   register pico y,sym;
	cell c1;

   sym = car(x);
   NEEDSYM(sym);
   CHECKSYM(sym);
   if (!isCell(x = cdr(x)))
      x = objectSym;
   else {
      push(y = newCell(car(x),objectSym), c1);
      while (isCell(x = cdr(x))) {
         cdr(y) = newCell(car(x),objectSym);
         y = cdr(y);
      }
      x = pop(c1);
   }
   if ((y = val(sym)) == voidSym)
      val(sym) = x;
   else {
      while (isCell(y) && isCell(car(y)))
         y = cdr(y);
      if (!sameDef(x,y)) {
         redefMsg(sym,NULL);
         val(sym) = x;
      }
   }
   record(sym,srcFlg);
   return val(classSym) = sym;
}

/* Define method for current class */
pico To(x)
register pico x;
{
   register pico y,mth,cl;

   mth = car(x);
   x = cdr(x);
   cl = car(x);
   if (isNil(cl) || isCell(cl))
      cl = getClass();
   else
      x = cdr(x);
   y = val(cl);
   while (isCell(y)) {
      if (car(car(y)) == mth) {
         y = car(y);
         if (!sameDef(cdr(y),x))
            redefMsg(mth,cl);
         cdr(y) = x;
         goto done;
      }
      y = cdr(y);
   }
   val(cl) = newCell(newCell(mth,x), val(cl));
done:
   record(cl,mth);
   return mth;
}

/* Find method in object or its classes */
static pico method(x)
register pico x;
{
   register pico y;

   x = val(x);
   while (isCell(y = car(x))) {
      if (car(y) == theMessage)
         return cdr(y);
      x = cdr(x);
   }
   while (isCell(x)) {
      if (y = method(car(x)))
         return y;
      x = cdr(x);
   }
   return NULL;
}

pico Method(x)
register pico x;
{
	cell c1;

   push(EVAL1(x),c1);  /* Message */
   x = cdr(x);
   x = EVAL1(x);       /* Object */
   theMessage = pop(c1);
   return (x = method(x))? x : nilSym;
}

static void badMessage(obj)
pico obj;
{
   reset();
   prin0(theMessage);
   prString(": Bad message to ");
   prin0(obj);
   doError();
}

/* Find and execute method in object or its classes */
pico Do(x)
register pico x;
{
   register pico y,obj;
	pico msg;

   msg = car(x);      /* Message */
   x = cdr(x);
   obj = EVAL1(x);    /* Object */
   theMessage = msg;
   if (y = method(obj))
      return evMethod(y,cdr(x),msg,obj);
   badMessage(obj);
}

pico All(x)
register pico x;
{
   register pico y,obj,msg;
	cell c1;

   msg = car(x);      /* Message */
   x = cdr(x);
   push(EVAL1(x),c1); /* Object list */
   x = cdr(x);
   y = nilSym;
   while (isCell(tos(c1))) {
      theMessage = msg;
      if (!(y = method(obj = car(tos(c1)))))
         badMessage(obj);
      y = evMethod(y,x,msg,obj);
      tos(c1) = cdr(tos(c1));
   }
   drop(c1);
   return y;
}

pico May(x)
register pico x;
{
   register pico y,obj,msg;

   msg = car(x);      /* Message */
   x = cdr(x);
   obj = EVAL1(x);    /* Object */
   theMessage = msg;
   if (y = method(obj))
      return evMethod(y,cdr(x),msg,obj);
   return nilSym;
}

/* Inherit method from another class */
pico From(x)
register pico x;
{
   register pico y,obj;

   obj = car(x);         /* Class */
   x = cdr(x);
   theMessage = car(x);   /* Message */
   if (y = method(obj))
      return evExpr(y,cdr(x),theMessage);
   errObj(theMessage,"Can't inherit");
}

pico Super(x)
register pico x;
{
   register pico y,z,obj,msg;

   msg = car(x);      /* Message */
   x = cdr(x);
   obj = EVAL1(x);    /* Object */
   theMessage = msg;
   z = val(obj);
   while (isCell(car(z)))
      z = cdr(z);
   while (isCell(z)) {
      if (y = method(car(z)))
         return evMethod(y,cdr(x),msg,obj);
      z = cdr(z);
   }
   return nilSym;
}

/* Create object */
pico New(x)
register pico x;
{
   register pico y,z;
	cell c1,c2;

   push(y = EVAL1(x),c1);    /* Class(es) */
   if (!isCell(y))
      y = newCell(y,objectSym);
   else {
      push(z = newCell(car(y),objectSym), c2);
      while (isCell(y = cdr(y))) {
         cdr(z) = newCell(car(y),objectSym);
         z = cdr(z);
      }
      y = pop(c2);
   }
   push(z = gensym(y), c2);
   theMessage = tSym;
   if (y = method(z))
      evMethod(y,cdr(x),tSym,z);
   drop(c1);
   return z;
}

/* Return object's classes */
pico Class(x)
register pico x;
{
   register pico y;

   x = EVAL1(x);
   NEEDSYM(x);
   x = val(x);
   while (isCell(x) && isCell(car(x)))
      x = cdr(x);
   y = x;
   while (isCell(y))
      y = cdr(y);
   return (y == objectSym)? x : nilSym;
}

/* Define a Demon */
pico Demon(x)
register pico x;
{
   register pico msg,obj;
	cell c1;

   msg = car(x);             /* Message */
   x = cdr(x);
   push(obj = EVAL1(x), c1); /* Object */
   NEEDSYM(obj);
   x = cdr(x);
   x = EVAL1(x); /* Demon code */
   x = newCell(msg,x);
   val(obj) = newCell(x,val(obj));
   drop(c1);
   return msg;
}
