/* picoPred.c
 * 16dec92abu
 */

#pragma segment picoPred

#include "pico.h"

static bool wild(pico,pico);

static long wildLen;
static bool wildFlg;

pico Stringp(x)
register pico x;
{
   x = EVAL1(x);
   if (isNum(x) || isSym(x) && !isNil(x))
      return nilSym;
   while (isCell(x)) {
      if (!isNum(car(x)))
         return nilSym;
      x = cdr(x);
   }
   return isNil(x)? tSym:nilSym;
}

static bool wild(p,d)
register pico p,d;
{
   long n;

   loop {
      if (!isCell(p) && !isCell(d))
         return YES;
      if (!isCell(p))
         return wildFlg;
      if (!isCell(d))
         return car(p) == boxNum('*') && !isCell(cdr(p));
      if (!(car(p)==car(d) || car(p)==boxNum('?'))) {
         if (car(p) != boxNum('*'))
            return NO;
         if (!isCell(cdr(p))) {
            wildLen += length(d);
            return YES;
         }
         n = wildLen;
         if (wild(cdr(p),d))
            return YES;
         wildLen = n + 1;
         return wild(p,cdr(d));
      }
      p = cdr(p);
      d = cdr(d);
      ++wildLen;
   }
}

pico Wild(x)
register pico x;
{
	cell c1,c2;

   push(EVAL1(x),c1); /* Pattern */
   x = cdr(x);
   push(EVAL1(x),c2); /* Data */
   wildLen = 0;
   wildFlg  =  EVAL1(cdr(x)) != nilSym;
   x = wild(tos(c1),tos(c2))? boxNum(wildLen) : nilSym;
   drop(c1);
   return x;
}

pico Member(x)
register pico x;
{
   register pico y;
   register number count;
	cell c1;

   push(EVAL1(x),c1);
	x = cdr(x);
	y = EVAL1(x);
	x = pop(c1);
   count = MAXLIST;
   while (isCell(y)) {
      if (equal(x,car(y)))
         return y;
      if (--count < 0)
         circError();
      y = cdr(y);
   }
   return nilSym;
}

pico Memq(x)
register pico x;
{
   register pico y;
   register number count;
	cell c1;

   push(EVAL1(x),c1);
	x = cdr(x);
	y = EVAL1(x);
	x = pop(c1);
   count = MAXLIST;
   while (isCell(y)) {
      if (x == car(y))
         return y;
      if (--count < 0)
         circError();
      y = cdr(y);
   }
   return nilSym;
}

pico Eq(x)
register pico x;
{
	cell c1;

   push(EVAL1(x),c1);
   while (isCell(x = cdr(x)))
      if (tos(c1) != EVAL1(x)) {
         drop(c1);
         return nilSym;
      }
   drop(c1);
   return tSym;
}

pico Neq(x)
register pico x;
{
	cell c1;

   push(EVAL1(x),c1);
   while (isCell(x = cdr(x)))
      if (tos(c1) != EVAL1(x)) {
         drop(c1);
         return tSym;
      }
   drop(c1);
   return nilSym;
}

pico Equal(x)
register pico x;
{
	cell c1;

   push(EVAL1(x),c1);
   while (isCell(x = cdr(x)))
      if (!equal(tos(c1),EVAL1(x))) {
         drop(c1);
         return nilSym;
      }
   drop(c1);
   return tSym;
}

pico ATom(x)
pico x;
{
   return isCell(EVAL1(x))? nilSym:tSym;
}

pico Pairp(x)
pico x;
{
   return isCell(EVAL1(x))? tSym:nilSym;
}

pico Listp(x)
register pico x;
{
   return isCell(x = EVAL1(x)) || isNil(x) ?  tSym : nilSym;
}

pico Numberp(x)
pico x;
{
   return isNum(EVAL1(x))? tSym:nilSym;
}

pico Symbolp(x)
register pico x;
{
   return (isNum(x=EVAL1(x)) || !isSym(x))? nilSym:tSym;
}

bool funp(x)
register pico x;
{
   register pico y;
   register number n;

   if (isNum(x))
      return (bool)(num(x) & 1);
   if (isSym(x))
      return NO;
   x = car(x);
   n = MAXLIST;
   while (isCell(x)) {
      if (isNum(y = car(x)) || isCell(y) || y<=tSym)
         return NO;
      if (--n < 0)
         circError();
      x = cdr(x);
   }
   return isNil(x) || !isNum(x) && x>tSym;
}

pico Funp(x)
register pico x;
{
   x = EVAL1(x);
   return funp(x)? tSym:nilSym;
}

pico Hidden(x)
register pico x;
{
   if (isNum(x = EVAL1(x)) || !isSym(x))
      return nilSym;
   return hidden(x)?  tSym : nilSym;
}

pico Varp(x)
register pico x;
{
   if (isNum(x = EVAL1(x)) || !isSym(x))
      return nilSym;
   return (firstChar(x) <= DASH) ?  tSym : nilSym;
}

pico Dashp(x)
register pico x;
{
   if (isNum(x = EVAL1(x)) || !isSym(x))
      return nilSym;
   return (firstChar(x) == DASH) ?  tSym : nilSym;
}

pico Boundp(x)
register pico x;
{
   x = EVAL1(x);
   NEEDSYM(x);
   return  val(x)==voidSym?  nilSym : tSym;
}

pico Zerop(x)
register pico x;
{
   return (isNum(x=EVAL1(x)) && isZero(x))? tSym:nilSym;
}

pico Onep(x)
register pico x;
{
   return (isNum(x=EVAL1(x)) && x==boxNum(1))? tSym:nilSym;
}

pico Minusp(x)
register pico x;
{
   return (isNum(x=EVAL1(x)) && unBox(x)<0)? tSym:nilSym;
}

pico Plusp(x)
register pico x;
{
   return (isNum(x=EVAL1(x)) && unBox(x)>0)? tSym:nilSym;
}

pico Evenp(x)
register pico x;
{
   return (isNum(x=EVAL1(x)) && num(x) & 4)? nilSym:tSym;
}

pico Oddp(x)
register pico x;
{
   return (isNum(x=EVAL1(x)) && num(x) & 4)? tSym:nilSym;
}

pico Lessp(x)
register pico x;
{
   register number n;
   register pico y;

   y = EVAL1(x);
   NEEDNUM(y);
   while (isCell(x = cdr(x))) {
      n = num(y);
      y = EVAL1(x);
      NEEDNUM(y);
      if (num(y) <= n)
         return nilSym;
   }
   return tSym;
}

pico Leq(x)
register pico x;
{
   register number n;
   register pico y;

   y = EVAL1(x);
   NEEDNUM(y);
   while (isCell(x = cdr(x))) {
      n = num(y);
      y = EVAL1(x);
      NEEDNUM(y);
      if (num(y) < n)
         return nilSym;
   }
   return tSym;
}

pico Order(x)
register pico x;
{
	cell c1,c2,c3;

	push(EVAL1(x),c1); /* Item 1 */
	x = cdr(x);
	push(EVAL1(x),c2); /* Item 2 */
	x = cdr(x);
	push(x=EVAL1(x),c3); /* Foo */
	if (isNil(x)) {
		drop(c1);
		return boxNum(compare(tos(c1),tos(c2)));
	}
	x = boxNum(compare(apply1(x,tos(c1)), apply1(x,tos(c2))));
	drop(c1);
	return x;
}
