/* picoSubr.c
 * 11apr93abu
 */

#pragma segment picoSubr

#include "pico.h"

/* Prototypes */
static pico array(pico,number,pico);
static number depth(pico);
static pico mSort(pico,number,pico);
/* static void splay(pico); */
static number mkSize(pico);

pico Quote(x)
pico x;
{
   return x;
}

pico Align(x)
register pico x;
{
   register number n;
	cell c1;

   push(EVAL1(x),c1);
   NEEDSTRING(tos(c1));
   x = cdr(x);
   x = EVAL1(x);
   NEEDNUM(x);
   n = unBox(x) - strLength(tos(c1));
   if (n > 0) {
      if (isNum(x = car(tos(c1)))  &&  unBox(x) < 0)
         tos(c1) = newCell(boxNum(unBox(x) - n), cdr(tos(c1)));
      else
         tos(c1) = newCell(boxNum(-n), tos(c1));
   }
   return pop(c1);
}

static pico mSort(l,n,foo)
register pico l;
register number n;
pico foo;
{
   register pico l1,l2;
   register number m;
	cell c1,c2,c3;

   if (n == 1)
      return newCell(car(l),nilSym);
   m = n/2;
   n -= m;
   push(mSort(l,m,foo), c1);
   do
      l = cdr(l);
   while (--m);
   push(l2 = mSort(l,n,foo), c2);
   l1 = tos(c1);
   if ((isNil(foo)?
         compare(car(l1),car(l2)) :
         compare(apply1(foo,car(l1)), apply1(foo,car(l2))) )
         >= 0 ) {
      push(l = l1, c3);
      l1 = cdr(l1);
   }
   else {
      push(l = l2, c3);
      l2 = cdr(l2);
   }
   while (isCell(l1) && isCell(l2)) {
      if ((isNil(foo)?
            compare(car(l1),car(l2)) :
            compare(apply1(foo,car(l1)), apply1(foo,car(l2))) )
            >= 0 ) {
         cdr(l) = l1;
         l1 = cdr(l1);
      }
      else {
         cdr(l) = l2;
         l2 = cdr(l2);
      }
      l = cdr(l);
   }
   cdr(l) = isCell(l1)? l1:l2;
   drop(c1);
   return tos(c3);
}

pico Sort(x)
register pico x;
{
	cell c1,c2;

   push(EVAL1(x),c1);
   x = cdr(x);
   push(EVAL1(x),c2);
   if (isCell(x = tos(c1)))
      x = mSort(x,length(x),tos(c2));
   drop(c1);
   return x;
}

/* D.Sleator: DDJ Apr93:10 */
pico Splay(x)
register pico x;
{
	pico l,r;
	number n;
	cell t,k,f,v,c;

   push(EVAL1(x),t); /* Splay tree */
   x = cdr(x);
   push(EVAL1(x),k); /* Key */
   x = cdr(x);
   push(EVAL1(x),f); /* Foo */
	v.data = nilSym;
	v.link = nilSym;
	push(l = r = &v, c);

	while (n = compare(tos(k), isNil(tos(f))? car(tos(t)):apply1(tos(f),car(tos(t))))) {
		if (n > 0) {
			if (!isNil(cadr(tos(t)))  &&
						compare(tos(k), isNil(tos(f))? caadr(tos(t)):apply1(tos(f),caadr(tos(t)))) > 0) {
				x = cadr(tos(t));
				cadr(tos(t)) = cddr(x);
				cddr(x) = tos(t);
				tos(t) = x;
			}
			if (isNil(cadr(tos(t))))
				break;
			car(r) = tos(t),  r = cdr(tos(t)),  tos(t) = cadr(tos(t));
		}
		else {
			if (!isNil(cddr(tos(t)))  &&
						compare(tos(k), isNil(tos(f))? caddr(tos(t)):apply1(tos(f),caddr(tos(t)))) < 0) {
				x = cddr(tos(t));
				cddr(tos(t)) = cadr(x);
				cadr(x) = tos(t);
				tos(t) = x;
			}
			if (isNil(cddr(tos(t))))
				break;
			cdr(l) = tos(t),  l = cdr(tos(t)),  tos(t) = cddr(tos(t));
		}
	}
	cdr(l) = cadr(tos(t));
	car(r) = cddr(tos(t));
	cadr(tos(t)) = cdr(&v);
	cddr(tos(t)) = car(&v);
	drop(t);
	return tos(t);
}

pico Copy(x)
register pico x;
{
	cell c1;

   push(EVAL1(x), c1);
   x = copy(tos(c1));
   drop(c1);
   return x;
}

pico Diff(x)
register pico x;
{
   register pico y;
	cell c1,c2;

   push(EVAL1(x),c1);
   x = cdr(x);
   push(x = EVAL1(x), c2);
   y = nilSym;
   while (isCell(x)) {
      if (!member(car(x),tos(c1)))
         y = newCell(car(x),y);
      x = cdr(x);
   }
   x = tos(c1);
   while (isCell(x)) {
      if (!member(car(x),tos(c2)))
         y = newCell(car(x),y);
      x = cdr(x);
   }
   drop(c1);
   return y;
}

pico Sect(x)
register pico x;
{
   register pico y;
	cell c1,c2;

   push(EVAL1(x),c1);
   x = cdr(x);
   push(x = EVAL1(x), c2);
   y = nilSym;
   while (isCell(x)) {
      if (member(car(x),tos(c1)))
         y = newCell(car(x),y);
      x = cdr(x);
   }
   drop(c1);
   return y;
}

pico Unique(x)
register pico x;
{
   register pico y,z;
	cell c1;

   z = nilSym;
   while (isCell(x)) {
      push(y = EVAL1(x), c1);
      while (isCell(y)) {
         if (!member(car(y),z))
            z = newCell(car(y),z);
         y = cdr(y);
      }
      drop(c1);
      x = cdr(x);
   }
   return z;
}

pico Assoc(x)
register pico x;
{
   register pico y, z;
	cell c1;

	push(EVAL1(x), c1);
	x = cdr(x);
	y = EVAL1(x);
	x = pop(c1);
   while (isCell(y)) {
      if (isCell(z = car(y)) && equal(x, car(z)))
         return z;
      y = cdr(y);
   }
   return nilSym;
}

pico Append(x)
register pico x;
{
   register pico y;
	cell c1;

   push(EVAL1(x),c1);
   x = cdr(x);
   y = EVAL1(x);
   y = append(pop(c1),y);
   while (isCell(x = cdr(x))) {
      push(y,c1);
      y = EVAL1(x);
      y = append(pop(c1),y);
   }
   return y;
}

pico Reverse(x)
register pico x;
{
   register pico y;
	cell c1;

   push(x = EVAL1(x), c1);
   y = nilSym;
   while (isCell(x)) {
      y = newCell(car(x),y);
      x = cdr(x);
   }
   drop(c1);
   return y;
}

pico Insert(x)
register pico x;
{
   number n;
   register pico y;
	cell c1,c2,c3;

   push(EVAL1(x),c1);
   x = cdr(x);
   n = num(EVAL1(x));
   NEEDNUM(n);
   n = unBox(n);
   x = EVAL1(cdr(x));
   if (--n < 0  ||  !isCell(x))
      return newCell(pop(c1),x);
   push(x,c2);
   push(y = newCell(car(x),nilSym), c3);
   while (x = cdr(x), --n >= 0  &&  isCell(x)) {
      cdr(y) = newCell(car(x),nilSym);
      y = cdr(y);
   }
   cdr(y) = newCell(tos(c1),x);
   drop(c1);
   return tos(c3);
}

pico Delete(x)
register pico x;
{
	cell c1;

   push(EVAL1(x),c1);
   x = EVAL1(cdr(x));
   return doDelete(pop(c1),x);
}

pico Cut(x)
register pico x;
{
   register pico y, z;

   y = EVAL1(x);
   z = car(cdr(x));
   NEEDSYM(z);
   CHECKSYM(z);
   if (isCell(x = val(z))) {
      if (equal(y, car(x))) {
         val(z) = cdr(x);
         return tSym;
      }
      else {
         while (z = x, isCell(x = cdr(x))) {
            if (equal(y, car(x))) {
               cdr(z) = cdr(x);
               return tSym;
            }
         }
      }
   }
   return nilSym;
}

pico Nconc(x)
register pico x;
{
	cell c1;

   push(EVAL1(x),c1);
   while (isCell(x = cdr(x)))
      tos(c1) = nconc(tos(c1),EVAL1(x));
   return pop(c1);
}

pico Nconc1(x)
register pico x;
{
	cell c1;

   push(EVAL1(x),c1);
   x = newCell(EVAL1(cdr(x)),nilSym);
   return nconc(pop(c1),x);
}

pico Ring(x)
register pico x;
{
   x = EVAL1(x);
   return nconc(x,x);
}

pico Rplaca(x)
register pico x;
{
	cell c1;

   push(EVAL1(x),c1);
   NEEDCELL(tos(c1));
   car(tos(c1)) = EVAL1(cdr(x));
   return pop(c1);
}

pico Rplacd(x)
register pico x;
{
	cell c1;

   push(EVAL1(x),c1);
   NEEDCELL(tos(c1));
   cdr(tos(c1)) = EVAL1(cdr(x));
   return pop(c1);
}

pico Cons(x)
register pico x;
{
	cell c1;

   push(EVAL1(x),c1);
   x = EVAL1(cdr(x));
   return newCell(pop(c1),x);
}

pico Cons2(x)
register pico x;
{
   pico y;
	cell c1,c2;

   push(EVAL1(x),c1);
   x = cdr(x);
   y = EVAL1(x);
   tos(c1) = newCell(tos(c1),y);
   x = cdr(x);
   push(EVAL1(x),c2);
   x = EVAL1(cdr(x));
   y = newCell(pop(c2),x);
   return newCell(pop(c1),y);
}

pico List(x)
register pico x;
{
   register pico y;
	cell c1;

   if (!isCell(x))
      return nilSym;
   push(y = newCell(EVAL1(x),nilSym), c1);
   while (isCell(x = cdr(x))) {
      cdr(y) = newCell(EVAL1(x),nilSym);
      y = cdr(y);
   }
   return pop(c1);
}

pico Sift(x)
register pico x;
{
   register pico y,z;
	cell c1;

   loop {
      if (!isCell(x))
         return nilSym;
      if (!isNil(y = EVAL1(x)))
         break;
      x = cdr(x);
   }
   push(z = newCell(y,nilSym), c1);
   while (isCell(x = cdr(x))) {
      if (!isNil(y = EVAL1(x))) {
         cdr(z) = newCell(y,nilSym);
         z = cdr(z);
      }
   }
   return pop(c1);
}

static pico array(init,n,x)
pico init;
register number n;
register pico x;
{
   register number m;
	cell c1;

   NEEDNUM(n);
   n = unBox(n);
   push(nilSym,c1);
   if (isCell(x)) {
      m = (number)EVAL1(x);
      while (--n >= 0)
         tos(c1) = newCell(array(init,m,cdr(x)),tos(c1));
   }
   else
      while (--n >= 0)
         tos(c1) = newCell(init,tos(c1));
   return pop(c1);
}

pico Array(x)
register pico x;
{
	cell c1;

   push(EVAL1(x),c1); /* Initial value */
   x = cdr(x);
   x = array(tos(c1), (number)EVAL1(x), cdr(x));
   drop(c1);
   return x;
}

pico Car(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return car(x);
}

pico Cdr(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return cdr(x);
}

pico Caar(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return car(car(x));
}

pico Cadr(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return car(cdr(x));
}

pico Cdar(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return cdr(car(x));
}

pico Cddr(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return cdr(cdr(x));
}

pico Caaar(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return car(car(car(x)));
}

pico Caadr(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return car(car(cdr(x)));
}

pico Cadar(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return car(cdr(car(x)));
}

pico Caddr(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return car(cdr(cdr(x)));
}

pico Cdaar(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return cdr(car(car(x)));
}

pico Cdadr(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return cdr(car(cdr(x)));
}

pico Cddar(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return cdr(cdr(car(x)));
}

pico Cdddr(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return cdr(cdr(cdr(x)));
}

pico Cadddr(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return car(cdr(cdr(cdr(x))));
}

pico Cddddr(x)
register pico x;
{
   x = EVAL1(x);
   NEEDLIST(x);
   return cdr(cdr(cdr(cdr(x))));
}

pico Nthcdr(x)
register pico x;
{
   register number n;

   n = num(EVAL1(x));
   NEEDNUM(n);
   n = unBox(n);
   if (isCell(x = EVAL1(cdr(x))))
      while (--n >= 0)
         x = cdr(x);
   return x;
}

pico Nth(x)
register pico x;
{
   register number n;

   n = num(EVAL1(x));
   NEEDNUM(n);
   n = unBox(n);
   if (isCell(x = EVAL1(cdr(x))))
      while (--n >= 0)
         x = cdr(x);
   return car(x);
}

pico Index(x)
register pico x;
{
   register pico y;
   register number n;
	cell c1;

   push(EVAL1(x),c1);
   x = cdr(x);
   x = EVAL1(x);
   n = 0;
   y = pop(c1);
   while (isCell(x)) {
      if (equal(y,car(x)))
         return boxNum(n);
      ++n;
      x = cdr(x);
   }
   return nilSym;
}

pico Tail(x)
register pico x;
{
   register pico y;

   x = EVAL1(x);
   if (!isCell(x))
      return nilSym;
   do
      y = x;
   while (isCell(x = cdr(x)));
   return y;
}

pico Last(x)
register pico x;
{
   register pico y;

   x = EVAL1(x);
   if (!isCell(x))
      return nilSym;
   do
      y = x;
   while (isCell(x = cdr(x)));
   return car(y);
}

pico Last2(x)
register pico x;
{
   register pico y;

   x = EVAL1(x);
   if (!isCell(x) || !isCell(cdr(x)))
      return nilSym;
   do
      y = x;
   while (isCell(cdr(x = cdr(x))));
   return car(y);
}

pico Access(x)
register pico x;
{
   register pico y;
   register number n;
	cell c1;

   push(y = EVAL1(x), c1);
   do {
      NEEDCELL(y);
      x = cdr(x);
      n = num(EVAL1(x));
      NEEDNUM(n);
      n = unBox(n);
      while (--n >= 0)
         y = cdr(y);
      y = car(y);
   } while (isCell(cdr(x)));
   drop(c1);
   return y;
}

pico Store(x)
register pico x;
{
   register pico y;
   register number n;
	cell c1,c2;

   push(EVAL1(x),c1);
   x = cdr(x);
   push(y = EVAL1(x), c2);
   loop {
      x = cdr(x);
      n = num(EVAL1(x));
      NEEDNUM(n);
      n = unBox(n);
      while (--n >= 0)
         y = cdr(y);
      if (!isCell(cdr(x)))
         break;
      y = car(y);
   }
   NEEDCELL(y);
   return car(y) = pop(c1);
}

pico Subst(x)
register pico x;
{
   register pico y;
	cell c1,c2;

   push(EVAL1(x),c1);      /* New item */
   x = cdr(x);
   push(y = EVAL1(x), c2); /* Old item */
   x = cdr(x);
   x = EVAL1(x);
   while (isCell(x)) {
      if (equal(y, car(x)))
         return car(x) = pop(c1);
      x = cdr(x);
   }
   drop(c1);
   return nilSym;
}

pico Swap(x)
register pico x;
{
   register pico y, z;
   register number i,j,tmp;

   i = num(EVAL1(x));
   NEEDNUM(i);
   i = unBox(i);
   x = cdr(x);
   j = num(EVAL1(x));
   NEEDNUM(j);
   j = unBox(j);
   if (j < i)
      tmp=i, i=j, j=tmp;
   j -= i;
   z = x = EVAL1(cdr(x));
   NEEDCELL(x);
   while (--i >= 0)
      x = cdr(x);
   if (isCell(x)) {
      y = x;
      while (--j >= 0)
         x = cdr(x);
      if (isCell(x)) {
         tmp = num(car(x));
         car(x) = car(y);
         car(y) = (pico)tmp;
      }
   }
   return z;
}

pico Length(x)
register pico x;
{
   register number n;

   x = EVAL1(x);
   n = 0;
   while (isCell(x)) {
      if (++n > MAXLIST)
         circError();
      x = cdr(x);
   }
   return boxNum(n);
}

pico StrLen(x)
pico x;
{
   return boxNum(strLength(EVAL1(x)));
}

static number depth(x)
register pico x;
{
   if (isNil(x))
      return 1;
   if (!isCell(x))
      return 0;
   return maxNumber(depth(car(x))+1, depth(cdr(x)));
}

pico DEpth(x)
pico x;
{
   return boxNum(depth(EVAL1(x)));
}

static number mkSize(x)
register pico x;
{
   if (!isCell(x))
      return 0;
   return mkSize(car(x)) + mkSize(cdr(x)) + 1;
}

pico pSize(x)
pico x;
{
   return boxNum(mkSize(EVAL1(x)));
}
