/* picoSyst.c
 * 12jan93abu
 */

#pragma segment picoSyst

#include "pico.h"

/* Prototypes */
static void doBs(void);
static void echoChar(int);
static bool fKey(int);
static int readKey(void);


void exitPico(flg)
bool flg;
{
   stopApplication();
   libExit(flg);
}

pico System(x)
register pico x;
{
   uchar buf[1024];

   bufString(EVAL1(x),buf,1024L);
   return boxNum(libSystem(buf));
}

pico Check()
{
   return keyBreak()? tSym : nilSym;
}

pico Dir(x)
register pico x;
{
   uchar fName[FILENAME];

   bufString(EVAL1(x), fName, (long)FILENAME);
	return libDir(fName);
}

pico pDate()
{
	number y,m,d;

   libDate(&y,&m,&d);
   return packNum(y, m, d);
}

pico pTime()
{
	number h,m,s;

   libTime(&h,&m,&s);
   return packNum(h, m, s);
}

pico pBench(x)
register pico x;
{
   register long n;
   picoFile *sSave;

   n = libTick();
   x = evalBody(x);
   n = libTick() - n;
   sSave = stream;
   setStream(NULL);
   prNumber(n), prString(" ticks [");
   n /= 6;
   prNumber(n/10), chrOut('.'), prNumber(n%10), prString(" sec]\n");
   stream = sSave;
   return x;
}

pico AccString(x)
register pico x;
{
   uchar *p;
   register int c;
   pico y;

   p = (uchar*)EVAL1(x);
   NEEDNUM(p);
   p = (uchar*)unBoxPtr((pico)p);
   if (isNil(x = EVAL1(cdr(x))))
      return unBufString(p);
   y = x;
   while (isCell(x)) {
      c = (int)unBox(car(x));
      if (c >= 0)
         *p++ = (uchar)c;
      else do {
         *p++ = ' ';
      } while (++c);
      x = cdr(x);
   }
   *p = 0;
   return y;
}

pico Alloc(x)
pico x;
{
   register char c, *p, *q;
   register number size;

   size = nextNum(&x);
   q = libAlloc((unsigned long)size);
   if (isCell(x)) {
      c = (char)nextNum(&x);
      p = q;
      while (--size >= 0)
         *p++ = c;
   }
   return chkPtr(q);
}

pico Free(x)
register pico x;
{
	x = EVAL1(x);
	NEEDNUM(x);
   libFree((char *)unBoxPtr(x));
   return tSym;
}

pico Stuff(x)
register pico x;
{
   register char *p;
   register pico y;
   register number cnt;
	cell c1;

   p = (char*)EVAL1(x);
   x = cdr(x);
   NEEDNUM(p);
   p = (char*)unBoxPtr((pico)p);
   y = EVAL1(x);
   if (isNum(y)) {
      if (!(cnt = unBox(y)))
         return nilSym;
      --cnt;
      push(x = newCell(boxNum(*p++), nilSym), c1);
      while (--cnt >= 0) {
         cdr(x) = newCell(boxNum(*p++), nilSym);
         x = cdr(x);
      }
      return pop(c1);
   }
   loop {
      NEEDLIST(y);
      while (isCell(y)) {
         NEEDNUM(car(y));
         *p++ = (char)unBox(car(y));
         y = cdr(y);
      }
      if (!isCell(x = cdr(x)))
         return boxPtr(num(p));
      y = EVAL1(x);
   }
}

pico Block(x)
register pico x;
{
   register pico src,dst;

   src = EVAL1(x);
   NEEDNUM(src);
   x = cdr(x);
   dst = EVAL1(x);
   NEEDNUM(dst);
   x = EVAL1(cdr(x));
   NEEDNUM(x);
   libBlock((char*)unBoxPtr(src),(char*)unBoxPtr(dst),unBoxPtr(x));
   return x;
}

pico Serial(x)
pico x;
{
   uchar buf[256];

   if (isNil(x = EVAL1(x))) {
      if (!serialReady())
         return nilSym;
      return boxNum(serialIn());
   }
   if (isNum(x)) {
      serialOut((int)unBox(x));
      return x;
   }
	if (x == tSym)
      buf[0] = '\0';
   bufString(x,buf,256);
	return boxBool(initSerial(buf));
}

int readKey()
{
	int c;

   if (isCell(val(queueSym))) {
      c = (int)unBox(car(val(queueSym)));
      val(queueSym) = cdr(val(queueSym));
   }
   else
      c = waitTTY();
   if (!isNil(val(logFlg)))
      val(logFlg) = newCell(boxNum(c),val(logFlg));
   return c;
}

pico Key()
{
   if (!isCell(val(queueSym))  &&  !ttyAvail())
      return nilSym;
   return boxNum(readKey());
}

pico HitKey()
{
   return boxNum(readKey());
}

bool keyBreak()
{
   int c;

   if (ttyAvail()) {
      if ((c = waitTTY()) == '.') {
         cBreak();
		   return YES;
      }
      val(queueSym) = nconc(val(queueSym), newCell(boxNum(c),nilSym));
   }
	return NO;
}

static void echoChar(c)
int c;
{
   ttyOut(c>0 && c<32 ?  '_' : c);
}

static void doBs()
{
   ttyOut(8);
   ttyOut(' ');
   ttyOut(8);
}

static bool fKey(c)
int c;
{
   register pico x = val(fkeySym);

   while (isCell(x)) {
      if (unBox(car(car(x))) == c) {
         evalBody(cdr(car(x)));
         return YES;
      }
      x = cdr(x);
   }
   return NO;
}

void getLine(first,last)
uchar *first,*last;
{
   pico x, str;
   int c;
	uchar *s, *t;
   int i, again;
   bool overwrite;

   s = first;
   again = -1;
   overwrite = YES;
   loadPos = NULL;
   loop {
      do
         c = readKey();
      while (c == ESCAPE  &&  fKey(c = readKey()));
      switch (c) {
         case EOL:
         case '\r':
            if (s-first > 3  &&  val(againSym) != nilSym  &&
                  !equal(str = unBufCntString(s-first, first),
                        car(val(againSym)) ) )
			      val(againSym) = newCell(str, val(againSym));
            *s++ = EOL;
            while (s <= last)
               *s++ = 0;
            return;
         case ctrl('H'):
            if (s > first) {
               --s;
               doBs();
            }
            break;
         case ctrl('X'):
            while (s > first) {
               --s;
               doBs();
            }
            break;
         case ctrl('I'):
            for (i=0; i<TABLEN && s<last-1; ++i) {
               if (!overwrite) {
                  t = last-1;
                  while (t > s) {
                     *t = *(t-1);
                     --t;
                  }
               }
               ttyOut(*s++ = ' ');
            }
            break;
         case ctrl('A'):
            while (s > first) {
               --s;
               doBs();
            }
            x = val(againSym);
            ++again;
            for (i=0; isCell(x) && i<again; ++i)
               x = cdr(x);
            if (isCell(x)) {
               bufString(car(x), first, (long)LBSIZE);
               while (*s)
                  echoChar(*s++);
            }
            break;
         case ctrl('Z'):
            while (s > first) {
               --s;
               doBs();
            }
            x = val(againSym);
            if (again)
               --again;
            for (i=0; isCell(x) && i<again; ++i)
               x = cdr(x);
            if (isCell(x)) {
               bufString(car(x), first, (long)LBSIZE);
               while (*s)
                  echoChar(*s++);
            }
            break;
         case ctrl('R'):
            while (*s && *s!=EOL)
               echoChar(*s++);
            break;
         case ctrl('D'):
            t = s;
            while (*t) {
               *t = *(t+1);
               ++t;
            }
            break;
         case ctrl('O'):
            overwrite = !overwrite;
            break;
         case ctrl('F'):
            if (*s && *s!=EOL)
               echoChar(*s++);
            break;
         case ctrl('C'):
            reset();
            prString("^C\n");
            unwind();
            closeAll();
            longjmp(errRst,-1);
         default:
            if (s < last-1) {
               if (!overwrite) {
                  t = last-1;
                  while (t > s) {
                     *t = *(t-1);
                     --t;
                  }
               }
               echoChar(*s++ = (char)c);
            }
            break;
      }
   }
}
