[ledit.l 27jan93abu]
[+++ Lisp Line Editor +++]

[++ Global variables ++]
(off :dirty :dirt2)     [Dirty flags]
(setq :line 1)          [Position in text]
(setq :line2 1)
(zero :col :col2)       [Current line position]
(off :macro)            [Editor macro]
(setq :scrap NIL)       [Cut/Paste scrap]
(setq :find NIL)        [Search buffer]
(setq :found NIL)
(setq :rplc NIL)        [Replace buffer]
(setq :plen 23)         [Page length]

[SEARCH files for a pattern]
<de grep (pat d f)
   (when (sect "?*" d)
      (xchg d f) )
   (setq pat (append "*" pat ["*"]))
   (local (fd n f lin)
      (mapc
         (if f
            (filter (dir d) '((s) (wild f s)))
            (dir d) )
         '((nm)
            (setq nm (append d nm))
            (unless (setq fd (open nm))
               (error "Can't open " nm) )
            (zero n)
            (off f)
            (while (setq lin (getLine fd))
               (inc n)
               (when (wild pat lin T)
                  (unless f
                     (on f)
                     (prin2 nm)
                     (putc \:)
                     (terpri) )
                  (prin1 n)
                  (putc \.)
                  (prLine lin) ) )
            (close fd) ) )
      T >

[EDIT symbol or file]
<de edit (:e :c)
   (local (:cnt)
      (when (doEdit :e :c)
         (loop
            (zero :cnt)
            (prCurr)
            (setq :c (edKey))
            (when (leq \1 :c \9)
               (repeat
                  (setq :cnt (add (mul 10 :cnt) (sub :c \0)))
                  (setq :c (edKey))
                  (not (leq \0 :c \9)) ) )
            (when (eq :c \*)
               (catch T
                  (local (:c :l)
                     (setq :c :col :l :line)
                     (rPar T)
                     (setq :cnt (sub :l :line -1)) ) )
               (setq :c (edKey)) )
            (when (eq :c \-)
               (setq :cnt (max 1 (sub :cnt :line -1)))
               (setq :c (edKey)) )
            (while (eq :c \+)
               (inc :cnt)
               (setq :c (edKey)) )
            (T (eq :c \Q))
            (reptn (add (if (zerop :col) 5 6) (strLen (nth :line Edit)))
               (putc 8) )
            (case :c
               (\, (setq Queue :macro))
               (\l (reptn (max 1 :cnt) (edRight)))
               (\w
                  (reptn (max 1 :cnt)
                     (while (plusp (access Edit :line :col))
                        (edRight) )
                     (edRight) ) )
               (\h (reptn (max 1 :cnt) (edLeft :cnt)))
               (\b
                  (reptn (max 1 :cnt)
                     (until
                        (or
                           (not (edLeft))
                           (minusp
                              (access Edit :line (sub1 :col)) ) ) ) ) )
               (\j (edMove 1))
               (\k (edMove -1))
               (\i (terpri) (edIns (getLine)))
               (\/ (terpri) (edFind (getLine)))
               (\f
                  (edRight)
                  (setq :c (edKey))
                  (while
                     (and
                        (access Edit :line :col)
                        (neq :c (access Edit :line :col)) )
                     (edRight) ) )
               (\n (edFind))
               (\c (terpri) (edRepl (getLine)))
               (\. (edRepl))
               (\x (edDel))
               (\K (edDel 9999))
               (\X (unless (zerop :col) (dec :col) (edDel)))
               (\t (edIns (cons (edKey))) (edRight))
               (\r
                  (store (edKey) Edit :line :col)
                  (touch) )
               (\D (edCut :cnt))
               (\Y (local (:dirty) (edCut :cnt) (edPast :scrap 0)))
               (\P (edPast :scrap 0))
               (\p (edPast :scrap 1))
               (\O (terpri) (enter NIL 0))
               (\o (terpri) (enter NIL 1))
               (\# (dateStamp))
               (\S (edSplt))
               (\J (edJoin))
               (\< (edBlkL :cnt))
               (\> (edBlkR :cnt))
               (\0 (zero :col))
               (\$ (setq :col (length (nth :line Edit))))
               (\G (edLine (if (zerop :cnt) (length Edit) :cnt)))
               (\g (edLine :cnt))
               (\(
                  (catch T
                     (local (:c :l)
                        (setq :c :col :l :line)
                        (lPar (eq \> (access Edit :l :c)))
                        (setq :col :c :line :l) ) ) )
               (\)
                  (catch T
                     (local (:c :l)
                        (setq :c :col :l :line)
                        (rPar T)
                        (setq :col :c :line :l) ) ) )
               (\I (indent))
               (\[ (on Log))
               (\] (setq :macro (reverse (cdr Log))) (off Log))
               (\u (edMove #(minus :plen)) (eView #:plen))
               (\d (edMove #:plen) (eView #:plen))
               (\v
                  (if (zerop :cnt)
                     (eView 4 3)
                     (eView (mod :cnt 10) (div :cnt 10)) ) )
               (^M (eView (if (zerop :cnt) #:plen :cnt)))
               (\F
                  (terpri)
                  (terpri)
                  (showLines :line #:plen (mul 3 (minus :cnt))) )
               (^H
                  (terpri)
                  (xchg Edit Edit2)
                  (xchg :line :line2)
                  (xchg :col :col2)
                  (xchg :dirty :dirt2)
                  (prLine (car Edit)) )
               (\e (local (l s p)
                     (setq
                        l (nthcdr :col (nth :line Edit))
                        s )
                     (unless (symChar (car l))
                        (pop l) )
                     (while (symChar (car l))
                        (link s p (pop l)) )
                     (when (and s (get (symbol s) 'Src))
                        (terpri)
                        (doEdit (symbol s)) ) ) )
               (\s (setq  :find :rplc  :rplc :found))
               (-1 (zero :col) (edMove 1) (terpri))
               (\~
                  (local (c)
                     (when (setq c (access Edit :line :col))
                        (store
                           ((if (leq \a c \z) upc lowc) c)
                           Edit :line :col )
                        (edRight)
                        (touch) ) ) )
               (\! (save))
               (\@ (terpri) (load))
               (27 )
               (T (bell)) ) )
         (terpri)
         T >

<de doEdit (:e :c)
   (catch T
      (when :e
         (if (stringp :e)
            (progn
               (setq
                  Edit2 Edit
                  :line2 :line
                  :col2 :col
                  :dirt2 :dirty )
               (edOpen :e)
               (edLine (if (numberp :c) :c 1)) )
            (progn
               (unless (setq :c (if :c (get :c :e) (get :e 'Src)))
                  (throw T) )
               (setq
                  Edit2 Edit
                  :line2 :line
                  :col2 :col
                  :dirt2 :dirty )
               (unless (equal (car Edit) (cdr :c))
                  (edOpen (cdr :c)) )
               (edLine (car :c)) ) ) )
      (prLine (car Edit)) >

<de eView (n m)
   (terpri)
   (terpri)
   (if m (showLines (sub :line m) m -9999))
   (showLines :line n -9999)
   (terpri) >

<de enter (file offs)
   (default offs 0)
   (local (n lin text)
      (setq text)
      (if file
         (setq file (open file)) )
      (setq n :line)
      (while
         (progn
            (unless file (prin2 "   "))
            (setq lin (getLine file)) )
         (inc n)
         (push lin text) )
      (setq text (reverse text))
      (edPast text offs)
      (if file (close file) )
      (if text (touch)) >

<de touch () (on :dirty) >

<de save (nm bk)
   (local (Edit fd ok)
      (off ok)
      (when (eq nm T)
         (off nm)
         (on bk) )
      (default nm (car Edit))
      (when (or :dirty (not (equal nm (car Edit))))
         (on ok)
         (rplaca Edit nm)
         (when bk
            (erase (setq bk (append nm "-")))
            (rename nm bk) )
         (unless (setq fd (create nm))
            (error "Can't create") )
         (while (setq Edit (cdr Edit))
            (prLine (car Edit) fd) )
         (close fd) )
      (off :dirty)
      ok >

<de rid ()
   (off Edit Edit2 :dirty)
   (setq  :line 1  :col 0) >

(de sl () (and (save T) (load)))

<de edOpen (f)
   (setq Edit)
   (local (fd p)
      (if (setq fd (open f))
         (progn
            (while (getLine fd)
               (link Edit p it) )
            (close fd) )
         (setq Edit (cons (cons -1))) ) )
   (push f Edit)
   (zero :col)
   (off :dirty) >

<de symChar (c)
   (or (letter c) (digit c) (eq c \-)) >

<de edKey ()
   (local (c)
      (if (eq 32 (setq c (hitKey))) -1 c) >

<de edLine (n)
   (setq :line
      (limit n 1 (sub1 (length Edit))) )
   (zero :col) >

<de edMove (n)
   (setq :line
      (limit (add n :line) 1 (sub1 (length Edit))) )
   (setq :col (min :col (length (nth :line Edit)))) >

<de edRight ()
   (unless (eq :col (length (nth :line Edit))) (inc :col)) >

<de edLeft ()
   (unless (zerop :col) (dec :col)) >

<de edBlkR (n)
   (if (zerop n) (setq n 1))
   (zero :col)
   (local (:line)
      (reptn n
         (edIns "   ")
         (inc :line) ) )
   (touch) >

<de edBlkL (n)
   (if (zerop n) (setq n 1))
   (zero :col)
   (local (:line lin)
      (reptn n
         (setq lin (nth :line Edit))
         (when (minusp (car lin))
            (rplaca lin (add 3 (car lin)))
            (unless (minusp (car lin))
               (edDel) ) )
         (inc :line) ) )
   (touch) >

<de lScan ()
   (when (minusp (dec :c))
      (setq :c (sub1 (length (nth (dec :l) Edit))))
      (when (zerop :l)
         (bell)
         (throw T) >

<de rScan ()
   (unless (access Edit :l (inc :c))
      (zero :c)
      (unless (nth (inc :l) Edit)
         (bell)
         (throw T) >

<de indent ()
   (local (lin n1 n2 l s c)
      (setq
         n1 (car (nth :line Edit))
         lin :line
         l )
      (unless (minusp n1)
         (zero n1) )
      (setq n2 n1)
      (loop
         (setq s (nth lin Edit))
         (while s
            (cond
               ((eq \\ (setq c (pop s)))
                  (pop s) )
               ((eq \" c)
                  (while (and s (neq \" (setq c (pop s))))
                     (when (eq \\ c)
                        (pop s) ) ) )
               (T
                  (case c
                     (\( (dec n2 3))
                     (\) (inc n2 3))
                     (\< (push n2 l) (dec n2 3))
                     (\> (setq n2 (pop l))) ) ) ) )
         (T (not n2))
         (T (not (lessp n2 n1)))
         (T (not (nth (inc lin) Edit)))
         (when (neq n2 (access Edit lin 0))
            (touch)
            (if (minusp (access Edit lin 0))
               (rplaca (nth lin Edit) n2)
               (rplaca (nthcdr lin Edit)
                  (cons n2 (nth lin Edit)) >

<de lPar (flg)
   (local (c)
      (lScan)
      (loop
         (setq c
            (access Edit :l :c))
         (T (and (not flg) (eq c \()))
         (T (eq c \<))
         (if (and (not flg) (eq c \)))
            (lPar)
            (if (eq c \>)
               (lPar T) ) )
         (lScan)) >

<de rPar (flg)
   (local (c)
      (rScan)
      (loop
         (when (eq \\ (setq c (access Edit :l :c)))
            (rScan)
            (rScan)
            (setq c (access Edit :l :c)) )
         (T (eq c \)) (unless flg (rScan)))
         (T (eq c \>))
         (cond
            ((eq c \() (rPar))
            ((eq c \<) (rPar) (rScan))
            (T (rScan)) >

<de edFind (s)
   (and s (setq :find s))
   (when :find
      (local (pos lin text)
         (setq
            lin :line
            text (nthcdr :line Edit) )
         (if <setq pos (matchLine (nthcdr (add1 :col) (car text>
            (setq pos (add 1 pos :col))
            (progn
               (inc lin)
               (pop text)
               (until
                  (or
                     (null text)
                     (setq pos (matchLine (car text))) )
                  (inc lin)
                  (pop text) ) ) )
         (if text
            (setq
               :line lin
               :col pos )
            (bell) >

<de edRepl (s)
   (when :found
      (and s (setq :rplc s))
      (edDel (length :found))
      (edIns :rplc) >

<de edIns (s)
   (local (lin)
      (setq lin (nth :line Edit))
      (if (zerop :col)
         (rplaca
            (nthcdr :line Edit)
            (append s lin) )
         (rplacd
            (nthcdr (sub1 :col ) lin)
            (append s (nthcdr :col lin)) ) )
      (collps)
      (if s (touch)) >

<de edDel (n)
   (default n 1)
   (local (lin)
      (setq lin (nth :line Edit))
      (if
         (and
            (eq n 1)
            (numberp (nth :col lin))
            (lessp (nth :col lin) -1) )
         (rplaca
            (nthcdr :col lin)
            (add1 (nth :col lin)) )
         (if (zerop :col)
            (rplaca
               (nthcdr :line Edit)
               (nthcdr n lin) )
            (rplacd
               (nthcdr (sub1 :col ) lin)
               (nthcdr (add n :col) lin) ) ) ) )
   (touch) >

<de datStr ()
   (local (d)
      (setq d (date))
      (append
         (if (lessp (low d) 10) "0")
         (format (low d))
         <nth (sub1 (middle d)) '(
               "jan" "feb" "mar" "apr" "may" "jun"
               "jul" "aug" "sep" "oct" "nov" "dec" >
         (format (high d)) >

<de dateStamp ()
   (edDel 7)
   (edIns (datStr)) >

<de edCut (n)
   (if (zerop n) (setq n 1))
   (local (Edit)
      (setq Edit (nthcdr (sub1 :line) Edit))
      (setq :scrap (cdr Edit))
      (when (cdr (rplacd Edit (nthcdr n :scrap)))
         (rplacd (nthcdr (sub1 n) :scrap)) )
      (touch) >

<de edPast (text offs)
   (local (Edit)
      (setq Edit (nthcdr (add -1 offs :line) Edit))
      (rplacd Edit (nconc (copy text) (cdr Edit)))
      (touch) >

<de edSplt ()
   (local (lin rest)
      (setq
         lin (nth :line Edit)
         rest (nthcdr :col lin) )
      (if (minusp (car lin))
         (push (add -3 (car lin)) rest) )
      (unless (or (null rest) (zerop :col))
         (rplacd (nthcdr (sub1 :col) lin))
         (rplacd (nthcdr :line Edit)
            (nconc (cons rest) (nthcdr (add1 :line) Edit)) )
         (touch) >

<de edJoin ()
   (local (lin)
      (setq lin (nth (add1 :line) Edit))
      (nconc
         (nth :line Edit)
         (if (minusp (car lin))
            (cdr lin)
            lin ) )
      (rplacd
         (nthcdr :line Edit)
         (nthcdr (add2 :line) Edit) )
      (collps)
      (touch) >

<de prCurr ()
   (local (lin len)
      (prLineNo :line)
      (putc (if :dirty \! \.))
      (setq
         lin (nth :line Edit)
         len (limit (sub 73 (strLen lin)) 0 8) )
      (unless (zerop :col)
         (reptn :col (putc (pop lin)))
         (putc \^) )
      (prin2 lin)
      (reptn len (putc 32))
      (reptn len (putc 8)) >

<de showLines (lin n f)
   (when (lessp lin 1)
      (setq n (add n -1 lin))
      (setq lin 1) )
   (local (l)
      (setq l (nthcdr lin Edit))
      (until (or (null l) (zerop n))
         (unless (and (numberp (caar l)) (lessp (caar l) f))
            (prLineNo lin)
            (putc \:)
            (prLine (car l))
            (dec n) )
         (inc lin)
         (pop l) >

<de prLineNo (n)
   (if (lessp n 1000)
      (space) )
   (if (lessp n 100)
      (space) )
   (if (lessp n 10)
      (space) )
   (prin1 n) >

[++ Pattern matching ++]
<de matchLine (lin)
   (local (pos)
      (catch T
         (zero pos)
         (reptn (sub (length lin) (length :find) -2)
            (when (wild :find lin T)
               (setq :found (chop it lin))
               (throw T pos) )
            (inc pos)
            (pop lin) )
         NIL >

[++ Collapse white space ++]
<de collps ()
   (local (lin)
      (setq lin (nth :line Edit))
      (while lin
         (when (and (minusp (car lin)) (minusp (cadr lin)))
            (rplaca
               lin
               (add (car lin) (cadr lin)) )
            (rplacd lin (cddr lin)) )
         (pop lin) >

T
