/*
 *  bezier include file for sv.c    bez.h
 * 04aug89gr
 */

#define     UDF 	0x7fffffff  /* undefine of Long value */
#define     UDFS	0x7fff	    /* undefine of Long value */
#define     INF 	1.0e+12     /* infinite value */
#define     EPS 	1.0e-6	    /* epsilon value */
#define     TOL 	1.0	    	/* tollerance on pixel coordinate */
#define     HDSIZ	4	    	/* allocate header size */
#define     NSRECT	4			/* Number of segments */
#define     NSCIRC	8

/* define macros ------------------------------------------------------------ */
#define MAX(a,b)    (((a) > (b)) ? (a) : (b))
#define MIN(a,b)    (((a) < (b)) ? (a) : (b))
#define VPR(A,B)    (A.dx * B.dy - A.dy * B.dx)
#define SPR(A,B)    (A.dx * B.dx + A.dy * B.dy)
#define SQR(A)	    ((A) * (A))
#define DIS(A,B)    (sqrt(SQR((A).dx - (B).dx) + SQR((A).dy - (B).dy)))
#define MAG(A)	    (sqrt(SQR(A.dx) + SQR(A.dy)))

/* define structures -------------------------------------------------------- */

typedef struct {
    double dx, dy;
} Dxy;

/* point */
typedef struct {
    Dxy     p; /* passing  point */
    Dxy     q; /* first control point */
    Dxy     r; /* second control point */
} bezPoint;

/* Prototypes */
pico boxBezPoint(Dxy*);
void nextBezPoint(pico*,Dxy*);
void unBoxBezPoint(pico,Dxy*);
