/* isarRudi.c
 * 09dec89rudi
 */

#include "HD:picoSources:pico.h"
#include "HD:picoSources:stack.h"
#include "HD:picoSources:mac.h"
#include "isar.h"
#include <VRetraceMgr.h>

#define INCH 274
#define DOTS 72
#define DIGISKIP 3

/* Undocumented low-memory variables */
#define mouseH (*(integer*)2090)
#define mouseV (*(integer*)2088)
#define magic1 (*(char*)2254)
#define magic2 (*(char*)2255)
#define mbState (*(char*)0x172)

/* Prototypes */
static pascal void doDigiTask(void);
static int serialNum(void);

static pico LotPoint(pico);

symInit rudiSyms[] = {
	{"LOTPOINT",		LotPoint},
	NULL
};

VBLTask digiTask = {NULL, vType, (ProcPtr)doDigiTask, DIGISKIP, 0};
static int digiX = 0;
static int digiY = 0;
static int digiF = 0;
static int lastY = 0;
static int lastX = 0;
static int lastF = 0;
static pico digiTaskSym;
static pico digiHSym, digiVSym;

/* gibt bei jedem Aufruf eine Komponente des Digi Status zurueck */
int serialNum()
{
	register number v;
	register char c;
	bool sign;

	sign = FALSE;
	if ((c = serialIn()) == '-'  ||  c == '+') {
		if (c == '-')
			sign = TRUE;
		c = serialIn();
	}
	v = c - '0';
	while ((c = serialIn()) != ',')
		v = v * 10 + c - '0';
	return sign? -v : v;
}

/* hauptfunktion der task in der der digistatus abgefragt wird und speicher - */
/* stelle 0172 versorgt wird */
pascal void doDigiTask()
{
	SetUpA5();
	if (outAux  &&  !isNil(val(digiTaskSym))) {
		register long h,v;

		if (!serialStat())
			serialOut('Y');
		else if (serialStat() >= 12) {     /* [+/-]XXXX,[+/-]YYYY,F<lf> */
			h = serialNum();
			v = serialNum();
			digiF = serialIn() - '0';
			while (serialStat()) /* <Lf> etc. */
				serialIn();
			if (lastF==0 && digiF==1) {
				PostEvent(app1Evt, (long)(v << 16) | (h & 0xFFFF));
				mbState = 0;
			}
			else if (lastF==1 && digiF==0) {
				PostEvent(mouseUp,0);
				mbState = 0x80;
			}
			lastX = digiX;
			lastY = digiY;
			lastF = digiF;
			if (h < unBox(val(digiHSym))/10 && v < unBox(val(digiVSym))/10) {
				h *= DOTS;
				v = (unBox(val(digiVSym))/10 - v) * DOTS;
				digiX = h / INCH;
				digiY = v / INCH;
			}
		}
		if ((digiX!=lastX || digiY!=lastY) && (digiX!=mouseH || digiY!=mouseV)) {
			if (h = digiX - mouseH) {
				if (h > 0) {
					if (h >= 16)
						h /= 4;
					else if (h >= 2)
						h /= 2;
				}
				else {
					if (h <= -16)
						h /= 4;
					else if (h <= -2)
						h /= 2;
				}
				mouseH += h;
			}
			if (v = digiY - mouseV) {
				if (v > 0) {
					if (v >= 16)
						v /= 4;
					else if (v >= 2)
						v /= 2;
				}
				else {
					if (v <= -16)
						v /= 4;
					else if (v <= -2)
						v /= 2;
				}
				mouseV += v;
			}
			magic1 = magic2;
		}
	}
	digiTask.vblCount = DIGISKIP;
	RestoreA5();
}

pico LotPoint(x)
register pico x;
{
	register pico y,z;
	double a,b,c,d,n;
	double fx,fy,gx,gy,px,py;

	push(EVAL1(x)); /* First arg: bLine's start point */
	x = cdr(x);
	push(EVAL1(x)); /* Second arg: bLine's end point */
	x = cdr(x);
	x = EVAL1(x); /* Third arg: point */
	y = pop();
	z = pop();
	fx = (double)(unBox(car(z)));
	fy = (double)(unBox(cdr(z)));
	gx = (double)(unBox(car(y)));
	gy = (double)(unBox(cdr(y)));
	px = (double)(unBox(car(x)));
	py = (double)(unBox(cdr(x)));
	a = distPt(px,py,fx,fy);
	b = distPt(px,py,gx,gy);
	if ((c = distPt(fx,fy,gx,gy)) == 0.0)
		return nilSym;
	a *= a;
	b *= b;
	c *= c;
	n = (a - b + c) / (2*c);
	if (n < 0.0  ||  n > 1.0)
		return nilSym;
	return newCell(boxDouble(fx + n*(gx-fx)), boxDouble(fy + n*(gy - fy)));
}

void initRudi()
{
	initSymTab(rudiSyms);
	VInstall(&digiTask);
}

void initRudiVars()
{
	digiTaskSym = init1Sym("*DIGITASK",fresh,nilSym);
	digiHSym = init1Sym("*DIGIH", fresh, boxNum(46000));
	digiVSym = init1Sym("*DIGIV", fresh, boxNum(31000));
}

void stopRudi()
{
	VRemove(&digiTask);
}
