[cmyk.l 16dec89]

(object cmyk mask picApp)

<to classify () 'gerd>

<to t (obj z r)
   (with obj
      (slot home (get *app 'home))
      (slot zoom z)
      (from docWin t obj
         (winLoc -30 22)
         (mul 640 z)
         (mul 640 z)
         (append
            (get (get *app 'home) 'name)
            " - Zoom "
            (format z) )
         r )
      (do start 'boss obj) >

<to close (*app)
   (do hide 'spot)
   (with *app
      (slot* zooms (delete *app (slot* zooms))) )
   (peepUp *app)
   (from picApp close *app) >

<to setUp (*app)
   (SetMenuBar *rMBar)
   (DrawMenuBar) >

<to begin (*app)
   (with *app
      (put (slot* peep) 'app *app)
      (do show (slot* peep))
      (setq
         *undo (slot* undo)
         *redo (slot* redo)
         *mark (slot* mark) )
      (unless
         (and
            (equal (slot envMark) *mark)
            (equal (slot envMask) (slot* mask)) )
         (do refresh *app) ) )
   (setUndo)
   (setRedo) >

<to end (*app)
   (with *app
      (do hide (slot* peep))
      (slot* undo *undo)
      (slot* redo *redo)
      (slot* mark *mark)
      (slot envMark *mark)
      (slot envMask (slot* mask))
      (hidespot) >

<to able (*app)
   (local (d l1 l2 f)
      (with *app
         (setq
            d (flagp (slot home) 'dirty)
            l1 *mark
            l2 (cdr *bitsClip)
            f (and l1 l2) )
         (while (or l1 l2)
            (unless (equal (cdr (pop l1)) (cdr (pop l2)))
               (off f l1 l2) ) )
         (doMenu fileM
            t nil
            t nil
            t nil
            t nil
            nil nil
            t nil
            d nil
            t nil
            d nil
            nil nil
            t nil
            nil nil
            t nil )
         (doMenu editM
            *undo nil
            *redo nil
            nil nil
            *mark nil
            *mark nil
            *cmykClip nil
            *mark nil
            *mark nil
            (slot* mask) nil
            nil nil
            nil nil )
         (doMenu retouchM
            t (eq (car (class 'cmyk)) 'measure)
            t (eq (car (class 'cmyk)) 'spuit)
            t (eq (car (class 'cmyk)) 'pixelcopy)
            t (eq (car (class 'cmyk)) 'brush)
            t (eq (car (class 'cmyk)) 'wisch)
            nil nil
            *mark nil
            (and f (not (find *mark mop))) nil
            nil nil
            *mark nil
            nil nil
            *mark nil
            *mark nil
            nil nil
            t )
         (doMenu freeLineM
            *mark nil
            (slot* mask) (slot* showMask)
            (slot* mask) (slot* showCut) >

<to clickSpecial (*app win pt)
   (with *app
      (eq win (get (slot* peep) 'winPtr)) >

<to grow (*app pt)
   (from docWin grow *app pt)
   (peepUp *app) >

<to zoom (*app f)
   (from docWin zoom *app f)
   (peepUp *app) >

<to update (*app)
   (from docWin update *app
      '(()
         (local (*mark)
            (unless (eq *app (front))
               (setq *mark (get (get *app 'home) 'mark)) )
            (showTiles *app)
            (when *poly
               (PenNormal)
               (PenMode patXor)
               (dMask *poly) >

[++ File Menu ++]
<to #(cmd fileM freeCmd) (*app)
   (local (vol s f l)
      (setq vol (GetVol))
      (if *mark
         (when
            (and
               (setq s (putFile "Save Freeline Mask" "FreeMask"))
               (setq f (create s "iFlc")) )
            (print (length *mark) f)
            (mapc *mark '((g) (print g f)))
            (close f) )
         (when
            (and
               (setq s (getFile "iFlc"))
               (setq f (open s)) )
            (setq l)
            (for (i 0 (read f))
               (push (read f) l) )
            (with *app
               (make
                  "Load Freeline"
                  (list (slot* showMask))
                  '((f)
                     (removeMask *mark)
                     (with *app (slot* showMask f)) )
                  (list l)
                  '((m)
                     (mapc m
                        '((x)
                           (drawMask x)
                           (hiMask x) ) )
                     (with *app
                        (slot* showMask t)
                        (slot* mask
                           (append m (slot* mask)) ) ) ) ) )
            (close f) ) )
      (SetVol vol) >

<to #(cmd fileM saveCmd) (*app)
   (saveCmyk *app (get *app 'name)) >

<to #(cmd fileM saveAsCmd) (*app)
   (saveCmyk *app) >

<to #(cmd fileM revertCmd) (*app)
   (local (vol nm)
      (setq
         vol (GetVol)
         nm (get *app 'name) )
      (SetVol (get *app 'vol))
      (do close *app)
      (put (new 'cmyk nm) 'vol (GetVol))
      (SetVol vol) >

[++ Edit Menu ++]
<to #(cmd editM cutCmd) (*app)
   (when *mark
      (make
         "Cut"
         (list *cmykClip)
         '((x)
            (putMask *cmykClip)
            (setq *cmykClip x) )
         nil
         '(nil
            (setq *cmykClip *mark)
            (removeMask *mark) >

<to #(cmd editM copyCmd) (*app)
   (make
      "Copy"
      (list *cmykClip)
      '((x) (setq *cmykClip x))
      (list (copy *mark))
      '((l) (setq *cmykClip l) >

<to #(cmd editM pasteCmd) (*app)
   (pasteCmd1) >

<to #(cmd editM clearCmd) (*app)
   (when *mark
      (make
         "Clear"
         (list *mark)
         putMask
         nil
         '(nil (removeMask *mark) (setq *mark) >

<to #(cmd editM dupCmd) (*app)
   (when *mark
      (make
         "Duplicate"
         (list *mark)
         '((x)
            (removeMask *mark)
            (mapc x hiMask) )
         (list *mark )
         '((x)
            (putMask
               (mapcar *mark
                  '((g) (mvGraf g 10 10)) >

<to #(cmd editM allCmd) (*app)
   (make
      "Select All"
      (list *mark)
      '((x)
         (mapc *mark
            '((g)
               (or
                  (memq g x)
                  (unHiMask g) ) ) ) )
      (with *app (list (slot* mask)))
      '((x)
         (mapc x hiMask) ) >

[++ retouch menu ++++]

<to #(cmd retouchM msrCmd) (*app)
   (hidespot)
   (with *app
      (if (eq (car (class 'cmyk)) 'measure)
         (s-mask)
         (progn
            (do print 'spot "measure")
            (rplaca (class 'cmyk) 'measure) >

<to #(cmd retouchM spuitCmd) (*app)
   (if (eq (car (class 'cmyk)) 'spuit)
      (s-mask)
      (progn
         (entersrc)
         (h-mask 'spuit) >

<to #(cmd retouchM pxlcopyCmd) (*app)
   (if (eq (car (class 'cmyk)) 'pixelcopy)
      (s-mask)
      (progn
         (entersrc)
         (h-mask 'pixelcopy) >

<to #(cmd retouchM brushCmd) (*app)
   (if (eq (car (class 'cmyk)) 'brush)
      (s-mask)
      (h-mask 'brush) >

<to #(cmd retouchM wischCmd) (*app)
   (if (eq (car (class 'cmyk)) 'wisch)
      (s-mask)
      (progn
         (do hide 'spot)
         (h-mask 'wisch) >

<to #(cmd retouchM cBitsCmd) (*app)
   (doCopyBits) >

<to #(cmd retouchM pBitsCmd) (*app)
   (doPasteBits) >

<to #(cmd retouchM lToneCmd) (*app)
   (doLocalTone) >

<to #(cmd retouchM gToneCmd) (*app)
   (doGlobalTone) >

<to #(cmd retouchM loCmd) (*app)
   (pixFilter pixLo "Low") >

<to #(cmd retouchM hiCmd) (*app)
   (pixFilter pixHi "High") >

<to #(cmd retouchM zoomCmd) (*app)
   (zoomCmd1) >

[++ blot menu ++++]

<to #blotM (*app theItem)
   (check1blot theItem) >

[++ freelineM menu ++++]

<to #(cmd freelineM optimCmd) (*app)
   (SetCursor (ptr (GetCursor watchCursor)))
   (local (bs dh dv flg)
      (with *app
         (setq
            bs (slot* base)
            dh (mul 32 (slot* pos-h))
            dv (mul 32 (slot* pos-v))
            flg (zerop (bitand shiftKey (ev-modifiers *event))) )
         (make
            "Optimize"
            (list *mark (slot* mask))
            undoMask
            (list
               (mapcar *mark
                  '((g)
                     (unless flg
                        (meanColor)
                        (scan g
                           '((v h1 h2)
                              (meanColor
                                 bs
                                 (sub v dv)
                                 (sub h1 dh)
                                 (sub h2 dh) ) ) )
                        (meanColor t) )
                     (graf
                        (mapcar (deGraf g)
                           '((l)
                              (optimize
                                 (optimize
                                    (refine l) ) ) ) ) ) ) )
               t )
            makeMask >

<to #(cmd freelineM showMaskCmd) (*app)
   (with *app
      (slot* showMask
         (not (slot* showMask)) ) )
   (refreshCmyks *app) >

<to #(cmd freelineM showCutCmd) (*app)
   (with *app
      (slot* showCut
         (not (slot* showCut)) ) )
   (refreshCmyks *app) >

[+++++++ menu funktions +++++++++]
<de pasteCmd1 ()
   (when (and *cmykClip [*mark])
      (make
         "Paste"
         (list *mark)
         '((x)
            (removeMask *mark)
            (mapc x hiMask) )
         (list *cmykClip *mark)
         '((c m)
            (local (dh dv)
               (if *mark
                  (progn
                     (setq
                        dh
                        (apply min
                           (mapcar c caaar) )
                        dv
                        (apply min
                           (mapcar c cdaar) )
                        dh
                        (sub
                           (left (caar m))
                           dh
                           -10 )
                        dv
                        (sub
                           (top (caar m))
                           dv
                           -10 ) ) )
                  (progn
                     (setq
                        dh 0
                        dv 0 ) ) )
               (putMask
                  (mapcar c
                     '((g)
                        (mvGraf
                           g
                           dh
                           dv ) >

<de zoomCmd1 ()
   (local (*spot pt1 pt2 zoom1 zoom2)
      (setq *spot)
      (when
         (and
            (setq pt1 (click))
            (setq *spot zoomSpot)
            (setq pt2
               (click
                  pt1
                  '((oldPt newPt)
                     (FrameRect  (cons oldPt newPt)) ) ) ) )
         (rightOrder pt1 pt2)
         (setq
            zoom2 (calcZoom
               (sub (car pt2) (car pt1))
               (sub (cdr pt2) (cdr pt1)) )
            zoom1 (div zoom2 (get *app 'zoom)) )
         (if (lessp 50 zoom2)
            (SysBeep 8)
            (with *app
               (slot* zooms
                  (cons
                     (new 'cmyk
                        zoom2
                        (cons2
                           (mul zoom1 (car pt1))
                           (mul zoom1 (cdr pt1))
                           (mul zoom1 (car pt2))
                           (mul zoom1 (cdr pt2)) ) )
                     (slot* zooms) >

t [cmyk.l]
