[cmykPrim.l 27nov89gr]

(setq *masksich)
(setq *marksich)

[when set to mask-modus, show masks]
<de s-mask ()
   (do print 'spot "enter mask")
   (rplaca (class 'cmyk) 'mask)
   (when *masksich
      (with *app
         (slot* mask *masksich)
         (off *masksich)
         (setq *mark *marksich)
         (refreshcmyks *app) ) >

[when change cmykmodi, hide masks]
<de h-mask (modus)
   (rplaca (class 'cmyk) modus)
   (with *app
      (when (slot* mask)
         (setq *masksich (slot* mask))
         (setq *marksich *mark)
         (removemask (slot* mask)) >

<de undoMask (x y)
   (mapc *mark drawHiMask)
   (mapc (setq *mark x) drawHiMask)
   (with *app (slot* mask y)) >

<de makeMask (x f)
   (with *app
      (mapc *mark
         '((g)
            (when (or f *redo)
               (drawHiMask g) )
            (slot* mask (delete g (slot* mask))) ) )
      (mapc (setq *mark x)
         '((g)
            (when (or f *redo)
               (drawHiMask g) )
            (slot* mask (cons g (slot* mask))) >

<de freeMaskRgn (points)
   (local (rgn)
      (setq rgn (NewRgn))
      (OpenRgn)
      (drawMask points)
      (CloseRgn rgn)
      rgn >

<de check1blot (item)
   (for (i 1 10)
      (CheckItem (GetResource "MENU" blotM) i (eq i item)) )
   (setq *blot (nth (sub1 item) *blots)) >

<de enterSrc ()
   (do print 'spot "Enter Source") >

<de enterDst ()
   (do print 'spot "Enter Destination") >

<de peepUp (obj)
   (with obj
      (do refresh (slot* peep) >

<de putMask (lst)
   (mapc *mark unHiMask)
   (mapc lst drawMask)
   (with *app
      (slot* mask
         (append (slot* mask) lst) )
      (mapc lst hiMask) >

<de refreshCmyks (obj)
   (do refresh obj)
   (mapc (get obj 'zooms)
      '((x) (do refresh x) >

<de removeMask (lst)
   (with *app
      (mapc lst
         '((g)
            (slot* mask
               (delete g (slot* mask)) )
            (drawMask g)
            (unHiMask g) >

[++++++
<de mipl (gl)
   (local (f)
      (setq f t)
      (while (and gl f)
         (setq f (and f (mip (pop gl)))) ) >

[if mask in pixmap  "mask in pixmap"]
<de mip (g h v)
   (default h 0 v 0)
   (local (r)
      (setq r (car g))
      (and
         (leq 0 (add (left r) h))
         (leq 0 (add (top r) v))
         (leq (add (bottom r) v) 640)
         (leq (add (right r) h) 640) >
++++++]

[Mask outside pixMap]
<de mop (g)
   (local (r dh dv)
      (with *app
         (setq
            r (car g)
            dh (mul 32 (slot* pos-h))
            dv (mul 32 (slot* pos-v)) ) )
      (or
         (lessp (left r) dh)
         (lessp (top r) dv)
         (lessp (add 640 dh) (right r))
         (lessp (add 640 dv) (bottom r)) >

<de zoomSpot (h v)
   (and
      (not (zerop (dec h (car clickAnchor))))
      (not (zerop (dec v (cdr clickAnchor))))
      (if (lessp 50 (calcZoom h v))
         (hideSpot)
         (do print 'spot
            (append
               "Zoom "
               (format (calcZoom h v))) >

<de refine (l)
   (mapcon l
      '((x)
         (if (and (cadr x) (lessp 8  (distPt (car x) (cadr x))))
            (list
               (car x)
               (cons
                  (div2 (add (caar x) (caadr x)))
                  (div2 (add (cdar x) (cdadr x))) ) )
            (list (car x)) >

<de optim1 (pt l)
   (local (w h1 v1 h v h2 v2 wx)
      (zero w)
      (setq
         h1 (sub (car pt) dh)
         v1 (sub (cdr pt) dv)
         h (sub (caar l) dh)
         v (sub (cdar l) dv)
         h2 (sub (caadr l) dh)
         v2 (sub (cdadr l) dv) )
      (if (lessp (abs (sub h2 h1)) (abs (sub v2 v1)))
         (for (i (sub2 h) (add 3 h))
            (setq wx
               (add
                  ((if flg colEdge1 colEdge2) bs h1 v1 i v)
                  ((if flg colEdge1 colEdge2) bs i v h2 v2) ) )
            (when (lessp w wx)
               (rplaca (car l) (add i dh))
               (setq w wx) ) )
         (for (i (sub2 v) (add 3 v))
            (setq wx
               (add
                  ((if flg colEdge1 colEdge2) bs h1 v1 h i)
                  ((if flg colEdge1 colEdge2) bs h i h2 v2) ) )
            (when (lessp w wx)
               (rplacd (car l) (add i dv))
               (setq w wx) >

<de optimize (l)
   (prog1
      l
      (optim1 (last2 l) l)
      (rplaca (tail l) (car l))
      (reptn (sub2 (length l))
         (optim1 (pop l) l) >

t [cmykPrim.l]
