[digiinput.l 16jul89rf]

(setq *termkey 2)
(setq *enterkey 1)
(setq *hybkey 4)
(setq *orthokey 8)


[Let user input a circle]
<de digiCircle (pt)
   (local (fig pt1 pt2 ptc c r)
      (setq fig)
      (setq pt1)
      (setq pt2)
      (setq ptc)
      (unless pt
         (setq pt (coord)) )
      (if (eq *press *enterkey)
         (setq pt1 pt) )
      (setq pt (coord))
      (if (eq *press *enterkey)
         (setq pt2 pt) )
      (setq pt (coord))
      (if (eq *press *enterkey)
         (progn
            (setq ptc pt)
            (setq pt (coord))
            (when (and pt1 pt2 ptc (eq *press *termkey) )
               (setq c (centre pt1 pt2 ptc))
               (setq r (distpt c pt1))
                (setq fig (gensym))
                (put fig 'type 'circle)
                (put fig 'bezier (bzCirc c r)) )
           (setq *press *enterkey)
           fig )
         (progn
            (when (and pt1 pt2 (eq *press *termkey))
               (setq c pt1)
               (setq r (distpt c pt2))
                (setq fig (gensym))
                (put fig 'type 'circle)
                (put fig 'bezier (bzCirc c r)) )
              (setq *press *enterkey)
              fig ) )
    (setq *press *enterkey)
     fig >

<de digiPoly (pt1)
   (local (*poly)
      (setq *poly)
      (PenNormal)
      (PenMode patXor)
      (while (and (setq pt (or pt1 (coord)))
            (neq *press *termkey))
         (setq pt1)
         (if (minusp (car pt))
            (if (numberp (caar *poly))
               (drawBack)
               (pop *poly) )
            (progn
               (cond
                  ((eq *press *hybkey)
                     (if (numberp (caar *poly))
                        (push (list pt) *poly)
                        (SysBeep 8) ) )
                  ((or (eq *press *enterkey) (eq *press *orthokey))
                     (when *poly
                        (if (numberp (caar *poly))
                           (line2 (unScale (car *poly)) (unScale pt))
                           (hybArc (cadr *poly) (caar *poly) pt) ) )
                     (push pt *poly) ) ) ) ) )
      (setq *press *enterkey)
      (makePoly) >

[Let user input a fan]
<de digifan (pt)
   (local (fig pt1 pt2 ptc ptd pth c r pts)
      (setq pts)
      (setq fig)
      (setq pt1)
      (setq pt2)
      (setq ptc)
      (setq ptd)
      (setq pth)
      (unless pt
         (setq pt (coord)) )
      (if (eq *press *enterkey)
         (setq pt1 pt) )
      (setq pt (coord))
      (if (eq *press *enterkey)
         (setq pt2 pt) )
      (setq pt (coord))
      (if (eq *press *enterkey)
         (setq ptc pt) )
      (setq pt (coord))
      (if (eq *press *enterkey)
         (setq ptd pt) )
      (when (and pt1 pt2 ptc (eq *press *enterkey))
         (setq pth (coord) )
         (when (eq *press *termkey)
            (setq c (centre pt2 ptc ptd))
            (if (lessp (distpt pt1 c) 200)
               (progn
                  (setq pts (list pt2 (list ptc) ptd c))
                   (setq fig (gensym))
                   (put fig 'type 'Fan)
                   (put fig 'bezier (bzHybrid pts)) )
               (progn
                  (setq pts (list pt2
                                   (list ptc)
                                   ptd
                                 (ptOncircle c pt1 ptd)
                                 (list pt1)
                                 (ptOnCircle c pt1 pt2) ) )
                  (setq fig (gensym))
                  (put fig 'type 'Fan)
                  (put fig 'bezier (bzHybrid pts)) ) ) ) )
   (setq *press *enterkey)
   fig >



<de digiOblong (pt)
   (local (fig pt1 pt2 ptc ptd pth a points)
      (setq fig)
      (setq pt1)
      (setq pt2)
      (setq pth)
      (setq points)
      (unless pt
         (setq pt (coord)) )
      (if (eq *press *enterkey)
         (setq pt1 pt) )
      (setq pt (coord))
      (if (eq *press *enterkey)
         (setq pt2 pt) )
      (setq pt (coord))
      (if (eq *press *termkey)
         (setq pth pt) )
      (when (and pt1 pt2 pth (eq *press *termkey))
         (if (quadrat pt1 pt2)
         (progn
             (orderpoints pt1 pt2)
             (setq c (zentrum pt1 pt2))
              (setq fig (gensym))
               (put fig 'type 'circle)
               (put fig 'bezier (bzCirc c (sub (car pt2)(car c))))
            fig )
         (progn
         (setq ptd pt1)
         (setq pt1 (cons (car ptd) (cdr pt2)))
         (setq ptc (cons (car pt2) (cdr ptd)))
         (if            [+++senkrecht und aussen++]
            (and
               (eq *press *termkey)
               (lessp (car pt2) (car pth))
               (lessp  (sub(car pt2)(car pt1))(sub (cdr pt2)(cdr ptc))))
            (progn
               (mOblcoord (unscale ptd) (unscale pt2))
               (setq fig (gensym))
               (put fig 'type 'oblong)
               (put fig 'bezier (bzHybrid points))
               (setq *press *enterkey)
               fig )
            (progn
               (if            [+++ quer und aussen++]
                  (and
                     (eq *press *termkey)
                     (lessp (car pt2) (car pth))
                     (lessp (sub (cdr pt2)(cdr ptc)) (sub(car pt2)(car pt1))))
                  (progn
                     (mOblcoord (unscale ptd) (unscale pt2))
                     (setq fig (gensym))
                     (put fig 'type 'oblong)
                     (put fig 'bezier (bzHybrid points))
                     (setq *press *enterkey)
                     fig )
                  (progn    [+++ senkrecht und waagrecht innen +++]
                     (when (and (eq *press *termkey)(lessp (car pth) (car pt2)))
                        (mOblcoord (unscale ptd)(unscale pt2) t)
                        (setq fig (gensym))
                        (flag fig 'invObl)
                        (put fig 'type 'oblong)
                        (put fig 'bezier (bzHybrid points))
                        (setq *press *enterkey)
                     fig ) ) )
            (setq *press *enterkey)
            fig )  )
>

<de digiElli (pt)
   (local (fig pt1 ptc pth pt2)
      (setq fig)
      (setq pt1)
      (setq pt2)
      (setq ptc)
      (unless pt
         (setq pt (coord)) )
      (if (eq *press *enterkey)
         (setq pt1 pt) )
      (setq pt (coord))
      (if (eq *press *enterkey)
         (setq pt2 pt) )
      (setq pt (coord))
      (if (eq *press *enterkey)
         (setq ptc pt) )
      (setq pt (coord))
      (when (and pt1 pt2 ptc (eq *press *termkey))
         (setq fig (gensym))
         (put fig 'type 'ellipse)
         (put fig 'bezier (bzElli pt1 pt2 ptc))
         fig )
   (setq *press *enterkey)
   fig >
t [digiinput.l]

