[dlg.l 25jun90]

(setq $point (0 . 0))
(setq $curve)

(setq *dlgEditItems)             [edit item numbers for dlgFilter]

(de *sizeButtons
   ( 3 . #AivV) ( 4 . #BivV) ( 5 . #AiiiV) ( 6 . #BiiiV)
   (28 . #AivH) (29 . #BivH) (30 . #AiiiH) (31 . #BiiiH) )

(setq $pageEditItems (7 8 9 10 11 12 13 33 36))
(setq $tintEditItems (3 4 5 6))
(setq $divEditItems (3 4))
(setq $cdivEditItems (3 4))

<de *curves
   (((30.90) 159.219) . nil)
   (((188.90) 317.219) . nil)
   (((346.90) 475.219) . nil)
   (((504.90) 633.219) . nil) >

<de dlgFilter (theDialog theEvent itemHit)
   (gc 1000)
   (SetCursor
      (if (find *dlgEditItems '((x) (mouseInCtl theDialog x)))
         (ptr (GetCursor iBeamCursor))
         *arrow ) )
   [(and
      (eq nullEvent (ev-what theEvent))
      (GetNextEvent app1Mask theEvent)
      (ev-what theEvent mouseDown) )]
   (when (eq keyDown (ev-what theEvent))
      (case (bitand charCodeMask (ev-message theEvent))
         ((3 13) (word itemHit 1))
         (#helpKey (*help) (word itemHit 9999)) >

<de d-item (i)
   (local (tp r)
      (GetDItem *dlg i tp r) >

[Set radio buttons]
<de setButton (sz)
   (mapc *sizeButtons
      '((x)
         (SetCtlValue
            (d-item (car x))
               (if (equal sz (cdr x)) 1 0) >

[Set up size fields of *DLG]
<de setISize (sz)
   (setButton sz)
   [Set numeric size fields]
   (SetIText
      (d-item 8)
      (format (car sz) 2) )
   (SetIText
      (d-item 9)
      (format (cdr sz) 2) >

[Extract size from size fields]
<de getSizeItem ()
   (cons
      (number (GetIText (d-item 8)) 2)
      (number (GetIText (d-item 9)) 2) >

<de offDigi ()
   (off digi)
   (SetCtlValue (d-item 32) 0) >

[++ Dialog for page properties ++]
<de pageDialog (sz nm digi bc al gr)
   (local (itemHit f pt c)
      (setq
         *dlgEditItems $pageEditItems
         *dlg (GetNewDialog pageDlg nil -1)
         f )
      (unless (setq *digiTask (testDigi))
         (HiliteControl (d-item 32) 255) )
      (SetIText (d-item 7)
         (or nm "Untitled") )
      (SelIText *dlg 7 0 9999)
      (SetISize sz)
      (SetCtlValue (d-item 32)
         (if digi 1 0) )
      (setq c bc)
      (SetIText (d-item 10) (format (pop c)))
      (SetIText (d-item 11) (format (pop c)))
      (SetIText (d-item 12) (format (pop c)))
      (SetIText (d-item 13) (format (pop c)))
      (SetIText (d-item 33) (format gr))
      (SetIText (d-item 36) (format al 2))
      (while (lessp 2 (ModalDialog dlgFilter itemHit))
         (case itemHit
            (7 (on f))
            ((3 4 5 6 28 29 30 31)
               (offDigi)
               (SetISize (cdr (assoc itemHit *sizeButtons))) )
            ((8 9)
               (offDigi)
               (setButton (getSizeItem)) )
            (32
               (if digi
                  (offDigi)
                  (progn
                     (SetCtlValue (d-item 32) 1)
                     (do print 'spot "Top left corner")
                     (setq digi (digiXY))
                     (do print 'spot "Bottom right corner")
                     (setq pt (digiXY))
                     (rplaca pt
                        (sub (car pt) (car digi)) )
                     (rplacd pt
                        (sub (cdr pt) (cdr digi)) )
                     (SetISize pt)
                     (HideSpot) ) ) ) ) )
      (prog1
         (when (eq 1 itemHit)
            (when f
               (setq nm (GetIText (d-item 7))) )
            (list
               (getSizeItem)
               nm
               digi
               (list [backColor]
                  (number (GetIText (d-item 10)))
                  (number (GetIText (d-item 11)))
                  (number (GetIText (d-item 12)))
                  (number (GetIText (d-item 13))) )
               (number (GetIText (d-item 36)) 2) [allow]
               (number (GetIText (d-item 33))) [grid] ) )
         (DisposDialog *dlg) >

[++ Tint color input ++]
<de tintDialog (c)
   (local (mh itemHit)
      (setq
         mh (GetMenu ctabM)
         *dlgEditItems $tintEditItems
         *dlg (GetNewDialog tintDlg nil -1) )
      (when c
         (SetIText (d-item 3) (format (pop c)))
         (SetIText (d-item 4) (format (pop c)))
         (SetIText (d-item 5) (format (pop c)))
         (SetIText (d-item 6) (format (pop c))) )
      (SelIText *dlg 3 0 9999)
      (while (lessp 2 (ModalDialog dlgFilter itemHit))
         (case itemHit
            (16
               (InsertMenu mh -1)
               (PopUpMenuSelect mh 250 300 1)
               (DeleteMenu ctabM) ) ) )
      (prog1
         (when (eq 1 itemHit)
            (list
               (min 100 (number (GetIText (d-item 3))))
               (min 100 (number (GetIText (d-item 4))))
               (min 100 (number (GetIText (d-item 5))))
               (min 100 (number (GetIText (d-item 6)))) ) )
         (DisposDialog *dlg) >

<de divDialog (d)
   (local (itemHit)
      (setq
         *dlgEditItems $divEditItems
         *dlg (GetNewDialog d nil -1) )
      (SelIText *dlg 3 0 9999)
      (while (lessp 2 (ModalDialog dlgFilter itemHit)))
      (prog1
         (when (eq 1 itemHit)
            (set hSym (number (GetIText (d-item 3))))
            (set vSym (number (GetIText (d-item 4)))) )
         (DisposDialog *dlg) >

<de divideDialog (hSym vSym)
   (divDialog divideDlg) >

<de cdivideDialog (hSym vSym)
   (divDialog cdivideDlg) >

[++ Retouch mode tone changes ++]
[++ Init Color Tone Curves ++]
<de initCurve (n)
   (local (l)
      (setq l (list 0))
      (for (i 1 129)
         (nconc1 l i) )
      (rplacd (nth n *curves) l) >

(for (i 0 4)
   (initCurve i) )

<de curvDlgFilter (theDialog theEvent itemHit)
   (local (x)
      (GetMouse $point)
      (setq $curve
         (find *curves
            '((c)
               (and
                  (PtInRect $point (car c))
                  (lessp
                     (abs
                        (sub
                           (sub (bottom (car c)) (cdr $point))
                           (nth
                              (sub (car $point) (left (car c)))
                              (cdr c) ) ) )
                     3 ) ) ) ) )
      (if $curve
         (progn
            (setq x (sub (car $point) (left (car $curve))))
            (SetCursor (ptr (GetCursor crossCursor)))
            (do print 'spot
               (append
                  (format
                     (div
                        (mul 100 x)
                        128 ) )
                  "%" ) ) )
         (progn
            (SetCursor *arrow)
            (HideSpot) ) )
      (case (ev-what theEvent)
         (#mouseDown
            (when $curve
               (drag $point
                  '((oldPt newPt)
                     (local (d a1 b1 a2 b2)
                        (setq
                           d (abs (sub (car oldPt) (car $point)))
                           a1 (max 0 (sub x d))
                           b1 (min 128 (add x d))
                           d (abs (sub (car newPt) (car $point)))
                           a2 (max 0 (sub x d))
                           b2 (min 128 (add x d)) )
                        (plotCurve
                           $curve
                           (sub1 (min a1 a2))
                           (max b1 b2)
                           -1 )
                        (for (i a1 b1)
                           (store
                              (sub
                                 (nth i (cdr $curve))
                                 (sub (cdr $point) (cdr oldPt)) )
                              (cdr $curve) i ) )
                        (for (i a2 b2)
                           (store
                              (add
                                 (nth i (cdr $curve))
                                 (sub (cdr $point) (cdr newPt)) )
                              (cdr $curve) i ) )
                        (plotCurve
                           $curve
                           (sub1 (min a1 a2))
                           (max b1 b2)
                           0 ) ) ) )
               nil ) )
         (#keyDown
            (case (bitand charCodeMask (ev-message theEvent))
               ((3 13) (word itemHit 1))
               (#helpKey
                  (*help)
                  (showCurves)
                  (word itemHit 9999) >

<de plotCurve (crv x1 x2 col)
   (local (a b c)
      (PenNormal)
      (RGBForeColor col)
      (MoveTo
         (add x1 (left (car crv)))
         (sub
            (bottom (car crv))
            (limit (nth x1 (cdr crv)) 0 128)
            1 ) )
      (until (lessp x2 x1)
         (setq
            a (limit (nth (sub1 x1) (cdr crv)) 0 128)
            b (limit (nth x1 (cdr crv)) 0 128)
            c (nth (add1 x1) (cdr crv)) )
         (when
            (or
               (eq x2 x1)
               (neq a (sub1 b))
               (and c (neq b (sub1 (max 0 (min 128 c))))) )
            (LineTo
               (add x1 (left (car crv)))
               (sub (bottom (car crv)) b 1) ) )
         (inc x1) >

<de showCurves ()
   (mapc *curves
      '((c)
         (PenSize 2 2)
         (FrameRect (InsetRect (car c) -2 -2))
         (plotCurve c 0 128 0) >

<de curvDialog ()
   (local (*spot itemHit)
      (setq *spot
         '((h v)
            (local (n)
               (setq n
                  (div
                     (mul 100 (sub (cdr $point) v))
                     128 ) )
               (do print 'spot
                  (append
                     (if (plusp n) "+")
                     (format n)
                  "%" ) ) ) ) )
      (localPort (setq *dlg (GetNewDialog curvDlg nil -1))
         (showCurves)
         (while (lessp 2 (ModalDialog curvDlgFilter itemHit))
            (when (lessp 7 itemHit 12)
               (dec itemHit 8)
               (plotCurve (nth itemHit *curves) 0 128 -1)
               (initCurve itemHit)
               (plotCurve (nth itemHit *curves) 0 128 0) ) )
         (DisposDialog *dlg)
         (when (eq 1 itemHit)
            (mapcar *curves
               '((x)
                  (mapcon (cdr x)
                     '((l)
                        (when (cadr l)
                           (list
                              (limit (mul2 (car l)) 0 255)
                              (limit
                                 (div2
                                    (add
                                       (mul2 (car l))
                                       (mul2 (cadr l)) ) )
                                 0 255 >

t [dlg.l]
