[listdlg.l 22feb90]

(setq $point (0.0))
(setq *dlgEditItems)             [edit item numbers for dlgFilter]

(setq $blilistEditItems (7 8 9 10 12 13 14 15 17 18 19 20 22 23 24 25 27
          28 29 30 32 33 34 35 37 38 39 40 42 43 44 45 47 48 49 50))
(setq $filiEditItems (13 19 20 21 22 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60))

(setq vsbarr 61)
(setq hsbarr 62)

<de switchbutton (n)
   (setctlvalue
      (d-item n)
      (if (eq (getctlvalue (d-item n)) 1) 0 1) ) >

<de fidlgFilter (theDialog theEvent itemHit)
   (gc 3000)
   (SetCursor
      (if (find *dlgEditItems '((x) (mouseInCtl theDialog x)))
         (ptr (GetCursor iBeamCursor))
         *arrow ) )
   (when
      (and
         (eq mouseDown (ev-what theEvent))
         (mouseinctl thedialog #hsbarr) )
      (horizcntl (ev-where theevent)) )
   (when
      (and
         (eq mouseDown (ev-what theEvent))
         (mouseinctl thedialog #vsbarr) )
      (verticntl (ev-where theevent)) )
   (when (eq keyDown (ev-what theEvent))
      (case (bitand charCodeMask (ev-message theEvent))
         ((3 13) (word itemHit 1))
         (#helpKey (*help) (word itemHit 9999)) >

<de blidlgFilter (theDialog theEvent itemHit)
   (gc 1000)
   (SetCursor
      (if (find *dlgEditItems '((x) (mouseInCtl theDialog x)))
         (ptr (GetCursor iBeamCursor))
         *arrow ) )
   (when (eq keyDown (ev-what theEvent))
      (case (bitand charCodeMask (ev-message theEvent))
         ((3 13) (word itemHit 1))
         (#helpKey (*help) (word itemHit 9999)) >

[show values of baselines at items in baslinelistdlg]
<de setBlitext (a b)
   (SetIText (d-item (inc pt)) (format (car a) 2))
   (SetIText (d-item (inc pt)) (format (cdr a) 2))
   (SetIText (d-item (inc pt)) (format (car b) 2))
   (SetIText (d-item (inc pt)) (format (cdr b) 2))
   >

[show baselines from bali-list at position pos, 9lines]
<de seeblili (bali pos)
(local (a pt)
   (setq pt 6)
   (reptn pos (pop bali))
   (for (i 0 9)
      (setq a (pop bali))
      (setblitext (cadr a) (cddr a))
      (setctlvalue
         (d-item (inc pt))
         (if (car a) 1 0) ) )
   >

[scroll baselinelist at position pos for n positions]
<de dobascroll (pos n)
(local (a)
   (when (not (zerop n))
      (off a)
      (setq bali (riedbali bali pos))
      (seeblili bali (add pos n))   [show new baselines]
      (setq position (setctlvalue (d-item 6) (add pos n)))
      >

[read from balist dlg edititems in balist]
<de riedbali (blili pos)
(local (a b c)
   (off a)
   (reptn pos
      (push (pop blili) a) )
   (setq b 6)
   (reptn 9
      (setq c
         (cons
            (if (eq (getctlvalue (d-item (add b 5))) 0) nil T)
            (cons
               (cons
                  (number (getitext (d-item (inc b))) 2)
                  (number (getitext (d-item (inc b))) 2) )
               (cons
                  (number (getitext (d-item (inc b))) 2)
                  (number (getitext (d-item (inc b))) 2) ) ) ) )
      (inc b)
      (push c a)
      (pop blili) )
   (while blili (push (pop blili) a))
   (reverse a)
   >

<de scrollbali (cntl part)
(local (val d1 d2)
   (setq val (GetCtlValue cntl))
   (setq d1 (sub (GetCtlMax cntl) val))
   (setq d2 (sub val (getctlmin cntl)) )
   (case part
      (#inUpButton
         (dobascroll val (minus (min 1 d2))) )
      (#inDownButton
         (dobascroll val (min 1 d1)) )
      (#inPageUp
         (dobascroll val (minus (min 9 d2))) )
      (#inPageDown
         (dobascroll val (min 9 d1)) )
      >

<de dobalicntl ()
(local (part cntl x  pos val)
   (getmouse $point)
   [(globaltolocal $point)]
   (setq part (findcontrol $point *dlg cntl))
   (setq x position)
   (if (eq part inthumb)
      (unless (zerop (trackcontrol cntl $point))
         (setq val (getctlvalue cntl))
         (dobascroll x (sub val x)) )
      (trackControl cntl $point scrollbali) )
   >

[++ show page BaseLines and edit them. ++]
<de blilist ()
(local (bali itemHit a b c pos position pt c l i)
   (when (setq bali (get *app 'baselines))
      (setq
         *dlgEditItems $blilistEditItems
         *dlg (GetNewDialog blilistDlg nil -1)
         l (length bali)
         pt 6)      [startpt for edititems ]
      (localPort *dlg
         (if (lessp l 10)      [can show all baselines]
            (progn
               (hideditem *dlg 6)       [scrollbar]
               (mapc bali '((x)
                     (setblitext (cadr x) (cddr x))
                     (setctlvalue
                        (d-item (inc pt))
                        (if (car x) 1 0) ) ) )
               (for (i (inc pt) 52) (hideditem *dlg i)) )
            (progn
               (showcontrol (d-item 6))
               (seeblili bali 0)
               (setctlmin (d-item 6) 0)
               (setctlmax (d-item 6) (sub l 9))
               (setq position (setctlvalue (d-item 6) 0)) ) )
         (while (lessp 2 (ModalDialog blidlgFilter itemHit))
            (case itemHit
               (6 (dobalicntl))
               (11 (switchbutton 11))
               (16 (switchbutton 16))
               (21 (switchbutton 21))
               (26 (switchbutton 26))
               (31 (switchbutton 31))
               (36 (switchbutton 36))
               (41 (switchbutton 41))
               (46 (switchbutton 46))
               (51 (switchbutton 51)) ) ) )
      (when (eq 1 itemHit)
         (if (lessp l 10)
            (progn
               (setq b 6)
               (off a)
               (reptn l
                  (setq c
                     (cons
                        (if (eq (getctlvalue (d-item (add b 5))) 0) nil T)
                        (cons
                           (cons
                              (number (getitext (d-item (inc b))) 2)
                              (number (getitext (d-item (inc b))) 2) )
                           (cons
                              (number (getitext (d-item (inc b))) 2)
                              (number (getitext (d-item (inc b))) 2) ) ) ) )
                  (push c a)
                  (inc b) )
               (setq bali (reverse a)) )
            (setq bali (riedbali bali (getctlvalue (d-item 6)))) )
         (unless (equal bali (get *app 'baselines))
            (make
               "Edit Baselines"
               (list (get *app 'baselines))
               '((x)
                  (put *app 'baselines x)
                  (mapc x
                     '((k)
                        (InvalRect
                           (InsetRect
                              (orderpoints (unScale (cadr k)) (unScale (cddr k)))
                              -1 -1 ) ) ) ) )
               (list bali)
               '((y)
                  (mapc y
                     '((z)
                        (InvalRect
                           (InsetRect
                              (orderpoints (unScale (cadr z)) (unScale (cddr z)))
                              -1 -1 ) ) ) )
                  (put *app 'baselines y) ) ) ) )
      (DisposDialog *dlg)
      >

[show rule properties if exist, else hide rule-items]
<de riedruleitems ()
   (list
      (number (GetIText (d-item 13)) 2)
      (list
         (number (GetIText (d-item 19)))
         (number (GetIText (d-item 20)))
         (number (GetIText (d-item 21)))
         (number (GetIText (d-item 22)))
         >

<de setruleitems (l)
   (local (a b c)
      (setq b (cadr l))
      (if b
         (progn
            (SetIText (d-item 13) (format b 2) )
            (for (c 15 23)
               (showditem *dlg c) )
            (setq a (caddr l))
            (SetIText (d-item 19) (format (pop a)))
            (SetIText (d-item 20) (format (pop a)))
            (SetIText (d-item 21) (format (pop a)))
            (SetIText (d-item 22) (format (pop a))) )
         (progn
            (SetIText (d-item 13) "0") )
            (for (c 15 23)
               (hideditem *dlg c) )
            >

[show size properties]
<de setsizeitems (fig)
(local (a b)
   (setq a (div 100 (get *app 'scale)))
   (setq b (get fig 'rgnbbox))
   (SetIText (d-item 6) (format (mul (caar b) a) 2))
   (SetIText (d-item 7) (format (mul (cdar b) a) 2))
   (SetIText (d-item 9) (format (mul (cadr b) a) 2))
   (SetIText (d-item 10) (format (mul (cddr b) a) 2))
   >

[get size properties]
<de riedsizeitems (fig)
   (cons
      (cons
         (number (getitext (d-item 6)))
         (number (getitext (d-item 7))) )
      (cons
         (number (getitext (d-item 9)))
         (number (getitext (d-item 10))) ) )
   >

[show content properties if exist, else hide content-items]
<de setcontentitems (fig)
(local (b c clss)
   (setq clss (class fig))
   (setitext (d-item 4)
      (append
         (format (add1 (index fig orgfili)))
         "/"
         (format (length  orgfili))
         "   "
         (if (eq (setq c (car clss)) 'empty)
            (progn
               (append
                  "empty  "
                  (nth (index (cadr clss) ftypes) fprity) ) )
            (progn
               (append
                  (nth (index (cadr clss) ftypes) fprity)
                  "  "
                  fpriwith
                  "  "
                  (nth (index c fcontents) fprico)
                  (case c
                     (tinted
                        (setq b (get fig 'tint))
                        (append
                           "  Y: "
                           (format (pop b))
                           "%  M: "
                           (format (pop b))
                           "%  C: "
                           (format (pop b))
                           "%  K: "
                           (format (pop b))
                           "%" ) )
                     (pictured
                        (append "  " (get fig 'picture)) >

[show figure in figlist at position poos]
<de seefili (pos)
   (local (a b l)
      (dec pos)
      (setq
         a (nth pos fili)
         b (nth pos *fili) )
      (setq bezlist (borderbez (modl (car b))))
      (if (lessp (setq l (length bezlist)) 7)
         [(setctlmax (d-item #vsbarr) 0)]
         (hideditem *dlg #vsbarr)
         (progn
            (showditem *dlg #vsbarr)
            (setctlmin (d-item #vsbarr) 0)
            (setctlmax (d-item #vsbarr) (sub l 6))
            (setctlvalue (d-item #vsbarr) 0) ) )
      (setsizeitems a)
      (setruleitems b)
      (setcontentitems a)
      (showbez bezlist 0)
      >

[read in figure properties at figurelist in position pos]
         [and set new list]
<de riedfili (pos)
   (store
      (cons
         (zufass
            (riedbezli bezlist (getctlvalue (d-item #vsbarr))) )
         (riedruleitems) )
      *fili
      (sub1 pos) >

[scroll figurelinelist at position pos for n positions]
<de dofiliscroll (pos n)
   (when (not (zerop n))
      (riedfili pos)
      (setctlvalue (d-item #hsbarr) (add pos n))
      (seefili (add pos n))   [show new figure]
      >

<de scrollfili (cntl part)
(local (val d1 d2)
   (setq val (GetCtlValue cntl))
   (setq d1 (sub (GetCtlMax cntl) val))
   (setq d2 (sub val (getctlmin cntl)) )
   (case part
      (#inUpButton
         (dofiliscroll val (minus (min 1 d2))) )
      (#inDownButton
         (dofiliscroll val (min 1 d1)) )
      (#inPageUp
         (dofiliscroll val (minus (min 6 d2))) )
      (#inPageDown
         (dofiliscroll val (min 6 d1)) )
      >

<de horizcntl (pt)
(local (part cntl pos val)
[   (getmouse $point)]
   (setq part (findcontrol (globaltolocal pt) *dlg cntl))
   (setq pos (getctlvalue cntl))
   (if (eq part inthumb)
      (unless (zerop (trackcontrol cntl pt))
         (setq val (getctlvalue cntl))
         (dofiliscroll pos (sub val pos)) )
      (trackControl cntl pt scrollfili) )
   >

[read from filist bezpoints dlg edititems in filist]
<de riedbezli (bezli pos)
(local (a b)
   (off a)
   (setq b 24)
   (if (lessp 6 (length bezli))
      (progn
         (reptn pos
            (push (pop bezli) a) )
         (reptn 6
            (push (riedbzline (pop bezli) b) a)
            (setq b (add b 6)) )
         (while bezli (push (pop bezli) a)) )
      (progn
         (reptn (length bezli)
            (push (riedbzline (pop bezli) b) a)
            (setq b (add b 6) ) ) ) )
   (reverse a)
   >

<de riedbzline (bzseg b)
   (if (lessp 1 (length bzseg))
      (list
         (cons
            (number (getitext (d-item (inc b))) 4)
            (number (getitext (d-item (inc b))) 4) )
         (cons
            (number (getitext (d-item (inc b))) 4)
            (number (getitext (d-item (inc b))) 4) )
         (cons
            (number (getitext (d-item (inc b))) 4)
            (number (getitext (d-item (inc b))) 4) ) )
      (cons
         (number (getitext (d-item (inc b))) 4)
         (number (getitext (d-item (inc b))) 4) )
      >

<de scrollbez (vcntl vpart)
(local (vval d1 d2)
   (setq vval (GetCtlValue vcntl))
   (setq d1 (sub (GetCtlMax vcntl) vval))
   (setq d2 (sub vval (getctlmin vcntl)) )
   (case vpart
      (#inUpButton
         (dobezscroll vval (minus (min 1 d2))) )
      (#inDownButton
         (dobezscroll vval (min 1 d1)) )
      (#inPageUp
         (dobezscroll vval (minus (min 6 d2))) )
      (#inPageDown
         (dobezscroll vval (min 6 d1)) )
      >

[scroll bezlist at position pos for n positions]
<de dobezscroll (pos n)
   (when (not (zerop n))
      (setq bezlist (riedbezli bezlist pos))
      (showbez bezlist (add pos n))   [show new bezlist]
      (setq bezpos (setctlvalue (d-item #vsbarr) (add pos n)))
      >

<de verticntl (pt)
(local (vpart vcntl bezpos vval)
   [   (getmouse pt)]
   (setq vpart (findcontrol (globaltolocal pt) *dlg vcntl))
   (setq bezpos (getctlvalue vcntl))
   (if (eq vpart inthumb)
      (unless (zerop (trackcontrol vcntl pt))
         (setq vval (getctlvalue vcntl))
         (dobezscroll bezpos (sub vval bezpos)) )
      (trackControl vcntl pt scrollbez) )
   >

[show one segment of bezlist]
<de setbezpoints (seg)
(local (a b)
   (if (lessp (length seg) 2)
      (progn
         (showditem *dlg (inc pt))
         (SetIText (d-item pt) (format (car seg) 4))
         (showditem *dlg (inc pt))
         (SetIText (d-item pt) (format (cdr seg) 4))
         (reptn 4
            (hideditem *dlg (inc pt)) ) )
      (progn
         (reptn 3
            (setq a (pop seg))
            (showditem *dlg (inc pt))
            (SetIText (d-item pt) (format (car a) 4))
            (showditem *dlg (inc pt))
            (SetIText (d-item pt) (format (cdr a) 4)) ) ) )
   >

<de showbez (bezli pos)
(local (a b l pt bezli)
   (setq pt 24)
   (setq l (length bezli))
   (reptn pos (pop bezli))
   (setq b (min 6 l))
   (for (i 0 b)
      (setq a (pop bezli))
      (setbezpoints a) )
   (for (i b 6)
      (reptn 6 (hideditem *dlg (inc pt))) )
   >

[++ show figure list and edit figures etc. ++]
[
<de filist ()
   (local (orgfili fili itemHit a pos pt l oldl1 oldl2 newl1 newl2)
      (off oldl1 oldl2 newl1 newl2)
      (when (setq orgfili (get *app 'figures))
         (if *mark
            (setq fili *mark)
            (setq fili orgfili) )
         (setq *fili
            (mapcar fili
               '((fig)
                  (list
                     (get fig 'bezier)
                     (or (get fig 'rule) 0)
                     (or (get fig 'rTint) '(0 0 0 0))) ) ) )
         (setq
            *dlgEditItems $filiEditItems
            *dlg (GetNewDialog filistDlg nil -1)
            l (length fili)
            pt 48)     [startpt for edititems points]
         (localPort *dlg
            (setq a (car fili))
            (setq pos 1)
            (if (eq l 1)
               (hideditem *dlg #hsbarr)
               (progn
                  (showditem *dlg #hsbarr)
                  (setctlmin (d-item #hsbarr) 1)
                  (setctlmax (d-item #hsbarr) l)
                  (setctlvalue (d-item #hsbarr) 1) ) )
            (seefili pos)
            (while (lessp 2 (ModalDialog fidlgFilter itemHit)) )
            (when (eq 1 itemHit)
               (do refresh *app)
               (riedfili
                  (if (eq (length fili) 1)
                     1
                     (getctlvalue (d-item #hsbarr)) ) )
               (mapc2 fili *fili
                  '((fig l)
                     (unless
                        (and
                           (equal (get fig 'rule) (cadr l) )
                           (equal
                              (if (eq nil (get fig 'rTint))
                                 '(0 0 0 0)
                                 (get fig 'rtint) )
                              (caddr l) ) )
                        (push (list fig (get fig 'rule) (get fig 'rTint)) oldl1)
                        (push (list fig (cadr l) (caddr l)) newl1) )
                     (unless (equal (get fig 'bezier) (car l))
                        (push (cons fig (get fig 'bezier)) oldl2)
                        (push (cons fig (car l)) newl2) ) ) )
               (when (or oldl1 oldl2)
                  (make
                     "Edit Figures"
                     (list oldl1 oldl2)
                     '((l1 l2) (setfigures l1 l2))
                     (list newl1 newl2)
                     '((l1 l2) (setfigures l1 l2)) ) ) )
            (DisposDialog *dlg) >
]


<de filist ()
   (local (orgfili fili itemHit a pos pt l old new)
      (off old new)
      (when (setq orgfili (get *app 'figures))
         (if *mark
            (setq fili *mark)
            (setq fili orgfili) )
         (setq *fili
            (mapcar fili
               '((fig)
                  (list
                     (get fig 'bezier)
                     (or (get fig 'rule) 0)
                     (or (get fig 'rTint) '(0 0 0 0))) ) ) )
         (setq
            *dlgEditItems $filiEditItems
            *dlg (GetNewDialog filistDlg nil -1)
            l (length fili)
            pt 48)     [startpt for edititems points]
         (localPort *dlg
            (setq a (car fili))
            (setq pos 1)
            (if (eq l 1)
               (hideditem *dlg #hsbarr)
               (progn
                  (showditem *dlg #hsbarr)
                  (setctlmin (d-item #hsbarr) 1)
                  (setctlmax (d-item #hsbarr) l)
                  (setctlvalue (d-item #hsbarr) 1) ) )
            (seefili pos)
            (while (lessp 2 (ModalDialog fidlgFilter itemHit)) )
            (when (eq 1 itemHit)
               (do refresh *app)
               (riedfili
                  (if (eq (length fili) 1)
                     1
                     (getctlvalue (d-item #hsbarr)) ) )
               (mapc2 fili *fili
                  '((fig l)
                     (with fig
                        (unless
                           (and
                              (equal (slot bezier) (car l))
                              (equal (or (slot rule) 0) (cadr l) )
                              (equal
                                 (or (slot rTint) '(0 0 0 0))
                                 (caddr l) ) )
                           (push
                              (list
                                 fig
                                 (slot bezier)
                                 (slot rule)
                                 (slot rTint) )
                              old )
                           (push
                              (list
                                 fig
                                 (car l)
                                 (if (neq (cadr l) 0) (cadr l))
                                 (if (neq (cadr l) 0) (caddr l)) )
                              new ) ) ) ) )
               (when new
                  (make
                     "Edit Figures"
                     (list old)
                     setfigures
                     (list new)
                     setfigures new ) ) )
            (DisposDialog *dlg) >

[set figures to new bezier or new rule]
[list is fig, bezier, rule, rtint]
<de setfigures (lst)
   (mapc lst
      '((l)
         (InvalFig (car l))
         (with (car l)
            (slot rule (nth 2 l))
            (slot rTint (nth 3 l))
            (adjBez (car l) (cadr l)) >

t [listdlg.l]
