[main.l 19mar90abu]

[++ Start Main Loop ++]
<de task ()
   (setq
      *spot defaultSpot
      *cursor nil )
   (go) >

[++ Init the ISAR environment ++]
<de isar ()
   (reptn 8 (MoreMasters))
   (SetGrowZone isarGrow)
   (crash 8) [Intercept BusErrors]
   (baud 9600)
   (setq
      *digiTask (testDigi)
      *resFile (OpenResFile "isarRsrc")
      *event (alloc 16)
      *blPat (alloc 8)
      *lastFix fix-rect
      *iMBar (GetNewMBar iMBar)
      *pMBar (GetNewMBar pMBar)
      *rMBar (GetNewMBar rMBar)
      *tMBar (GetNewMBar tMBar) )
   (zero *lastWhen *lastH *lastV)
   (SetMenuBar *iMBar)
   (GetIndPattern *blPat 0 9) [Disabled BaseLines]
   (AddResMenu (GetMenu appleM) "DRVR")
   (AddResMenu (GetMenu fontM) "FONT")
   (DrawMenuBar)
   (do init 'fixMenu)
   (do init 'spot)
   (check1blot 5)
   [#(not $debug)
   (off initFixMenu initSpot)
   ]
   (task) >


<de isarGrow (n)
   (prin1 n)
   (prLine " bytes needed")
   (print (GZSaveHnd))
   (if (lessp 20 (length *undo))
      (zap1undo)
      (tryClose) )
   (gc)
   1 >

(setq *class 'picApp)

<to keyDown (*app c m)
   (if (zerop (bitand cmdKey m))
      (case c
         (3 [ENTER]
            )
         (9 [TAB]
            )
         ((28 29 30 31) [Arrows]
            (and
               (get (car *mark) 'radius)
               (fix-round c) )
            )
         (t
            ) )
      (case c
         (30 [Up arrow]
            )
         (31 [Down arrow]
            )
         (t
            (when (setq m (method (MenuKey c) *app))
               (m *app)
               (HiliteMenu 0) >

<to autoKey (*app c m)
   (unless (zerop (bitand cmdKey m))
      (when (setq m (method (MenuKey c) *app))
         (m *app)
         (HiliteMenu 0) >

<to app2Evt (*app msg)
   (local (l)
      (when *jFile
         (close *jFile)
         (off *jFile)
         (word 08DE 0) )
      (when *batch
         (if
            (and
               (not (Button))
               (setq l (getline (cdr *batch))) )
            (local (vol)
               (setq vol (GetVol))
               (SetVol (car *batch))
               (when (equal l "*")
                  (seek 0 (cdr *batch))
                  (setq l (getline (cdr *batch))) )
               (prline l)
               (setq *jFile (open l))
               (SetVol vol)
               (control *drvr 18 *jFile)
               (word 08DE -1) )
            (progn
               (close (cdr *batch))
               (off *batch)
               (word 08DE 0) >

[++ File Menu ++]
<to #(cmd fileM newPCmd) ()
   (local (l)
      (when (setq l (pageDialog AivV nil nil (0 0 0 0) 500 0))
         [++ (zapUndo) ++]
         (new 'page (cons 2 l)) >

<to #(cmd fileM newTCmd) ()
   (new 'text "Untitled" 200) >

<to #(cmd fileM openCmd) ()
   (local (vol nm)
      (setq vol (GetVol))
      (when (setq nm (getFile "page" "CMYK"))
         [++ (zapUndo) ++]
         (if (equal "page" (fType nm))
            (put (loadPage nm) 'vol (GetVol))
            (new 'cmyk1 nm fd) )
         (SetVol vol) >

<to #(cmd fileM closeCmd) (*app)
   (do close *app) >

<to #(cmd fileM playCmd) ()
   (doPlay) >

<to #(cmd fileM quitCmd) ()
   (do quit 'boss) >

[++ Edit Menu ++]
<to #(cmd editM undoCmd) (*app)
   (local (x mh)
      (setq mh (GetResource "MENU" editM))
      (push (GetItem mh redoCmd) *redo)
      (push (setq x (pop *undo)) *redo)
      (setRedo)
      (apply (caddr x) (cadr x))
      (SetItem mh undoCmd (pop *undo))
      ((if (pop *undo) 'flag 'remove) *app 'dirty) >

<to #(cmd editM redoCmd) (*app)
   (apply make1 (pop *redo))
   (SetItem
      (GetResource "MENU" editM)
      redoCmd
      (pop *redo) >

<de make (s l1 foo1 l2 foo2)
   (zapRedo)
   (make1 s l1 foo1 l2 foo2) >

<de make1 (s l1 foo1 l2 foo2)
   (local (mh)
      (push (flagp *app 'dirty) *undo)
      (flag *app 'dirty)
      (setq mh (GetResource "MENU" editM))
      (push (GetItem mh undoCmd) *undo)
      (push (list s l1 foo1 l2 foo2) *undo)
      (setUndo)
      (apply foo2 l2) >

<de setUndo ()
   (SetItem
      (GetResource "MENU" editM)
      undoCmd
      (append "Undo " (caar *undo)) >

<de setRedo ()
   (SetItem
      (GetResource "MENU" editM)
      redoCmd
      (append "Redo " (caar *redo)) >

<de zapUndo ()
   (zapRedo)
   (off *undo)
   (setUndo) >

<de zapRedo ()
   (off *redo)
   (setRedo) >

<de zap1undo ()
   (reptn 3 (shift *undo)) >

t [main.l]
