[page.l 22nov89]

(object page picApp)

<to classify () 'rudi>

<to t (obj l) [l = (scale size name digi backColor allow grid)]
   (with obj
      (slot scale (pop l))
      (slot size (pop l))
      (slot name (pop l))
      (slot digi (pop l))
      (slot backColor (pop l))
      (slot allow (pop l))
      (unless (zerop (slot grid (pop l)))
         (flag obj 'grid) )
      (flag obj 'showBline)
      (from picApp t obj
         (winLoc 5 22 #(cons (add fmWidth 6) 65))
         (mul (slot scale) (div (car (slot size)) 100))
         (mul (slot scale) (div (cdr (slot size)) 100))
         (or (slot name) "Untitled") )
      (do start 'boss obj) >

<to app1Evt (*app msg)
   (if (get *app 'digi)
      (local (pt a d)
         (setq
            pt (ev-where *event)
            d (get *app 'digi)
            a (cons
               (div (mul 72 (car d)) 2540)
               (div (mul 72 (cdr d)) 2540) ) )
         (if
            <and
               d
               *lastFix
               (PtInRect
                  pt
                  (cons
                     a
                     (cons
                        (add
                           (car a)
                           (div (mul 72 (car (get *app 'size))) 2540) )
                        (add
                           (cdr a)
                           (div (mul 72 (cdr (get *app 'size))) 2540) >
            (*lastFix
               (cons
                  (grid (sub (mul 10 (word (add 4 *event))) (car d)))
                  (grid
                     (sub
                        *digiV
                        (mul 10 (word (add2 *event)))
                        (cdr d) ) ) ) )
            (do #mouseDown 'boss) >

<to close (*app)
   (zapUndo)
   (from picApp close *app) >

<to setUp (*app)
   (do show 'fixMenu)
   (SetMenuBar *pMBar)
   (DrawMenuBar) >

<to begin (*app)
   (put 'fixMenu 'app *app)
   (with *app
      (setq
         *undo (slot undo)
         *redo (slot redo)
         *mark (slot mark) ) )
   (setUndo)
   (setRedo) >

<to end (*app)
   (with *app
      (slot undo *undo)
      (slot redo *redo)
      (slot mark *mark) >

<to cleanUp (*app)
   (do hide 'fixMenu) >

<to setCursor (*app pt)
   (localPort (get *app 'winPtr)
      (when (eq *port (FrontWindow))
         (GlobalToLocal pt)
         (local (fig)
            (setq fig (findFigure pt))
            (SetCursor
               (cond
                  ((not (memq fig *mark)) *arrow)
                  ((onFrame pt fig) (ptr (GetCursor crossCursor)))
                  ((s-key) *arrow)
                  ((eq 'pictured (car (class fig)))
                     (ptr (GetCursor plusCursor)) )
                  (t *arrow) >

<to able (*app)
   (local (d sc bl)
      (with *app
         (setq
            d (flagp *app 'dirty)
            sc (slot scale)
            bl (slot baseLines) )
         (doMenu fileM
            t nil
            t nil
            t nil
            (and
               (eq 1 (length *mark))
               (eq 'pictured (car (class (car *mark)))) )
            nil
            nil nil
            t nil
            d nil
            t nil
            (and d (slot vol)) nil
            nil nil
            t nil
            nil nil
            t nil )
         (doMenu editM
            *undo nil
            *redo nil
            nil nil
            *mark nil
            *mark nil
            *pageClip nil
            *mark nil
            *mark nil
            (slot figures) nil )
         (doMenu figureM
            (slot figures) nil
            nil nil
            *mark nil
            *mark nil
            nil nil
            (and *mark bl) nil )
         (doMenu baselM
            bl nil
            bl (flagp *app 'showBline)
            nil nil
            bl nil
            bl nil
            bl nil
            bl nil
            bl nil
            bl nil )
         (doMenu layoutM
            t (eq 1 sc)
            t (eq 2 sc)
            t (eq 4 sc)
            nil nil
            (not (zerop (slot grid))) (flagp *app 'grid)
            t nil )
         (doMenu arrangeM
            *mark nil
            *mark nil
            nil nil
            *mark nil
            *mark nil >

<to update (*app)
   (from docWin update *app
      '(()
         (local (*mark)
            (unless (eq *app (front))
               (setq *mark (get *app 'mark)) )
            (setPageColor *app)
            (EraseRect (portRect *port))
            (resetColor)
            (drawPage *app)
            (when *poly
               (PenNormal)
               (PenMode patXor)
               (dPoly *poly) >

<to content (*app pt)
   (from picApp content *app pt doFigure) >

[++ File Menu ++]
<to #(cmd fileM freeCmd) (*app)
   (local (vol s f l x h th v tv)
      (setq vol (GetVol))
      (when
         (and
            (setq s (getFile "iFlc"))
            (setq f (open s)) )
         (setq l)
         (for (i 0 (read f))
            (push (read f) l) )
         (close f)
         (setq
            x (get (car *mark) 'pScale)
            h (caar x)
            th (cdar x)
            v (cadr x)
            tv (cddr x) )
         <map l
            '((x)
               (rplaca x
                  (graf
                     (mapcar (deGraf (car x))
                        '((l)
                           (mapcar l
                              '((pt)
                                 (rplaca pt
                                    (div (mul h (car pt)) th 4) )
                                 (rplacd pt
                                    (div (mul v (cdr pt)) tv 4) >
         (make
            "Freeline"
            (list (get (car *mark) 'freeLine))
            '((x)
               (put (car *mark) 'freeLine x)
               (InvalRgn (getFigRgn (car *mark))) )
            (list l)
            '((x)
               (put (car *mark) 'freeLine x)
               (InvalRgn (getFigRgn (car *mark))) ) ) )
      (SetVol vol) >

<to #(cmd fileM saveCmd) (*app)
   (savePage *app (get *app 'name)) >

<to #(cmd fileM saveAsCmd) (*app)
   (savePage *app) >

<to #(cmd fileM revertCmd) (*app)
   (local (vol nm)
      (setq
         vol (GetVol)
         nm (get *app 'name) )
      (SetVol (get *app 'vol))
      (do close *app)
      (put (loadPage nm) 'vol (GetVol))
      (SetVol vol) >

[++ Edit Menu ++]
<to #(cmd editM cutCmd) (*app)
   (make
      "Cut"
      (list *pageClip)
      '((x)
         (putFig *pageClip)
         (setq *pageClip x) )
      nil
      '(nil
         (removeFig *mark)
         (setq *pageClip *mark)
         (setq *mark) >

<to #(cmd editM copyCmd) (*app)
   (make
      "Copy"
      (list *pageClip)
      '((x) (setq *pageClip x))
      (list (copyFig *mark))
      '((l) (setq *pageClip l)) >

<to #(cmd editM pasteCmd) (*app)
   (make
      "Paste"
      (list *mark)
      '((x)
         (removeFig *mark)
         (setq *mark)
         (mapc x mark) )
      (list (pasteFig *pageClip))
      '((l) (putFig l)) >

<to #(cmd editM clearCmd) (*app)
   (make
      "Clear"
      (list *mark)
      putFig
      nil
      '(nil (removeFig *mark) (setq *mark)) >

<to #(cmd editM dupCmd) (*app)
   (make
      "Duplicate"
      (list *mark)
      '((x)
         (removeFig *mark)
         (setq *mark)
         (mapc x mark) )
      (list (recalcFig *mark))
      '((l) (putFig l)) >

<to #(cmd editM allCmd) (*app)
   (make
      "Select All"
      (list *mark)
      '((x)
         (mapc *mark
            '((fig)
               (or
                  (memq fig x)
                  (unMark fig) ) ) ) )
      (list (get *app 'figures))
      '((l) (mapc l mark)) >

[++ Figure Menu ++]
<to #(cmd figureM listCmd) (*app)
   (fiList) >

<to #(cmd figureM mirCmd) (*app)
   (doMirror) >

<to #(cmd figureM rotCmd) (*app)
   (doRot) >

<to #(cmd figureM joinCmd) (*app)
   >
<to #(cmd figureM alignCmd) (*app)
   (alignSelection) >

[++ Baseline Menu ++]
<to #(cmd baselM listBlCmd) (*app)
   (bliList) >

<to #(cmd baselM showBlCmd) (*app)
   (unless (remove *app 'showBline)
      (flag *app 'showBline) )
   (do refresh *app) >

<to #(cmd baselM delBlCmd) (*app)
   (dodelbline) >

<to #(cmd baselM dupBlCmd) (*app)
   (dupBline) >

<to #(cmd baselM movBlCmd) (*app)
   (moveBline) >

<to #(cmd baselM enBlCmd) (*app)
   (enableBline) >

<to #(cmd baselM disBlCmd) (*app)
   (disableBline) >

<to #(cmd baselM extBlCmd) (*app)
   (extendBline) >

[++ Layout Menu ++]
<to #(cmd layoutM reducedCmd) (*app)
   (chgScale 1) >

<to #(cmd layoutM normalCmd) (*app)
   (chgScale 2) >

<to #(cmd layoutM enlargedCmd) (*app)
   (chgScale 4) >

<to #(cmd layoutM gridCmd) (*app)
   (unless (remove *app 'grid)
      (flag *app 'grid) )
   (do refresh *app) >

<to #(cmd layoutM pBaseCmd) (*app)
   (local (x)
      (when
         (setq x
            (with *app
               (pageDialog
                  (slot size)
                  (slot name)
                  (slot digi)
                  (slot backColor)
                  (slot allow)
                  (slot grid) ) ) )
         (make
            "Change Page Base"
            (list
               (copy (plist *app))
               (flags *app) )
            '((p f)
               (setplist *app p)
               (setflags *app f)
               (changedPageBase) )
            x
            '((sz nm dg bc al gr)
               (with *app
                  (slot size sz)
                  (slot name nm)
                  (slot digi dg)
                  (slot backColor bc)
                  (slot allow al)
                  ((if (zerop (slot grid gr)) remove flag)
                     *app 'grid ) )
               (changedPageBase) >

[++ Arrange Menu ++]
<to #(cmd arrangeM frontCmd) (*app)
   (bringFront) >

<to #(cmd arrangeM backCmd) (*app)
   (sendBack) >

<to #(cmd arrangeM closerCmd) (*app)
   (bringCloser) >

<to #(cmd arrangeM behindCmd) (*app)
   (sendFigBehind) >

<to #ymckM (*app i)
   (doTint (nth (sub1 i) *tints)) >

t [page.l]
