[rectangle.l 31oct89]

(off $divFlg $horiDiv $vertDiv)

<de mouseRect (fig pt)
   (local (pt1 pt2)
      (when
         (and
            (setq pt1 (or pt (click)))
            (setq pt2
               (click
                  pt1
                  '((oldPt newPt)
                     (FrameRect  (cons oldPt newPt)) ) ) ) )
         (rightorder pt1 pt2)
         (put fig 'bezier (bzRect (scale pt1) (scale pt2)) >

<de digiRect (fig pt)
   (local (pt1 pt2 ptd ptc pth angle rct pts x y m)
      (setq pt1)
      (setq pt2)
      (setq ptc)
      (unless pt
         (setq pt (coord)) )
      (if (eq *press *enterkey)
         (setq pt1 pt) )
      (setq pt (coord))
      (if (eq *press *enterkey)
         (setq pt2 pt) )
      (setq pt (coord))
      (if (eq *press *enterkey)
         (setq ptc pt) )
      (if (and pt1 pt2 ptc (eq *press *enterkey))
         (progn
            (setq pth (coord))
            (when (eq *press *termkey)
               (setq pts nil)
               (setq m (cons (add (car pt1) (div2 (sub (car pt2)(car pt1))))
                     (add (cdr pt2) (div2 (sub (cdr pt1)(cdr pt2)))) ) )
               (setq rct (sqrect m (distpt m pt2)))
               (setq angle (PtToAngle rct ptc))
               (setq ptc (ptOnCircle m pt2 ptc))
               (setq x (sub (car ptc) (car pt2)))
               (setq y (sub (cdr ptc) (cdr pt2)))
               (setq ptd (cons
                           (sub (car pt1) x)
                           (sub (cdr pt1) y) ) )
               (setq pts (list ptd pt2 ptc pt1))
               (put fig 'bezier (bzHybrid pts)) ) )
         (progn
            (when (and pt1 pt2 (eq *press *termkey))
              (put fig 'bezier (bzRect pt1 pt2))
              (setq *press *enterkey) ) ) [++end when++]
      (setq *press *enterkey) >


(object rectangle polygon)

<to input (obj pt f)
   (case f
      (mouse (mouseRect obj pt))
      (digi (digiRect obj pt)) >

<to initDiv (fig)
   (off $divFlg $horiDiv $vertDiv) >

<to divide (fig)
   (local (rlist bz h v rct w s)
      (when
         (or
            $horiDiv
            (and
               (not $divFlg)
               (on $divFlg)
               (divideDialog '$horiDiv '$vertDiv) ) )
         (setq rlist)
         (setq bz
            (mapcar (get fig 'bezier)
               '((x) (bez-pt x))))
         (setq w (div (sub (caar bz) (car (nth 1 bz))) $horiDiv))
         (setq s (div (sub (cdar bz) (cdr (last bz))) $vertDiv))
         (setq rct
            (cons
               (nth 2 bz)
               (cons
                  (add w (car (nth 2 bz)))
                  (add s (cdr (nth 2 bz))) ) ) )
         (for (j 0 $vertDiv)
            (for (i 0 $horiDiv)
               (push
                  (OffsetRect rct (mul i w) (mul j s))
                  rlist ) ) )
         (mapcar rlist
            '((x)
               (local (fig)
                  (setq fig (new (list 'empty 'rectangle)))
                  (adjBez fig (bzRect (car x) (cdr x)))
                  fig >

<to figTyp (fig)
   (local (bez d bbox)
      (setq bbox (get fig 'rgnBBox))
      (setq bez (get fig 'bezier))
      (setq d (not (find bez '((x) (not (pointp x))))))
      (cond
         ((and (eq (length bez) 4)
					 d 
					(rectTest bez) 
					(quadrat (car bbox)(cdr bbox)) )
            'Square )
         ((and d (not (rectTest bez)))
            'Polygon ) 
			(t 'Rectangle) >

t [rectangle.l]
