[text.l 09jan90]

(setq
   $teRectH 2000
   $teRectV 300 )

(object text picApp)

<to classify () 'alex>

<to t (obj name v)
   (from picApp t obj
      (winLoc 5 22 #(cons (add fmWidth 6) 90))
      #$teRectH
      (max v #$teRectV)
      name
      '((0.0) 500 . #$teRectV) )
   (with obj
      (slot teRec
         (TENew
            '#(cons2 4 4 $teRectH $teRectV)
            (InsetRect (viewRect (slot winPtr)) 4 4) ) ) )
   (te-clikloop (ptr (get obj 'terec)) clikfun)
   (teProp obj)
   (push obj *texte)
   (do start 'boss obj) >

<to close (*app)
   (zapUndo)
   (cut *app *texte)
   (with *app
      (TEDispose (slot teRec)) )
   (from picApp close *app) >

<to setUp (*app)
   (SetMenuBar *tMBar)
   (DrawMenuBar) >

<to begin (*app)
   (cut *app *texte)
   (push *app *texte)
   (with *app
      (TEActivate (slot teRec))
      (setq
         *undo (slot undo)
         *redo (slot redo)
         *mark (slot mark) ) )
   (setUndo)
   (setRedo) >

<to end (*app)
   (with *app
      (TEDeactivate (slot teRec))
      (slot undo *undo)
      (slot redo *redo)
      (slot mark *mark) >

[++++++
<to cleanUp (*app)
   (do hide 'fixMenu) >
++++++]

<to setCursor (*app pt)
   (localPort (get *app 'winPtr)
      (when (eq *port (FrontWindow))
         (GlobalToLocal pt)
            (SetCursor
               (if (inView pt *port)
                  (ptr (GetCursor iBeamCursor))
                  *arrow >

<to update (*app)
   (from docWin update *app
      '(()
         (TEUpdate (portRect *port) (get *app 'teRec)) >

<to grow (*app pt)
   (from docWin grow *app pt)
   (te-viewRect (ptr (get *app 'teRec)) (viewRect *port))
   (do refresh *app) >

<to zoom (*app n)
   (from docWin zoom *app n)
   (te-viewRect (ptr (get *app 'teRec)) (viewRect *port))
   (do refresh *app) >

<to scroll (*app cntl part pt)
   (from docWin scroll *app cntl part pt)
   (te-viewRect (ptr (get *app 'teRec))
      (viewRect *port) >

<to keyDown (*app c m)
   (with *app
      (if (zerop (bitand cmdKey m))
         (case c
            (3 [ENTER]
               )
            (9 [TAB]
               )
            ((28 29 30 31) [Arrows]
               )
            (t (teType c)) )
         (case c
            (30 [Up arrow]
               )
            (31 [Down arrow]
               )
            (t
               (when (setq m (method (MenuKey c) *app))
                  (m *app)
                  (HiliteMenu 0) >

<to autoKey (*app c m)
   (do keyDown *app c m) >

<to content (*app pt)
   (from picApp content *app pt
      '((pt)
         (with *app
            (local (teH)
               (setq teH (slot teRec))
               (make
                  "Select"
                  (list
                     (te-selStart (ptr teH))
                     (te-selEnd (ptr teH)) )
                  chgTESel
                  (progn
                     (TEClick pt (s-key) (slot teRec))
                     (list
                        (te-selStart (ptr teH))
                        (te-selEnd (ptr teH)) ) )
                  chgTESel >

<to able (*app)
   (local (teH d f m)
      (with *app
         (setq
            teH (slot teRec)
            d (flagp *app 'dirty)
            f (slot face)
            m (neq
               (word (add 32 (ptr teH)))
               (word (add 34 (ptr teH))) ) )
         (doMenu fileM
            t nil
            t nil
            t nil
            nil nil
            nil nil
            t nil
            d nil
            t nil
            (and d (slot vol)) nil
            nil nil
            t nil
            nil nil
            t nil )
         (doMenu editM
            *undo nil
            *redo nil
            nil nil
            m nil
            m nil
            *textClip nil
            m nil
            nil nil
            (not (zerop (te-teLength (ptr (slot teRec))))) nil )
         (doMenu styleM
            t nil
            nil nil
            t (zerop f)
            t (bit 0 f)
            t (bit 1 f)
            t (bit 2 f)
            t (bit 3 f)
            t (bit 4 f)
            t (bit 5 f)
            t (bit 6 f) >

<to idle (*app)
   (with *app
      (TEIdle (slot teRec))
      (local (v)
         (setq v
            (max
               #$teRectV
               (add
                  #(mul2 4)
                  (slot height)
                  (TEGetHeight 32767 0 (slot teRec)) ) ) )
         (unless (eq (slot size-v) v)
            (slot size-v v)
            (adjSBars *app) >

<to #(cmd fileM saveCmd) (*app)
   (saveText *app (get *app 'name)) >

<to #(cmd fileM saveAsCmd) (*app)
   (saveText *app) >

<to #(cmd fileM revertCmd) (*app)
   (local (vol nm)
      (setq
         vol (GetVol)
         nm (get *app 'name) )
      (SetVol (get *app 'vol))
      (do close *app)
      (put (loadText nm) 'vol (GetVol))
      (SetVol vol) >

<to #(cmd editM cutCmd) (*app)
   (make
      "Cut"
      (with *app
         (list
            *textClip
            (te-selStart (ptr (slot teRec)))
            (te-selEnd (ptr (slot teRec))) ) )
      '((x s e)
         (doTEInsert *textClip)
         (TESetSelect s e (get *app 'teRec))
         (setq *textClip x)
         (teProp *app) )
      nil
      '(nil
         (with *app
            (setq *textClip (getSelText (slot teRec)))
            (TEDelete (slot teRec)) )
         (teProp *app) >

<to #(cmd editM copyCmd) (*app)
   (make
      "Copy"
      (list *textClip)
      '((x) (setq *textClip x))
      nil
      '(nil
         (setq *textClip
            (getSelText (get *app 'teRec))) >

<to #(cmd editM pasteCmd) (*app)
   (local (teH)
      (setq teH (get *app 'teRec))
      (make
         "Paste"
         (list
            *textClip
            (te-selStart (ptr teH))
            (te-selEnd (ptr teH))
            (getSelText teh) )
         '((x s e y)
            (local (teH)
               (setq teH (get *app 'teRec))
               (TESetSelect s (te-selEnd (ptr teH)) teH)
               (doTEInsert y)
               (TESetSelect s e teH)
               (setq *textClip x)
               (teProp *app) ) )
         nil
         '(nil
            (doTEInsert *textClip)
            (teProp *app) >

<to #(cmd editM clearCmd) (*app)
   (make
      "Clear"
      (with *app
         (list
            (getSelText (slot teRec))
            (te-selStart (ptr (slot teRec)))
            (te-selEnd (ptr (slot teRec))) ) )
      '((x s e)
         (doTEInsert x)
         (TESetSelect s e (get *app 'teRec))
         (teProp *app) )
      nil
      '(nil
         (TEDelete (get *app 'teRec))
         (teProp *app) >

<to #(cmd editM allCmd) (*app)
   (local (teH)
      (setq teH (get *app 'teRec))
      (make
         "Select All"
         (list (te-selStart (ptr teH)) (te-selEnd (ptr teH)))
         chgTESel
         (0 32767)
         chgTESel >

<to #fontM (*app i)
   (local (tx)
   (setq tx (GetSelText (get *app 'terec)))
   (make
      "Change Font"
      (with *app
         (list tx
            (te-selStart (ptr (slot teRec)))
            (te-selEnd (ptr (slot teRec))) ) )
      '((x s e)
         (doTeInsert x)
         (TESetSelect s e (get *app 'teRec)) )
      (list
         (GetFNum
            (GetItem
               (GetResource "MENU" fontM)
               i) ) )
      doTeFont >

<to #(cmd styleM colorCmd) (*app)
   (local (c tx)
      (when (setq c (tintDialog (car *tints)))
         (setq tx (GetSelText (get *app 'terec)))
         (make
            "Change Color"
            (with *app
               (list tx
                  (te-selStart (ptr (slot teRec)))
                  (te-selEnd (ptr (slot teRec))) ) )
            '((x s e)
               (doTeInsert x)
               (TESetSelect s e (get *app 'teRec)) )
            (list c)
               '((c)
                  (doTEColor c)
                  (doYMCK c) >


<to #(cmd styleM plainCmd) (*app)
   (local ()
         (make
            "Change Style"
            (with *app
               (list (GetSelText (get *app 'terec))
                  (te-selStart (ptr (slot teRec)))
                  (te-selEnd (ptr (slot teRec))) ) )
            '((x s e)
               (doTeInsert x)
               (TESetSelect s e (get *app 'teRec))
               (teProp *app) )
            (list 0)
            '((n)
               (doTEFace n) >

<to #(cmd styleM boldCmd) (*app)
      (local ()
         (make
            "Change Style"
            (with *app
               (list (GetSelText (get *app 'terec))
                  (te-selStart (ptr (slot teRec)))
                  (te-selEnd (ptr (slot teRec))) ) )
            '((x s e)
               (doTeInsert x)
               (TESetSelect s e (get *app 'teRec))
               (teProp *app) )
            (list bold)
            '((b)
               (doTEFace b) >

<to #(cmd styleM italicCmd) (*app)
      (local ()
         (make
            "Change Style"
            (with *app
               (list (GetSelText (get *app 'terec))
                  (te-selStart (ptr (slot teRec)))
                  (te-selEnd (ptr (slot teRec))) ) )
            '((x s e)
               (doTeInsert x)
               (TESetSelect s e (get *app 'teRec))
               (teProp *app) )
            (list italic)
            '((b)
               (doTEFace b) >

<to #(cmd styleM underlCmd) (*app)
      (local ()
         (make
            "Change Style"
            (with *app
               (list (GetSelText (get *app 'terec))
                  (te-selStart (ptr (slot teRec)))
                  (te-selEnd (ptr (slot teRec))) ) )
            '((x s e)
               (doTeInsert x)
               (TESetSelect s e (get *app 'teRec))
               (teProp *app) )
            (list underline)
            '((b)
               (doTEFace b) >

<to #(cmd styleM outlCmd) (*app)
      (local ()
         (make
            "Change Style"
            (with *app
               (list (GetSelText (get *app 'terec))
                  (te-selStart (ptr (slot teRec)))
                  (te-selEnd (ptr (slot teRec))) ) )
            '((x s e)
               (doTeInsert x)
               (TESetSelect s e (get *app 'teRec))
               (teProp *app) )
            (list outline)
            '((b)
               (doTEFace b) >

<to #(cmd styleM shadowCmd) (*app)
      (local ()
         (make
            "Change Style"
            (with *app
               (list (GetSelText (get *app 'terec))
                  (te-selStart (ptr (slot teRec)))
                  (te-selEnd (ptr (slot teRec))) ) )
            '((x s e)
               (doTeInsert x)
               (TESetSelect s e (get *app 'teRec))
               (teProp *app) )
            (list shadow)
            '((b)
               (doTEFace b) >

<to #(cmd styleM condenseCmd) (*app)
      (local ()
         (make
            "Change Style"
            (with *app
               (list (GetSelText (get *app 'terec))
                  (te-selStart (ptr (slot teRec)))
                  (te-selEnd (ptr (slot teRec))) ) )
            '((x s e)
               (doTeInsert x)
               (TESetSelect s e (get *app 'teRec))
               (teProp *app) )
            (list condense)
            '((b)
               (doTEFace b) >

<to #(cmd styleM extendCmd) (*app)
      (local ()
         (make
            "Change Style"
            (with *app
               (list (GetSelText (get *app 'terec))
                  (te-selStart (ptr (slot teRec)))
                  (te-selEnd (ptr (slot teRec))) ) )
            '((x s e)
               (doTeInsert x)
               (TESetSelect s e (get *app 'teRec))
               (teProp *app) )
            (list extend)
            '((b)
               (doTEFace b) >

<to #sizeM (*app i)
   (local ()
      (make
         "Change Size"
            (with *app
               (list (GetSelText (get *app 'terec))
                  (te-selStart (ptr (slot teRec)))
                  (te-selEnd (ptr (slot teRec))) ) )
            '((x s e)
               (doTeInsert x)
               (TESetSelect s e (get *app 'teRec))
               (teProp *app) )
         (list i)
         '((i)
            (doTESize
                 (nth (sub1 i)
                  (9 10 12 14 18 20 24) >

<to #ymckM (*app i)
   (local ()
      (make
         "Change Color"
            (with *app
               (list (GetSelText (get *app 'terec))
                  (te-selStart (ptr (slot teRec)))
                  (te-selEnd (ptr (slot teRec))) ) )
            '((x s e)
               (doTeInsert x)
               (TESetSelect s e (get *app 'teRec))
               (teProp *app) )
         (list i)
         '((i)
            (doTEColor (nth (sub1 i) *tints)) >

<to make (obj)
   (local (s l m x n1 n2)
      (setq
         s (teStyles (GetStylHandle (get obj 'teRec)))
         l (teRuns (GetStylHandle (get obj 'teRec)))
         m (pop l) )
      (mapcon l
         '((l)
            (setq
               x (cddr (nth (cdar l) s))
               n1 (caar l)
               n2 (if (cdr l) (caadr l) m) )
            (list
               (pack
                  (pop x) [Font]
                  (bitr 8 (pop x)) [Face]
                  (pop x) ) [Size]
               (pop x) [Color]
               (killBlanks
                  (stuff
                     (add n1 (ptr (te-hText (ptr (get obj 'teRec)))))
                     (sub n2 n1) >

t [text.l]
