[texted.l 05dec89]

<de txLen (txt)
   (local (n)
      (zero n)
      (mapc txt
         '((x)
            (when (pairp x)
               (inc n
                  (if (pointp x)
                     1
                     (length x) ) ) ) ) )
      n >

<de selTx (fig pt)
   (local (txt n fi h v w)
      (setq txt (get fig 'text1))
      (zero n v)
      (catch 1
         (while txt
            (setq s (pop txt))
            (cond
               ((numberp s)
                  (textAttr s)
                  (setq fi (GetFontInfo))
                  (pop txt) )
               ((pointp s)
                  (when (lessp (cdr pt) v)
                     (throw 1) )
                  (inc n)
                  (setq
                     h (car s)
                     v (add (cdr s) (cadr fi)) ) )
               ((lessp v (cdr pt))
                  (inc n (length s)) )
               (t
                  (while s
                     (setq w
                        (if (minusp (car s))
                           (mul
                              (minus (pop s))
                              (CharWidth 32) )
                           (CharWidth (pop s)) ) )
                     (when
                        (lessp
                           (add (car pt) (div2 w))
                           (inc h w) )
                        (throw 1) )
                     (inc n) ) ) ) ) )
      n >

<de hiTextDone ()
   (rplaca res
      (cons2
         (sub1 (caar res))
         (min
            (cdar res)
            (sub v (car fi)) )
         h
         (add v (cadr fi)) ) )
   (throw 1) >

<de countText ()
   (if res
      (when (zerop (dec n))
         (hiTextDone) )
      (when (minusp (dec m))
         (setq f (add (car fi) (cadr fi)))
         (push
            (cons h (sub v (car fi)))
            res )
         (when (zerop n)
            (hiTextDone) >

<de hiText (fig sel1 sel2)
   (and sel1 sel2 (lessp sel2 sel1) (xchg sel1 sel2))
   (local (res m n txt fi s h v f)
      (put fig 'sel2 sel2)
      (setq res)
      (when (setq m (put fig 'sel1 sel1))
         (setq
            n (sub sel2 m)
            txt (get fig 'text1) )
         (zero h v f)
         (catch 1
            (while txt
               (setq s (pop txt))
               (cond
                  ((numberp s)
                     (textAttr s)
                     (setq fi (GetFontInfo))
                     (pop txt) )
                  ((pointp s)
                     (countText)
                     (when res
                        (rplaca res
                           (cons2
                              (caar res)
                              (min (cdar res) (sub v (car fi)))
                              h
                              (add v (cadr fi)) ) )
                        (push
                           (cons (car s) (sub (cdr s) (car fi)))
                           res ) )
                     (setq
                        h (car s)
                        v (cdr s) ) )
                  ((and res (lessp (length s) n))
                     (dec n (length s))
                     (inc h (StringWidth s)) )
                  ((and (not res) (lessp (length s) m))
                     (dec m (length s))
                     (inc h (StringWidth s)) )
                  (t
                     (while s
                        (countText)
                        (inc h
                           (if (minusp (car s))
                              (mul
                                 (minus (pop s))
                                 (CharWidth 32) )
                              (CharWidth (pop s)) ) ) ) ) ) )
            (unless res
               (setq res (list (cons2 h v (add1 h) (add v f)))) )
            (textAttr 0) ) )
      (put fig 'hiText
         (if (pointp (car res))
            (rplaca res
               (cons
                  (car res)
                  (cons
                     (add1 (caar res))
                     (add (cdar res) f) ) ) )
            res >

<de justify (s len j)
   (local (n l)
      (setq n (div len (CharWidth 32)))
      (while (minusp (car s))
         (pop s) )
      (while (minusp (last s))
         (inc n)
         (shift s) )
      (when (find s minusp)
         (setq l)
         (reptn n
            (until
               (progn
                  (unless l (setq l s))
                  (minusp (car l)) )
               (pop l) )
            (rplaca l (sub1 (car l)))
            (pop l) >

<de formText (fig)
   (local (g txt fi res ix s v v1 v2 h1 h2 l1 l2 len w n)
      (setq
         g (get fig 'graf)
         txt (get fig 'text) )
      (textAttr (car txt))
      (setq
         fi (GetFontInfo)
         v (top (car g))
         v1 (add v (car fi))
         v2 (add v1 (cadr fi))
         l1 (raster v g)
         l2 (raster v2 g)
         res (chop 2 txt)
         ix (tail res)
         len 0 )
      (catch 1
         (while txt
            (if (numberp (setq s (pop txt)))
               (progn
                  (textAttr s)
                  (setq fi (GetFontInfo))
                  (nconc ix (list s (pop txt)))
                  (when (lessp (sub v1 v) (car fi))
                     (mapc res
                        '((x)
                           (and
                              (pointp x)
                              (eq v1 (cdr x))
                              (rplacd x (add v (car fi))) ) ) )
                     (setq
                        v1 (add v (car fi))
                        v2 (add v1 (cadr fi)) )
                     (unless (lessp v2 (bottom (car g)))
                        (throw 1) ) )
                  (setq ix (tail ix)) )
               (while s
                  (setq n 1)
                  (when (lessp 32 (car s))
                     (while (and (nth n s) (lessp 32 (nth n s)))
                        (inc n) ) )
                  (setq w (chop n s))
                  (while
                     (and w
                        (or
                           (lessp len (StringWidth w))
                           (eq 13 (car w)) ) )
                     (when (or (null l1) (null l2) (eq 13 (car w)))
                        (setq
                           v (add v2 (cadddr fi))
                           v1 (add v (car fi))
                           v2 (add v1 (cadr fi)) )
                        (unless (lessp v2 (bottom (car g)))
                           (throw 1) )
                        (setq
                           l1 (raster v g)
                           l2 (raster v2 g) ) )
                     (and
                        (neq 13 (car w))
                        ix
                        (pairp (car ix))
                        (not (pointp (car ix)))
                        (justify (car ix) len 'center) )
                     (setq
                        h1 (max (car l1) (car l2))
                        h2 (min (cadr l1) (cadr l2)) )
                     (cond
                        ((and (caddr l2) (lessp (caddr l2) (cadr l1)))
                           (setq l2 (cddr l2)) )
                        ((and (caddr l1) (lessp (caddr l1) (cadr l2)))
                           (setq l1 (cddr l1)) )
                        ((setq  l1 (cddr l1)  l2 (cddr l2))) )
                     (setq len (sub h2 h1))
                     (unless (lessp 32 (car w))
                        (pop w)
                        (zero n) )
                     (nconc1 ix (cons h1 v1))
                     (setq ix (tail ix)) )
                  (when w
                     (dec len (StringWidth w))
                     (if (or (numberp (car ix)) (pointp (car ix)))
                        (progn
                           (rplacd ix (list w))
                           (setq ix (tail ix)) )
                        (nconc (car ix) w) ) ) ) ) ) )
      (textAttr 0)
      (hiText fig)
      (put fig 'text1 res) >


(object texted content)

<to draw (obj)
   (showText (get obj 'text1))
   [(draw (get obj 'graf))]
   (PenMode patXor)
   (mapc (get obj 'hiText) PaintRect) >

<to content (fig pt)
   (local (*spot)
      (setq *spot)
      (PenMode patXor)
      (if (zerop (bitand shiftKey (ev-modifiers *event)))
         (local (i l)
            (mapc (get fig 'hiText) PaintRect)
            (setq i (selTx fig pt))
            (PaintRect (car (setq l (hiText fig i i))))
            (drag pt
               '((oldPt newPt)
                  (mapc
                     (diff l
                        (setq l
                           (hiText
                              fig
                              i
                              (selTx fig newPt) ) ) )
                     PaintRect ) ) ) )
         (mapc
            (diff
               (get fig 'hiText)
               (hiText
                  fig
                  (get fig 'sel1)
                  (selTx fig pt)))
            PaintRect >

t [texted.l]
