/* macColor.c
 * 16jan90abu
 */

#include "pico.h"
#include "mac.h"
#include <ColorToolbox.h>

/* Prototypes */
static pico pOpenCPort(pico);
static pico pRGBForeColor(pico);
static pico pRGBBackColor(pico);
static pico pSetCPixel(pico);
static pico pNewPixMap(void);
static pico pDisposPixMap(pico);
static pico pCopyPixMap(pico);
static pico pSetPortPix(pico);
static pico pGetGDevice(void);
static pico pSetGDevice(pico);
static pico pGetMaxDevice(pico);
static pico pGetColor(pico);
static pico pNewCWindow(pico);

symInit colorSyms[] = {
	{"OPENCPORT",		pOpenCPort},	/* Color QuickDraw */
	{"RGBFORECOLOR",	pRGBForeColor},
	{"RGBBACKCOLOR",	pRGBBackColor},
	{"SETCPIXEL",		pSetCPixel},
	{"NEWPIXMAP",		pNewPixMap},
	{"DISPOSPIXMAP",	pDisposPixMap},
	{"COPYPIXMAP",		pCopyPixMap},
	{"SETPORTPIX",		pSetPortPix},
	{"GETGDEVICE",		pGetGDevice},   /* Device Manager */
	{"SETGDEVICE",		pSetGDevice},
	{"GETMAXDEVICE",	pGetMaxDevice},
	{"GETCOLOR",		pGetColor},		/* Color Picker */
	{"NEWCWINDOW",		pNewCWindow},   /* Window Manager */
	NULL
};


pico pOpenCPort(x)
pico x;
{
	OpenCPort((CGrafPtr)nextPtr(&x));
	return tSym;
}

pico pRGBForeColor(x)
pico x;
{
	RGBColor c;

	nextColor(&x,&c);
	RGBForeColor(&c);
	return tSym;
}

pico pRGBBackColor(x)
pico x;
{
	RGBColor c;

	nextColor(&x,&c);
	RGBBackColor(&c);
	return tSym;
}

pico pSetCPixel(x)
pico x;
{
	integer h,v;
	RGBColor cPix;

	h = (integer)nextNum(&x);
	v = (integer)nextNum(&x);
	nextColor(&x,&cPix);
	SetCPixel(h,v,&cPix);
	return tSym;
}

pico pNewPixMap()
{
	return boxPtr(NewPixMap());
}

pico pDisposPixMap(x)
pico x;
{
	Handle h;

	DisposPixMap(nextPtr(&x));
	return tSym;
}

pico pCopyPixMap(x)
pico x;
{
	Handle srcPM;

	srcPM = nextPtr(&x);
	CopyPixMap(srcPM, nextPtr(&x));
	return tSym;
}

pico pSetPortPix(x)
pico x;
{
	SetPortPix((PixMapHandle)nextNum(&x));
	return tSym;
}

pico pGetGDevice()
{
	return boxPtr(GetGDevice());
}

pico pSetGDevice(x)
pico x;
{
	SetGDevice((GDHandle)nextNum(&x));
	return tSym;
}

pico pGetMaxDevice(x)
pico x;
{
	Rect r;

	nextRect(&x,&r);
	return boxPtr(GetMaxDevice(&r));
}

pico pGetColor(x)
pico x;
{
	Point where;
	Str255 prompt;
	RGBColor in, out;

	where.h = 0;
	where.v = 0;
	nextString(&x,prompt);
	nextColor(&x,&in);
	if (!GetColor(where, prompt, &in, &out))
		return nilSym;
	return boxColor(out.red, out.green, out.blue);
}

pico pNewCWindow(x)
pico x;
{
	Ptr wStorage;
	Rect boundsRect;
	Str255 title;
	bool visible;
	integer procID;
	WindowPtr behind;
	bool goAwayFlag;

	wStorage = nextPtr(&x);
	nextRect(&x,&boundsRect);
	nextString(&x,title);
	visible = nextBool(&x);
	procID = (integer)nextNum(&x);
	behind = (WindowPtr)nextPtr(&x);
	goAwayFlag = nextBool(&x);
	return boxPtr(NewCWindow(wStorage, &boundsRect, title, visible,
									procID, behind, goAwayFlag, (long)EVAL1(x)));
}
