/* macIO.c
 * 25jun89abu
 */

#include "pico.h"
#include "mac.h"
#include <SCSIMgr.h>

/* Prototypes */
static pico pOpenDriver(pico);
static pico pCloseDriver(pico);
static pico pControl(pico);
static pico pSCSIReset(void);
static pico pSCSIGet(void);
static pico pSCSISelect(pico);
static pico pSCSICmd(pico);
static pico pSCSIRead(pico);
static pico pSCSIWrite(pico);
static pico pSCSIComplete(pico);
static pico pSCSIStat(void);

symInit macioSyms[] = {
	{"OPENDRIVER",		pOpenDriver},
	{"CLOSEDRIVER",		pCloseDriver},
	{"CONTROL",			pControl},
	{"SCSIRESET",		pSCSIReset},
	{"SCSIGET",			pSCSIGet},
	{"SCSISELECT",		pSCSISelect},
	{"SCSICMD",			pSCSICmd},
	{"SCSIREAD",		pSCSIRead},
	{"SCSIWRITE",		pSCSIWrite},
	{"SCSICOMPLETE",	pSCSIComplete},
	{"SCSISTAT",		pSCSIStat},
	NULL
};

static SCSIInstr tib[2] = {{scNoInc,0,0},{scStop,0,0}};


pico pOpenDriver(x)
pico x;
{
	Str255 name;
	integer refNum;
	OSErr n;

	nextString(&x,name);
	n = OpenDriver(name, &refNum);
    setVal(nextVar(&x), boxNum(refNum));
    return boxNum(n);
}

pico pCloseDriver(x)
pico x;
{
	return boxNum(CloseDriver((integer)nextNum(&x)));
}

pico pControl(x)
pico x;
{
	integer refNum,csCode;

	refNum = (integer)nextNum(&x);
	csCode = (integer)nextNum(&x);
	return boxNum(Control(refNum,csCode,nextPtr(&x)));
}

pico pSCSIReset()
{
	return boxNum(SCSIReset());
}

pico pSCSIGet()
{
	return boxNum(SCSIGet());
}

pico pSCSISelect(x)
pico x;
{
	return boxNum(SCSISelect((integer)nextNum(&x)));
}

pico pSCSICmd(x)
pico x;
{
	register integer i;
	unsigned char buffer[128];

	i = 0;
	do
		buffer[i++] = (unsigned char)nextNum(&x);
	while (isCell(x));
	return boxNum(SCSICmd(buffer, i));
}

pico pSCSIRead(x)
pico x;
{
	tib[0].scParam1 = nextNum(&x);
	tib[0].scParam2 = nextNum(&x);
	return boxNum(SCSIRead(tib));
}

pico pSCSIWrite(x)
pico x;
{
	tib[0].scParam1 = nextNum(&x);
	tib[0].scParam2 = nextNum(&x);
	return boxNum(SCSIWrite(tib));
}

pico pSCSIComplete(x)
pico x;
{
	register pico statSym, msgSym;
	integer stat, message;
	OSErr res;

	statSym = nextVar(&x);
	msgSym = nextVar(&x);
	res = SCSIComplete(&stat, &message, nextNum(&x));
	setVal(statSym, boxNum(stat));
	setVal(msgSym, boxNum(message));
	return boxNum(res);
}

pico pSCSIStat()
{
	return boxNum(SCSIStat());
}
