/* macMem.c
 * 18jul90abu
 */

#include "pico.h"
#include "mac.h"

/* Prototypes */
static pascal long setGZDefProc(Size);

static pico pMoreMasters(void);
static pico pNewHandle(pico);
static pico pDisposHandle(pico);
static pico pGetHandleSize(pico);
static pico pGetPtrSize(pico);
static pico pSetHandleSize(pico);
static pico pSetPtrSize(pico);
static pico pFreeMem(void);
static pico pHLock(pico);
static pico pHUnlock(pico);
static pico pHPurge(pico);
static pico pHNoPurge(pico);
static pico pSetGrowZone(pico);
static pico pGZSaveHnd(void);

symInit memSyms[] = {
	{"MOREMASTERS",		pMoreMasters},
	{"NEWHANDLE",		pNewHandle},
	{"DISPOSHANDLE",	pDisposHandle},
	{"GETHANDLESIZE",	pGetHandleSize},
	{"GETPTRSIZE",		pGetPtrSize},
	{"SETHANDLESIZE",	pSetHandleSize},
	{"SETPTRSIZE",		pSetPtrSize},
	{"FREEMEM",			pFreeMem},
	{"HLOCK",			pHLock},
	{"HUNLOCK",			pHUnlock},
	{"HPURGE",			pHPurge},
	{"HNOPURGE",		pHNoPurge},
	{"SETGROWZONE",		pSetGrowZone},
	{"GZSAVEHND",		pGZSaveHnd},
	NULL
};


pico pMoreMasters()
{
	MoreMasters();
	return checkMemErr();
}

pico pNewHandle(x)
pico x;
{
	return boxPtr(NewHandle((Size)nextNum(&x)));
}

pico pDisposHandle(x)
pico x;
{
	DisposHandle((Handle)nextNum(&x));
	return checkMemErr();
}

pico pGetHandleSize(x)
pico x;
{
	return boxNum(GetHandleSize((Handle)nextNum(&x)));
}

pico pGetPtrSize(x)
pico x;
{
	return boxNum(GetPtrSize((Ptr)nextNum(&x)));
}

pico pSetHandleSize(x)
pico x;
{
	Handle h;

	h = (Handle)nextNum(&x);
	SetHandleSize(h, (Size)nextNum(&x));
	return checkMemErr();
}

pico pSetPtrSize(x)
pico x;
{
	Ptr p;

	p = (Ptr)nextNum(&x);
	SetPtrSize(p, (Size)nextNum(&x));
	return checkMemErr();
}

pico pFreeMem()
{
	return boxNum(FreeMem());
}

pico pHLock(x)
pico x;
{
	Handle h;

	HLock(h = (Handle)nextNum(&x));
	return boxPtr(*h);
}

pico pHUnlock(x)
pico x;
{
	Handle h;

	HUnlock(h = (Handle)nextNum(&x));
	return boxPtr(h);
}

pico pHPurge(x)
pico x;
{
	HPurge((Handle)nextNum(&x));
	return checkMemErr();
}

pico pHNoPurge(x)
pico x;
{
	HNoPurge((Handle)nextNum(&x));
	return checkMemErr();
}

pico setGZDef;

pascal long setGZDefProc(cbNeeded)
Size cbNeeded;
{
	long res;

	SetUpA5();
	res = unBox(apply1(setGZDef,boxNum(cbNeeded)));
	RestoreA5();
	return res;
}

pico pSetGrowZone(x)
pico x;
{
	SetGrowZone(nextProc(&x, &setGZDef, (ProcPtr)setGZDefProc));
	return tSym;
}

pico pGZSaveHnd()
{
	return boxPtr(GZSaveHnd());
}

/* Pico entry */
pico dynHandle(h)
Handle h;
{
	if (h)
		return dynamo(boxFun(pDisposHandle), boxNum(h));
	return dynamo(boxFun(Quote), nilSym);
}
