/* macOs.c
 * 03feb89abu
 */

#include "pico.h"
#include "mac.h"

/* Prototypes */
static pico pHandToHand(pico);
static pico pPtrToHand(pico);
static pico pSysBeep(pico);

symInit osSyms[] = {
	{"HANDTOHAND",		pHandToHand},
	{"PTRTOHAND",		pPtrToHand},
	{"SYSBEEP",			pSysBeep},
	NULL
};

pico pHandToHand(x)
pico x;
{
	Handle h;

	h = (Handle)nextNum(&x);
	if (HandToHand(&h) != noErr)
		return nilSym;
	return boxPtr(h);
}
pico pPtrToHand(x)
pico x;
{
	Ptr srcPtr;
	Handle dstHndl;

	srcPtr = (Ptr)nextNum(&x);
	if (PtrToHand(srcPtr, &dstHndl, nextNum(&x)) != noErr)
		return nilSym;
	return boxPtr(dstHndl);
}

pico pSysBeep(x)
pico x;
{
	SysBeep((integer)nextNum(&x));
	return tSym;
}
