/* macPrim.c
 * 28jun90abu
 */

#include "pico.h"
#include "stack.h"
#include "mac.h"
#include <Color.h>
#include "HyperXCmd.h"

/* Prototypes */
static pico DoMenu(pico);
static pico InPort(pico);
static pico InView(pico);
static pico MouseInCtl(pico);
static pico pRGB(pico);
static pico LocalClip(pico);
static pico LocalLock(pico);
static pico LocalPort(pico);
static pico Pustel(pico);
static pico GetSelText(pico);
static pico pXcmd(pico);

symInit macSyms[] = {
	{"DOMENU",		DoMenu},
	{"INPORT",		InPort},
	{"INVIEW",		InView},
	{"MOUSEINCTL",	MouseInCtl},
	{"RGB",			pRGB},
	{"LOCALCLIP",	LocalClip},
	{"LOCALLOCK",	LocalLock},
	{"LOCALPORT",	LocalPort},
	{"PUSTEL",		Pustel},
	{"GETSELTEXT",	GetSelText},
	{"XCMD",		pXcmd},
	NULL
};


/* Enable/Disable menu items */
pico DoMenu(x)
pico x;
{
	MenuHandle mh;
	integer cnt,i;

	if (!(mh = (MenuHandle)(GetResource('MENU',(integer)nextNum(&x)))))
		return nilSym;
	cnt = CountMItems(mh);
	for (i = 1; i <= cnt; ++i) {
		if (nextBool(&x))
			EnableItem(mh,i);
		else
			DisableItem(mh,i);
		CheckItem(mh, i, nextBool(&x));
	}
	return tSym;
}

/* Test if point is in window's portRect */
pico InPort(x)
pico x;
{
	Point pt;
	WindowPtr win;

	nextPoint(&x,&pt);
	win = (WindowPtr)nextNum(&x);
	return PtInRect(pt,&win->portRect) ? tSym : nilSym;
}

/* Test if point is in window's viewRect */
pico InView(x)
pico x;
{
	Point pt;
	WindowPtr win;
	Rect r;

	nextPoint(&x,&pt);
	win = (WindowPtr)nextNum(&x);
	r = win->portRect;
	r.right -= 15;
	r.bottom -= 15;
	return PtInRect(pt,&r) ? tSym : nilSym;
}

pico MouseInCtl(x)
pico x;
{
	DialogPtr theDialog;
	integer itemNo, itemType;
	GrafPtr savePort;
	Handle item;
	Rect box;
	Point pt;

	theDialog = (DialogPtr)nextNum(&x);
	itemNo = (integer)nextNum(&x);
	GetPort(&savePort);
	SetPort(theDialog);
	GetDItem(theDialog, itemNo, &itemType, &item, &box);
	GetMouse(&pt);
	SetPort(savePort);
	return boxBool(PtInRect(pt,&box));
}

pico pRGB(x)
pico x;
{
	register number y,m,c,k;

	y = nextNum(&x);
	m = nextNum(&x);
	c = nextNum(&x);
	k = nextNum(&x);
	y = 65535 * minNumber(100, (y + k));
	m = 65535 * minNumber(100, (m + k));
	c = 65535 * minNumber(100, (c + k));
	return boxColor(65535-c/100, 65535-m/100, 65535-y/100);
}

pico LocalClip(x)
register pico x;
{
	register pico y;
	RgnHandle rgn;
	Rect rct;

	y = EVAL1(x);
	x = cdr(x);
	GetClip(rgn = NewRgn());
	if (isNum(y))
		SetClip(unBox(y));
	else if (isRect(y)) {
		unBoxRect(y,&rct);
		ClipRect(&rct);
	}
	else
		errObj(y, "Rect or Rgn expected");
	x = evalBody(x);
	SetClip(rgn);
	DisposeRgn(rgn);
	return x;
}

pico LocalLock(x)
pico x;
{
	Handle h;

	HLock(h = (Handle)nextNum(&x));
	x = evalBody(x);
	HUnlock(h);
	return x;
}

pico LocalPort(x)
pico x;
{
	GrafPtr savePort;

	GetPort(&savePort);
	SetPort((GrafPtr)nextNum(&x));
	setVal(portSym, boxNum(thePort));
	x = evalBody(x);
	SetPort(savePort);
	setVal(portSym, boxNum(thePort));
	return x;
}

pico Pustel(x)
pico x;
{
	register short c;
	register Ptr p;
	register number h,v,dh,dv;
	register unsigned long bytes;
	CGrafPtr port;
	PixMapPtr pm;
	Point pt;
	Rect rct;
	RGBColor col;

	nextColor(&x,&col);						/* Pustel color */
	c = Color2Index(&col) & 0xFF;
	port = (CGrafPtr)nextNum(&x);
	nextRect(&x,&rct);
	dv = dh = nextNum(&x);
	if (isCell(x))
		dv = nextNum(&x);
	pm = *port->portPixMap;
	if (pm->pixelSize != 8)
		return nilSym;
	p = pm->baseAddr;
	bytes = pm->rowBytes & 0x1FFF;
	HideCursor();
	for (v = rct.top; v < rct.bottom; v += dv) {
		for (h = rct.left; h < rct.right; h += dh) {
			pt.h = h;
			pt.v = v;
			if (PtInRgn(pt,port->visRgn)) {
				LocalToGlobal(&pt);
				*(p + (long)pt.h + (long)pt.v*bytes) = c;
			}
		}
	}
	ShowCursor();
	return tSym;
}

pico GetSelText(x)
pico x;
{
	register TEHandle t;
	register number s;
	Handle h;

	t = (TEHandle)nextNum(&x);
	s = (*t)->selStart;
	if (PtrToHand(*(*t)->hText + s, &h, (*t)->selEnd-s) != noErr)
		return nilSym;
	push(dynHandle(h));
	tos = newCell(tos, dynHandle((Handle)GetStylScrap(t)));
	return pop();
}

/* Arguments and results */
pico boxColor(red,green,blue)
integer red, green, blue;
{
	return packNum(red >> 6, green >> 6, blue >> 6);
}

void unBoxColor(x,col)
register pico x;
register RGBColor *col;
{
	register number n;

	NEEDNUM(x);
	n = unBox(x);
	col->red   = n >> 14 & 0xFFC0;
	col->green = n >>  4 & 0xFFC0;
	col->blue  = n <<  6 & 0xFFC0;
}

void nextColor(p,col)
register pico *p;
RGBColor *col;
{
	unBoxColor(EVAL1(*p),col);
	*p = cdr(*p);
}

pico boxStyle(s)
register TextStyle *s;
{
	return
		newCell(boxNum(s->tsFont),
			newCell(boxNum(s->tsFace),
				newCell(boxNum(s->tsSize),
					newCell(boxColor(s->tsColor.red,s->tsColor.green,s->tsColor.blue),
						nilSym ) ) ) );
}

void unBoxStyle(x,s)
register pico x;
register TextStyle *s;
{
	NEEDLIST(x);
	s->tsFont = (integer)unBox(car(x));
	x = cdr(x);
	s->tsFace = (Style)unBox(car(x));
	x = cdr(x);
	s->tsSize = (integer)unBox(car(x));
	x = cdr(x);
	unBoxColor(car(x),(RGBColor*)&s->tsColor); /* Cast: Stupid TextEdit.h of LSC */
}

void nextStyle(p,s)
register pico *p;
TextStyle *s;
{
	unBoxStyle(EVAL1(*p),s);
	*p = cdr(*p);
}

pico checkMemErr()
{
	return  MemError() ? nilSym : tSym;
}

pico checkResErr()
{
	return  ResError() ? nilSym : tSym;
}

bool nextBool(p)
register pico *p;
{
	register pico x;

	x = EVAL1(*p);
	*p = cdr(*p);
	return  isNil(x) ?  NO : YES;
}

pico nextVar(p)
register pico *p;
{
	register pico sym;

	sym = car(*p);
	*p = cdr(*p);
	NEEDSYM(sym);
	CHECKSYM(sym);
	return sym;
}

StringPtr nextString(p,buf)
register pico *p;
register StringPtr buf;
{
	register pico x;
	register StringPtr s;
	register int c;

	x = EVAL1(*p);
	*p = cdr(*p);
	s = buf;
	*s++ = strLength(x);
	while (isCell(x)) {
		c = unBox(car(x));
		if (c >= 0)
			*s++ = c;
		else do
			*s++ = ' ';
		while (++c);
		x = cdr(x);
	}
	return buf;
}

void nextPoint(p,pt)
register pico *p;
register Point *pt;
{
	register pico x;

	unBoxPoint(EVAL1(*p),pt);
	*p = cdr(*p);
}

void nextRect(p,r)
register pico *p;
Rect *r;
{
	unBoxRect(EVAL1(*p),r);
	*p = cdr(*p);
}

ProcPtr nextProc(p, def, foo)
register pico *p, *def;
ProcPtr foo;
{
	register pico x;

	x = EVAL1(*p);
	*p = cdr(*p);
	if (isNum(x))
		return (ProcPtr)unBox(x);
	if (!isCell(x))
		return (ProcPtr)NULL;
	*def = x;
	return foo;
}

pico fetchB(x,offs)
pico x;
integer offs;
{
	register char *adr;
	char old;

	adr = (char*)nextNum(&x) + offs;
	if (isNil(x = EVAL1(x)))
		return boxNum(*adr);
	NEEDNUM(x);
	old = *adr;
	*adr = unBox(x);
	return boxNum(old);
}

pico fetchW(x,offs)
pico x;
int offs;
{
	register integer *adr;
	integer old;

	adr = (integer*)((char*)nextNum(&x) + offs);
	if (isNil(x = EVAL1(x)))
		return boxNum(*adr);
	NEEDNUM(x);
	old = *adr;
	*adr = unBox(x);
	return boxNum(old);
}

pico fetchL(x,offs)
pico x;
int offs;
{
	register long *adr;
	long old;

	adr = (long*)((char*)nextNum(&x) + offs);
	if (isNil(x = EVAL1(x)))
		return boxNum(*adr);
	NEEDNUM(x);
	old = *adr;
	*adr = unBox(x);
	return boxNum(old);
}

pico fetchPoint(x,offs)
pico x;
int offs;
{
	register Point *adr;
	Point old;

	adr = (Point*)((char*)nextNum(&x) + offs);
	if (!isCell(x))
		return newCell(boxNum(adr->h), boxNum(adr->v));
	old = *adr;
	nextPoint(&x,adr);
	return newCell(boxNum(old.h), boxNum(old.v));
}

pico fetchRect(x,offs)
pico x;
int offs;
{
	register Rect *adr;
	Rect old;

	adr = (Rect*)((char*)nextNum(&x) + offs);
	if (!isCell(x))
		return boxRect(adr);
	old = *adr;
	nextRect(&x,adr);
	return boxRect(&old);
}

/* Interface to HyperCard XCMDs and XFCNs */

static XCmdBlock blk;

static pascal void hyperEntry(void);
pascal void hyperEntry()
{
	register Ptr p, q;
	long n;

	switch(blk.request) {
		case xreqZeroToPas:
			for (p = (Ptr)blk.inArgs[0], q = (Ptr)blk.inArgs[1]; *q++ = *p++;)
				;
			CtoPstr((Ptr)blk.inArgs[1]);
			break;
		case xreqStrToNum:
			StringToNum((StringPtr)blk.inArgs[0], &n);
			blk.outArgs[0] = n;
			break;
		case xreqScanToReturn:
			p = *(Handle)(blk.inArgs[0]);
			while (*p)
				p++;
			*(Handle)(blk.inArgs[0]) = p;
			break;
		case xreqScanToZero:
			p = *(Handle)(blk.inArgs[0]);
			while (*p && *p!=CR)
				p++;
			*(Handle)(blk.inArgs[0]) = p;
			break;
		default:
			errObj(boxNum(blk.request), "Request from XCMD");
	}
}

pico pXcmd(x)
pico x;
{
	Str255 str;
	Handle h,theCode;
	register int nh;

	nextString(&x,str);
	if (!(theCode = GetNamedResource('XCMD',str)))
		err("Can't XCMD");
	nh = 0;
	while (isCell(x)) {
		nextString(&x,str);
		PtrToHand(str,&h, (long)pstrlen(str));
		HLock(h);
		PtoCstr(*h);
		HUnlock(h);
		blk.params[nh++] = h;
	}
	blk.paramCount = nh;
	blk.entryPoint = hyperEntry;
	HLock(theCode);
/* ((pascal void (*)())*theCode)(&blk); */
	asm {
		pea blk
		movea.l theCode,a0
		move.l (a0),a0
		jsr (a0)
	}
	HUnlock(theCode);
	while (--nh >= 0)
		DisposHandle((Handle)blk.params[nh]);
	return boxPtr(blk.returnValue);
}
