/* macPrint.c
 * 18jul89abu
 */

#include "pico.h"
#include "mac.h"
#include "PrintMgr.h"

/* Prototypes */
static pico pPrOpen(void);
static pico pPrClose(void);
static pico pPrintDefault(pico);
static pico pPrStlDialog(pico);
static pico pPrJobDialog(pico);
static pico pPrOpenDoc(pico);
static pico pPrOpenPage(pico);
static pico pPrClosePage(pico);
static pico pPrCloseDoc(pico);
static pico pPrPicFile(pico);
static pico pPrError(void);

static TPrStatus picoPrStatus;

symInit printSyms[] = {
	{"PROPEN",			pPrOpen},
	{"PRCLOSE",			pPrClose},
	{"PRINTDEFAULT",	pPrintDefault},
	{"PRSTLDIALOG",		pPrStlDialog},
	{"PRJOBDIALOG",		pPrJobDialog},
	{"PROPENDOC",		pPrOpenDoc},
	{"PROPENPAGE",		pPrOpenPage},
	{"PRCLOSEPAGE",		pPrClosePage},
	{"PRCLOSEDOC",		pPrCloseDoc},
	{"PRPICFILE",		pPrPicFile},
	{"PRERROR",			pPrError},
	NULL
};


pico pPrOpen()
{
	PrOpen();
	return tSym;
}

pico pPrClose()
{
	PrClose();
	return tSym;
}

pico pPrError()
{
	integer err;

	err = PrError();
	return err? boxNum(err):nilSym;
}

pico pPrintDefault(x)
pico x;
{
	PrintDefault((THPrint)nextNum(&x));
	return tSym;
}

pico pPrStlDialog(x)
pico x;
{
	return boxBool(PrStlDialog((THPrint)nextNum(&x)));
}

pico pPrJobDialog(x)
pico x;
{
	return boxBool(PrJobDialog((THPrint)nextNum(&x)));
}

pico pPrOpenDoc(x)
pico x;
{
	THPrint hPrint;
	TPPrPort pPrPort;

	hPrint = (THPrint)nextNum(&x);
	pPrPort = (TPPrPort)nextPtr(&x);
	return boxPtr(PrOpenDoc(hPrint, pPrPort, (Ptr)nextPtr(&x)));
}

pico pPrOpenPage(x)
pico x;
{
	TPPrPort pPrPort;

	pPrPort = (TPPrPort)nextNum(&x);
	PrOpenPage(pPrPort, (TPRect)nextPtr(&x));
	return tSym;
}

pico pPrClosePage(x)
pico x;
{
	PrClosePage((TPPrPort)nextNum(&x));
	return tSym;
}

pico pPrCloseDoc(x)
pico x;
{
	PrCloseDoc((TPPrPort)nextNum(&x));
	return tSym;
}

pico pPrPicFile(x)
pico x;
{
	THPrint hPrint;
	TPPrPort pPrPort;
	Ptr pIOBuf;

	hPrint = (THPrint)nextNum(&x);
	pPrPort = (TPPrPort)nextPtr(&x);
	pIOBuf = nextPtr(&x);
	if ((*hPrint)->prJob.bJDocLoop == bSpoolLoop)
		PrPicFile(hPrint,pPrPort,pIOBuf,nextPtr(&x),&picoPrStatus);
	return tSym;
}
