/* macRsrc.c
 * 18apr89abu
 */

#include "pico.h"
#include "mac.h"

/* Prototypes */
static pico pCloseResFile(pico);
static pico pOpenResFile(pico);
static pico pCountResources(pico);
static pico pGetIndResource(pico);
static pico pGetResource(pico);
static pico pGetNamedResource(pico);
static pico pLoadResource(pico);
static pico pReleaseResource(pico);
static pico pDetachResource(pico);
static pico pChangedResource(pico);
static pico pAddResource(pico);
static pico pRmveResource(pico);

pico pCount1Resources(pico);
pico pGet1IndResource(pico);

symInit rsrcSyms[] = {
	{"OPENRESFILE",			pOpenResFile},
	{"CLOSERESFILE",		pCloseResFile},
	{"COUNTRESOURCES",		pCountResources},
	{"GETINDRESOURCE",		pGetIndResource},
	{"GETRESOURCE",			pGetResource},
	{"GETNAMEDRESOURCE",	pGetNamedResource},
	{"LOADRESOURCE",		pLoadResource},
	{"RELEASERESOURCE",		pReleaseResource},
	{"DETACHRESOURCE",		pDetachResource},
	{"CHANGEDRESOURCE",		pChangedResource},
	{"ADDRESOURCE",			pAddResource},
	{"RMVERESOURCE",		pRmveResource},
	{"COUNT1RESOURCES",		pCount1Resources},
	{"GET1INDRESOURCE",		pGet1IndResource},
	NULL
};

pico pOpenResFile(x)
pico x;
{
	Str255 name;

	return boxNum(OpenResFile(nextString(&x,name)));
}

pico pCloseResFile(x)
pico x;
{
	CloseResFile((integer)nextNum(&x));
	return tSym;
}

pico pCountResources(x)
pico x;
{
	return boxNum(CountResources(nextPLong(&x)));
}

pico pGetIndResource(x)
pico x;
{
	ResType theType;

	theType = nextPLong(&x);
	return boxPtr(GetIndResource(theType, (integer)nextNum(&x)));
}

pico pGetResource(x)
pico x;
{
	ResType theType;

	theType = nextPLong(&x);
	return boxPtr(GetResource(theType, (integer)nextNum(&x)));
}

pico pGetNamedResource(x)
pico x;
{
	ResType theType;
	Str255 name;

	theType = nextPLong(&x);
	return boxPtr(GetNamedResource(theType, nextString(&x,name)));
}

pico pLoadResource(x)
pico x;
{
	LoadResource((Handle)nextNum(&x));
	return checkResErr();
}

pico pReleaseResource(x)
pico x;
{
	ReleaseResource((Handle)nextNum(&x));
	return checkResErr();
}

pico pDetachResource(x)
pico x;
{
	DetachResource((Handle)nextNum(&x));
	return checkResErr();
}

pico pChangedResource(x)
pico x;
{
	ChangedResource((Handle)nextNum(&x));
	return checkResErr();
}

pico pAddResource(x)
pico x;
{
	Handle theResource;
	ResType theType;
	integer theID;
	Str255 name;

	theResource = (Handle)nextPtr(&x);
	theType = nextPLong(&x);
	theID = (integer)nextNum(&x);
	AddResource(theResource, theType, theID, nextString(&x,name));
	return checkResErr();
}

pico pRmveResource(x)
pico x;
{
	RmveResource((Handle)nextNum(&x));
	return checkResErr();
}

pico pCount1Resources(x)
pico x;
{
	return boxNum(Count1Resources(nextPLong(&x)));
}

pico pGet1IndResource(x)
pico x;
{
	ResType theType;

	theType = nextPLong(&x);
	return boxPtr(Get1IndResource(theType, (integer)nextNum(&x)));
}

