/* picoMain.c
 * 18jul90abu
 */

#include "pico.h"
#include "stack.h"

/* Global objects */
pico applyList, mapCell, mapSym, mapCell2, mapSym2, mapCell3, mapSym3;
pico nilSym, voidSym, tSym, quoteSym, lambdaSym, shareFlg, objectSym, classSym;
pico star1Sym, star2Sym, star3Sym, star4Sym, star5Sym, star6Sym;
pico dolSym, fkeySym, againSym, taskSym, quitSym, fileSym, loadSym, editSym;
pico echoFlg, srcFlg, logFlg, macFlg;

picoEnv env;

/* Globals */
Ptr heapMem;
pico heap, heapEnd;
pico avail;
pico dynamos;				/* Dynamic memory objects */
jmp_buf errRst;				/* Error restart longjump */
pico *stkPtr;				/* Stack pointer */
stkFrame *stkBase;			/* Stack frame base */
catchFrame *catchBase;		/* Catch frame base */
pico *withPtr;				/* Current WITH-pointer */
pico loadPos;				/* Start of definition in source file */
pico loadName;
pico theMessage;			/* Current message */

char lBuff[LBSIZE];			/* Line buffer */
char *lbp;
file *stream;				/* The current input stream */
int nextChar;				/* Char look ahead on input */
integer inTTY, outTTY;		/* Serial channels */
integer inAux=0, outAux=0;
int traceLevel;				/* Trace recursion level */
int revaLevel;				/* Nesting level of read-eval-loops */
bool fresh;					/* Fresh start or loading freeze file */
integer saveMask;			/* Keep SysEvtMask */
char signOnMsg[] = "PICO Lisp  02jan91abu\r";

/* Prototypes */
static void applyErr(pico);
static void init(bool);
void main(void);

/* Initialization */
void reset()
{
	lbp = lBuff;
	while (*lbp)
		++lbp;
	traceLevel = 0;
	stream = NULL;
	nextChar = 0;
	setVal(taskSym, nilSym);
	resetGC();
}
void closeAll()
{
	while (isCell(val(fileSym)))
		closeFile((file*)unBox(car(car(val(fileSym)))));
}

void unwind()
{
	register pico *p;
	register long cnt;

	while (stkBase) {
		p = stkBase->sp;
		cnt = stkBase->cnt;
		while (--cnt >= 0) {
			setVal(*(p+1),*(p+3));
			p += 4;
		}
		stkBase = stkBase->link;
	}
	stkPtr = NULL;
	catchBase = NULL;
	withPtr = &nilSym;
}

/* Error processing */
void doError()
{
	char buf[FILENAME];

	if (isNum(loadPos)) {
		prString("\r[Line ");
		prNumber(unBox(loadPos));
		prString(" in ");
		prString(bufString(loadName, buf, FILENAME));
		chrOut(']');
	}
	crlf();
	revalo(nilSym);
	unwind();
	closeAll();
	longjmp(errRst,-1);
}

void error(s,t)
char *s,*t;
{
	reset();
	prString(s);
	if (t)
		prString(t);
	doError();
}

void err(s)
char *s;
{
	error(s,NULL);
}

void cBreak()
{
	file *sSave;

	push(val(taskSym));
	setVal(taskSym, nilSym);
	push(val(logFlg));
	setVal(logFlg, nilSym);
	push(val(macFlg));
	setVal(macFlg, nilSym);
	sSave = stream;
	stream = NULL;
	prString("\rCONSOLE BREAK\r");
	revalo(nilSym);
	stream = sSave;
	setVal(macFlg, pop());
	setVal(logFlg, pop());
	setVal(taskSym, pop());
}

/* Print the error object */
void errObj(x,s)
pico x;
char *s;
{
	reset();
	prin0(x);
	error(": ",s);
}

void errStrObj(x,s)
pico x;
char *s;
{
	char msg[256];

	reset();
	prString(bufString(x,msg,256));
	error(": ",s);
}

void numberError(x)
pico x;
{
	errObj(x, "Number expected");
}

void cellError(x)
pico x;
{
	errObj(x, "Cell expected");
}

void symbolError(x)
pico x;
{
	errObj(x, "Symbol expected");
}

void objError(x)
pico x;
{
	errObj(x, "Cell or Symbol expected");
}

void listError(x)
pico x;
{
	errObj(x, "List expected");
}

void strError(x)
pico x;
{
	errObj(x, "String expected");
}

void funError(x)
pico x;
{
	errObj(x, "Function expected");
}

void dynamoError(x)
pico x;
{
	errObj(x, "Dynamo expected");
}

void protected(x)
pico x;
{
	errObj(x, "Protected symbol");
}

void circError()
{
	err("Circular list");
}

void divError()
{
	err("Division by Zero");
}

void internErr(s)
char *s;
{
	error("Internal error: ",s);
}

/* Evaluate a list */
pico eval0(x)
register pico x;
{
	register pico y,z;
	register pico *p;
	register long cnt;
	stkFrame f;

	if (isNum(y = car(x)))
		return x;
	if (!isSym(y)) {
		if (isNum(y = eval0(y)))
			return (*(fun)(unBox(y)))(cdr(x));
		if (!isSym(y))
			return applySexpr(y, cdr(x));
	}
	if (isNum(z = val(y))) {
		if (!(num(z) & 1))
			errObj(y,"Bad function");
		return (*(fun)(unBox(z)))(cdr(x));
	}
	if (isSym(z))
		errObj(y, "Undefined");
	f.self = y;
	x = cdr(x);
	y = car(z);
	cnt = 0;
	while (isCell(y)) {
		++cnt;
		push(EVAL(car(x)));
		push(car(y));
		x = cdr(x);
		y = cdr(y);
	}
	if (!isNil(y)) {
		++cnt;
		push(x);
		push(y);
	}
	f.link = stkBase;
	stkBase = &f;
	p = f.sp = stkPtr;
	f.cnt = cnt;
	while (--cnt >= 0) {
		x = *++p;
		y = val(x);
		p += 2;
		setVal(x, *p);
		*p++ = y;
	}
	x = cdr(z);
	do
		y = EVAL(car(x));
	while (isCell(x = cdr(x)));
	while (--f.cnt >= 0) {
		x = pop();
		setVal(x,pop());
	}
	stkBase = f.link;
	return y;
}

pico applySexpr(sexpr,x)
pico sexpr;
register pico x;
{
	register pico y;
	register pico *p;
	register long cnt;
	stkFrame f;

	f.self = sexpr;
	y = car(sexpr);
	cnt = 0;
	while (isCell(y)) {
		++cnt;
		push(EVAL(car(x)));
		push(car(y));
		x = cdr(x);
		y = cdr(y);
	}
	if (!isNil(y)) {
		++cnt;
		push(x);
		push(y);
	}
	f.link = stkBase;
	stkBase = &f;
	p = f.sp = stkPtr;
	f.cnt = cnt;
	while (--cnt >= 0) {
		x = *++p;
		y = val(x);
		p += 2;
		setVal(x, *p);
		*p++ = y;
	}
	x = cdr(sexpr);
	do
		y = EVAL(car(x));
	while (isCell(x = cdr(x)));
	while (--f.cnt >= 0) {
		x = pop();
		setVal(x,pop());
	}
	stkBase = f.link;
	return y;
}

pico applyMethod(sexpr,arg,x)
pico sexpr;
register pico arg,x;
{
	register pico y;
	register pico *p;
	register long cnt;
	stkFrame f;

	f.self = theMessage;
	cnt = 0;
	if (isCell(y = car(sexpr))) {
		cnt = 1;
		push(arg);
		push(car(y));
		y = cdr(y);
		while (isCell(y)) {
			++cnt;
			push(EVAL(car(x)));
			push(car(y));
			x = cdr(x);
			y = cdr(y);
		}
		if (!isNil(y)) {
			++cnt;
			push(x);
			push(y);
		}
	}
	f.link = stkBase;
	stkBase = &f;
	p = f.sp = stkPtr;
	f.cnt = cnt;
	while (--cnt >= 0) {
		x = *++p;
		y = val(x);
		p += 2;
		setVal(x, *p);
		*p++ = y;
	}
	x = cdr(sexpr);
	do
		y = EVAL(car(x));
	while (isCell(x = cdr(x)));
	while (--f.cnt >= 0) {
		x = pop();
		setVal(x,pop());
	}
	stkBase = f.link;
	return y;
}

void applyErr(x)
pico x;
{
	errObj(x,"Can't apply");
}

pico apply0(x)
register pico x;
{
	register pico y,sym;
	stkFrame f;

	if (isNum(x))
		return (*(fun)(unBox(x)))();
	if (isSym(x))
		applyErr(x);
	f.self = x;
	y = car(x);
	f.cnt = 0;
	while (isCell(y)) {
		++f.cnt;
		sym = car(y);
		push(val(sym));
		push(sym);
		setVal(sym, nilSym);
		y  = cdr(y);
	}
	f.link = stkBase;
	stkBase = &f;
	f.sp = stkPtr;
	x = evalBody(cdr(x));
	while (--f.cnt >= 0) {
		sym = pop();
		setVal(sym,pop());
	}
	stkBase = f.link;
	return x;
}

pico apply1(x,arg)
register pico x,arg;
{
	register pico y,sym;
	stkFrame f;

	if (isNum(x)) {
		setVal(mapSym, arg);
		return (*(fun)(unBox(x)))(mapCell);
	}
	if (isSym(x))
		applyErr(x);
	f.self = x;
	y = car(x);
	f.cnt = 1;
	if (!isCell(y) || !isSym(sym = car(y)))
		applyErr(x);
	push(val(sym));
	push(sym);
	setVal(sym, arg);
	while (isCell(y = cdr(y))) {
		++f.cnt;
		sym = car(y);
		push(val(sym));
		push(sym);
		setVal(sym, nilSym);
	}
	f.link = stkBase;
	stkBase = &f;
	f.sp = stkPtr;
	x = evalBody(cdr(x));
	while (--f.cnt >= 0) {
		sym = pop();
		setVal(sym,pop());
	}
	stkBase = f.link;
	return x;
}

pico apply2(x,arg1,arg2)
register pico x,arg1,arg2;
{
	register pico y,sym;
	stkFrame f;

	if (isNum(x)) {
		setVal(mapSym2, arg1);
		setVal(mapSym, arg2);
		return (*(fun)(unBox(x)))(mapCell2);
	}
	if (isSym(x))
		applyErr(x);
	f.self = x;
	y = car(x);
	f.cnt = 2;
	if (!isCell(y) || !isSym(sym = car(y)))
		applyErr(x);
	push(val(sym));
	push(sym);
	setVal(sym, arg1);
	y = cdr(y);
	if (!isCell(y) || !isSym(sym = car(y)))
		applyErr(x);
	push(val(sym));
	push(sym);
	setVal(sym, arg2);
	while (isCell(y = cdr(y))) {
		++f.cnt;
		sym = car(y);
		push(val(sym));
		push(sym);
		setVal(sym, nilSym);
	}
	f.link = stkBase;
	stkBase = &f;
	f.sp = stkPtr;
	x = evalBody(cdr(x));
	while (--f.cnt >= 0) {
		sym = pop();
		setVal(sym,pop());
	}
	stkBase = f.link;
	return x;
}

pico apply3(x,arg1,arg2,arg3)
register pico x,arg1,arg2,arg3;
{
	register pico y,sym;
	stkFrame f;

	if (isNum(x)) {
		setVal(mapSym3, arg1);
		setVal(mapSym2, arg2);
		setVal(mapSym, arg3);
		return (*(fun)(unBox(x)))(mapCell3);
	}
	if (isSym(x))
		applyErr(x);
	f.self = x;
	y = car(x);
	f.cnt = 3;
	if (!isCell(y) || !isSym(sym = car(y)))
		applyErr(x);
	push(val(sym));
	push(sym);
	setVal(sym, arg1);
	y = cdr(y);
	if (!isCell(y) || !isSym(sym = car(y)))
		applyErr(x);
	push(val(sym));
	push(sym);
	setVal(sym, arg2);
	y = cdr(y);
	if (!isCell(y) || !isSym(sym = car(y)))
		applyErr(x);
	push(val(sym));
	push(sym);
	setVal(sym, arg3);
	while (isCell(y = cdr(y))) {
		++f.cnt;
		sym = car(y);
		push(val(sym));
		push(sym);
		setVal(sym, nilSym);
	}
	f.link = stkBase;
	stkBase = &f;
	f.sp = stkPtr;
	x = evalBody(cdr(x));
	while (--f.cnt >= 0) {
		sym = pop();
		setVal(sym,pop());
	}
	stkBase = f.link;
	return x;
}

pico Apply(x)
register pico x;
{
	register pico y, sexpr,sym;
	stkFrame f;

	push(EVAL1(x));
	x = cdr(x);
	x = EVAL1(x);
	sexpr = pop();
	if (isNum(sexpr)) {
		register pico p;

		if (!isCell(y = x))
			return (*(fun)(unBox(sexpr)))(nilSym);
		p = mapCell;
		while (isCell(y = cdr(y)))
			if ((p += 2) > applyList)
				errObj(x, "Too long list for APPLY");
		y = p;
		p = car(y);
		do {
			setVal(p, car(x));
			p -= 2;
		} while (isCell(x = cdr(x)));
		return (*(fun)(unBox(sexpr)))(y);
	}
	if (isSym(sexpr))
		applyErr(sexpr);
	f.self = sexpr;
	y = car(sexpr);
	f.cnt = 0;
	while (isCell(y)) {
		++f.cnt;
		sym = car(y);
		push(val(sym));
		push(sym);
		setVal(sym, car(x));
		x = cdr(x);
		y = cdr(y);
	}
	f.link = stkBase;
	stkBase = &f;
	f.sp = stkPtr;
	x = evalBody(cdr(sexpr));
	while (--f.cnt >= 0) {
		sym = pop();
		setVal(sym,pop());
	}
	stkBase = f.link;
	return x;
}

pico evalBody(x)
register pico x;
{
	register pico y;

	do
		y = EVAL(car(x));
	while (isCell(x = cdr(x)));
	return y;
}

/* Program termination */
void giveup(s)
char *s;
{
	prString(s);
	crlf();
	exitPico(FAIL);
}

void revalo(expr)
pico expr;
{
	register pico x;
	pico hidden,str;
	stkFrame *frameSave;
	catchFrame *catchSave;

	++revaLevel;
	hidden = env.threads[THREADS];
	push(val(classSym));
	push(val(dolSym));
	setVal(dolSym, expr);
	frameSave = stkBase;
	catchSave = catchBase;
	while ((x = read0(YES)) != tSym) {
		push(x);
		if (!stream  &&  lBuff[0]  &&  val(againSym) != nilSym  &&
				!equal(str = unBufCString(lBuff), car(val(againSym))) )
			setVal(againSym, newCell(str, val(againSym)));
		tos = EVAL(x);
		if (!stream) {
			setVal(star6Sym, val(star5Sym));
			setVal(star5Sym, val(star4Sym));
			setVal(star4Sym, val(star3Sym));
			setVal(star3Sym, val(star2Sym));
			setVal(star2Sym, val(star1Sym));
			setVal(star1Sym, tos);
			prString("-> ");
			prin0(tos);
			crlf();
		}
		drop();
		if (stkBase != frameSave)
			internErr("Frame");
		if (catchBase != catchSave)
			internErr("CatchFrame");
	}
	setVal(dolSym,pop());
	setVal(classSym,pop());
	env.threads[THREADS] = hidden;
	--revaLevel;
}

void init(flg)
bool flg;
{
	fresh = flg;
	initSymbols();
	reset();
}

void main()
{
	Handle h;
	register pico p;
	register long n;
	long nCells, nStack;

	asm {
		move.l a7,d0	/* Align Stack */
		andi.l #-4,d0
		move.l d0,a7
	}
	if (h = GetResource('pirm',1)) {
		nCells = (*(long*)(*h));		/* Number of LISP-cells */
		nStack = (*((long*)(*h)+1));	/* Total stack size in bytes */
		initSerial(*((long*)(*h)+2) & 0xFFFF, (*((long*)(*h)+2) & 0x10000) != 0);
	}
	else {
		nCells = 100000L;
		nStack = 65536L;
		initSerial(10,NO); /* 94->1200, 10->9600 Baud */
	}
	SetApplLimit(GetApplLimit() + 8*1024 - nStack);
	MoreMasters(), MoreMasters(), MoreMasters(), MoreMasters();
	MaxApplZone();
	if (!(heapMem = NewPtr((nCells+1) * sizeof(cell))))
		giveup("Can't allocate memory");
	heap = (pico)((long)heapMem  + (CELLSIZE-1) & ~(CELLSIZE-1));
	heapEnd = heap + nCells;
	/* Init Mac Toolbox */
	InitGraf(&thePort);
	InitFonts();
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(NULL);
	InitCursor();
	saveMask = SysEvtMask;
	SetEventMask(everyEvent);
	/* Init PICO environment */
	prString(signOnMsg);
	stkPtr = NULL;
	stkBase = NULL;
	catchBase = NULL;
	withPtr = &nilSym;
	loadPos = NULL;
	dynamos = NULL;

	/* Error Entry */
	if (setjmp(errRst)) {
		setVal(dolSym, nilSym);
		setVal(loadSym, nilSym);
	}
	else {
		integer message,count;
		AppFile file;

		CountAppFiles(&message, &count);
		if (count==1  &&  (GetAppFiles(1,&file), file.fType=='FREZ')) {
			SetVol((StringPtr)NULL, file.vRefNum); /* ? noetig ? */
			if (!unFreeze(file.fName, file.vRefNum))
				giveup("Can't UNFREEZE");
			ClrAppFiles(1);
			init(NO);
			evalBody(env.run);
		}
		else {
			/* Init empty heap */
			avail = NULL;
			p = heapEnd;
			n = nCells;
			do {
				--p;
				p->link = avail;
				avail = p;
			} while (--n);
			init(YES);
			env.genSeed[0] = env.genSeed[1] = '$';
			env.genSeed[2] = env.genSeed[3] = env.genSeed[4] = 'A';
			env.genSeed[5] = '@';
			env.genSeed[6] = '\0';
			env.run = nilSym;
			revaLevel = 0;
			while (count) {
				GetAppFiles(count,&file);
				if (file.fType=='TEXT') {
					SetVol((StringPtr)NULL, file.vRefNum);
					Load(newCell(unBufString(file.fName),nilSym));
					ClrAppFiles(count);
				}
				--count;
			}
		}
	}
	do {
		revaLevel = -1;
		revalo(nilSym);
		prString("Exit Pico?");
		revaLevel = 0;
	} while (read0(YES) != tSym);
	exitPico(SUCCESS);
}
